<?php

$routes->group('modules/backend/notifications', ["filter" => "cors", "namespace" => "\Modules\Notification\Controllers"], function ($routes) {
    $routes->get('new', 'Notification::new', ['as' => 'new-notification']);
    $routes->post('', 'Notification::create', ['as' => 'create-notification']);
    $routes->get('', 'Notification::index', ['as' => 'index-notification']);
    $routes->get('(:segment)', 'Notification::show/$1', ['as' => 'show-notification']);
    $routes->get('(:segment)/edit', 'Notification::edit/$1', ['as' => 'edit-notification']);
    $routes->put('(:segment)', 'Notification::update/$1', ['as' => 'update-notification']);
    $routes->delete('(:segment)', 'Notification::delete/$1', ['as' => 'delete-notification']);
    $routes->post('cancel/(:segment)', 'Notification::cancel/$1', ['as' => 'cancel-notification']);
    $routes->get('scheduled', 'Notification::scheduled', ['as' => 'scheduled-notifications']);
    $routes->get('sent', 'Notification::sent', ['as' => 'sent-notifications']);
    $routes->get('cancelled', 'Notification::cancelled', ['as' => 'cancelled-notifications']);
    $routes->post('send/(:segment)', 'Notification::sendNow/$1', ['as' => 'send-notification-now']);
    $routes->get('trip-passengers/(:segment)', 'Notification::getTripPassengers/$1', ['as' => 'get-trip-passengers']);
});

$routes->group('modules/api/v1/notifications', ["filter" => "cors", "namespace" => "\Modules\Notification\Controllers\Api"], function ($routes) {
    $routes->get('user/(:segment)', 'Notification::getUserNotifications/$1');
    $routes->post('mark-read/(:segment)', 'Notification::markAsRead/$1');
    $routes->get('unread-count/(:segment)', 'Notification::getUnreadCount/$1');
});
