<?php 
namespace App\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;

class payViaGeidea extends BaseController
{
    public function payViaGeidea()
    {
        // Load the payment page
        return view('payagent/geidea_payment');
    }

    public function processPayment()
    {
        $amount = $this->request->getPost('amount');

        // Geidea API credentials
        $publicKey = 'your_public_key';
        $apiPassword = 'your_api_password';

        // API endpoint
        $url = 'https://api.merchant.geidea.net/eg/transactions';

        // Prepare the payload
        $data = [
            'amount' => $amount,
            'currency' => 'EGP',
            'callbackUrl' => base_url('payment/callback'),
        ];

        // Send the request to Geidea API
        $client = \Config\Services::curlrequest();
        $response = $client->post($url, [
            'auth' => [$publicKey, $apiPassword],
            'json' => $data,
        ]);

        if ($response->getStatusCode() === ResponseInterface::HTTP_OK) {
            $responseData = json_decode($response->getBody(), true);
            return redirect()->to($responseData['paymentUrl']);
        } else {
            return redirect()->back()->with('error', 'Payment failed. Please try again.');
        }
    }
}