<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>

    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">

            <form action="<?php echo base_url(route_to('update-fleet', $fleet->id)) ?>" id="fleetupdate" method="post" class="row g-3" accept-charset="utf-8" enctype="multipart/form-data">
                <?php echo $this->include('common/securityupdate') ?>

                <div class="col-3">
                    <label for="fleettype" class="form-label"><?php echo lang("Localize.fleet") ?> <?php echo lang("Localize.type") ?> <abbr title="Required field">*</abbr></label>
                    <input type="text" placeholder="Fleet Type" name="type" value="<?php echo old('type') ?? $fleet->type ?>" class="form-control">
                </div>

                <div class="col-3 ">
                    <label for="layout" class="form-label"><?php echo lang("Localize.fleet") ?> <?php echo lang("Localize.layout") ?> <abbr title="Required field">*</abbr></label>
                    <select id="layout" class="form-select" name="layout" required="required">
                        <option value="" disabled selected><?= $fleet->layout ?></option>
                        <option value="2-2">2-2</option>
                        <option value="1-1">1-1</option>
                        <option value="2-1">2-1</option>
                        <option value="1-2">1-2</option>
                        <!-- <option value="3-2">3-2</option> -->
                        <!-- <option value="2-3">2-3</option> -->
                        <!-- <option value="1-1-1">1-1-1</option> -->
                        <!-- <option value="1 & 3 & 2-1 & 3">1-0,2-1</option> -->
                        <option value="4-1">4-1</option>
                    </select>
                </div>
                <div class="col-2 mt-5"  id="forth_seat_div">
                    <div class="form-check" >

                        <?php if ($fleet->forth_seat == 1) : ?>
                            <input class="form-check-input position-static" type="checkbox" id="forth_seat" value="1" name="forth_seat" checked>
                        <?php else : ?>
                            <input class="form-check-input position-static" type="checkbox" id="forth_seat" value="1" name="forth_seat">
                        <?php endif ?>

                        <label class="form-check-label" for="forth_seat">
                            4 Seat Check
                        </label>
                    </div>
                </div>
                
                <div class="col-2 mt-5" id="last_seat_div">
                    <div class="form-check">

                        <?php if ($fleet->last_seat == 1) : ?>
                            <input class="form-check-input position-static" type="checkbox" id="last_seat" value="1" name="last_seat" checked>
                        <?php else : ?>
                            <input class="form-check-input position-static" type="checkbox" id="last_seat" value="1" name="last_seat">
                        <?php endif ?>

                        <label class="form-check-label" for="last_seat">
                            13 Seat Check
                        </label>
                    </div>
                </div>

                <div class="col-2 mt-5" id="wc_div">
                    <div class="form-check" >

                        <?php if ($fleet->wc == 1) : ?>
                            <input class="form-check-input position-static" type="checkbox" id="wc" value="1" name="wc" checked>
                        <?php else : ?>
                            <input class="form-check-input position-static" type="checkbox" id="wc" value="1" name="wc">
                        <?php endif ?>

                        <label class="form-check-label" for="wc">
                            WC Check
                        </label>
                    </div>
                </div>
                <div class="col-2">
                    <label for="total_seat" class="form-label"><?php echo lang("Localize.total") ?> <?php echo lang("Localize.seat") ?> <abbr title="Required field">*</abbr></label>
                    <select name="total_seat" id="total_seat" class="form-select" required>
                        <option value="" disabled selected><?php echo lang("Localize.select") ?> <?php echo lang("Localize.total") ?> <?php echo lang("Localize.seat") ?></option>
                        <?php if (!empty($fleet->total_seat)) : ?>
                            <option value="<?php echo $fleet->total_seat ?>" selected><?php echo $fleet->total_seat ?></option>
                        <?php endif; ?>
                    </select>
                </div>

                <div class="mb-3">
                    <label for="seat_number" class="form-label"><?php echo lang("Localize.seat") ?> <?php echo lang("Localize.number") ?> <abbr title="Required field">*</abbr></label>
                    <textarea class="form-control" name="seat_number" id="seat_number" rows="3"><?php echo old('total_seat') ?? $fleet->seat_number ?></textarea>
                </div>


                <div class="col-3">

                    <label class="form-label" for="">
                        <?php echo lang("Localize.luggage") ?> <?php echo lang("Localize.service") ?>
                        <abbr title="Required field">*</abbr>
                    </label>
                    <?php if ($fleet->luggage_service == 1) : ?>

                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="luggage_service" id="luggage_service" value="1" checked>
                            <label class="form-check-label" for="exampleRadios1">
                                <?php echo lang("Localize.active") ?>
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="luggage_service" id="luggage_service" value="0">
                            <label class="form-check-label" for="exampleRadios2">
                                <?php echo lang("Localize.disable") ?>
                            </label>
                        </div>
                    <?php else : ?>

                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="luggage_service" id="luggage_service" value="1">
                            <label class="form-check-label" for="exampleRadios1">
                                <?php echo lang("Localize.active") ?>
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="luggage_service" id="luggage_service" value="0" checked>
                            <label class="form-check-label" for="exampleRadios2">
                                <?php echo lang("Localize.disable") ?>
                            </label>
                        </div>
                    <?php endif ?>
                </div>

                <div class="col-3">
                    <label class="form-label" for="">
                        <?php echo lang("Localize.status") ?>
                        <abbr title="Required field">*</abbr>
                    </label>

                    <?php if ($fleet->status == 1) : ?>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="status" id="status" value="1" checked>
                            <label class="form-check-label" for="exampleRadios1">
                                <?php echo lang("Localize.active") ?>
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="status" id="status" value="0">
                            <label class="form-check-label" for="exampleRadios2">
                                <?php echo lang("Localize.disable") ?>
                            </label>
                        </div>
                    <?php else : ?>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="status" id="status" value="1">
                            <label class="form-check-label" for="exampleRadios1">
                                <?php echo lang("Localize.active") ?>
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="status" id="status" value="0" checked>
                            <label class="form-check-label" for="exampleRadios2">
                                <?php echo lang("Localize.disable") ?>
                            </label>
                        </div>
                    <?php endif ?>

                </div>
                <div class="col-12">
                    <label for="buspicedit" class="form-label"><?php echo lang("Localize.bus") ?> <?php echo lang("Localize.image") ?></label>
                    <div id="buspicedit"></div>
                </div>

                <div class="text-danger">
                    <?php if (isset($validation)) : ?>
                        <?= $validation->listErrors(); ?>
                    <?php endif ?>
                </div>
                <div class="col-12 mt-3" id="newimg">

                    <div class="row mb-3" id="imgbus">
                        <?php foreach ($imagevehical as $imagepath) : ?>

                            <div class="col-md-3 col-sm-3 col-xs-6 mt-1" id="<?php echo $imagepath->id; ?>">
                                <button type="button" class="btn btn-danger close-btn" onclick="removefleetImage(<?php echo $imagepath->id; ?>)"><i class="fa fa-times"></i></button>
                                <img src="<?php echo base_url('public/' . $imagepath->img_path); ?>" alt="" height="100" class="img-fluid">
                                <input type="hidden" name="oldphoto[]" value="<?php echo $imagepath->img_path; ?>">

                            </div>
                        <?php endforeach ?>

                    </div>
                </div>

                <div class="col-12 text-center">
                    <button type="submit" class="btn btn-success"><?php echo lang("Localize.submit") ?></button>
                    <button type="button" class="btn btn-success" id="layoutButton"><?php echo "seatLayout"; ?></button>
                </div>
            </form>
        </div>
        <div id="seatLayoutContainer" class="mt-4"></div>

    </div>
<?php echo $this->endSection() ?>

<?php echo $this->section('js') ?>
    <script src="<?php echo base_url('public/js/fleet.js'); ?>"></script>
    <script>
        $(document).ready(function() {
            var defaultLayout = '<?= $fleet->layout ?>';

            if (defaultLayout === '4-1') {
                $('#forth_seat_div, #last_seat_div').show();
                $('#wc_div').hide();
            }else{
                $('#forth_seat_div, #last_seat_div').hide();
                $('#wc_div').show();
            }
            $('#layout').change(function () {
                var selectedValue = $(this).val();
                var totalSeatSelect = $('#total_seat');
                totalSeatSelect.empty();
                totalSeatSelect.append('<option value="" disabled selected><?php echo lang("Localize.select") ?> <?php echo lang("Localize.total") ?> <?php echo lang("Localize.seat") ?></option>');

                // Hide all buttons by default
                $('#forth_seat_div, #last_seat_div').hide();
                $('#wc_div').show();
                $('#forth_seat, #last_seat' ).prop('checked', false);

                // Show specific buttons based on selected value
                if (selectedValue === '4-1') {
                    $('#forth_seat_div, #last_seat_div').show();
                    $('#wc_div').hide();
                    $('#wc').prop('checked', false);
                    totalSeatSelect.append('<option value="14">14</option>');
                } else if (selectedValue === '2-2') {
                    totalSeatSelect.append('<option value="29">29</option>');
                    totalSeatSelect.append('<option value="33">33</option>');
                    totalSeatSelect.append('<option value="49">49</option>');
                    totalSeatSelect.append('<option value="61">61</option>');
                } else if (selectedValue === '2-1' || selectedValue === '1-2') {
                    totalSeatSelect.append('<option value="24">24</option>');
                    totalSeatSelect.append('<option value="26">26</option>');
                } else if (selectedValue === '1-1') {
                    totalSeatSelect.append('<option value="49">49</option>');
                } 
            });
            $('#layoutButton').click(function() {
                var totalSeat = $('#total_seat').val();
                var layout = $('#layout').val();
                var seatNumber = $('#seat_number').val();
                // var forth_seat = $('#forth_seat').val();
                var forth_seat = $('#forth_seat').prop('checked') ? 1 : 0;
                // var last_seat = $('#last_seat').val();
                var last_seat = $('#last_seat').prop('checked') ? 1 : 0;
                var wc = $('#wc').prop('checked') ? 1 : 0;

                if(layout == "" || layout == null){
                 alert("please select layout");
                 return false;
                }
                $.ajax({
                    url: '<?php echo base_url('modules/backend/fleets/getSeatLayout'); ?>',
                    type: 'GET',
                    headers: { "X-CSRF-TOKEN": "<?= csrf_hash() ?>" },
                    data: {
                        totalSeat:totalSeat,
                        seatLayout:layout,
                        seat_number:seatNumber,
                        forth_seat:forth_seat,
                        last_seat:last_seat,
                        wc:wc,
                    },
                    success: function(response) {
                        $('#seatLayoutContainer').html(response);
                    },
                    error: function(xhr, status, error) {
                        console.error('Error fetching seat layout:', error);
                    }
                });
            });
            $('#total_seat').change(function() {
                var totalSeat = $(this).val();
                if (totalSeat) {
                var seatNumbers = [];
            for (var i = 1; i <= totalSeat; i++) {
            seatNumbers.push(i);
            }
                $('#seat_number').val(seatNumbers.join(','));
            }
            });
        });
    </script>
<?php echo $this->endSection() ?>