<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('css') ?>
    <link href="<?php echo base_url('public/plugins/select2/select2.min.css'); ?>" rel="stylesheet" />
<?php echo $this->endSection() ?>

<?php echo $this->section('content') ?>
    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">

            <form action="<?php echo base_url(route_to('create-trip')) ?>" id="locationform" method="post" class="row g-3" accept-charset="utf-8" enctype="multipart/form-data">
                <?php echo $this->include('common/security') ?>

                <input type="hidden" id="baseurl" name="basurl" value="<?php echo base_url(); ?>">

                <div class="bg-light p-3 my-2">
                    <strong class="mb-1"><?php echo lang("Localize.trip") ?> <?php echo lang("Localize.section") ?></strong>

                    <div class="row">
                        <div class="col-3 ">
                            <label for="pick_location_id" class="form-label"><?php echo lang("Localize.pick_up") ?> <abbr title="Required field">*</abbr></label>
                            <select class="form-select select2" name="pick_location_id" id="pick_location_id" required>
                                <option value=""><?php echo lang("Localize.none") ?></option>
                                
                                <?php foreach ($location as $locationvalue) : ?>
                                    <option value="<?php echo $locationvalue->id ?>"><?php echo $locationvalue->name ?></option>
                                <?php endforeach ?>
                                
                            </select>
                        </div>
                        <div class="col-3 ">
                            <label for="drop_location_id" class="form-label"><?php echo lang("Localize.drop") ?> <abbr title="Required field">*</abbr></label>
                            <select class="form-select select2" name="drop_location_id" id="drop_location_id" required>
                                <option value=""><?php echo lang("Localize.none") ?></option>
                                
                                <?php foreach ($location as $locationvalue) : ?>
                                    <option value="<?php echo $locationvalue->id ?>"><?php echo $locationvalue->name ?></option>
                                <?php endforeach ?>

                            </select>
                        </div>
                        <div class="col-3 ">
                            <label for="stoppage" class="form-label"><?php echo lang("Localize.stoppage") ?> <?php echo lang("Localize.point") ?> <abbr title="Required field">*</abbr></label>
                            <select name="stoppage[]" id="stoppage" class="form-control" multiple>
                               
                                <option value="" disabled selected><?php echo lang("Localize.none") ?></option>
                                <?php foreach ($location as $locationvalue) : ?>
                                    <option value="<?php echo $locationvalue->id ?>"><?php echo $locationvalue->name ?></option>
                                <?php endforeach ?>

                            </select>
                        </div>
                        
                        <div class="col-3 ">
                            <label for="schedule_id" class="form-label"><?php echo lang("Localize.schedule") ?> <?php echo lang("Localize.time") ?> <abbr title="Required field">*</abbr></label>
                            <select name="schedule_id" id="schedule_id" class="form-select select2" data-minimum-results-for-search="-1" required>
                                <option value=""><?php echo lang("Localize.none") ?></option>
                                
                                <?php foreach ($schedule as $schedulevalue) : ?>
                                    <option value="<?php echo $schedulevalue->id ?>"><?php echo $schedulevalue->start_time ?> - <?php echo $schedulevalue->end_time ?></option>
                                <?php endforeach ?>

                            </select>
                        </div>
                    </div>
                </div>

                <div class="bg-light p-3 my-2">
                    <strong class="mb-1"><?php echo lang("Localize.boarding") ?> <?php echo lang("Localize.point") ?></strong>

                    <div class="row" id="boarding">
                        <div class="col-3 ">
                            <label for="picktime" class="form-label"><?php echo lang("Localize.select") ?> <?php echo lang("Localize.time") ?>  <abbr title="Required field">*</abbr></label>
                            <input type="text" id="picktime" name="picktime[]" class="form-control" value="<?php echo old('time') ?>" placeholder="<?php echo lang("Localize.select") ?> <?php echo lang("Localize.time") ?>" required />
                        </div>

                        <div class="col-3 ">
                            <label class="form-label"><?php echo lang("Localize.bus") ?> <?php echo lang("Localize.stand") ?> <abbr title="Required field">*</abbr></label>
                            <select name="picstand[]" id="b_stand_1" class="form-select select2" required>
                                <option value=""><?php echo lang("Localize.none") ?></option>

                                <?php foreach ($stand as $standvalue) : ?>
                                    <option value="<?php echo $standvalue->id ?>"><?php echo $standvalue->name ?></option>
                                <?php endforeach ?>
                            </select>
                        </div>

                        <div class="col-3 ">
                            <label for="detail" class="form-label"><?php echo lang("Localize.details") ?> </label>
                            <input type="text" id="detail" name="detail[]" class="form-control" value="<?php echo old('detail') ?>" placeholder="<?php echo lang("Localize.details") ?>">
                        </div>

                        <input type="hidden" name="type[]" value="1">
                        <div class="col-3 mt-4">
                            <a id="boardingadd" class="btn btn-success mt-1 text-white" onclick="addfieldboard()">+</a>
                        </div>
                    </div>

                    <div id="boardinadd"></div>
                </div>

                <div class="bg-light p-3 my-2">
                    <strong class="mb-1"><?php echo lang("Localize.dropping") ?> <?php echo lang("Localize.point") ?></strong>

                    <div class="row" id="droping">
                        <div class="col-3 ">
                            <label for="droptime" class="form-label"><?php echo lang("Localize.select") ?> <?php echo lang("Localize.time") ?>  <abbr title="Required field">*</abbr></label>
                            <input type="text" id="droptime" name="droptime[]" class="form-control" value="" placeholder="<?php echo lang("Localize.select") ?> <?php echo lang("Localize.time") ?>" required />
                        </div>

                        <div class="col-3 ">
                            <label class="form-label"><?php echo lang("Localize.bus") ?> <?php echo lang("Localize.stand") ?> <abbr title="Required field">*</abbr></label>
                            <select name="dropstand[]" id="d_stand_1" class="form-select select2" required>
                                <option value=""><?php echo lang("Localize.none") ?></option>
                                <?php foreach ($stand as $standvalue) : ?>
                                    <option value="<?php echo $standvalue->id ?>"><?php echo $standvalue->name ?></option>
                                <?php endforeach ?>
                            </select>
                        </div>

                        <div class="col-3 ">
                            <label for="dropdetail" class="form-label"><?php echo lang("Localize.details") ?></label>
                            <input type="text" id="detail" name="dropdetail[]" class="form-control" value="" placeholder="<?php echo lang("Localize.details") ?>">
                        </div>

                        <input type="hidden" name="droptype[]" value="0">

                        <div class="col-3 mt-4">
                            <a id="boardingadd" class="btn btn-success mt-1 text-white" onclick="addfielddrop()">+</a>
                        </div>
                    </div>

                    <div id="droppingadd"></div>
                </div>

                <div class="bg-light p-3 my-2">
                    <strong class="mb-1"><?php echo lang("Localize.seat") . ', ' . lang("Localize.fair") . ', ' . lang("Localize.time") ?></strong>

                    <div class="row">
                        <div class="col-3">
                            <label for="child_seat" class="form-label"><?php echo lang("Localize.children") ?> <?php echo lang("Localize.seat") ?> </label>
                            <input type="number" id="child_seat" name="child_seat" class="form-control" value="<?= old('child_seat') ?>" placeholder="<?php echo lang("Localize.children") ?> <?php echo lang("Localize.seat") ?>" min="0">
                        </div>

                        <div class="col-3">
                            <label for="child_fair" class="form-label"><?php echo lang("Localize.children") ?> <?php echo lang("Localize.fair") ?></label>
                            <input type="number" id="child_fair" name="child_fair" class="form-control" value="<?= old('child_fair') ?>" placeholder="<?php echo lang("Localize.children") ?> <?php echo lang("Localize.fair") ?>" min="0">
                        </div>

                        <div class="col-3">
                            <label for="special_seat" class="form-label"><?php echo lang("Localize.special") ?> <?php echo lang("Localize.seat") ?></label>
                            <input type="number" id="special_seat" name="special_seat" class="form-control" value="<?= old('special_seat') ?>" placeholder="<?php echo lang("Localize.special") ?> <?php echo lang("Localize.seat") ?>" min="0">
                        </div>

                        <div class="col-3">
                            <label for="special_fair" class="form-label"><?php echo lang("Localize.special") ?> <?php echo lang("Localize.fair") ?> </label>
                            <input type="number" id="special_fair" name="special_fair" class="form-control" value="<?= old('special_fair') ?>" placeholder="<?php echo lang("Localize.special") ?> <?php echo lang("Localize.fair") ?>" min="0">
                        </div>

                        <div class="col-3 mt-2">
                            <label for="adult_fair" class="form-label"><?php echo lang("Localize.adult") ?> <?php echo lang("Localize.fair") ?> <abbr title="Required field">*</abbr></label>
                            <input type="number" id="adult_fair" name="adult_fair" class="form-control" value="<?= old('adult_fair') ?>" placeholder="<?php echo lang("Localize.adult") ?> <?php echo lang("Localize.fair") ?>" min="1" required />
                        </div>

                        <div class="col-3 mt-2">
                            <label for="adult_fair" class="form-label"><?php echo lang("Localize.distance") ?> <abbr title="Required field">*</abbr></label>
                            <input type="number" id="distance" name="distance" class="form-control" value="<?= old('distance') ?>" placeholder="<?php echo lang("Localize.distance") ?>" min="1" required />
                        </div>

                        <div class="col-3 mt-2">
                            <label for="journey_hour" class="form-label"><?php echo lang("Localize.approximate") ?> <?php echo lang("Localize.time") ?> <abbr title="Required field">*</abbr></label>
                            <input type="number" id="journey_hour" name="journey_hour" class="form-control" value="<?= old('journey_hour') ?>" placeholder="<?php echo lang("Localize.approximate") ?> <?php echo lang("Localize.time") ?>" min="1" step=1 required />
                        </div>


                        <div class="col-3 mt-2">
                            <label for="startdate" class="form-label"><?php echo lang("Localize.trip") ?> <?php echo lang("Localize.start") ?> <?php echo lang("Localize.date") ?>  <abbr title="Required field">*</abbr></label>
                            <div class="input-group date datepicker" id="startdate">
                                <input type="text" class="form-control" name="startdate" readonly required />
                                <div class="input-group-addon"></div>
                            </div>
                        </div>


                        <div class="col-3 mt-2">
                            <label for="facility" class="form-label"><?php echo lang("Localize.facility") ?> </label>
                            <select multiple="multiple" name="facility[]" class="testselect3">
                                <option value="" disabled selected><?php echo lang("Localize.none") ?></option>

                                <?php foreach ($facility as $facilityvalue) : ?>
                                    <option value="<?php echo $facilityvalue->id ?>"><?php echo $facilityvalue->name ?></option>
                                <?php endforeach ?>

                            </select>
                        </div>
                        
                        
                    </div>
                </div>
                
                <div class="bg-light p-3 my-2">
                    <strong class="mb-1"><?php echo lang("Date Settings") ?></strong>

                    <div class="row">
                        
                        <!--//bus opration date type-->
                        <div class="col-6 mt-2">
                            <label for="oprationDatetype" class="form-label"><?php echo lang("Bus Opration Date Type") ?> </label>
                        </div>
                        <div class="col-6 mt-2">
                            <select name="oprationDatetype" class="testselect3" onchange="toggleRepetedFields()">
                                <option value="repeted"><?php echo "Repeted" ?> </option>
                                <option value="nonRepeted"><?php echo "Non-Repeted" ?> </option>
                            </select>
                        </div>

                        <!--repeted start date-->
                        <div class="col-6 mt-2">
                            <label for="repetedstartdate" class="form-label"><?php echo lang("Repeted") ?> <?php echo lang("Localize.start") ?> <?php echo lang("Localize.date") ?>  <abbr title="Required field">*</abbr></label>
                        </div>
                        <div class="col-6 mt-2">
                            <div class="input-group date datepicker">
                                <input type="text" class="form-control" id="repetedstartdate" name="repetedstartdate" readonly required />
                                <div class="input-group-addon"></div>
                            </div>
                        </div>

                        <!--repeted end date-->
                        <div class="col-6 mt-2">
                            <label for="repetedenddate" class="form-label"><?php echo lang("Repeted") ?> <?php echo lang("Localize.end") ?> <?php echo lang("Localize.date") ?>  <abbr title="Required field">*</abbr></label>
                        </div>
                        <div class="col-6 mt-2">
                            <div class="input-group date datepicker">
                                <input type="text" class="form-control" id="repetedenddate" name="repetedenddate" readonly required />
                                <div class="input-group-addon"></div>
                            </div>
                        </div>

                        <!--repeted after-->
                        <div class="col-6 mt-2">
                            <label for="repeted_after" class="form-label"><?php echo lang("Repeted After") ?> </label>
                        </div>
                        <div class="col-6 mt-3">
                            <input type="number" id="repeted_after" name="repeted_after" class="form-control" value="<?= old('repeted_after') ?>" min="0">
                        </div>

                        
                        
                        <!--maximum day for booking-->
                        <div class="col-6 mt-2">
                            <label for="maxdayforbooking" class="form-label"><?php echo lang("Maximum Day For Booking") ?> </label>
                            
                        </div>
                        <div class="col-6 mt-2">
                            
                            <input type="number" id="maxdayforbooking" name="maxdayforbooking" class="form-control" value="<?= old('maxdayforbooking') ?>" min="0">
                        </div>
                        
                        <div class="col-4 mt-2">
                            <label for="weekend" class="form-label"><?php echo lang("Days Off") ?> </label>
                            
                        </div>
                        <div class="col-8 mt-2 text-end">
                            
                            <div class="d-flex flex-wrap">
                                <?php foreach ($weekday as $key => $weekdayvalue) : ?>
                                <div class="form-check me-3">
                                <input class="form-check-input" type="checkbox" style="border-color:green;" name="weekend[]" value="<?php echo $key ?>" id="weekend_<?php echo $key ?>">
                                <label class="form-check-label" for="weekend_<?php echo $key ?>">
                                <?php echo $weekdayvalue ?>
                                </label>
                                </div>
                                <?php endforeach ?>
                            </div>
                        </div>
                        
                        <!--off dates-->
                        <div class="col-4 mt-2">
                            <label for="offdates" class="form-label"><?php echo lang("Off Dates") ?> </label>
                            
                        </div>
                        
                        <div class="col-8 mt-2 text-end">
                            
                            <span id="adddayoffid"></span>
                            <input type="hidden" name="offdates" id="offdates"/>
                            
                            <button onclick="addnewdaysoff()"  style="background-color: #4CAF50;color: white;padding: 10px 20px;margin-bottom: 10px;border: none;cursor: pointer;">Add New Off Date</button>
                        </div>
                        
                        
                        <!--off dates in range-->
                        <div class="col-4 mt-2">
                            <label for="offdatesInrange" class="form-label"><?php echo lang("Off Dates In Range") ?> </label>
                            
                        </div>
                        
                        <div class="col-8 mt-2 text-end">
                            
                            <span id="startdateinrange1"></span><span id="enddateinrange1"></span>
                            <input type="hidden" name="startdateinrange2" id="startdateinrange2" />
                            <input type="hidden" name="enddateinrange2" id="enddateinrange2" />
                            
                            <button onclick="offdateinrange()" style="background-color: #4CAF50;color: white;padding: 10px 20px;margin-bottom: 10px;border: none;cursor: pointer;">Add New Off Date Range</button>
                        </div>
                        
                        
                        
                    </div>
                </div>

                <div class="bg-light p-3 my-2">
                    <strong class="mb-1"><?php echo lang("Localize.vehicle") ?></strong>
                    <div class="row">

                        <div class="col-3 ">
                            <label for="fleet_id" class="form-label"><?php echo lang("Localize.fleet") ?> <?php echo lang("Localize.type") ?>  <abbr title="Required field">*</abbr></label>
                            <select id="fleet_id" name="fleet_id" class="form-select select2" required>
                                <option value=""><?php echo lang("Localize.none") ?></option>
                                <?php foreach ($fleet_type as $fleet_typevalue) : ?>

                                    <option value="<?php echo $fleet_typevalue->id ?>"><?php echo $fleet_typevalue->type ?></option>

                                <?php endforeach ?>
                            </select>
                        </div>

                        <div class="col-3 ">
                            <label for="vehicle_id" class="form-label"><?php echo lang("Localize.vehicle") ?> <?php echo lang("Localize.list") ?> <abbr title="Required field">*</abbr></label>
                            <div class="inline-loader-wrapper" id="vehicle-id-wrapper">
                                <select id="vehicle_id" name="vehicle_id" class="form-select select2" required>
                                    <option value="" readonly><?php echo lang('Localize.select') . " " . lang('Localize.vehicle'); ?></option>
                                </select>
                            </div>
                        </div>

                        <div class="col-3 ">
                            <label for="driver" class="form-label"><?php echo lang("Localize.driver") ?> <?php echo lang("Localize.list") ?>  <abbr title="Required field">*</abbr></label>
                            
                            <select multiple="multiple" name="driver[]" class="testselect3" required>
                                <option value="" disabled selected><?php echo lang("Localize.none") ?></option>
                                <?php foreach ($driver as $drivervalue) : ?>

                                    <option value="<?php echo $drivervalue->id ?>"><?php echo $drivervalue->first_name ?> <?php echo $drivervalue->last_name ?></option>

                                <?php endforeach ?>
                            </select>
                        </div>

                        <div class="col-3 ">
                            <label for="assistant" class="form-label"><?php echo lang("Localize.assistant") ?> <?php echo lang("Localize.list") ?>  <abbr title="Required field">*</abbr></label>
                            <select multiple="multiple" name="assistant[]" class="testselect3" required>
                                <option value="" disabled selected><?php echo lang("Localize.none") ?></option>

                                <?php foreach ($assistant as $assistantvalue) : ?>
                                    <option value="<?php echo $assistantvalue->id ?>"><?php echo $assistantvalue->first_name ?> <?php echo $assistantvalue->last_name ?></option>
                                <?php endforeach ?>
                            </select>
                        </div>

                        <div class="col-3 mt-2">
                            <label for="company_name" class="form-label"><?php echo lang("Localize.company") ?> <?php echo lang("Localize.name") ?>  <abbr title="Required field">*</abbr></label>
                            <input type="text" id="company_name" name="company_name" class="form-control" value="<?= old('company_name') ?>" placeholder="<?php echo lang("Localize.company") ?> <?php echo lang("Localize.name") ?>" required />
                        </div>
                    </div>
                </div>

                <label for="status" class="form-label"><?php echo lang("Localize.trip") ?> <?php echo lang("Localize.status") ?> </label>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="status" id="active" value="1" checked>
                    <label class="form-check-label" for="active">
                        <?php echo lang("Localize.active") ?>
                    </label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="status" value="0" id="disable">
                    <label class="form-check-label" for="disable">
                        <?php echo lang("Localize.disable") ?>
                    </label>
                </div>

                <div class="text-danger">
                    <?php if (isset($validation)) : ?>
                        <?= $validation->listErrors(); ?>
                    <?php endif ?>
                </div>

                <br>
                <input type="hidden" id="baseurl" name="baseurl" value="<?php echo esc(base_url()) ?>">

                <br>
                <div class="col-12">
                    <button type="submit" class="btn btn-success"><?php echo lang("Localize.submit") ?></button>
                </div>

            </form>
        </div>
    </div>
    
    
    <!--model for wallet-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Add New Off Date</h5>
        <button type="button" class="close"  onclick='modelClose()' data-dismiss="exampleModal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
        </button>
      </div>
        <form>
            <?php echo $this->include('common/security') ?>
            <div class="modal-body">
                <div class="row">
                    
                    <div class="col-md-6">
                       <label for="">Add Date Off</label>
                        
                        <div class="input-group date datepicker" id="repetedenddate">
                            <input type="text" class="form-control" name="addDateoff" onchange="valuepassdayoff()" id="addDateoff" readonly required />
                            <div class="input-group-addon"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" onclick='modelClose()' class="btn btn-secondary" data-dismiss="exampleModal">Close</button>
                <button type="button" onclick="modelClose()" class="btn btn-primary" data-dismiss="exampleModal">submit</submit>
            </div>
        </form>
    </div>
  </div>
</div>  


<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<div class="modal fade" id="offdateinrange" tabindex="-1" role="dialog" aria-labelledby="offdateinrangeLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="offdateinrangeLabel">Add Day Off in Range Date</h5>
        <button type="button" class="close"  onclick='bmodelClose()' data-dismiss="offdateinrange" aria-label="Close">
        <span aria-hidden="true">&times;</span>
        </button>
      </div>
        <form>
            <?php echo $this->include('common/security') ?>
            <div class="modal-body">
                <div class="row">
                    
                    <div class="col-md-6">
                       <label for="">Start</label>
                        
                        <div class="input-group date datepicker" >
                            <input type="text" class="form-control" name="daysInRangeStart" onchange="valuepassdayoffinRange()" id="daysInRangeStart" required />
                            <div class="input-group-addon"></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                       <label for="">End</label>
                        
                        <div class="input-group date datepicker" >
                            <input type="text" class="form-control" name="daysInRangeEnd" onchange="valuepassdayoffinRange()" id="daysInRangeEnd" required />
                            <div class="input-group-addon"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" onclick='bmodelClose()' class="btn btn-secondary" data-dismiss="offdateinrange">Close</button>
                <button type="button" onclick="bmodelClose()" class="btn btn-primary" data-dismiss="offdateinrange">submit</submit>
            </div>
        </form>
    </div>
  </div>
</div>

<script>
    function toggleRepetedFields() {
        var oprationDatetype = document.querySelector('select[name="oprationDatetype"]').value;
        var repetedstartdate = document.getElementById('repetedstartdate');
        var repetedenddate = document.getElementById('repetedenddate');
        var repeted_after = document.getElementById('repeted_after');
        
        if (oprationDatetype === 'nonRepeted') {
            repetedstartdate.disabled = true;
            repetedenddate.disabled = true;
            repeted_after.disabled = true;
            repetedstartdate.required = false;
            repetedenddate.required = false;
        } else {
            repetedstartdate.disabled = false;
            repetedenddate.disabled = false;
            repeted_after.disabled = false;
            repetedstartdate.required = true;
            repetedenddate.required = true;
        }
    }

    // Call the function initially to set the correct state based on the initial value
    document.addEventListener('DOMContentLoaded', toggleRepetedFields);
</script>
</script>

<script>
    
    function valuepassdayoff(){
        
       let addDateoff = $('#addDateoff').val();
        $('#adddayoffid').html(addDateoff);
        $('#offdates').val(addDateoff);
    }
    
    function valuepassdayoffinRange(){
        let daysInRangeStart = $('#daysInRangeStart').val();
        let daysInRangeEnd = $('#daysInRangeEnd').val();
            $('#startdateinrange1').html("start "+daysInRangeStart);
            $('#startdateinrange2').val(daysInRangeStart);
            $('#enddateinrange1').html(", end "+daysInRangeEnd);    
            $('#enddateinrange2').val(daysInRangeEnd);
    }


    function offdateinrange(){
        $("#offdateinrange").modal("show");
    }
    
    function bmodelClose(){ 
        $("#offdateinrange").modal("hide");
    }

    function addnewdaysoff(){
        $("#exampleModal").modal("show");
    }

    function modelClose(){
        $("#exampleModal").modal("hide");
    }
</script>
    <!--model end-->
<?php echo $this->endSection() ?>



<?php echo $this->section('js') ?>
    <script src="<?php echo base_url('public/js/ajax.js'); ?>"></script>
    <script src="<?php echo base_url('public/js/dynamicinput.js'); ?>"></script>
    <script src="<?php echo base_url('public/plugins/select2/select2.min.js'); ?>"></script>
<?php echo $this->endSection() ?>