<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>

    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <form action="<?php echo base_url(route_to('create-fleet')) ?>" id="fleet" method="post" class="row g-3" accept-charset="utf-8" enctype="multipart/form-data">
                        <?php echo $this->include('common/security') ?>
        
                        <div class="row">
                            <div class="col-3">
                                <label for="fleettype" class="form-label"><?php echo lang("Localize.fleet") . " " . lang("Localize.type") ?> <abbr title="Required field">*</abbr></label>
                                <input type="text" placeholder="<?php echo lang("Localize.fleet") . " " . lang("Localize.type") ?>" name="type" value="<?php echo esc(old('type')) ?>" class="form-control" required />
                            </div>
            
                            <div class="col-3 ">
                                <label for="layout" class="form-label"><?php echo lang("Localize.fleet") . " " . lang("Localize.layout") ?> <abbr title="Required field">*</abbr></label>
                                <select id="layout" class="form-select" name="layout" required="required">
                                    <option value="" disabled selected><?php echo lang("Localize.seat") ?> <?php echo lang("Localize.type") ?> </option>
                                    <option value="2-2">2-2</option>
                                    <option value="2-1">2-1</option>
                                    <option value="1-2">1-2</option>
                                    <option value="1-1">1-1</option>
                                    <!-- <option value="3-2">3-2</option> -->
                                    <!-- <option value="2-3">2-3</option> -->
                                    <!-- <option value="1-1-1">1-1-1</option> -->
                                    <!-- <option value="1 & 3 & 2-1 & 3">1-0,2-1</option> -->
                                    <option value="4-1">4-1</option>
                                    
                                    
                                    <!--<option value="1-2-1">1-2-1</option>-->
                                </select>
                            </div>
                            <div class="col-4">
                                <label for="total_seat" class="form-label"><?php echo lang("Localize.total") ?> <?php echo lang("Localize.seat") ?> <abbr title="Required field">*</abbr></label>
                                <select name="total_seat" id="total_seat" class="form-select" required>
                                    <option value="" disabled selected><?php echo lang("Localize.select") ?> <?php echo lang("Localize.total") ?> <?php echo lang("Localize.seat") ?></option>
                                </select>
                            </div>
                            <div class="col-3 mt-1">
                                <div class="form-check" id="forth_seat_div">
                                    <input class="form-check-input position-static" type="checkbox" id="forth_seat" value="1" name="forth_seat">
            
                                    <label class="form-check-label" for="forth_seat">
                                        4 Seat Check
                                    </label>
                                </div>
                            </div>
            
                            <div class="col-3 mt-1">
                                <div class="form-check" id="last_seat_div"> 
                                    <input class="form-check-input" type="checkbox" id="last_seat" value="1" name="last_seat">
                                    
                                    <label class="form-check-label" for="last_seat">
                                        13 Seat Check
                                    </label>
                                </div>
                            </div>

                            <div class="col-3 mt-1">
                                <div class="form-check" id="wc_div"> 
                                    <input class="form-check-input" type="checkbox" id="wc" value="1" name="wc">
                                    <label class="form-check-label" for="wc">
                                        WC
                                    </label>
                                </div>
                            </div>
            
                           
            
                            <div class="mb-3">
                                <label for="seat_number" class="form-label"><?php echo lang("Localize.seat") . " " . lang("Localize.number") ?> <abbr title="Required field">*</abbr></label>
                                <textarea class="form-control" name="seat_number" id="seat_number" rows="3" required></textarea>
                            </div>
            
                            <div class="col-3">
                                <label class="form-label" for="">
                                    <?php echo lang("Localize.luggage") ?> <?php echo lang("Localize.service") ?>
                                    <abbr title="Required field">*</abbr>
                                </label>
            
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="luggage_service" id="luggage_service" value="1" checked>
                                    <label class="form-check-label" for="exampleRadios1">
                                        <?php echo lang("Localize.active") ?>
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="luggage_service" id="luggage_service" value="0">
                                    <label class="form-check-label" for="exampleRadios2">
                                        <?php echo lang("Localize.disable") ?>
                                    </label>
                                </div>
                            </div>
            
                            <div class="col-3">
                                <label class="form-group" for="">
                                    <?php echo lang("Localize.status") ?>
                                    <abbr title="Required field">*</abbr>
                                </label>
                                
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="status" id="status" value="1" checked>
                                    <label class="form-check-label" for="exampleRadios1">
                                        <?php echo lang("Localize.active") ?>
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="status" id="status" value="0">
                                    <label class="form-check-label" for="exampleRadios2">
                                        <?php echo lang("Localize.disable") ?>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <label for="buspic" class="form-label"><?php echo lang("Localize.bus") ?> <?php echo lang("Localize.image") ?> </label>
                            <div id="buspic"></div>
                        </div>
        
                        <div class="text-danger">
                            <?php if (isset($validation)) : ?>
                                <?= $validation->listErrors(); ?>
                            <?php endif ?>
                        </div>
        
                        <div class="col-12 text-center">
                            <button type="submit" class="btn btn-success"><?php echo lang("Localize.submit") ?></button>
                            <button type="button" class="btn btn-success" id="layoutButton"><?php echo "seatLayout"; ?></button>
                        </div>    
                    </form>
                </div>
            </div>
            <div id="seatLayoutContainer" class="mt-4"></div>

        </div>
    </div>
<?php echo $this->endSection() ?>

<?php echo $this->section('js') ?>
    <script src="<?php echo base_url('public/js/fleet.js'); ?>"></script>
    <script>
        $(document).ready(function() {
            $('#forth_seat_div, #last_seat_div','#wc_div').hide();
            $('#layout').change(function () {
                var selectedValue = $(this).val();
                var totalSeatSelect = $('#total_seat');
                totalSeatSelect.empty();
                totalSeatSelect.append('<option value="" disabled selected><?php echo lang("Localize.select") ?> <?php echo lang("Localize.total") ?> <?php echo lang("Localize.seat") ?></option>');

                // Hide all buttons by default
                $('#forth_seat_div, #last_seat_div').hide();
                $('#forth_seat, #last_seat' ).prop('checked', false);
                $('#wc_div').show();

                // Show specific buttons based on selected value
                if (selectedValue === '4-1') {
                    $('#forth_seat_div, #last_seat_div').show();
                    $('#wc_div').hide();
                    $('#wc').prop('checked', false);
                    totalSeatSelect.append('<option value="14">14</option>');
                } else if (selectedValue === '2-2') {
                    totalSeatSelect.append('<option value="29">29</option>');
                    totalSeatSelect.append('<option value="33">33</option>');
                    totalSeatSelect.append('<option value="49">49</option>');
                    totalSeatSelect.append('<option value="61">61</option>');
                } else if (selectedValue === '2-1' || selectedValue === '1-2') {
                    totalSeatSelect.append('<option value="24">24</option>');
                    totalSeatSelect.append('<option value="26">26</option>');
                } else if (selectedValue === '1-1') {
                    totalSeatSelect.append('<option value="49">49</option>');
                }

            });

            $('#layoutButton').click(function() {
                var totalSeat = $('#total_seat').val();
                var layout = $('#layout').val();
                var seatNumber = $('#seat_number').val();
                // var forth_seat = $('#forth_seat').val();
                var forth_seat = $('#forth_seat').prop('checked') ? 1 : 0;
                // var last_seat = $('#last_seat').val();
                var last_seat = $('#last_seat').prop('checked') ? 1 : 0;
                var wc = $('#wc').prop('checked') ? 1 : 0;


                $.ajax({
                    url: '<?php echo base_url('modules/backend/fleets/getSeatLayout'); ?>',
                    type: 'GET',
                    headers: { "X-CSRF-TOKEN": "<?= csrf_hash() ?>" },
                    data: {
                        totalSeat:totalSeat,
                        seatLayout:layout,
                        seat_number:seatNumber,
                        forth_seat:forth_seat,
                        last_seat:last_seat,
                        wc:wc,

                    },
                    success: function(response) {
                        $('#seatLayoutContainer').html(response);
                    },
                    error: function(xhr, status, error) {
                        console.error('Error fetching seat layout:', error);
                    }
                });
            });
            $('#total_seat').change(function() {
            var totalSeat = $(this).val();
                if (totalSeat) {
                    var seatNumbers = [];
                    for (var i = 1; i <= totalSeat; i++) {
                        seatNumbers.push(i);
                    }
                    $('#seat_number').val(seatNumbers.join(','));
                }
            });
        });
    </script>
<?php echo $this->endSection() ?>