<?php

$routes->group('modules/backend/terms', ["filter" => "cors", "namespace" => "\Modules\Term\Controllers"], function ($routes) {
    $routes->get('new', 'Term::new', ['as' => 'new-company-term']);
    $routes->post('', 'Term::create', ['as' => 'create-company-term']);
    $routes->post('', 'Term::create', ['as' => 'status-term']);
    $routes->put('status/(:segment)', 'Term::status/$1', ['as' => 'status-term']);

    $routes->get('', 'Term::index', ['as' => 'index-company-term']);
    $routes->get('(:segment)/edit', 'Term::edit/$1', ['as' => 'edit-term']);
    
    $routes->put('(:segment)/(:segment)', 'Term::update/$1/$2', ['as' => 'update-company-term']);

    $routes->get('(:segment)/edit/company', 'Term::edit_company_term/$1', ['as' => 'edit-company-term']);
    $routes->put('(:segment)/(:segment)/company', 'Term::update_company_term/$1/$2', ['as' => 'update-company-term']);
    $routes->get('(:segment)/clear/company', 'Term::clear_company_term/$1', ['as' => 'clear-company-term']);
    
    $routes->delete('(:segment)', 'Term::delete/$1', ['as' => 'delete-term']);

    $routes->get('trash', 'Term::index/1', ['as' => 'trash-index-term']);
    $routes->get('restore/(:segment)', 'Term::restore/$1', ['as' => 'restore-term']);

});
