<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('css') ?>
    <link rel="stylesheet" href="<?php echo base_url('public/css/customestyle.css'); ?>" type="text/css">
<?php echo $this->endSection() ?>

<?php echo $this->section('content') ?>

    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">
            <?php if ($add_data == true) : ?>
                <div class="text-end mb-3">
                    <a class="btn btn-sm btn-success" href="<?php echo base_url(route_to('new-trip')) ?>">
                        <i class="fas fa-suitcase"></i> <sup><i class="fas fa-plus small"></i></sup>
                        <?php echo lang("Localize.add_trip") ?>
                    </a>
                </div>
            <?php endif ?>
            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover" id="triplist" data-server="true">
                    <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col"><?php echo lang("Localize.pick_up") ?> </th>
                            <th scope="col"><?php echo lang("Localize.drop") ?> </th>
                            <th scope="col"><?php echo lang("Localize.schedule") ?> </th>
                            <th scope="col"><?php echo lang("Localize.distance") ?> </th>
                            <th scope="col"><?php echo lang("Localize.hour") ?> </th>
                            <?php if(session()->get('role_id') == "1"){ ?>
                                <th scope="col"><?php echo lang("Localize.company") ?> </th>
                            <?php } ?>
                            <th scope="col"><?php echo lang("Localize.trip").lang("Localize.id") ?> </th>
                            <th scope="col"><?php echo lang("Localize.status") ?> </th>
                            <th scope="col"><?php echo lang("Localize.action") ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        
                    </tbody>
                </table>
            </div>

        </div>
    </div>
    <?php echo $this->include('common/confirmation-modal') ?>
    <?php echo $this->include('common/datatable_default_lang_change') ?>
    
    <!-- CSRF Token for AJAX -->
    <input type="hidden" name="<?php echo csrf_token(); ?>" id="csrf_token" value="<?php echo csrf_hash(); ?>">
    
<?php echo $this->endSection() ?>

<?php echo $this->section('js') ?>
<script>
    $(document).ready(function () {
        // Check if DataTable is loaded
        if (typeof $.fn.DataTable === 'undefined') {
            console.error('DataTables is not loaded. Please check if datatables.min.js is included.');
            return;
        }
        
        // Get company name from hidden input or use default
        var companyname = $("#logotext").val() || "<?php echo lang('Localize.trip_list'); ?>";
        
        // Check if table exists
        if ($('#triplist').length === 0) {
            console.error("Table #triplist not found!");
            return;
        }
        
        // Destroy existing DataTable instance if it exists (from mydatatable.js client-side init)
        if ($.fn.DataTable.isDataTable('#triplist')) {
            $('#triplist').DataTable().destroy();
            console.log("Destroyed existing client-side DataTable instance for #triplist");
        }
        
        console.log("Initializing server-side DataTable for #triplist");
        console.log("Number of header columns:", $('#triplist thead th').length);

        var table = $('#triplist').DataTable({
            processing: true,
            serverSide: true,
            lengthMenu: [[10, 15, 20, 25, 30, 40, 50, -1], [10, 15, 20, 25, 30, 40, 50, "All"]],
            dom: 'lBfrtip',
            language: {
                search: search,
                lengthMenu: lengthMenu,
                zeroRecords: zeroRecords,
                info: info,
                infoEmpty: infoEmpty,
                infoFiltered: infoFiltered,
                paginate: {
                    first: first,
                    previous: previous,
                    next: next,
                    last: last
                }
            },

            ajax: {
                url: "<?= base_url(route_to('server-trip-list')); ?>",
                type: "POST",
                data: function(d) {
                    // Add CSRF token to the request data
                    var csrfToken = $('#csrf_token').val() || $('input[name="<?php echo csrf_token(); ?>"]').val();
                    if (csrfToken) {
                        d.<?php echo csrf_token(); ?> = csrfToken;
                    }
                    return d;
                },
                beforeSend: function(xhr) {
                    // Set CSRF token in header
                    var csrfToken = $('#csrf_token').val() || $('input[name="<?php echo csrf_token(); ?>"]').val();
                    if (csrfToken) {
                        xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken);
                        xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
                    }
                },
                dataSrc: 'data',
                error: function(xhr, error, code) {
                    console.error("DataTables AJAX Error:", error, code);
                    console.error("Response:", xhr.responseText);
                    if (xhr.status === 403) {
                        alert("CSRF token validation failed. Please refresh the page and try again.");
                    }
                }
            },

            buttons: [
                {
                    extend: 'copy',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: <?php echo session()->get('role_id') == "1" ? '[0,1,2,3,4,5,6,7,8]' : '[0,1,2,3,4,5,6,7]'; ?>}
                },
                {
                    extend: 'csv',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: <?php echo session()->get('role_id') == "1" ? '[0,1,2,3,4,5,6,7,8]' : '[0,1,2,3,4,5,6,7]'; ?>}
                },
                {
                    extend: 'excel',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: <?php echo session()->get('role_id') == "1" ? '[0,1,2,3,4,5,6,7,8]' : '[0,1,2,3,4,5,6,7]'; ?>}
                },
                {
                    extend: 'pdf',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: <?php echo session()->get('role_id') == "1" ? '[0,1,2,3,4,5,6,7,8]' : '[0,1,2,3,4,5,6,7]'; ?>}
                },
                {
                    extend: 'print',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: <?php echo session()->get('role_id') == "1" ? '[0,1,2,3,4,5,6,7,8]' : '[0,1,2,3,4,5,6,7]'; ?>}
                }
            ],

            columns: [
                { data: "index", orderable: false },
                { data: "pick_up" },
                { data: "drop" },
                { data: "schedule" },
                { data: "distance", orderable: false },
                { data: "hour" }<?php if(session()->get('role_id') == "1"): ?>,
                { data: "company" }<?php endif; ?>,
                { data: "trip_id" },
                { data: "status", orderable: false },
                { data: "action", orderable: false, searchable: false }
            ],

            responsive: true,

            initComplete: function () {
                var api = this.api();
                console.log("DataTables initialized. Columns:", api.columns().count());
                console.log("DataTables data:", api.rows().data().toArray());

                $('.column-search').on('keyup', function () {
                    let colIndex = $(this).data('col');
                    api.column(colIndex).search(this.value).draw();
                });
                
            },
            
            drawCallback: function(settings) {
                console.log("DataTables draw callback fired");
                var api = this.api();
                console.log("Current page data:", api.rows({page: 'current'}).data().toArray());
            }
        });

    });
</script>
<?php echo $this->endSection() ?>