<?php

$routes->group('modules/backend/companies', ["filter" => "cors", "namespace" => "\Modules\Company\Controllers"], function ($routes) {
    $routes->get('new', 'Company::new', ['as' => 'new-company']);
    $routes->post('', 'Company::create', ['as' => 'create-company']);
    $routes->get('', 'Company::index', ['as' => 'index-company']);
    $routes->get('(:segment)/edit', 'Company::edit/$1', ['as' => 'edit-company']);
    $routes->put('status/(:segment)', 'Company::status/$1', ['as' => 'status-company']);
    $routes->put('(:segment)/(:segment)', 'Company::update/$1/$2', ['as' => 'update-company']);
    $routes->delete('(:segment)', 'Company::delete/$1', ['as' => 'delete-company']);

    $routes->get('trash', 'Company::index/1', ['as' => 'trash-index-company']);
    $routes->get('restore/(:segment)', 'Company::restore/$1', ['as' => 'restore-company']);

    // $routes->get('commission/(:segment)', 'Company::companyCommissionDetails/$1',['as' => 'commission-company']);

    $routes->get('transaction/(:segment)', 'Company::companyTransactionDetails/$1', ['as' => 'transaction-company']);
    $routes->post('date/range', 'Company::companyTranDateRange', ['as' => 'trandaterange-company']);
    $routes->post('payment/update_payment', 'Company::updatePaymentByAdmin', ['as' => 'update-payment']);
});
