<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>
    <style>
        .trip-group {
            display: flex;
            align-items: center;
            font-weight: bold;
            padding: 8px;
            background-color: #f8f9fa;
            border-radius: 5px;
            margin-bottom: 5px;
        }

        .subtrip-container {
            margin-left: 20px;
            padding-left: 10px;
            border-left: 2px solid #ccc;
            max-height: 150px; /* Set a max height for scrolling */
            overflow-y: auto;
        }

        #tripContainer {
            max-height: 300px; /* Set a height for scrolling */
            overflow-y: auto;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            background-color: #fff;
        }

        /* Style checkboxes */
        input[type="checkbox"] {
            margin-right: 8px;
            transform: scale(1.2);
            cursor: pointer;
        }

    </style>
    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">
            <form action="<?php echo base_url(route_to('update-coupon', $coupon->id)) ?>" id="couponedit" method="post" class="row g-3" accept-charset="utf-8" enctype="multipart/form-data">
                <?php echo $this->include('common/securityupdate') ?>

                <div class="row justify-content-center">
                    <div class="col-4">
                        <div class="row">
                            <input type="hidden" id="selectedSubTrips" value='<?php echo json_encode($selectedSubTrips); ?>'>
                            <?php if ($roleId == 1): ?>
                                <div class="col-12 mt-3">
                                    <label for="company"><?php echo lang("Localize.company") ?> <abbr title="Required field">*</abbr></label>
                                    <select class="form-select" name="company[]" id="company" multiple>
                                        <?php foreach ($companies as $company) : ?>
                                            <option value="<?php echo $company->id; ?>" 
                                                <?php echo in_array($company->id, (array) $selectedCompanies) ? 'selected' : ''; ?>>
                                                <?php echo $company->name; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            <?php elseif ($roleId == 7): ?>
                                <?php foreach ($selectedCompanies as $companyId): ?>
                                    <input type="hidden" name="company[]" value="<?php echo $companyId; ?>">
                                <?php endforeach; ?>
                            <?php endif; ?>

                            <div class="col-12 mt-3">
                                <label class="form-group" for="" style='white-space: nowrap;'>
                                    Select Type
                                    <abbr title="Required field">*</abbr>
                                </label>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="coupon_type" id="online" value="1" <?= isset($coupon->coupon_for) && $coupon->coupon_for == "1" ? 'checked' : '' ?>>
                                    <label class="form-check-label" for="activated">
                                        <?php echo lang("Localize.online") ?>
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="coupon_type" id="offline_agent" value="0" <?= isset($coupon->coupon_for) && $coupon->coupon_for == "0" ? 'checked' : '' ?>>
                                    <label class="form-check-label" for="offline_agent">
                                        <?php echo lang("Localize.offline_agent") ?>
                                    </label>
                                </div>
                            </div>

                            <div class="col-12 mt-3">
                                <label for="code" class=""><?php echo lang("Localize.coupon") ?> <?php echo lang("Localize.code") ?> <abbr title="Required field">*</abbr></label>
                                <input type="text" id="code" name="code" value="<?php echo esc(old('code') ?? $coupon->code) ?>" class="form-control" required />
                            </div>

                            <div class="col-12 mt-3" id="payment_method">
                                <!-- <label for="subtrip_id"><?php echo lang("Localize.sub") ?> <?php echo lang("Localize.trip") ?> <abbr title="Required field">*</abbr></label> -->
                                
                                <!-- <select class="form-select" name="subtrip_id" id="subtrip_id"> -->
                                </select>
                            </div>

                            <!-- <div class="col-12 mt-3">
                                <label for="subtrip_id">
                                    <?php echo lang("Localize.sub") ?> <?php echo lang("Localize.trip") ?><abbr title="Required field">*</abbr>
                                </label>
                                <div id="tripContainer">
                                    <?php if (!empty($trips)) : ?>
                                        <?php foreach ($trips as $trip) : ?>
                                            
                                            <div class="trip-group">
                                            <label>
                                                <input type="checkbox" 
                                                    class="main-trip"
                                                    data-trip-id="<?php echo $trip->id; ?>"
                                                    name="main_trips[]" 
                                                    value="<?php echo $trip->id; ?>"
                                                    <?php echo in_array($trip->id, $selectedMainTrips) ? 'checked' : ''; ?>>
                                                <?php echo $trip->picklocation . ' -- ' . $trip->droplocation; ?>
                                            </label>
                                            </div>

                                            <div class="subtrip-container" style="margin-left: 20px;">
                                                <?php if (!empty($trip->children)) : ?>
                                                    <?php foreach ($trip->children as $subtrip) : ?>
                                                        <label>
                                                            <input type="checkbox" 
                                                                class="sub-trip"
                                                                data-parent-id="<?php echo $trip->id; ?>"
                                                                data-trip-id="<?php echo $trip->id; ?>"
                                                                name="subtrips[<?php echo $trip->id; ?>][]" 
                                                                value="<?php echo $subtrip->id; ?>"
                                                                <?php echo in_array((string)$subtrip->id, $selectedSubTrips) ? 'checked' : ''; ?>>
                                                            <?php echo $subtrip->picklocation . ' -- ' . $subtrip->droplocation; ?>
                                                        </label>
                                                    <?php endforeach; ?>
                                                <?php else : ?>
                                                    <div>No subtrips available</div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endforeach; ?>
                                    <?php else : ?>
                                        <div>No trips found</div>
                                    <?php endif; ?>
                                </div>
                            </div> -->

                            <div class="col-12 mt-3">
                                <label for="subtrip_id">
                                    <?php echo lang("Localize.sub") ?> <?php echo lang("Localize.trip") ?><abbr title="Required field">*</abbr>
                                </label>
                                <div id="tripContainer">
                                    <?php if (!empty($trips)) : ?>
                                        <?php foreach ($trips as $trip) : ?>
                                            
                                            <div class="trip-group">
                                                <label>
                                                    <input type="checkbox" 
                                                        class="main-trip"
                                                        data-trip-id="<?php echo $trip->id; ?>"
                                                        name="main_trips[]" 
                                                        value="<?php echo $trip->id; ?>"
                                                        <?php echo in_array($trip->id, $selectedMainTrips) ? 'checked' : ''; ?>>
                                                    <?php echo $trip->picklocation . ' -- ' . $trip->droplocation. "( ". $trip->id ." )";?>
                                                </label>
                                            </div>

                                            <div class="subtrip-container">
                                                <?php if (!empty($trip->children)) : ?>
                                                    <?php foreach ($trip->children as $subtrip) : ?>
                                                        <label>
                                                            <input type="checkbox" 
                                                                class="sub-trip"
                                                                data-parent-id="<?php echo $trip->id; ?>"
                                                                data-trip-id="<?php echo $trip->id; ?>"
                                                                name="subtrips[<?php echo $trip->id; ?>][]" 
                                                                value="<?php echo $subtrip->id; ?>"
                                                                <?php echo in_array((string)$subtrip->id, $selectedSubTrips) ? 'checked' : ''; ?>>
                                                            <?php echo $subtrip->picklocation . ' -- ' . $subtrip->droplocation; ?>
                                                        </label><br>
                                                    <?php endforeach; ?>
                                                <?php else : ?>
                                                    <div>No subtrips available</div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endforeach; ?>
                                    <?php else : ?>
                                        <div>No trips found</div>
                                    <?php endif; ?>
                                </div>
                            </div>


                            <div class="col-12 mt-3">
                                <label for="start_date" class="form-label"><?php echo lang("Localize.date") ?> <abbr title="Required field">*</abbr></label>
                                <div class="input-append date datepicker" id="start_date" data-date-format="yyyy-mm-dd">
                                    <input size="16" type="text" name="start_date" class="form-control will-fill-by-plugin" value="<?php echo $coupon->start_date ?>" required readonly />
                                    <span class="add-on"><i class="icon-th"></i></span>
                                </div>
                            </div>

                            <div class="col-12 mt-3">
                                <label for="end_date" class="form-label"> <?php echo lang("Localize.date") ?> <abbr title="Required field">*</abbr></label>
                                <div class="input-append date datepicker" id="end_date" data-date-format="yyyy-mm-dd">
                                    <input size="16" type="text" name="end_date" class="form-control will-fill-by-plugin" value="<?php echo $coupon->end_date ?>" required readonly />
                                    <span class="add-on"><i class="icon-th"></i></span>
                                </div>
                            </div>

                             <div class="col-12 mt-3" >
                                <label for="subtrip_id">Discount Type </label>
                                <select class="form-select" name="discount_type" id="discount_type" required onchange="getDiscountType()">
                                   <option>Select</option>
                                   <option value='1' <?php echo ($coupon->discount_type == '1') ? 'selected' : ''; ?>>Amount</option>
                                   <option value='2' <?php echo ($coupon->discount_type == '2') ? 'selected' : ''; ?>>Percent</option>
                                </select>
                            </div>
                            <div class="col-12 mt-3">
                                <label for="discount" class=""><?php echo lang("Localize.discount") ?> <span id='partype'></span> <abbr title="Required field">*</abbr></label>
                                <input type="number" id="discount" name="discount" value="<?php echo esc(old('discount') ?? $coupon->discount) ?>" class="form-control" placeholder="<?php echo lang("Localize.discount") ?> <?php echo lang("Localize.amount") ?>" min="0" required />
                            </div>

                            <div class="col-12 mt-3">
                                <label for="condition" class="form-label"><?php echo lang("Localize.terms_conditions") ?> <abbr title="Required field">*</abbr></label>
                                <textarea class="form-control" name="condition" id="condition" rows="3" required><?php echo old('condition') ?? $coupon->condition ?></textarea>
                            </div>

                            <div class="text-danger">
                                <?php if (isset($validation)) : ?>
                                    <?= $validation->listErrors(); ?>
                                <?php endif ?>
                            </div>
                        </div>

                        <br>
                        <div class="col-12 text-center mt-3">
                            <button type="submit" class="btn btn-success"><?php echo lang("Localize.submit") ?></button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <script>
    getDiscountType();
    function getDiscountType() {
        var discountType = document.getElementById('discount_type').value;
        if(discountType == 1){
            $("#partype").html(" Amount");
            $('#discount').attr('placeholder', "Discount Amount");
        }else{
            $("#partype").html(" Percent");
            $('#discount').attr('placeholder', "Discount Percent");
        }
    }

    $(document).ready(function () {
    // Auto-select all sub-trips when main trip is selected
        $(document).on('change', '.main-trip', function () {
            const tripId = $(this).data('trip-id');
            $(`.sub-trip[data-parent-id="${tripId}"]`).prop('checked', $(this).prop('checked'));
        });

        // Check main trip if any sub-trip is selected
        $(document).on('change', '.sub-trip', function () {
            const tripId = $(this).data('parent-id');

            // If at least one sub-trip is checked, check the main trip
            const anySubChecked = $(`.sub-trip[data-parent-id="${tripId}"]:checked`).length > 0;

            $(`.main-trip[data-trip-id="${tripId}"]`).prop('checked', anySubChecked);
        });
    });

</script>
<?php echo $this->endSection() ?>
<?php echo $this->section('js') ?>
    <script src="<?php echo base_url('public/js/jquery.sumoselect.min.js'); ?>"></script>
    <script src="<?php echo base_url('public/js/dynamicinput.js'); ?>"></script>
    <script src="<?php echo base_url('public/plugins/select2/select2.min.js'); ?>"></script>
<?php echo $this->endSection() ?>