<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>
    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">
            
            <?php if($role_id == 1){ ?>
                <div class="text-end">
                    <a class="btn btn-primary mb-3" href="<?php echo base_url(route_to('index-company-term')) ?>"><i class="fas fa-backward"></i> <?php echo lang("Localize.back") ?></a>
                </div>
            <?php }?>

            <form action="<?php echo base_url(route_to('update-company-term', $logged_user_id, $company_id)) ?>" id="employee" method="post" class="row g-3" accept-charset="utf-8" enctype="multipart/form-data">
                <?php echo $this->include('common/securityupdate') ?>
                <input type="hidden" id="baseurl" name="baseurl" value="<?php echo base_url(); ?>">
                <div class="row">
                    <div class="col-12">
                        <div class="row">
                            <div class="col-3 mt-3">
                                <input type="hidden" name="user_id" id="user_id" class="form-control" value="<?php echo $logged_user_id; ?>">
                                <label for="name"><?php echo lang("Localize.company_name") ?> <abbr title="Required field">*</abbr></label>
                                <select name="company_id" id="company_id" class="form-control" disabled>
                                    <?php foreach ($companies as $companyvalue) : ?>
                                        <option value="<?php echo $companyvalue->id; ?>" 
                                            <?php echo ($companyvalue->id == $company_id) ? 'selected' : ''; ?>>
                                            <?php echo $companyvalue->name; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                                <?php if (isset($validation) && $validation->hasError('company_id')) : ?>
                                    <div class="text-danger">
                                        <?php echo $validation->getError('company_id'); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <label for="title"><?= lang("Localize.title") ?></label>
                                <input type="text" id="title" name="title"
                                       value="<?= esc(old('title', $termlist[0]->title ?? '')) ?>"
                                       class="form-control text-capitalize"
                                       placeholder="<?= lang("Localize.title") ?>">
                            </div>

                            <div class="col-12 mt-3">
                                <label for="sub_title"><?= lang("Localize.sub") ?> <?= lang("Localize.title") ?></label>
                                <input type="text" id="sub_title" name="sub_title"
                                       value="<?= esc(old('sub_title', $termlist[0]->sub_title ?? '')) ?>"
                                       class="form-control text-capitalize"
                                       placeholder="<?= lang("Localize.sub") ?> <?= lang("Localize.title") ?>">
                            </div>
                            <div class="col-12 mt-3">
                                <label for="description"><?= lang("Localize.description") ?></label>
                                <textarea id="editor1" name="description" class="form-control" rows="10" cols="80" maxlength="10"><?= old('description', $termlist[0]->description ?? '') ?></textarea>
                            </div>

                        </div>

                        <div class="row">
                            <div class="col-12 mt-3">
                                <button type="submit" class="btn btn-success"><?php echo lang("Localize.submit") ?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php echo $this->endSection() ?>

<?php echo $this->section('js') ?>
<script src="<?php echo base_url('public/ckeditor/ckeditor.js'); ?>"></script>
<script src="<?php echo base_url('public/ckeditor/ckeditor.active.js'); ?>"></script>
<?php echo $this->endSection() ?>