<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>

<div class="card mb-4">
    <div class="card-body">
        <div class="text-end mb-3">
            <a class="btn btn-success" href="<?php echo base_url(route_to('create-holdseat')) ?>">
                <i class="fas fa-chair"></i><sup><i class="fas fa-plus small"></i></sup>
                <?php echo lang("Localize.add_hold_seat") ?>
            </a>
        </div>
        <input type="hidden" id="csrf_token" name="<?php echo csrf_token(); ?>" value="<?php echo csrf_hash(); ?>">
        <div class="table-responsive">
            <table class="table table-bordered" id="holdseatlist">
                <thead>
                    <tr>
                        <th>#</th>
                        <th><?php echo lang("Localize.company") ?></th>
                        <th><?php echo lang("Localize.seat_number") ?></th>
                        <th><?php echo lang("Localize.trip") ?></th>
                        <th><?php echo lang("Localize.journey").lang("Localize.start").lang("Localize.date") ?></th>
                        <th><?php echo lang("Localize.journey").lang("Localize.end").lang("Localize.date") ?></th>
                        <th><?php echo "Block By"; ?></th>
                        <th><?php echo "unblock By"; ?></th>
                        <th><?php echo lang("Localize.start").lang("Localize.date") ?></th>
                        <th><?php echo lang("Localize.end").lang("Localize.date")?></th>
                        <th><?php echo lang("Localize.action") ?></th>
                    </tr>
                </thead>
                <tbody>
                    
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php echo $this->include('common/datatable_default_lang_change') ?>
<?php echo $this->endSection() ?>

<?php echo $this->section('js') ?>
<script>
    $(document).ready(function() {
        // Destroy existing DataTable instance if it exists
        if ($.fn.DataTable.isDataTable('#holdseatlist')) {
            $('#holdseatlist').DataTable().destroy();
        }

        // Get companyname for export titles
        var companyname = $('#logotext').text().trim() || '<?php echo lang("Localize.company"); ?>';

        // Initialize DataTables with server-side processing
        $('#holdseatlist').DataTable({
            processing: true,
            serverSide: true,
            order: [[0, 'desc']],
            lengthMenu: [[10, 15, 20, 25, 30, 40, 50, -1], [10, 15, 20, 25, 30, 40, 50, "All"]],
            pageLength: 50,
            language: {
                lengthMenu: lengthMenu,
                zeroRecords: zeroRecords,
                info: info,
                infoEmpty: infoEmpty,
                infoFiltered: infoFiltered,
                search: search,
                paginate: {
                    first: first,
                    previous: previous,
                    next: next,
                    last: last
                }
            },
            ajax: {
                url: "<?= base_url(route_to('server-list-holdseat')); ?>",
                type: "POST",
                data: function(d) {
                    // Add CSRF token to the request data
                    var csrfToken = $('#csrf_token').val() || $('input[name="<?php echo csrf_token(); ?>"]').val();
                    if (csrfToken) {
                        d.<?php echo csrf_token(); ?> = csrfToken;
                    }
                    return d;
                },
                beforeSend: function(xhr) {
                    // Set CSRF token in header
                    var csrfToken = $('#csrf_token').val() || $('input[name="<?php echo csrf_token(); ?>"]').val();
                    if (csrfToken) {
                        xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken);
                        xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
                    }
                },
                dataSrc: 'data',
                error: function(xhr, error, code) {
                    console.error("DataTables AJAX Error:", error, code);
                    console.error("Response:", xhr.responseText);
                    if (xhr.status === 403) {
                        alert("CSRF token validation failed. Please refresh the page and try again.");
                    }
                }
            },
            buttons: [
                {
                    extend: 'copy',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5,6,7,8,9]}
                },
                {
                    extend: 'csv',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5,6,7,8,9]}
                },
                {
                    extend: 'excel',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5,6,7,8,9]}
                },
                {
                    extend: 'pdf',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5,6,7,8,9]}
                },
                {
                    extend: 'print',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5,6,7,8,9]}
                }
            ],
            columns: [
                { data: "index", orderable: false },
                { data: "companyname" },
                { data: "seat_number" },
                { data: "trip" },
                { data: "journeydata" },
                { data: "journeydataend" },
                { data: "hold_by", orderable: false },
                { data: "unhold_by", orderable: false },
                { data: "startdate" },
                { data: "enddate" },
                { data: "action", orderable: false, searchable: false }
            ],
            responsive: true,
            dom: 'lBfrtip',
            initComplete: function () {
                var api = this.api();
                console.log("Hold seat DataTables initialized. Columns:", api.columns().count());
            },
            drawCallback: function(settings) {
                console.log("Hold seat DataTables draw callback fired");
            }
        });

    });
</script>
<?php echo $this->endSection() ?>