<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>

<div class="card mb-4">
    <div class="card-body">
        <div class="text-end">
            <a class="btn btn-success" href="<?php echo base_url(route_to('create-holdseat')) ?>">
                <i class="fas fa-chair"></i><sup><i class="fas fa-plus small"></i></sup>
                <?php echo lang("Localize.add_hold_seat") ?>
            </a>
        </div>
        <div class="table-responsive" style="margin-top:20px;">
            <table class="table table-bordered" id="holdseatlist">
                <thead>
                    <tr>
                        <th>#</th>
                        <th><?php echo lang("Localize.company") ?></th>
                        <th><?php echo lang("Localize.seat_number") ?></th>
                        <th><?php echo lang("Localize.trip") ?></th>
                        <th><?php echo lang("Localize.journey").lang("Localize.start").lang("Localize.date") ?></th>
                        <th><?php echo lang("Localize.journey").lang("Localize.end").lang("Localize.date") ?></th>
                        <th><?php echo "Block By"; ?></th>
                        <th><?php echo "unblock By"; ?></th>
                        <th><?php echo lang("Localize.start").lang("Localize.date") ?></th>
                        <th><?php echo lang("Localize.end").lang("Localize.date")?></th>
                        <th><?php echo lang("Localize.action") ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($holdSeats as $key => $seat): ?>
                        <tr>
                            <td><?php echo $key + 1; ?></td>
                            <td><?php echo $seat['companyname']; ?></td>
                            <td><?php echo $seat['seat_number']; ?></td>
                            <td><?php echo $seat['pic_location_name']."-".$seat['drop_location_name']."( ".$seat['trip_id']." )"; ?></td>
                            <td><?php echo $seat['journeydata']??""; ?></td>
                            <td><?php echo $seat['journeydataend']??""; ?></td>
                            <td><?php echo $seat['hold_by'] ? $seat['hold_by'] . "<br/>" . $seat['created_at'] : ""; ?></td>
                            <td><?php echo $seat['unhold_by']? $seat['unhold_by'] . "<br/>" . $seat['updated_at'] : ""; ?></td>
                            <td><?php echo $seat['startdate']; ?></td>
                            <td><?php echo $seat['enddate']; ?></td>
                            <td>
                                <?php if ($seat['hold_status'] == 1 && strtotime($seat['enddate']) > time()): ?>
                                    <a href="<?php echo base_url(route_to('unhold-seat', $seat['hold_id'])); ?>" 
                                       class="btn btn-danger btn-sm"
                                       onclick="return confirm('Are you sure you want to unblock this seat?');">
                                        <i class="fas fa-trash"></i> UnBlock
                                    </a>
                                <?php endif; ?>


                            </td>
                            <!-- <td>
                                <a href="#" class="btn btn-primary btn-sm"><?php //echo lang("Localize.edit") ?></a>
                                <a href="#" class="btn btn-danger btn-sm"><?php //echo lang("Localize.delete") ?></a>
                            </td> -->
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php echo $this->include('common/datatable_default_lang_change') ?>
<?php echo $this->endSection() ?>