<?php



namespace Modules\Offer\Controllers;



use App\Controllers\BaseController;

use Modules\Offer\Models\OfferModel;

use Modules\Trip\Models\SubtripModel;

use Modules\Location\Models\LocationModel;

use App\Libraries\Rolepermission;

use Modules\Company\Models\CompanyModel;

use Modules\Trip\Models\TripModel;

use Modules\Offer\Models\OfferDetailsModel;



class Offer extends BaseController

{

    protected $Viewpath;

    protected $offerModel;

    protected $tripModel;

    protected $subtripModel;

    protected $locationModel;

    protected $companyModel;

    protected $offerDetailsModel;
    
    protected $db;



    public function __construct()

    {

        $this->Viewpath = "Modules\Offer\Views";

        $this->offerModel = new OfferModel();

        $this->tripModel = new TripModel();

        $this->subtripModel = new SubtripModel();

        $this->locationModel = new LocationModel();

        $this->companyModel = new CompanyModel();

        $this->offerDetailsModel = new OfferDetailsModel();
        $this->db = \Config\Database::connect();

    }



    public function new()

    {

        

        $companyId = session()->get('company_id'); 

        $data['module'] =    lang("Localize.offer");

        $data['title']  =    lang("Localize.add_offer");

        $data['pageheading'] = lang("Localize.add_offer");

        $data['roleId'] = session()->get('role_id');

        $data['companies'] = $this->companyModel->findAll();



        $data['companyId'] = $companyId;

        $data['tripGroups'] = $this->subtripModel->getTripsByCompany([$companyId]);



        // Fetch seat classes from database

        $db = \Config\Database::connect();

        $db->transStart();

        $builder = $db->table('seat_class');

        $query = $builder->select('id, name')->get();

        $data['seatClasses'] = $query->getResult();

        $db->transComplete();



        // Fetch trip categories from database

        $db->transStart();

        $tripCategories = $db->table('trip_category')

                        ->where('deleted_at', null)

                        ->get()

                        ->getResult();

        $data['tripCategories'] = $tripCategories;

        $db->transComplete();



        echo view($this->Viewpath . '\offer\new', $data);

    }



    public function create()

    {

        $subtrip = $this->subtripModel->where('status', 1)->findAll();

        $locationname = $this->locationModel->findAll();



        foreach ($subtrip as $skey => $subtripvalue) {

            foreach ($locationname as $lkey => $locationvalue) {



                if ($subtripvalue->pick_location_id == $locationvalue->id) {

                    $subtrip[$skey]->picklocation = $locationvalue->name;

                }



                if ($subtripvalue->drop_location_id == $locationvalue->id) {

                    $subtrip[$skey]->droplocation = $locationvalue->name;

                }

            }

        }



        // Handle file upload

        $offerImage = null;

        if ($this->request->getFile('offer_image') && $this->request->getFile('offer_image')->isValid()) {

            $file = $this->request->getFile('offer_image');

            $newName = $file->getRandomName();

            $file->move(ROOTPATH . 'public/uploads/offers/', $newName);

            $offerImage = $newName;

        }



        $offerData = array(

            "code" => $this->request->getVar('code'),

            "offer_title" => $this->request->getVar('offer_title'),

            "offer_description" => $this->request->getVar('offer_description'),

            "start_date" => $this->request->getVar('start_date'),

            "end_date" => $this->request->getVar('end_date'),

            "booking_start_date" => $this->request->getVar('booking_start_date'),

            "booking_end_date" => $this->request->getVar('booking_end_date'),

            "travel_start_date" => $this->request->getVar('travel_start_date'),

            "travel_end_date" => $this->request->getVar('travel_end_date'),

            "min_passengers" => $this->request->getVar('min_passengers') ?: 1,

            "discount" => $this->request->getVar('discount'),

            "discount_type" => $this->request->getVar('discount_type'),

            "discount_cap" => $this->request->getVar('discount_cap'),

            "min_discount" => $this->request->getVar('min_discount'),

            "max_discount" => $this->request->getVar('max_discount'),

            "condition" => $this->request->getVar('condition'),

            "offer_for" => $this->request->getVar('offer_type'),

            "offer_image" => $offerImage,

            "seat_class" => json_encode($this->request->getVar('seat_class') ?: []),

            "trip_category" => json_encode($this->request->getVar('trip_category') ?: [])

        );



        // if ($this->validation->run($offerData, 'offer')) {   



            $offerId = $this->offerModel->insert($offerData, true); 

            $offerDetailsData = [];



            $companies = $this->request->getVar('company');

            $mainTrips = $this->request->getVar('main_trips');

            $subtripsData = $this->request->getVar('subtrips');



            // Combine company IDs into a string

            $companyIdsString = implode(',', $companies);



            $groupedSubtrips = [];



            // Group subtrips by their main trip ID

            

            if (is_array($mainTrips)) {

                foreach ($mainTrips as $tripId) {

                    if (isset($subtripsData[$tripId])) {

                        $groupedSubtrips[$tripId] = $subtripsData[$tripId];

                    }

                }

            }



            // Insert each grouped entry

            foreach ($groupedSubtrips as $tripId => $subtrips) {

                $offerDetailsData[] = [

                    'offer_id'    => $offerId,

                    'company_id'   => $companyIdsString, // Correctly stores all company IDs in one entry

                    'main_trip_id' => $tripId,

                    'sub_trip_id'  => json_encode($subtrips),

                ];

            }



            // Insert Offer Details

            $this->offerDetailsModel->insertBatch($offerDetailsData);



            return redirect()->route('index-offer')->with("success", "Data Saved");



        // }



        // return redirect()->back()->withInput()->with('fail', $this->validation->listErrors());

    }



    public function index()

    {

        $offer_detail = $this->offerModel->getOffersWithDetails();



        $data['module'] =    lang("Localize.offer");

        $data['title']  =    lang("Localize.offer_list");

        $data['offer'] = $offer_detail;

        $data['pageheading'] = lang("Localize.offer_list");



        $rolepermissionLibrary = new Rolepermission();

        $add_data = "add_offer";

        $list_data = "offer_list";



        $data['add_data'] = $rolepermissionLibrary->create($add_data);

        $data['edit_data'] = $rolepermissionLibrary->edit($list_data);

        $data['delete_data'] = $rolepermissionLibrary->delete($list_data);



        return view($this->Viewpath . '\offer/index', $data);

    }



    public function edit($id)

    {

        

        $subtrip = $this->subtripModel

            ->select('subtrips.id, l1.name AS picklocation, l2.name AS droplocation')

            ->join('locations l1', 'subtrips.pick_location_id = l1.id')

            ->join('locations l2', 'subtrips.drop_location_id = l2.id')

            ->where('l1.deleted_at IS NULL')

            ->where('l2.deleted_at IS NULL')

            ->where('status', 1)

            ->findAll();

        

        if(session()->get('role_id') == 7 ){

            $selectedCompanies = (array) session()->get('company_id');

        }else{

            $selectedCompanies = $this->offerDetailsModel

                ->where('offer_id', $id)

                ->findColumn('company_id');

        }



        // Ensure `$selectedCompanies` is always an array

        $selectedCompanies = is_array($selectedCompanies) ? $selectedCompanies : [];

        



        // Handle comma-separated data if required

        if (!empty($selectedCompanies)) {

            $selectedCompanies = explode(',', implode(',', $selectedCompanies));

        }



        if (!empty($selectedCompanies)) {

            $selectedCompanies = explode(',', implode(',', $selectedCompanies));

        }



        

        if(session()->get('role_id') == 7 ){

            $selectedCompanies = (array) session()->get('company_id');

            $main_trip_data = $this->offerDetailsModel

                ->where('offer_id', $id)

                ->whereIn('company_id', $selectedCompanies)

                ->findAll();

        }else{

            $main_trip_data = $this->offerDetailsModel

                ->where('offer_id', $id)

                ->findAll();

        }





        $selectedMainTrips = [];

        $selectedSubTrips = [];



        if (session()->get('role_id') == 7) {

            $companyId = session()->get('company_id');

            if (!empty($companyId)) {

                $main_trip_data = array_filter($main_trip_data, function ($trip) use ($companyId) {

                    // Ensure proper matching by using regex for exact value match

                    return preg_match('/\b' . preg_quote($companyId, '/') . '\b/', $trip['company_id']);

                });

            }

        }

       

        $selectedMainTrips = array_column($main_trip_data, 'main_trip_id');

        $selectedSubTrips = [];

        foreach ($main_trip_data as $trip) {

            $subTrips = json_decode($trip->sub_trip_id ?? '[]', true);

            $selectedSubTrips = array_merge($selectedSubTrips, array_map('strval', $subTrips));

        }

        

        // Fetch grouped trips using new method

        if (!empty($selectedCompanies)) {

            $groupedTrips = $this->subtripModel->getTripsByCompany($selectedCompanies);

        } else {

            $groupedTrips = [];  // Handle gracefully if no companies are selected

        }



        $data['subtrip'] = $subtrip;

        $data['offer'] = $this->offerModel->find($id);

        $data['selectedCompanies'] = $selectedCompanies;

        $data['selectedMainTrips'] = $selectedMainTrips;

        $data['selectedSubTrips'] = $selectedSubTrips;



        $data['module'] = lang("Localize.offer");

        $data['title'] = lang("Localize.offer_list");



        $heading = lang("Localize.edit") . ' ' . lang("Localize.offer");

        $data['pageheading'] = $heading;

        $data['roleId'] = session()->get('role_id');

        $data['companies'] = $this->companyModel->findAll();

        $data['trips'] = $groupedTrips;



        // Fetch seat classes from database

        $db = \Config\Database::connect();

        $db->transStart();

        $builder = $db->table('seat_class');

        $query = $builder->select('id, name')->get();

        $data['seatClasses'] = $query->getResult();

        $db->transComplete();



        // Fetch trip categories from database

        $db->transStart();

        $tripCategories = $db->table('trip_category')

                        ->where('deleted_at', null)

                        ->get()

                        ->getResult();

        $data['tripCategories'] = $tripCategories;

        $db->transComplete();



        return view($this->Viewpath . '\offer/edit', $data);

    }





    public function updateold($id)

    {

       

        $companies = (array) $this->request->getVar('company');

        $companyIdsString = implode(',', $companies);

       

        // Handle file upload

        $offerImage = null;

        if ($this->request->getFile('offer_image') && $this->request->getFile('offer_image')->isValid()) {

            $file = $this->request->getFile('offer_image');

            $newName = $file->getRandomName();

            $file->move(ROOTPATH . 'public/uploads/offers/', $newName);

            $offerImage = $newName;

        } else {

            // Keep existing image if no new file uploaded

            $existingOffer = $this->offerModel->find($id);

            $offerImage = $existingOffer->offer_image ?? null;

        }



        $offerData = [

            "id" => $id,

            "code" => $this->request->getVar('code'),

            "offer_title" => $this->request->getVar('offer_title'),

            "offer_description" => $this->request->getVar('offer_description'),

            "start_date" => $this->request->getVar('start_date'),

            "end_date" => $this->request->getVar('end_date'),

            "booking_start_date" => $this->request->getVar('booking_start_date'),

            "booking_end_date" => $this->request->getVar('booking_end_date'),

            "travel_start_date" => $this->request->getVar('travel_start_date'),

            "travel_end_date" => $this->request->getVar('travel_end_date'),

            "min_passengers" => $this->request->getVar('min_passengers') ?: 1,

            "discount" => $this->request->getVar('discount'),

            "discount_type" => $this->request->getVar('discount_type'),

            "discount_cap" => $this->request->getVar('discount_cap'),

            "min_discount" => $this->request->getVar('min_discount'),

            "max_discount" => $this->request->getVar('max_discount'),

            "condition" => $this->request->getVar('condition'),

            "offer_for" => $this->request->getVar('offer_type'),

            "offer_image" => $offerImage,

            "seat_class" => json_encode($this->request->getVar('seat_class') ?: []),

            "trip_category" => json_encode($this->request->getVar('trip_category') ?: [])

        ];



        // if ($this->validation->run($offerData, 'offer')) {

            $this->offerModel->save($offerData);

            $this->offerDetailsModel->where('offer_id', $id)->delete();



            /* --------------- */

            $offerDetailsData = [];

            $groupedSubtrips = [];



            $mainTrips = $this->request->getVar('main_trips');

            $subtripsData = $this->request->getVar('subtrips');



            // Combine company IDs into a string

            $companyIdsString = implode(',', $companies);



            // Group subtrips by their main trip ID

            

            if (is_array($mainTrips)) {

                foreach ($mainTrips as $tripId) {

                    if (isset($subtripsData[$tripId])) {

                        $groupedSubtrips[$tripId] = $subtripsData[$tripId];

                    }

                }

            }



            // Insert each grouped entry

            foreach ($groupedSubtrips as $tripId => $subtrips) {

                $offerDetailsData[] = [

                    'offer_id'    => $id,

                    'company_id'   => $companyIdsString, // Correctly stores all company IDs in one entry

                    'main_trip_id' => $tripId,

                    'sub_trip_id'  => json_encode($subtrips),

                ];

            }

            // Insert Offer Details

            $this->offerDetailsModel->insertBatch($offerDetailsData);

            /* --------------- */



            return redirect()->route('index-offer')->with("success", "Data Updated");

        // }



        return redirect()->back()->withInput()->with('fail', $this->validation->listErrors());

    }

    public function update($id)
    {
        $companies = (array) $this->request->getVar('company');
        $companyIdsString = implode(',', $companies);
    
        // Handle Image
        $offerImage = null;
        if ($this->request->getFile('offer_image') && $this->request->getFile('offer_image')->isValid()) {
            $file = $this->request->getFile('offer_image');
            $newName = $file->getRandomName();
            $file->move(ROOTPATH . 'public/uploads/offers/', $newName);
            $offerImage = $newName;
        } else {
            $existing = $this->offerModel->find($id);
            $offerImage = $existing->offer_image ?? null;
        }
    
        // Main offer update
        $offerData = [
            "id" => $id,
            "code" => $this->request->getVar('code'),
            "offer_title" => $this->request->getVar('offer_title'),
            "offer_description" => $this->request->getVar('offer_description'),
            "start_date" => $this->request->getVar('start_date'),
            "end_date" => $this->request->getVar('end_date'),
            "booking_start_date" => $this->request->getVar('booking_start_date'),
            "booking_end_date" => $this->request->getVar('booking_end_date'),
            "travel_start_date" => $this->request->getVar('travel_start_date'),
            "travel_end_date" => $this->request->getVar('travel_end_date'),
            "min_passengers" => $this->request->getVar('min_passengers') ?: 1,
            "discount" => $this->request->getVar('discount'),
            "discount_type" => $this->request->getVar('discount_type'),
            "discount_cap" => $this->request->getVar('discount_cap'),
            "min_discount" => $this->request->getVar('min_discount'),
            "max_discount" => $this->request->getVar('max_discount'),
            "condition" => $this->request->getVar('condition'),
            "offer_for" => $this->request->getVar('offer_type'),
            "offer_image" => $offerImage,
            "seat_class" => json_encode($this->request->getVar('seat_class') ?: []),
            "trip_category" => json_encode($this->request->getVar('trip_category') ?: []),
        ];
    
        $this->offerModel->save($offerData);
    
        // DELETE existing rows
        $this->offerDetailsModel->where('offer_id', $id)->delete();
    
        $mainTrips = $this->request->getVar('main_trips');
        $subtripsData = $this->request->getVar('subtrips');
    
        $offerDetailsData = [];
    
        if ($mainTrips) {
            foreach ($mainTrips as $tripId) {
    
                $subList = $subtripsData[$tripId] ?? [];
    
                // Always keep consistent structure
                $offerDetailsData[] = [
                    'offer_id'    => $id,
                    'company_id'   => $companyIdsString,
                    'main_trip_id' => $tripId,
                    'sub_trip_id'  => json_encode($subList),
                ];
            }
        }
    
        // Insert only if not empty
        if (!empty($offerDetailsData)) {
            $this->offerDetailsModel->insertBatch($offerDetailsData);
        }
    
        return redirect()->route('index-offer')->with("success", "Data Updated");
    }




    public function delete($id)

    {

        $this->offerModel->delete($id);

        return redirect()->route('index-offer')->with("fail", "Data Deleted");

    }



    public function getTripsByCompany()

    {

        $companyIds = $this->request->getGet('companyIds');



        if (!$companyIds) {

            return $this->response->setJSON([

                'success' => false,

                'message' => 'No company IDs provided'

            ]);

        }



        $tripData = $this->subtripModel->getTripsByCompany($companyIds);



        return $this->response->setJSON([

            'success' => true,

            'data' => $tripData

        ]);

    }
        public function serverList()
    {
        $request = service('request');

        // Role and company ID from session
        $role_id = session()->get('role_id');
        $company_id = session()->get('company_id');

        // Check permissions
        $rolepermissionLibrary = new Rolepermission();
        $edit_offer = $rolepermissionLibrary->edit("offer_list");
        $delete_offer = $rolepermissionLibrary->delete("offer_list");

        // DataTables request values
        $draw   = $request->getPost('draw');
        $start  = $request->getPost('start');
        $length = $request->getPost('length');
        $searchValue = $request->getPost('search')['value'] ?? '';

        // Column map
        $columns = [
            0 => 'offers.id',
            1 => 'offers.offer_title',
            2 => 'offers.code',
            3 => 'companies.name',
            4 => 'offers.discount',
            5 => 'offers.min_passengers',
            6 => 'offers.start_date',
            7 => 'offers.end_date',
            8 => null  // action column
        ];

        // Order column & direction
        $order = $request->getPost('order');
        $orderColumnIndex = !empty($order) && isset($order[0]['column']) ? $order[0]['column'] : 0;
        $orderDirection   = !empty($order) && isset($order[0]['dir']) ? $order[0]['dir'] : 'asc';

        // ---- TOTAL RECORDS ----
        $totalBuilder = $this->db->table('offers');
        $totalBuilder->select('offers.id')
            ->join('offer_details', 'offer_details.offer_id = offers.id', 'left')
            ->join('companies', 'FIND_IN_SET(companies.id, offer_details.company_id)', 'left')
            ->where('offers.deleted_at IS NULL')
            ->groupBy('offers.id');
        
        // Apply role-based filtering for total count
        if ($role_id != 1) {
            $totalBuilder->where('companies.id', $company_id);
        }
        
        $totalRecords = $totalBuilder->countAllResults(false);

        // Create fresh builder for filtered query
        $builder = $this->db->table('offers');
        $builder->select('
                offers.*,
                GROUP_CONCAT(DISTINCT companies.name SEPARATOR ", ") AS company_names
            ')
            ->join('offer_details', 'offer_details.offer_id = offers.id', 'left')
            ->join('companies', 'FIND_IN_SET(companies.id, offer_details.company_id)', 'left')
            ->where('offers.deleted_at IS NULL')
            ->groupBy('offers.id');

        // Apply role-based filtering
        if ($role_id != 1) {
            $builder->where('companies.id', $company_id);
        }

        // Global search
        if (!empty($searchValue)) {
            $builder->groupStart()
                ->like('offers.offer_title', $searchValue)
                ->orLike('offers.code', $searchValue)
                ->orLike('offers.discount', $searchValue)
                ->orLike('offers.start_date', $searchValue)
                ->orLike('offers.end_date', $searchValue)
                ->orLike('companies.name', $searchValue)
                ->groupEnd();
        }

        // Column-wise filters
        if (!empty($request->getPost('columns'))) {
            foreach ($request->getPost('columns') as $idx => $col) {
                $searchCol = $col['search']['value'] ?? '';
                if ($searchCol !== '' && isset($columns[$idx]) && $columns[$idx] !== null) {
                    $builder->like($columns[$idx], $searchCol);
                }
            }
        }

        // ---- TOTAL FILTERED ----
        $totalRecordwithFilter = $builder->countAllResults(false);

        // ---- ORDERING ----
        if (isset($columns[$orderColumnIndex]) && $columns[$orderColumnIndex] !== null) {
            $builder->orderBy($columns[$orderColumnIndex], $orderDirection);
        } else {
            $builder->orderBy('offers.id', 'desc');
        }

        // ---- PAGINATION ----
        if ($length > 0) {
            $builder->limit($length, $start);
        }

        // ---- FETCH RECORDS ----
        $records = $builder->get()->getResult();

        // ---- FORMAT JSON ----
        $data = [];
        $i = $start + 1;

        foreach ($records as $row) {
            // Format discount based on discount_type
            $discountDisplay = '';
            if (isset($row->discount_type) && $row->discount_type == 1) {
                $discountDisplay = '₹' . esc($row->discount);
            } else {
                $discountDisplay = esc($row->discount) . '%';
            }

            // Format offer title with image if available
            $offerTitleHtml = '<strong>' . esc($row->offer_title ?? 'N/A') . '</strong>';
            if (!empty($row->offer_image)) {
                $imageUrl = base_url('public/uploads/offers/' . $row->offer_image);
                $offerTitleHtml .= '<br><img src="' . esc($imageUrl, 'attr') . '" style="width:50px; height:50px; object-fit:cover;" />';
            }

            $data[] = [
                "index" => $i++,
                "offer_title" => $offerTitleHtml,
                "code" => esc($row->code),
                "company" => esc($row->company_names ?? ''),
                "discount" => $discountDisplay,
                "min_passengers" => esc($row->min_passengers ?? 1),
                "start_date" => esc($row->start_date),
                "end_date" => esc($row->end_date),
                "action" => $this->generateActionButtons($row, $edit_offer, $delete_offer)
            ];
        }

        return $this->response->setJSON([
            "draw" => intval($draw),
            "recordsTotal" => $totalRecords,
            "recordsFiltered" => $totalRecordwithFilter,
            "data" => $data
        ]);
    }

    private function generateActionButtons($row, $edit_offer, $delete_offer)
    {
        $security = \Config\Services::security();
        $csrfToken = $security->getTokenName();
        $csrfHash = $security->getHash();
        
        $actionHtml = '';
        
        if ($edit_offer) {
            $actionHtml .= '<a href="' . base_url(route_to('edit-offer', $row->id)) . '" class="btn btn-sm btn-info text-white" title="' . lang("Localize.edit") . '"><i class="fas fa-edit"></i></a> ';
        }
        
        if ($delete_offer) {
            $actionHtml .= '<form action="' . base_url(route_to('ss-delete-confirmation', 'offer', $row->id)) . '" method="get" class="d-inline-block deletionForm">';
            $actionHtml .= '<button type="button" data-modal-confirm="true" class="btn btn-sm btn-danger" title="' . lang("Localize.delete") . '"><i class="far fa-trash-alt"></i></button>';
            $actionHtml .= '</form>';
        }
        
        return $actionHtml;
    }

}

