<?php



namespace Modules\Trip\Controllers;







use App\Controllers\BaseController;

use Modules\Trip\Models\TripModel;

use Modules\Trip\Models\StuffassignModel;

use Modules\Trip\Models\SubtripModel;

use Modules\Trip\Models\PickdropModel;

use Modules\Trip\Models\FacilityModel;

use Modules\Location\Models\LocationModel;

use Modules\Employee\Models\EmployeeModel;

use Modules\Fleet\Models\FleetModel;

use Modules\Fleet\Models\VehicleModel;

use Modules\Schedule\Models\ScheduleModel;

use Modules\Location\Models\StandModel;

use App\Libraries\Rolepermission;

use Modules\Company\Models\CompanyModel;

use Modules\Ticket\Models\TicketModel;

use App\Models\TripBusTypeModel;

use App\Models\TripCategoryModel;

use Modules\Notification\Models\NotificationModel;



class Trip extends BaseController

{

    protected $Viewpath;

    protected $tripModel;

    protected $subtripModel;

    protected $stuffassignModel;

    protected $locationModel;

    protected $employeeModel;

    protected $fleetTypeModel;

    protected $scheduleeModel;

    protected $vehicleModel;

    protected $standModel;

    protected $picdropModel;

    protected $facilitypModel;

    protected $db;

    protected $companyModel;

    protected $ticketModel;

    protected $tripBusTypeModel;

    protected $tripCategoryModel;

    protected $notificationModel;



    public function __construct()

    {



        $this->Viewpath = "Modules\Trip\Views";

        $this->tripModel = new TripModel();

        $this->subtripModel = new SubtripModel();

        $this->stuffassignModel = new StuffassignModel();

        $this->locationModel = new LocationModel();

        $this->employeeModel = new EmployeeModel();

        $this->fleetTypeModel = new FleetModel();

        $this->vehicleModel = new VehicleModel();

        $this->scheduleeModel = new ScheduleModel();

        $this->standModel = new StandModel();

        $this->picdropModel = new PickdropModel();

        $this->facilitypModel = new FacilityModel();

        $this->companyModel = new CompanyModel();

        $this->ticketModel = new TicketModel();

        $this->tripBusTypeModel = new TripBusTypeModel();

        $this->tripCategoryModel = new TripCategoryModel();

        $this->db      = \Config\Database::connect();

        $this->notificationModel = new NotificationModel();

    }

    public function index()

    {

        $search        = trim((string) $this->request->getGet('search'));

        $perPageParam  = (int) ($this->request->getGet('per_page') ?? 50);

        $allowedPerPage = [25, 50, 100, 200];

        $perPage       = in_array($perPageParam, $allowedPerPage, true) ? $perPageParam : 50;

        $builder = $this->buildTripListQuery();

        $builder = $this->applyTripRoleFilters($builder);

        $builder = $this->applyTripSearchFilter($builder, $search);

        $builder->orderBy('trips.id', 'DESC');



        $data['trip']   = $builder->paginate($perPage);

        $data['pager']  = $this->tripModel->pager;

        $data['search'] = $search;

        $data['perPage'] = $perPage;



        $data['module'] =    lang("Localize.trip");

        $data['title']  =    lang("Localize.trip_list");



        $data['pageheading'] = lang("Localize.trip_list");



        $rolepermissionLibrary = new Rolepermission();



        $add_data = "add_trip";

        $list_data = "trip_list";



        $data['add_data'] = $rolepermissionLibrary->create($add_data);

        $data['edit_data'] = $rolepermissionLibrary->edit($list_data);

        $data['delete_data'] = $rolepermissionLibrary->delete($list_data);

        $data['companies'] = $this->companyModel->findAll();



        echo view($this->Viewpath . '\trip/index', $data);

    }



    public function exportTripList()

    {

        $search = trim((string) $this->request->getGet('search'));



        $builder = $this->buildTripListQuery();

        $builder = $this->applyTripRoleFilters($builder);

        $builder = $this->applyTripSearchFilter($builder, $search);

        $rows    = $builder->orderBy('trips.id', 'DESC')->findAll();



        $fp = fopen('php://temp', 'r+');

        fputcsv($fp, [

            '#',

            lang('Localize.pick_up'),

            lang('Localize.drop'),

            lang('Localize.schedule'),

            lang('Localize.distance'),

            lang('Localize.hour'),

            lang('Localize.trip') . ' ' . lang('Localize.id'),

            lang('Localize.company'),

            lang('Localize.status'),

        ]);



        $i = 1;

        foreach ($rows as $row) {

            $statusLabel = $row->trip_status == "1" ? lang("Localize.active") : lang("Localize.disable");

            fputcsv($fp, [

                $i++,

                $row->pick_location_name ?? '',

                $row->drop_location_name ?? '',

                $row->start_time ?? '',

                ($row->trip_distance ?? '') !== '' ? ($row->trip_distance . 'km') : '',

                $row->trip_journey_hour ?? '',

                $row->tripid ?? '',

                $row->company_name ?? '',

                $statusLabel,

            ]);

        }



        rewind($fp);

        $csv = stream_get_contents($fp);

        fclose($fp);



        return $this->response

            ->setHeader('Content-Type', 'text/csv')

            ->setHeader('Content-Disposition', 'attachment; filename="trip_list_' . date('Ymd_His') . '.csv"')

            ->setBody($csv);

    }



    private function buildTripListQuery()

    {

        return $this->tripModel->select('trips.id as tripid, trips.status as trip_status, trips.*, trips.distance as trip_distance, trips.journey_hour as trip_journey_hour, schedules.*, companies.name as company_name, pick_location.name as pick_location_name, drop_location.name as drop_location_name')

            ->join('schedules', 'schedules.id = trips.schedule_id', 'left')

            ->join('companies', 'trips.company_id = companies.id', 'left')

            ->join('locations as pick_location', 'pick_location.id = trips.pick_location_id', 'left')

            ->join('locations as drop_location', 'drop_location.id = trips.drop_location_id', 'left');

    }



    private function applyTripRoleFilters($builder)

    {

        $roleId    = session()->get('role_id');

        $companyId = session()->get('company_id');



        if ($roleId == "1") {

            return $builder;

        }



        if (!empty($companyId)) {

            return $builder->where('trips.company_id', $companyId);

        }



        return $builder;

    }



    private function applyTripSearchFilter($builder, string $search)

    {

        if ($search === '') {

            return $builder;

        }



        return $builder->groupStart()

            ->like('pick_location.name', $search)

            ->orLike('drop_location.name', $search)

            ->orLike('schedules.start_time', $search)

            ->orLike('trips.distance', $search)

            ->orLike('trips.journey_hour', $search)

            ->orLike('companies.name', $search)

            ->orLike('trips.id', $search)

            ->groupEnd();

    }



    public function new()

    {

        $weekday = array(

            '1' => 'Monday',

            '2' => 'Tuesday',

            '3' => 'Wednesday',

            '4' => 'Thursday',

            '5' => 'Friday',

            '6' => 'Saturday',

            '7' => 'Sunday',

        );

        $this->db->transStart();

        $classData = $this->db->table('seat_class')

                        ->get()

                        ->getResult();

        $this->db->transComplete();



        $this->db->transStart();

        $TripBusTypes = $this->db->table('trip_bus_types')

                        ->where('deleted_at', null)

                        ->get()

                        ->getResult();

        $this->db->transComplete();



        $this->db->transStart();

        $TripCategories = $this->db->table('trip_category')

                        ->where('deleted_at', null)

                        ->get()

                        ->getResult();

        $this->db->transComplete();



        $data['TripBusTypes'] =  $TripBusTypes;

        $data['TripCategories'] =  $TripCategories;



        $data['weekday'] =  $weekday;

        $data['location'] = $this->locationModel->findAll();

        $data['class'] = $classData;

        $data['schedule'] = $this->scheduleeModel->findAll();

        $data['fleet_types'] = $this->fleetTypeModel->findAll();

        $data['driver'] = $this->employeeModel->where('employeetype_id', 1)->findAll();

        $data['assistant'] = $this->employeeModel->where('employeetype_id', 2)->findAll();

        $data['stand'] = $this->standModel->findAll();

        $data['facility'] = $this->facilitypModel->findAll();



        $data['module'] =    lang("Localize.trip");

        $data['title']  =    lang("Localize.add_trip");



        $data['pageheading'] = lang("Localize.add_trip");

        $data['companies'] = $this->companyModel->findAll();

        // echo"<pre>";print_r($data['fleet_type']);exit;

        echo view($this->Viewpath . '\trip/new', $data);

    }



    public function create()

    {

        // echo "<pre>";print_r($_POST['seatClass']);exit;



        $picupdata = array();

        $dropdata = array();



        $pickLocation = $this->request->getVar('pick_location_id');

        $dropLocation = $this->request->getVar('drop_location_id');

        $busStandTime = $this->request->getVar('picktime');

        $busStandlocation = $this->request->getVar('picstand');

        $standDetails = $this->request->getVar('detail');

        $busStandtype = $this->request->getVar('type');

        $dropbusStandTime = $this->request->getVar('droptime');

        $dropbusStandlocation = $this->request->getVar('dropstand');

        $dropstandDetails = $this->request->getVar('dropdetail');

        $dropbusStandtype = $this->request->getVar('droptype');

        $trip_category_id = $this->request->getVar('trip_category_id');

        $trip_bus_type_id = $this->request->getVar('trip_bus_type_id');

        $trip_type = $this->request->getVar('trip_type');



        $driver = array_filter($this->request->getVar('driver'));

        $assistant = array_filter($this->request->getVar('assistant'));



        $companyId = $this->request->getVar('company_id')??session()->get('company_id');



        $weekend = $this->request->getVar('weekend');

        if (!empty($weekend)) {

            $weekend = implode(",", $weekend);

        }



        $stoppage = array_merge([$pickLocation], (array) $this->request->getVar('stoppage'), [$dropLocation]);

        $stoppage = implode(",", array_filter($stoppage));



        $facility = $this->request->getVar('facility');

        if (!empty($facility)) {

            $facility = implode(",", $facility);

        }



        if (isset($_POST['seatNo']) && is_array($_POST['seatNo'])) {

            $seatNoArray = $_POST['seatNo'];

        

            // Normalize the array to ensure proper indexing

            $_POST['seatNo'] = array_values($seatNoArray);

        }



        $mergedData = [];

        foreach ($_POST['seatClass'] as $key => $seatClass) {

            

            if($seatClass > 0 && (isset($_POST['seatNo'][$key]) && is_array($_POST['seatNo'][$key]) && !empty($_POST['seatNo'][$key])) && (isset($_POST['fares'][$key]) && $_POST['fares'][$key] > 0) ){

                $mergedData[] = [

                    'seatClass' => $seatClass,

                    'seatNo' => $_POST['seatNo'][$key]??"",

                    'fare' => $_POST['fares'][$key]

                ];

            }

        }



        $tripData = array(

            "fleet_id" => $this->request->getVar('fleet_id'),

            "schedule_id" => $this->request->getVar('schedule_id'),

            "pick_location_id" => $this->request->getVar('pick_location_id'),

            "drop_location_id" => $this->request->getVar('drop_location_id'),

            "vehicle_id" => $this->request->getVar('vehicle_id'),

            "distance" => $this->request->getVar('distance'),

            "journey_hour" => $this->request->getVar('journey_hour'),

            "special_seat" => $this->request->getVar('special_seat') ?? 0,

            "child_seat" => $this->request->getVar('child_seat') ?? 0,

            "adult_fair" => $this->request->getVar('adult_fair') ?? 0,

            "child_fair" => $this->request->getVar('child_fair') ?? 0,

            "vip_seat" => $this->request->getVar('vip_seat') ?? 0,

            "vip_fair" => $this->request->getVar('vip_fair') ?? 0,

            "special_fair" => $this->request->getVar('special_fair') ?? 0,

            "weekend" => (string) $weekend,

            "stoppage" => (string) $stoppage,

            "facility" => (string) $facility,

            "company_name" => $this->request->getVar('company_name'),

            "startdate" => $this->request->getVar('startdate'),

            "status" => $this->request->getVar('status'),

            "oprationDatetype" => $this->request->getVar('oprationDatetype'),

            "repetedstartdate" => $this->request->getVar('repetedstartdate'),

            "repetedenddate" => $this->request->getVar('repetedenddate'),

            "repeted_after" => $this->request->getVar('repeted_after'),

            "maxdayforbooking" => $this->request->getVar('maxdayforbooking'),

            "offdates" => $this->request->getVar('offdates'),

            "offdateranges" => $this->request->getVar('offdateranges'),

            "startdateinrange" => $this->request->getVar('startdateinrange2'),

            "enddateinrange" => $this->request->getVar('enddateinrange2'),

            "trip_category_id" => $this->request->getVar('trip_category_id'),

            "trip_bus_type_id" => $this->request->getVar('trip_bus_type_id'),

            "trip_type" => $this->request->getVar('trip_type'),

            'company_id' => $companyId,

            "seatclass" => json_encode($mergedData),

        );

        if(empty($companyId)){

        return redirect()->back()->withInput()->with('fail', "please select company name");    

        }

        

        if ($this->validation->run($tripData, 'trip')) {

            // trip data is valid

            $this->db->transStart();

            $maintrip = $this->tripModel->insert($tripData);

            $data = [

                "subject" => "New Trip create",

                "message" => "Big Discount on Trip",

                "notification_type" => 'manual',

                "target_group" => "all_users",

                "trip_id" => null,

                "notification_date" => date('Y-m-d H:i:s', strtotime('+30 minutes')),

                "repeat_option" => 'none',

                "status" => 'scheduled',

                "is_push_notification" =>  0,

                "created_by" => 0,

            ];

            $notificationId = $this->notificationModel->insert($data);



            // build data for pickdropstands

            foreach ($busStandTime as $key => $pickupvalue) {

                $picupdata[$key] = array(

                    "stand_id" => $busStandlocation[$key],

                    "trip_id" => $maintrip,

                    "time" => $pickupvalue,

                    "trip_type" => 1,

                    "type" => (int) $busStandtype[$key],

                    "detail" => $standDetails[$key],

                );

            }



            foreach ($dropbusStandTime as $dkey => $dropvalue) {

                $dropdata[$dkey] = array(

                    "stand_id" => $dropbusStandlocation[$dkey],

                    "trip_id" => $maintrip,

                    "time" => $dropvalue,

                    "trip_type" => 1,

                    "type" => (int) $dropbusStandtype[$dkey],

                    "detail" => $dropstandDetails[$dkey],

                );

            }



            // insert pick stands

            // and insert drop stands

            $this->picdropModel->insertBatch($picupdata);

            $this->picdropModel->insertBatch($dropdata);



            // build subtrip data

            $subtripdata = array(

                "pick_location_id" => $this->request->getVar('pick_location_id'),

                "drop_location_id" => $this->request->getVar('drop_location_id'),

                "stoppage" => (string) $stoppage,

                "trip_id" => $maintrip,

                "adult_fair" => $this->request->getVar('adult_fair') ?? 0,

                "child_fair" => $this->request->getVar('child_fair') ?? 0,

                "special_fair" => $this->request->getVar('special_fair') ?? 0,

                "type" => 'main',

                "status" => $this->request->getVar('status'),

                "subtrip_seatclass" => json_encode($mergedData),

            );



            // insert subtrip

            $this->subtripModel->insert($subtripdata);



            // build driver and assistant data

            // foreach ($driver as $key => $value) {

            //     $driverdata = array(

            //         "trip_id" => $maintrip,

            //         "employee_id" => $value,

            //         "employee_type" => '1',

            //     );



            //     $this->stuffassignModel->insert($driverdata);

            // }



            // foreach ($assistant as $key => $avalue) {

            //     $assistantdata = array(

            //         "trip_id" => $maintrip,

            //         "employee_id" => $avalue,

            //         "employee_type" => '2',

            //     );



            //     $this->stuffassignModel->insert($assistantdata);

            // }

            $this->db->transComplete();

        // print_r($tripData);die;

            return redirect()->route('index-trip')->with("success", "Data Save");

        }



        return redirect()->back()->withInput()->with('error', $this->validation->listErrors());

    }



    public function edit($id)

    {

        $data['viewpath'] = $this->Viewpath;



        $trip = $this->tripModel->find($id);

        $driver = array();

        foreach ($this->stuffassignModel->where('trip_id ', $id)->where('employee_type', 1)->findAll() as $key => $driverValue) {

            array_push($driver, $driverValue->employee_id);

        }



        $assistant =  array();

        foreach ($this->stuffassignModel->where('trip_id ', $id)->where('employee_type', 2)->findAll() as $key => $assistantValue) {

            array_push($assistant, $assistantValue->employee_id);

        }



        $this->db->transStart();

        $TripBusTypes = $this->db->table('trip_bus_types')

                        ->where('deleted_at', null)

                        ->get()

                        ->getResult();

        $this->db->transComplete();



        $this->db->transStart();

        $TripCategories = $this->db->table('trip_category')

                        ->where('deleted_at', null)

                        ->get()

                        ->getResult();

        $this->db->transComplete();



        $data['TripBusTypes'] =  $TripBusTypes;

        $data['TripCategories'] =  $TripCategories;

        $data['stoppage'] = [];

        $data['weekoff'] = [];

        if(isset($trip->stoppage) && !empty($trip->stoppage)){

            $data['stoppage'] = explode(",", $trip->stoppage);

        }

        if(isset($trip->weekend) && !empty($trip->weekend)){

            $data['weekoff'] = explode(",", $trip->weekend);

        }

        



        $data['olddriver'] = $driver;

        $data['olddassistant'] = $assistant;



        $data['facilityold'] = isset($trip->facility)?explode(",", $trip->facility):[];



        $heading = lang("Localize.edit") . ' ' . lang("Localize.trip");

        $data['pageheading'] = $heading;



        $data['trip'] = $trip;

        // echo "<pre>";print_r($data['trip']);exit;



        $data['total_layout_seats'] = 50;

        if(isset($data['trip']->fleet_id) && $data['trip']->fleet_id){

            $fleet_type_details = $this->fleetTypeModel->find($data['trip']->fleet_id);

            if($fleet_type_details && $fleet_type_details->total_seat){

                $data['total_layout_seats'] = $fleet_type_details->total_seat;

            }

            

        }



        $weekday = array(

            '1' => 'Monday',

            '2' => 'Tuesday',

            '3' => 'Wednesday',

            '4' => 'Thursday',

            '5' => 'Friday',

            '6' => 'Saturday',

            '7' => 'Sunday',

        );

        $this->db->transStart();

        $classData = $this->db->table('seat_class')

                        ->get()

                        ->getResult();

        $this->db->transComplete();

        $data['class'] = $classData;

        $data['weekday'] =  $weekday;

        $data['location'] = $this->locationModel->findAll();

        $data['schedule'] = $this->scheduleeModel->findAll();

        $data['fleet_types'] = $this->fleetTypeModel->findAll();

        $data['vehicle_id'] = $this->vehicleModel->findAll();

        //echo "<pre>";print_r($data['vehicle_id']);exit;

        $data['driver'] = $this->employeeModel->where('employeetype_id', 1)->findAll();

        $data['assistant'] = $this->employeeModel->where('employeetype_id', 2)->findAll();

        $data['stand'] = $this->standModel->findAll();

        $data['facility'] = $this->facilitypModel->findAll();

        $data['arrival'] = $this->picdropModel->where('trip_id', $id)->where('type', 1)->findAll();

        $data['departure'] = $this->picdropModel->where('trip_id', $id)->where('type', 0)->findAll();



        $data['module'] =    lang("Localize.trip");

        $data['title']  =    lang("Localize.trip_list");

        $data['company_id'] = isset($data['trip']->company_id)?$data['trip']->company_id:"";

        $data['companies'] = $this->companyModel->findAll();

        $data['seatclass'] = $trip->seatclass??"";





        echo view($this->Viewpath . '\trip/edit', $data);

    }



    public function update($trip_id)

    {

        $NewBokkingClass = $_POST['seatClass'];

        // $NewBokkingClass = $this->removeEmptyValues($_POST['seatNo']);

        // print_r(array_keys($NewBokkingClass));

        // exit;

        $futureTickets = $this->db->table('tickets')

                ->join('trips', 'trips.id = tickets.trip_id', 'left')

                ->where('tickets.trip_id', $trip_id)

                ->where('tickets.journeydata >', date('Y-m-d H:i:s'))

                ->get()

                ->getResult();

        

        $seatclass = [];

        if(!empty($futureTickets)){

            foreach($futureTickets as $futureTicket){

                // if (!empty($futureTicket->seatnumber)) {

                    $seatclass[] = array_values($this->getSeatClasses($futureTicket->seatclass, $futureTicket->seatnumber));

                // }

            }

        }

        $keepClass = array_unique(array_merge(...$seatclass));

        foreach($keepClass as $class){

            if(!in_array($class, array_values($NewBokkingClass))){

                $customError = "Please don't remove active class";

                return redirect()->route('edit-trip', [$trip_id])->with('fail', $customError);

            }

        }

        

        $companyId = $this->request->getVar('company_id')??session()->get('company_id');



        if($companyId > 0){

            $companyData = $this->companyModel->where('id',$companyId)->first();

            if($companyData->status == 0 && $this->request->getVar('status') == 1){

                $customError = "Please activate the company";

                return redirect()->route('edit-trip', [$trip_id])->with('fail', $customError);

            }

        }



        $data['viewpath'] = $this->Viewpath;

        $picupdata = array();

        $dropdata = array();



        $pickLocation = $this->request->getVar('pick_location_id');

        $dropLocation = $this->request->getVar('drop_location_id');

        $busStandTime = $this->request->getVar('picktime');

        $busStandlocation = $this->request->getVar('picstand');

        $standDetails = $this->request->getVar('detail');

        $busStandtype = $this->request->getVar('type');



        $dropbusStandTime = $this->request->getVar('droptime');

        $dropbusStandlocation = $this->request->getVar('dropstand');

        $dropstandDetails = $this->request->getVar('dropdetail');

        $dropbusStandtype = $this->request->getVar('droptype');

        $trip_category_id = $this->request->getVar('trip_category_id');

        $trip_bus_type_id = $this->request->getVar('trip_bus_type_id');

        $trip_type = $this->request->getVar('trip_type');



        foreach ($busStandTime as $key => $pickupvalue) {

            $picupdata[$key] = array(

                "stand_id" => $busStandlocation[$key],

                "trip_id" => $trip_id,

                "time" => $busStandTime[$key],

                "type" => (int) $busStandtype[$key],

                "detail" => $standDetails[$key],

            );

        }



        foreach ($dropbusStandTime as $dkey => $dropvalue) {

            $dropdata[$dkey] = array(

                "stand_id" => $dropbusStandlocation[$dkey],

                "trip_id" => $trip_id,

                "time" => $dropbusStandTime[$dkey],

                "type" => (int) $dropbusStandtype[$dkey],

                "detail" => $dropstandDetails[$dkey],

            );

        }



        $driver = $this->request->getVar('driver');

        $assistant = $this->request->getVar('assistant');



        $stoppage = array_merge([$pickLocation], (array) $this->request->getVar('stoppage'), [$dropLocation]);

        $stoppage = implode(",", array_filter($stoppage));



        $weekend = $this->request->getVar('weekend');

        if (!empty($weekend)) {

            $weekend = implode(",", $weekend);

        }



        $facility = $this->request->getVar('facility');

        if (!empty($facility)) {

            $facility = implode(",", $facility);

        }



        if (isset($_POST['seatNo']) && is_array($_POST['seatNo'])) {

            $seatNoArray = $_POST['seatNo'];

        

            // Normalize the array to ensure proper indexing

            $_POST['seatNo'] = array_values($seatNoArray);

        } 

        $mergedData = [];

        foreach ($_POST['seatClass'] as $key => $seatClass) {

            if($seatClass > 0 && (isset($_POST['seatNo'][$key]) && is_array($_POST['seatNo'][$key]) && !empty($_POST['seatNo'][$key])) && (isset($_POST['fares'][$key]) && $_POST['fares'][$key] > 0) ){

                $mergedData[] = [

                    'seatClass' => $seatClass,

                    'seatNo' => $_POST['seatNo'][$key]??"",

                    'fare' => $_POST['fares'][$key]

                ];

            }

        }

        $allSubtrips = $this->subtripModel->where("trip_id", $trip_id)->where('type !=', 'main')->findAll();

        {

            for($k = 0; $k < count($allSubtrips); $k++){

                

                $CurrentNewSeatData = [];

                $CurrentSeatDataNum = 0;

                $emptysubtrip = 0;

                $ExistingData = [];

                if($allSubtrips[$k]->subtrip_seatclass != "" && $allSubtrips[$k]->subtrip_seatclass != null){

                    $ExistingData = json_decode($allSubtrips[$k]->subtrip_seatclass, 1);

                    if(empty($ExistingData)){

                        $emptysubtrip = 1;

                    }

                }

                if($emptysubtrip == 1){

                    $CurrentNewSeatData = $mergedData;

                } else {

                    

                    if(!empty($mergedData)){



                        for($o = 0; $o < count($mergedData); $o++){

                            

                            $seatClass = $mergedData[$o]['seatClass'];

                            $classMatch = 0;

                            for($m = 0; $m < count($ExistingData); $m++){

                                

                                if($seatClass == $ExistingData[$m]['seatClass']){

                                    $classMatch = 1;

                                    

                                    $CurrentNewSeatData[$CurrentSeatDataNum]['seatClass'] = $ExistingData[$m]['seatClass'];

                                    $CurrentNewSeatData[$CurrentSeatDataNum]['seatNo'] = $mergedData[$o]['seatNo'];

                                    $CurrentNewSeatData[$CurrentSeatDataNum]['fare'] = $ExistingData[$m]['fare'];

                                    $CurrentSeatDataNum++;

                                }

                            }

                            if($classMatch == 0){

                                $CurrentNewSeatData[$CurrentSeatDataNum] = $mergedData[$o];

                                $CurrentSeatDataNum++;

                            }

                            

                        }

                    }

                }

                if(empty($CurrentNewSeatData)){

                    $CurrentNewSeatData = null;

                }

                $this->subtripModel->where('id', $allSubtrips[$k]->id)

                    ->set(['subtrip_seatclass' => json_encode($CurrentNewSeatData)])

                    ->update();

            }

            

        }

        $offdates = $this->request->getVar('offdates');



        $tripData = array(

            "id" => $trip_id,

            "company_id" => $companyId,

            "fleet_id" => $this->request->getVar('fleet_id'),

            "schedule_id" => $this->request->getVar('schedule_id'),

            "pick_location_id" => $this->request->getVar('pick_location_id'),

            "drop_location_id" => $this->request->getVar('drop_location_id'),

            "vehicle_id" => $this->request->getVar('vehicle_id'),

            "distance" => $this->request->getVar('distance'),

            "journey_hour" => $this->request->getVar('journey_hour'),

            "special_seat" => $this->request->getVar('special_seat'),

            "child_seat" => $this->request->getVar('child_seat'),

            "adult_fair" => $this->request->getVar('adult_fair'),

            "child_fair" => $this->request->getVar('child_fair'),

            "vip_seat" => $this->request->getVar('vip_seat'),

            "vip_fair" => $this->request->getVar('vip_fair'),

            "special_fair" => $this->request->getVar('special_fair'),

            "weekend" => (string) $weekend,

            "stoppage" => (string) $stoppage,

            "facility" => (string) $facility,

            "company_name" => $this->request->getVar('company_name'),

            "startdate" => $this->request->getVar('startdate'),

            "status" => $this->request->getVar('status'),

            "oprationDatetype" => $this->request->getVar('oprationDatetype'),

            "repetedstartdate" => $this->request->getVar('repetedstartdate'),

            "repetedenddate" => $this->request->getVar('repetedenddate'),

            "repeted_after" => $this->request->getVar('repeted_after'),

            "maxdayforbooking" => $this->request->getVar('maxdayforbooking'),

            "offdates" => $offdates,

            "offdateranges" => $this->request->getVar('offdateranges'),

            "startdateinrange" => $this->request->getVar('startdateinrange2'),

            "enddateinrange" => $this->request->getVar('enddateinrange2'),

            "seatclass" => json_encode($mergedData),

            "trip_category_id" => $this->request->getVar('trip_category_id'),

            "trip_bus_type_id" => $this->request->getVar('trip_bus_type_id'),

            "trip_type" => $this->request->getVar('trip_type'),

        );



        if ($this->validation->run($tripData, 'trip')) {

            $this->db->transStart();

            $this->db->query('SET foreign_key_checks = 0');



            $this->tripModel->save($tripData);



            $subtripid = $this->subtripModel->where('trip_id', $trip_id)->where('type', 'main')->find();



            $subtripdata = array(

                "id" => $subtripid[0]->id,

                "pick_location_id" => $this->request->getVar('pick_location_id'),

                "drop_location_id" => $this->request->getVar('drop_location_id'),

                "stoppage" => (string) $stoppage,

                "trip_id" => $trip_id,

                "adult_fair" => $this->request->getVar('adult_fair'),

                "child_fair" => $this->request->getVar('child_fair'),

                "special_fair" => $this->request->getVar('special_fair'),

                "type" => 'main',

                "status" => $this->request->getVar('status'),

                "subtrip_seatclass" => json_encode($mergedData),



            );



            $this->subtripModel->save($subtripdata);



            $this->stuffassignModel->where('trip_id', $trip_id)->delete('', true);



            if($driver){

                foreach ($driver as $key => $value) {

                    $driverdata = array(

                        "trip_id" => $trip_id,

                        "employee_id" => $value,

                        "employee_type" => '1',

                    );



                    $this->stuffassignModel->insert($driverdata);

                }

            }



            if($assistant){

                foreach ($assistant as $key => $avalue) {

                    $assistantdata = array(

                        "trip_id" => $trip_id,

                        "employee_id" => $avalue,

                        "employee_type" => '2',

                    );



                    $this->stuffassignModel->insert($assistantdata);

                }

            }







            // if ($this->request->getVar('status') == 0) {



            //     $this->subtripModel->where('trip_id', $trip_id)

            //         ->set(['status' => 0])

            //         ->update();

            // }

            // if ($this->request->getVar('status') == 1) {



            //     $this->subtripModel->where('trip_id', $trip_id)

            //         ->set(['status' => 1])

            //         ->update();

            // }



            // $this->picdropModel->where('trip_id', $trip_id)->delete('', true);

            $this->picdropModel->where('trip_id', $trip_id)->delete();



            $this->picdropModel->insertBatch($picupdata);

            $lastpicId = $this->db->insertID();





            $this->picdropModel->insertBatch($dropdata);

            $lastdropId = $this->db->insertID();



            $futureTickets = $this->db->table('tickets')

                ->where('tickets.trip_id', $trip_id)

                ->where('tickets.journeydata >', date('Y-m-d H:i:s'))

                ->get()

                ->getResult();



            foreach($futureTickets as $futureTicket){;

                $this->ticketModel->where('id', $futureTicket->id)

                                    ->set(['pick_stand_id' => $lastpicId])

                                    ->set(['drop_stand_id' => $lastdropId])

                                    ->update();

            }



            $this->db->query('SET foreign_key_checks = 1');

            $this->db->transComplete();

            return redirect()->route('index-trip')->with("success", "Data Save");

        }



        return redirect()->back()->withInput()->with('fail', $this->validation->listErrors());

    }



    public function findtrip()

    {

        $data['location'] = $this->locationModel->findAll();

        $data['pageheading'] = lang("Localize.trip");

        echo view($this->Viewpath . '\trip/findtrip', $data);

    }



    public function getAllTrip()



    {

        $day = $this->request->getVar('journeydate');

        $day = date('Y-m-d', strtotime($day));







        $dayofweek = date('N', strtotime($this->request->getVar('journeydate')));

        $picklocation = $this->request->getVar('pick_location_id');

        $droplocation = $this->request->getVar('drop_location_id');

        $offerApplied = $this->request->getVar('offer')??"";

        $maintripId = array();





        $getdata =  $this->tripModel->select('trips.id')->Where('startdate >', $day)->where('status', 1)->orwhere("find_in_set($dayofweek, weekend)")->findAll();



        foreach ($getdata as $key => $value) {

            array_push($maintripId, (int)$value->id);

        }



        if ($getdata) {

            $getMainTripid = array();

            $subtrips =  $this->subtripModel->select('trip_id')->where('pick_location_id', $picklocation)->where('drop_location_id', $droplocation)->whereNotIn('trip_id', $maintripId)->findAll();







            foreach ($subtrips as $key => $svalue) {

                array_push($getMainTripid, (int)$svalue->trip_id);

            }





            if ($subtrips) {

                $allTripList =  $this->subtripModel->select('trips.id as tripid,trips.*,fleets.*,schedules.*,vehicles.*,subtrips.id as subtripId,subtrips.*')

                    ->join('trips', 'trips.id = subtrips.trip_id')

                    ->join('fleets', 'fleets.id = trips.fleet_id')

                    ->join('schedules', 'schedules.id = trips.schedule_id')

                    ->join('vehicles', 'vehicles.id = trips.vehicle_id')

                    ->whereIn('trip_id', $getMainTripid)

                    ->where('subtrips.status', 1)

                    ->findAll();

                echo json_encode($allTripList);

            } else {

                dd("Holiday for all trip No trip found");

            }

        } else {

            $getMainTripid = array();

            $subtrips =  $this->subtripModel->select('trip_id')->where('pick_location_id', $picklocation)->where('drop_location_id', $droplocation)->findAll();



            foreach ($subtrips as $key => $svalue) {

                array_push($getMainTripid, (int)$svalue->trip_id);

            }

            if ($subtrips) {



                $subtrips =  $this->subtripModel->select('trips.id as tripid,trips.*,fleets.*,schedules.*,vehicles.*,subtrips.id as subtripId,subtrips.*')

                    ->join('trips', 'trips.id = subtrips.trip_id')

                    ->join('fleets', 'fleets.id = trips.fleet_id')

                    ->join('schedules', 'schedules.id = trips.schedule_id')

                    ->join('vehicles', 'vehicles.id = trips.vehicle_id')

                    ->whereIn('trip_id', $getMainTripid)

                    ->where('subtrips.status', 1)

                    ->findAll();

                echo json_encode($subtrips);

            } else {

                dd("NO trip found for this destination");

            }

        }

    }







    public function delete($id)

    {

        $subtripid = array();

        $subtrip = $this->subtripModel->where('trip_id', $id)->findAll();





        foreach ($subtrip as $key => $subvalue) {

            $subid = $subvalue->id;

            array_push($subtripid, $subid);

        }



        if ($subtrip) {

            $this->subtripModel->delete($subtripid);

        }



        $this->tripModel->delete($id);

        return redirect()->route('index-trip')->with("fail", "Data Deleted");

    }



    public function status($tripId)

    {

        $tripStatus = $this->tripModel->find($tripId);



        if ($tripStatus->status == 1) {        

            $upData = array(

                "id" => $tripId,

                "status" => 0

            );

            $this->tripModel->save($upData);



        }

        if ($tripStatus->status == 0) {

            if($tripStatus->company_id > 0){

                $companyStatus = $this->companyModel->find($tripStatus->company_id);

                if($companyStatus->status == 0){

                    return redirect()->route('index-trip')->with("fail", "please activate the company");

                }

            }

            $upData = array(

                "id" => $tripId,

                "status" => 1

            );

            $this->tripModel->save($upData);

        }

        return redirect()->route('index-trip')->with("success", "Data Update");

    }



    function removeEmptyValues($array) {

        return array_map(function($subArray) {

            return array_values(array_filter($subArray));

        }, $array);

    }



    function getSeatClasses($seatsData, $seatNumbers) {

        if (is_string($seatsData)) {

            $seatsData = json_decode($seatsData, true);

        }



        if (!is_array($seatNumbers)) {

            $seatNumbers = explode(",", $seatNumbers);

        }



        $seatClasses = [];

        $seatClassesArray = [];

        // print_r($seatNumbers);exit;

        foreach ($seatNumbers as $seatNo) {

            // $found = false; 

            if(is_array($seatsData) && !empty($seatsData)){

                foreach ($seatsData as $seatInfo) {

                    if (in_array($seatNo, $seatInfo['seatNo'])) {

                        $seatClasses[$seatNo] = $seatInfo['seatClass'];

                        // $found = true;

                        break;

                    }

                }

            }

            // if (!$found) {

            //     $seatClasses[$seatNo] = "adult seat";

            // }

            // $seatClassesArray[] = $seatClasses[$seatNo];

        }

        // $uniqueSeatClassesArray = array_unique($seatClassesArray);

        return $seatClasses;



    }
   
    public function serverList()
    {
        $request = service('request');

        // Role and company ID from session
        $role_id = session()->get('role_id');
        $company_id = session()->get('company_id');

        // Check permissions
        $rolepermissionLibrary = new Rolepermission();
        $edit_trip = $rolepermissionLibrary->edit("trip_list");
        $delete_trip = $rolepermissionLibrary->delete("trip_list");

        // DataTables request values
        $draw   = $request->getPost('draw');
        $start  = $request->getPost('start');
        $length = $request->getPost('length');
        $searchValue = $request->getPost('search')['value'] ?? '';

        // Column map
        // For role_id == 1: #, Pick Up, Drop, Schedule, Distance, Hour, Company, Trip ID, Status, Action
        // For role_id != 1: #, Pick Up, Drop, Schedule, Distance, Hour, Trip ID, Status, Action
        $columns = [];
        $colIndex = 0;
        
        $columns[$colIndex++] = 'trips.id';  // index column
        $columns[$colIndex++] = 'pick_location.name';  // pick_up
        $columns[$colIndex++] = 'drop_location.name';  // drop
        $columns[$colIndex++] = 'schedules.start_time';  // schedule
        $columns[$colIndex++] = 'trips.distance';  // distance
        $columns[$colIndex++] = 'trips.journey_hour';  // hour
        if ($role_id == "1") {
            $columns[$colIndex++] = 'companies.name';  // company column (only for admin)
        }
        $columns[$colIndex++] = 'trips.id';  // trip id (same as tripid)
        $columns[$colIndex++] = 'trips.status';  // status
        $columns[$colIndex++] = null;  // action column (not orderable/searchable)

        // Order column & direction
        $order = $request->getPost('order');
        $orderColumnIndex = !empty($order) && isset($order[0]['column']) ? $order[0]['column'] : 0;
        $orderDirection   = !empty($order) && isset($order[0]['dir']) ? $order[0]['dir'] : 'asc';

        // ---- TOTAL RECORDS ----
        // Use a fresh builder instance for count to avoid duplicate JOINs
        $countBuilder = $this->db->table('trips');
        $countBuilder->select('trips.id')
            ->join('schedules', 'schedules.id = trips.schedule_id', 'left')
            ->join('companies', 'trips.company_id = companies.id', 'left')
            ->join('locations as pick_location', 'pick_location.id = trips.pick_location_id', 'left')
            ->join('locations as drop_location', 'drop_location.id = trips.drop_location_id', 'left')
            ->where('trips.deleted_at IS NULL');

        // Apply role-based filtering
        if ($role_id != "1" && !empty($company_id)) {
            $countBuilder->where('trips.company_id', $company_id);
        }

        $totalRecords = $countBuilder->countAllResults(false);

        // Create fresh builder for filtered query - build manually to avoid model builder state issues
        $builder = $this->db->table('trips');
        $builder->select('trips.id as tripid, trips.status as trip_status, trips.*, trips.distance as trip_distance, trips.journey_hour as trip_journey_hour, schedules.*, companies.name as company_name, pick_location.name as pick_location_name, drop_location.name as drop_location_name')
            ->join('schedules', 'schedules.id = trips.schedule_id', 'left')
            ->join('companies', 'trips.company_id = companies.id', 'left')
            ->join('locations as pick_location', 'pick_location.id = trips.pick_location_id', 'left')
            ->join('locations as drop_location', 'drop_location.id = trips.drop_location_id', 'left')
            ->where('trips.deleted_at IS NULL');

        // Apply role-based filtering
        if ($role_id != "1" && !empty($company_id)) {
            $builder->where('trips.company_id', $company_id);
        }

        // Apply search filter
        if (!empty($searchValue)) {
            $builder->groupStart()
                ->like('pick_location.name', $searchValue)
                ->orLike('drop_location.name', $searchValue)
                ->orLike('schedules.start_time', $searchValue)
                ->orLike('trips.distance', $searchValue)
                ->orLike('trips.journey_hour', $searchValue)
                ->orLike('companies.name', $searchValue)
                ->orLike('trips.id', $searchValue)
                ->groupEnd();
        }

        // Create a separate builder for filtered count to avoid duplicate JOINs
        $filteredCountBuilder = $this->db->table('trips');
        $filteredCountBuilder->select('trips.id')
            ->join('schedules', 'schedules.id = trips.schedule_id', 'left')
            ->join('companies', 'trips.company_id = companies.id', 'left')
            ->join('locations as pick_location', 'pick_location.id = trips.pick_location_id', 'left')
            ->join('locations as drop_location', 'drop_location.id = trips.drop_location_id', 'left')
            ->where('trips.deleted_at IS NULL');

        // Apply role-based filtering
        if ($role_id != "1" && !empty($company_id)) {
            $filteredCountBuilder->where('trips.company_id', $company_id);
        }

        // Apply search filter
        if (!empty($searchValue)) {
            $filteredCountBuilder->groupStart()
                ->like('pick_location.name', $searchValue)
                ->orLike('drop_location.name', $searchValue)
                ->orLike('schedules.start_time', $searchValue)
                ->orLike('trips.distance', $searchValue)
                ->orLike('trips.journey_hour', $searchValue)
                ->orLike('companies.name', $searchValue)
                ->orLike('trips.id', $searchValue)
                ->groupEnd();
        }

        // Column-wise filters
        if (!empty($request->getPost('columns'))) {
            foreach ($request->getPost('columns') as $idx => $col) {
                $searchCol = $col['search']['value'] ?? '';
                if ($searchCol !== '' && isset($columns[$idx]) && $columns[$idx] !== null) {
                    $filteredCountBuilder->like($columns[$idx], $searchCol);
                    $builder->like($columns[$idx], $searchCol);
                }
            }
        }

        // ---- TOTAL FILTERED ----
        $totalRecordwithFilter = $filteredCountBuilder->countAllResults(false);

        // ---- ORDERING ----
        if (isset($columns[$orderColumnIndex]) && $columns[$orderColumnIndex] !== null) {
            $builder->orderBy($columns[$orderColumnIndex], $orderDirection);
        } else {
            $builder->orderBy('trips.id', 'desc');
        }

        // ---- PAGINATION ----
        if ($length > 0) {
            $builder->limit($length, $start);
        }

        // ---- FETCH RECORDS ----
        $records = $builder->get()->getResult();

        // ---- FORMAT JSON ----
        $data = [];
        $i = $start + 1;

        foreach ($records as $row) {
            // Format distance with 'km'
            $distanceDisplay = (!empty($row->trip_distance) && $row->trip_distance !== '') 
                ? esc($row->trip_distance) . 'km' 
                : '';

            // Format status
            $statusHtml = '';
            if (isset($row->trip_status) && $row->trip_status == "1") {
                $statusHtml = '<span class="badge bg-success">' . lang("Localize.active") . '</span>';
            } else {
                $statusHtml = '<span class="badge bg-secondary">' . lang("Localize.disable") . '</span>';
            }

            // Build data array - always start with index
            $rowData = [
                "index" => $i++,
                "pick_up" => esc($row->pick_location_name ?? ''),
                "drop" => esc($row->drop_location_name ?? ''),
                "schedule" => esc($row->start_time ?? ''),
                "distance" => $distanceDisplay,
                "hour" => esc($row->trip_journey_hour ?? ''),
            ];

            // Add company column only for role_id == 1
            if ($role_id == "1") {
                $rowData["company"] = esc($row->company_name ?? '');
            }

            // Add common columns
            $rowData["trip_id"] = esc($row->tripid ?? '');
            $rowData["status"] = $statusHtml;
            $rowData["action"] = $this->generateActionButtons($row, $edit_trip, $delete_trip);

            $data[] = $rowData;
        }

        return $this->response->setJSON([
            "draw" => intval($draw),
            "recordsTotal" => $totalRecords,
            "recordsFiltered" => $totalRecordwithFilter,
            "data" => $data
        ]);
    }

    private function generateActionButtons($row, $edit_trip, $delete_trip)
    {
        $security = \Config\Services::security();
        $csrfToken = $security->getTokenName();
        $csrfHash = $security->getHash();
        
        $actionHtml = '';
        
        if ($edit_trip) {
            // Status toggle button
            $statusIcon = isset($row->trip_status) && $row->trip_status ? 'fa-user-slash' : 'fa-user-check';
            $actionHtml .= '<form action="' . base_url(route_to('status-trip', $row->tripid)) . '" class="d-inline-block" method="post">';
            $actionHtml .= '<input type="hidden" name="' . esc($csrfToken, 'attr') . '" value="' . esc($csrfHash, 'attr') . '">';
            $actionHtml .= '<input type="hidden" name="_method" value="PUT">';
            $actionHtml .= '<button type="submit" class="btn btn-sm btn-secondary text-white" title="' . lang("Localize.status") . '">';
            $actionHtml .= '<i class="fas ' . esc($statusIcon, 'attr') . '"></i>';
            $actionHtml .= '</button>';
            $actionHtml .= '</form> ';

            // Edit button
            $actionHtml .= '<a href="' . base_url(route_to('edit-trip', $row->tripid)) . '" class="btn btn-sm btn-info text-white" title="' . lang("Localize.edit") . '">';
            $actionHtml .= '<i class="fas fa-edit"></i>';
            $actionHtml .= '</a> ';
        }

        // Sub Trip button
        $actionHtml .= '<a href="' . base_url(route_to('index-Subtrip', $row->tripid)) . '" class="btn btn-sm btn-success">';
        $actionHtml .= lang("Localize.sub") . ' ' . lang("Localize.trip");
        $actionHtml .= '</a> ';

        if ($delete_trip) {
            $actionHtml .= '<form action="' . base_url(route_to('ss-delete-confirmation', 'trip', $row->tripid)) . '" id="tripDelete" method="get" class="d-inline-block deletionForm">';
            $actionHtml .= '<button type="button" data-modal-confirm="true" class="btn btn-sm btn-danger" title="' . lang("Localize.delete") . '">';
            $actionHtml .= '<i class="far fa-trash-alt"></i>';
            $actionHtml .= '</button>';
            $actionHtml .= '</form>';
        }
        
        return $actionHtml;
    }

}

