<?php

namespace App\Commands;

use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;
use Modules\Notification\Models\NotificationModel;
use CodeIgniter\Database\Exceptions\DataException;
use Modules\Passanger\Models\UserDeviceModel;
use Modules\Ticket\Models\TicketModel;

class SendScheduledNotifications extends BaseCommand
{
    protected $group       = 'Notifications';
    protected $name        = 'notifications:send';
    protected $description = 'Send scheduled notifications every minute';

    // public function run(array $params)
    // {
    //     $notificationModel = new NotificationModel();

    //     // Find scheduled notifications whose time has arrived
    //     $notifications = $notificationModel->where('status', 'scheduled')
    //         ->where('notification_date <=', date('Y-m-d H:i:s'))
    //         ->findAll();
    //     if (empty($notifications)) {
    //         CLI::write('No notifications to send at this time.', 'yellow');
    //         return;
    //     }

    //     foreach ($notifications as $notification) {
    //             $targetUserIds = [];

    //     if ($notification->target_group === 'all_users') {
    //         // Get all active user device entries
    //         $devices = $userDeviceModel->where('status', 'active')->findAll();

    //         foreach ($devices as $device) {
    //             $targetUserIds[] = $device->user_id;
    //         }
    //         try {
    //             print_r($notification);
    //             exit;
    //             // Call your existing API endpoint
    //             $ch = curl_init();
    //             curl_setopt($ch, CURLOPT_URL, "https://data.busvalley.com/busvalley_new/modules/api/v1/passangers/send-notification");
    //             curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    //             curl_setopt($ch, CURLOPT_POST, true);
    //             curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    //             curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
    //                 'user_id' => $notification['user_id'],
    //                 'title'   => $notification['subject'],  
    //                 'body'    => $notification['message'],   
    //             ]));

    //             $response = curl_exec($ch);
    //             print_r($response);
    //             exit;

    //             curl_close($ch);

    //             // Update notification status → sent
    //              $notificationModel->update($notification['id'], [
    //                 'status' => 'sent',
    //                 'updated_at' => date('Y-m-d H:i:s')
    //             ]);

    //             CLI::write("Notification {$notification['id']} sent successfully.", 'green');
    //         } catch (\Exception $e) {
    //             CLI::error("Error sending notification {$notification['id']}: " . $e->getMessage());
    //         }
    //     }
    // }
    public function run(array $params)
    {
        $notificationModel = new NotificationModel();
        $userDeviceModel   = new UserDeviceModel();
        $ticketModel       = new TicketModel();

        // 1. Fetch scheduled notifications whose time has arrived
        $notifications = $notificationModel->where('status', 'scheduled')
            ->where('notification_date <=', date('Y-m-d H:i:s'))
            ->findAll();

        if (empty($notifications)) {
            CLI::write('No notifications to send at this time.', 'yellow');
            return;
        }

        foreach ($notifications as $notification) {

            $targetUserIds = [];

            // 2. Determine target users
            if ($notification['target_group'] === 'all_users') {
                // Get all active user device entries
                $devices = $userDeviceModel->where('status', 1)->findAll();
                foreach ($devices as $device) {
                    $targetUserIds[] = $device->user_id; // array syntax
                }
                // Remove duplicate user IDs
                $targetUserIds = array_unique($targetUserIds);
            }elseif ($notification['target_group'] === 'specific_trip' && !empty($notification['trip_id'])) {
                // Find all passengers linked to the given trip_id
                $tickets = $ticketModel->where('trip_id', $notification['trip_id'])->findAll();
                foreach ($tickets as $ticket) {
                    $targetUserIds[] = $ticket->passanger_id;
                }
                $targetUserIds = array_unique($targetUserIds);
            }
            // print_r($targetUserIds);
            // exit;
            // 3. Send notification to each user
            foreach ($targetUserIds as $userId) {
                try {
                    // Call your API endpoint
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, "https://data.busvalley.com/busvalley_new/modules/api/v1/passangers/send-notification");
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
                        'user_id' => $userId,
                        'title'   => $notification['subject'],  // array syntax
                        'body'    => $notification['message'],  // array syntax
                    ]));

                    $response = curl_exec($ch);
                    curl_close($ch);

                    CLI::write("Notification {$notification['id']} sent to user {$userId}: {$response}", 'green');

                } catch (\Exception $e) {
                    CLI::error("Error sending notification {$notification['id']} to user {$userId}: " . $e->getMessage());
                }
            }

            $updateData = [];

            switch ($notification['repeat_option']) {
                case 'none':
                    $updateData['status'] = 'sent';
                    break;
                case 'daily':
                    $updateData['notification_date'] = date('Y-m-d H:i:s', strtotime($notification['notification_date'].' +1 day'));
                    break;
                case 'weekly':
                    $updateData['notification_date'] = date('Y-m-d H:i:s', strtotime($notification['notification_date'].' +1 week'));
                    break;
                case 'monthly':
                    $updateData['notification_date'] = date('Y-m-d H:i:s', strtotime($notification['notification_date'].' +1 month'));
                    break;
            }

            $notificationModel->update($notification['id'], $updateData);
        }


        CLI::write('All due notifications processed.', 'blue');
    }

}
