<?php

// Needed for Point 5
$sessiondata = \Config\Services::session();
?>

<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>

<?php echo $this->include('common/message') ?>

<div class="card mb-4">
    <div class="card-body">

      <?php if (($add_data == true)&&($userType == 2)) : ?>
            <div class="text-end">
                <a class="btn btn-success" href="<?php echo base_url(route_to( 'new-payagent' )) ?>"><?php echo lang("Localize.wallet_recharge") ?></a>
            </div>
      <?php endif ?>

      <form action="<?php echo base_url(route_to('date-range'))?>" id="transaction" method="post" class="row g-3" accept-charset="utf-8" enctype="multipart/form-data">
								<?php echo $this->include('common/security') ?>

            <div class="col-3 ">
                <?php echo $this->include('common/filter/daterangefrom') ?>
            </div>

            <div class="col-3">
                <?php echo $this->include('common/filter/daterangeto') ?>
            </div>

            <div class="col-3 mt-4 mb-2">
            <br>
                <button type="submit" class="btn btn-success"><?php echo lang("Localize.submit") ?></button>
            </div>

      </form>
      <?php
      $userid = $sessiondata->get('user_id');

      if ($sessiondata->get('role_id') == 2) {
          $db = \Config\Database::connect();

          // Use prepared statements to prevent SQL injection
          $builder = $db->table('agents');
          $builder->where('user_id', $userid);
          $result = $builder->get()->getRowArray();

          if ($result): ?>
              <div style="width: 30%; margin: 10px; border: 1px solid #ddd; border-radius: 5px; box-shadow: 2px 2px 5px rgba(0, 0, 0, 0.1);">
                  <div style="padding: 15px;">
                      <h5 style="margin: 0 0 10px; font-size: 16px; font-weight: bold;">Wallet Balance</h5>
                      <p style="margin: 0; font-size: 14px; color: #555;">
                          <?= number_format($result['wallet'], 2); ?> EGP
                      </p>
                  </div>
              </div>
          <?php endif;
      }
      ?>
      <?php if (!empty($companyBalances) && is_array($companyBalances)): ?>
          <div class="row mt-4">
              <?php foreach ($companyBalances as $companyName => $balance): ?>
                  <div style="width: 30%; margin: 10px; border: 1px solid #ddd; border-radius: 5px; box-shadow: 2px 2px 5px rgba(0, 0, 0, 0.1);">
                      <div style="padding: 15px;">
                          <h5 style="margin: 0 0 10px; font-size: 16px; font-weight: bold;"><?php echo $companyName; ?> Wallet Balance</h5>
                          <p style="margin: 0; font-size: 14px; color: #555;">
                              <?php echo number_format($balance, 2); ?> EGP
                          </p>
                      </div>
                  </div>
              <?php endforeach; ?>
          </div>
      <?php endif; ?>

        <div class="table-responsive mt-3">
        <table class="table display table-bordered table-striped table-hover basic" id="agentpay">
          <thead>
            <tr>
              <th scope="col">#</th>
              <?php if ($userType == 1 || $userType == 2): ?>  
                  <th scope="col"><?php echo lang("Localize.company") ?></th>
              <?php endif; ?>
              <?php if ($userType == 7 || $userType == 1): ?> 
                  <th scope="col"><?php echo lang("Localize.agent") ?></th>
              <?php endif; ?>
              <th scope="col"><?php echo lang("Localize.id") ?> </th>
              <th scope="col"><?php echo lang("Localize.payment_method") ?> </th>
              <th scope="col"><?php echo lang("Localize.id") ?> </th>
              <th scope="col"><?php echo lang("Localize.status") ?> </th>
              <th scope="col"><?php echo lang("Localize.amount") ?>  </th>
              <th scope="col"><?php //echo lang("Localize.status") ?> Request Date</th>
              <th scope="col"><?php //echo lang("Localize.status") ?> Approve Date</th>
              <th scope="col"><?php //echo lang("Localize.status") ?> Approved by</th>
              
              <th scope="col"><?php echo lang("Localize.action") ?> </th>
            
            </tr>
          </thead>
          <tbody>
          <?php foreach ($payagent as $kye =>  $value) : ?>

            <tr>
              <th scope="row"><?php echo $kye+1 ;?></th>
              
              <?php if ($userType == 1 || $userType == 2): ?>  
                <td>
                  <?php echo $value->company_name??""; ?>
                </td>
              <?php endif; ?>
              <?php if ($userType == 7 || $userType == 1): ?> 
                <td>
                  <a href="<?= base_url(route_to( 'show-payagent',$value->agent_id )) ?>">
                    <?php echo $value->first_name; ?>
                    <?php echo $value->last_name; ?>
                  </a>
                </td>
              <?php endif; ?>
              <td>
                <?php echo $value->id;?>
              </td>
              <td>
                <?php if ($value->payment_mode == 0) : ?>
                  <span>Offline</span>
                <?php endif ?>
                <?php if ($value->payment_mode == 1) : ?>
                  <span>Online</span>
                <?php endif ?>
              </td>
              <td>
                <?php echo $value->transaction_id;?>
              </td>
              <td>
                <?php if ($value->status == 0) : ?>
                  <span class="badge bg-secondary">Pending</span>
                <?php endif ?>
                <?php if ($value->status == 1) : ?>
                  <span class="badge bg-success">Approved</span>
                <?php endif ?>
              </td>
              <td><?php echo $value->amount; ?></td>
              <td><?php echo date("Y-m-d H:i:s", strtotime($value->created_at)); ?></td>
              <td><?php echo ($value->accepted_date != null) ? date("Y-m-d H:i:s", strtotime($value->accepted_date)) : ""; ?></td>
              <td><?php echo  $value->approved_by ?? ""?></td>

        

              <td>
                
                  
                  <form action="<?php echo base_url(route_to('delete-payagent',$value->id ))?>" id="locatindelete" method="post" class="" accept-charset="utf-8" enctype="multipart/form-data">
                                    <?php echo $this->include('common/delete') ?>
                      
                      
                   <?php if ($value->status == 0) : ?>  
                      <?php if ($edit_data == true) : ?>
                        <a href="<?= base_url(route_to( 'edit-payagent',$value->id )) ?>" class="btn btn-sm btn-info text-white" title="<?php echo lang("Localize.edit") ?>" ><i class="fas fa-edit"></i></a>
                      <?php endif ?>
      
                      <?php if ($delete_data == true) : ?>
                        <button type="submit" class="btn btn-sm btn-danger" title="<?php echo lang("Localize.delete") ?>" ><i class="far fa-trash-alt"></i></button>
                      <?php endif ?>

                    <?php endif ?>

                  <?php if ($userType == 1 || $userType == 7) : ?>    
                      <?php if ($value->status == 0) : ?>
                        <?php $status = 1 ;?>
                        <a href="<?= base_url(route_to( 'status-payagent',$value->id,$status,$value->amount,$value->agent_id )) ?>" class="btn btn-sm btn-success text-white" title="<?php echo lang("Localize.active") ?>" ><i class="fas fa-check"></i></a>
                      <?php endif ?>
                      <?php if ($value->status == 1) : ?>
                        <?php $status = 0 ;?>
                        <a href="<?= base_url(route_to( 'status-payagent',$value->id,$status,$value->amount,$value->agent_id )) ?>" class="btn btn-sm btn-dark text-white" title="<?php echo lang("Localize.disable") ?>" ><i class="fas fa-times"></i></a>
                      <?php endif ?>
                  <?php endif ?>

                  </form>
                  
                    
                  
                
              </td>
              
            </tr>
              

          <?php endforeach ?>
          
          
          </tbody>
        </table>
        </div>

    </div>
</div>
<?php echo $this->include('common/datatable_default_lang_change') ?>

<?php echo $this->endSection() ?>