<?php



namespace Modules\Blog\Controllers\Api;



use App\Controllers\BaseController;

use CodeIgniter\API\ResponseTrait;

use Modules\Blog\Models\BlogModel;



class Blog extends BaseController

{

    private $blogModel;

    use ResponseTrait;



    public function __construct()

    {



        $this->blogModel = new BlogModel();

    }



    public function index()

    {



        $blogs = $this->blogModel->findAll();



        if (!empty($blogs)) {



            foreach ($blogs as $key => $value) {

                $value->image = base_url().'/public/'.$value->image;

            }



            $data = [



                'status' => "success",

                'response' => 200,

                'data' => $blogs,

            ];



            return $this->response->setJSON($data);



        } else {



             $data = [

                'message' => "No Data not found.",

				'status' => "failed",

				'response' => 204,

            ];

            return $this->response->setJSON($data);

        }



    }

    public function singleBlog($id)

    {



        $blogs = $this->blogModel->find($id);



        if (!empty($blogs)) {



            $blogs->image = base_url().'/public/'.$blogs->image;



            $data = [



                'status' => "success",

                'response' => 200,

                'data' => $blogs,

            ];



            return $this->response->setJSON($data);



        } else {



            $data = [

                'message' => "No Data not found.",

				'status' => "failed",

				'response' => 204,

            ];

            return $this->response->setJSON($data);

        }



    }
    public function paginatedBlogs()
    {
        $page = $this->request->getGet('page'); // get page from query string
        $perPage = 6; // number of blogs per page

        // Default page is 1 if not provided or invalid
        $page = !empty($page) && is_numeric($page) && $page > 0 ? (int)$page : 1;

        // Use CodeIgniter Model pagination
        $blogs = $this->blogModel->orderBy('id', 'DESC') // optional: order by latest
                                 ->findAll($perPage, ($page - 1) * $perPage);

        $totalBlogs = $this->blogModel->countAllResults();
        $totalPages = ceil($totalBlogs / $perPage);

        if (!empty($blogs)) {
            foreach ($blogs as $key => $value) {
                $value->image = base_url() . '/public/' . $value->image;
            }

            $data = [
                'status' => "success",
                'response' => 200,
                'current_page' => $page,
                'per_page' => $perPage,
                'total_pages' => $totalPages,
                'total_items' => $totalBlogs,
                'data' => $blogs,
            ];

            return $this->response->setJSON($data);
        } else {
            $data = [
                'status' => "failed",
                'response' => 204,
                'message' => "No data found for this page.",
            ];
            return $this->response->setJSON($data);
        }
    }




}

