<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>
    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">

            <?php if ($add_company == true) : ?>
                <div class="text-end">
                    
                    <?php if (true && false) : ?>
                        <?php if (!isset($trash_view)) : ?>
                            <a class="btn btn-warning me-1" href="<?php echo base_url(route_to('trash-index-company')) ?>">
                                <i class="fas fa-trash-restore"></i>
                                <?php echo lang("Localize.view_deleted") ?>
                            </a>
                        <?php else : ?>
                            <a class="btn btn-info me-1" href="<?php echo base_url(route_to('index-company')) ?>">
                                <i class="fas fa-list"></i>
                                <?php echo lang("Localize.view_all") ?>
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>

                    <a class="btn btn-success" href="<?php echo base_url(route_to('new-company')) ?>"><i class="fas fa-user-plus"></i> <?php echo lang("Localize.add_company") ?></a>
                </div>
            <?php endif ?>

            <div class="table-responsive">
                <table class="table display table-bordered table-striped table-hover basic" id="companylist">
                    <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col"><?php echo lang("Localize.name") ?></th>
                            <th scope="col"><?php echo lang("Localize.email") ?></th>
                            <th scope="col"><?php echo lang("Localize.mobile") ?></th>
                            <th scope="col"><?php echo lang("Localize.status") ?></th>
                            <th scope="col"><?php echo lang("Localize.sourceOption") ?></th>
                            <?php if ($role_id == 1) : ?>
                                <th scope="col"><?php echo lang("Localize.action") ?></th>
                            <?php endif ?>
                        </tr>
                    </thead>

                    
                    <tbody>
                        
                    </tbody>
                </table>
            </div>

        </div>
    </div>
    <?php echo $this->include('common/datatable_default_lang_change') ?>
    <?php echo $this->include('common/confirmation-modal') ?>
    
    <!-- CSRF Token for AJAX -->
    <input type="hidden" name="<?php echo csrf_token(); ?>" id="csrf_token" value="<?php echo csrf_hash(); ?>">
    
    <!--model for wallet-->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
</div>

<?php echo $this->endSection() ?>

<?php echo $this->section('js') ?>
<script>
    function waletRec(id,bal){
        $("#hdnid").val(id);
        $("#balSpan").html(bal);
        $("#exampleModal").modal("show");
    }

    function modelClose(){
        $("#exampleModal").modal("hide");
    }
    $(document).ready(function () {
        // Get company name from hidden input or use default
        var companyname = $("#logotext").val() || "<?php echo lang('Localize.company_list'); ?>";
        
        // Check if table exists
        if ($('#companylist').length === 0) {
            console.error("Table #companylist not found!");
            return;
        }
        
        console.log("Initializing DataTable for #companylist");
        console.log("Number of header columns:", $('#companylist thead th').length);

        var table = $('#companylist').DataTable({
            processing: true,
            serverSide: true,
            lengthMenu: [[5, 15, 20, 25, 30, 40, 50, -1], [5, 15, 20, 25, 30, 40, 50, "All"]],
            dom: 'lBfrtip',
            language: {
                search: search,
                lengthMenu: lengthMenu,
                zeroRecords: zeroRecords,
                info: info,
                infoEmpty: infoEmpty,
                infoFiltered: infoFiltered,
                paginate: {
                    first: first,
                    previous: previous,
                    next: next,
                    last: last
                }
            },

            ajax: {
                url: "<?= base_url(route_to('server-company-list')); ?>",
                type: "POST",
                data: function(d) {
                    // Add CSRF token to the request data
                    var csrfToken = $('#csrf_token').val() || $('input[name="<?php echo csrf_token(); ?>"]').val();
                    if (csrfToken) {
                        d.<?php echo csrf_token(); ?> = csrfToken;
                    }
                    return d;
                },
                beforeSend: function(xhr) {
                    // Set CSRF token in header
                    var csrfToken = $('#csrf_token').val() || $('input[name="<?php echo csrf_token(); ?>"]').val();
                    if (csrfToken) {
                        xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken);
                        xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
                    }
                },
                dataSrc: function(json) {
                    console.log("DataTables Response:", json);
                    console.log("Data array:", json.data);
                    if (!json.data || json.data.length === 0) {
                        console.warn("No data in response");
                    }
                    return json.data;
                },
                error: function(xhr, error, code) {
                    console.error("DataTables AJAX Error:", error, code);
                    console.error("Response:", xhr.responseText);
                    if (xhr.status === 403) {
                        alert("CSRF token validation failed. Please refresh the page and try again.");
                    }
                }
            },

            buttons: [
                {
                    extend: 'copy',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5]}
                },
                {
                    extend: 'csv',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5]}
                },
                {
                    extend: 'excel',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5]}
                },
                {
                    extend: 'pdf',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5]}
                },
                {
                    extend: 'print',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5]}
                }
            ],

            columns: [
                { data: "index", orderable: false },
                { data: "name" },
                { data: "login_email" },
                { data: "login_mobile" },
                { data: "status", orderable: false },
                { data: "source_option" }<?php if ($role_id == 1): ?>,
                { data: "action", orderable: false, searchable: false }<?php endif; ?>
            ],

            responsive: true,

            initComplete: function () {
                var api = this.api();
                console.log("DataTables initialized. Columns:", api.columns().count());
                console.log("DataTables data:", api.rows().data().toArray());

                $('.column-search').on('keyup', function () {
                    let colIndex = $(this).data('col');
                    api.column(colIndex).search(this.value).draw();
                });
                
            },
            
            drawCallback: function(settings) {
                console.log("DataTables draw callback fired");
                var api = this.api();
                console.log("Current page data:", api.rows({page: 'current'}).data().toArray());
            }
        });

    });
</script>
    <!--model end-->
<?php echo $this->endSection() ?>
