<?php echo $this->extend('template/admin/main') ?>


<?php echo $this->section('content') ?>

    <style>
        .trip-group {
            display: flex;
            align-items: center;
            font-weight: bold;
            padding: 8px;
            background-color: #f8f9fa;
            border-radius: 5px;
            margin-bottom: 5px;
        }

        .subtrip-container {
            margin-left: 20px;
            padding-left: 10px;
            border-left: 2px solid #ccc;
            max-height: 150px; /* Set a max height for scrolling */
            overflow-y: auto;
        }

        #tripContainer {
            max-height: 300px; /* Set a height for scrolling */
            overflow-y: auto;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            background-color: #fff;
        }

        /* Style checkboxes */
        input[type="checkbox"] {
            margin-right: 8px;
            transform: scale(1.2);
            cursor: pointer;
        }

    </style>
    <?php echo $this->include('common/message') ?>
    
    <div class="card mb-4">
        <div class="card-body">

            <form action="<?php echo base_url(route_to('create-coupon')) ?>" id="couponform" method="post" class="row g-3" accept-charset="utf-8" enctype="multipart/form-data">
                <?php echo $this->include('common/security') ?>
                <div class="row justify-content-center">
                    <div class="col-4">
                        <div class="row">

                            <?php if ($roleId == 1): ?>
                                <div class="col-12 mt-3">
                                    <label for="company_name"><?php echo lang("Localize.select_company") ?><abbr title="Required field">*</abbr></label>
                                    <select name="company[]" id="company" class="form-control" multiple>
                                        <option value="" disabled selected><?php echo lang("Localize.none") ?></option>
                                        <?php foreach ($companies as $companyvalue) : ?>
                                            <option value="<?php echo $companyvalue->id ?>"><?php echo $companyvalue->name ?></option>
                                        <?php endforeach ?>
                                    </select>
                                </div>
                            <?php elseif ($roleId == 7): ?>
                                <input type="hidden" name="company[]" value="<?= $companyId ?>" />
                            <?php endif; ?>

                            <div class="col-12 mt-3">
                                <label class="form-group" for="" style='white-space: nowrap;'>
                                    Select Type
                                    <abbr title="Required field">*</abbr>
                                </label>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="coupon_type" id="online" value="1" checked>
                                    <label class="form-check-label" for="activated">
                                        <?php echo lang("Localize.online") ?>
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="coupon_type" id="offline_agent" value="0">
                                    <label class="form-check-label" for="offline_agent">
                                        <?php echo lang("Localize.offline_agent") ?>
                                    </label>
                                </div>
                            </div>

                            <div class="col-12 mt-3">
                                <label for="code" class=""><?php echo lang("Localize.coupon") ?> <?php echo lang("Localize.code") ?></label>
                                <input type="text" id="code" name="code" class="form-control" required />
                            </div>

                            <div class="col-12 mt-3" id="payment_method">
                                <label for="subtrip_id">
                                    <?php echo lang("Localize.sub") ?> <?php echo lang("Localize.trip") ?>
                                </label>

                                <!-- <select class="form-select" name="subtrip_id" id="subtrip_id">
                                    <option value="">Select a Trip</option>
                                </select> -->
                                
                                <div class="col-12 mt-3" id="tripContainer"></div>
                            </div>


                            <?php if ($roleId == 7): ?>
                                <div class="col-12 mt-3" id="tripContainer">
                                    <?php foreach ($tripGroups as $trip) : ?>
                                        <div class="trip-group">
                                            <label>
                                            <input type="checkbox" class="main-trip" name="main_trips[]" value="<?= $trip->id ?>" data-trip-id="<?= $trip->id ?>" />
                                                <strong><?= $trip->picklocation ?> ➔ <?= $trip->droplocation ?><?php echo "( ". $trip->id. " )" ?></strong>
                                            </label>
                                            <ul>
                                                <?php foreach ($trip->children as $subtrip) : ?>
                                                    <li>
                                                        <input type="checkbox" class="sub-trip" 
                                                            data-parent-id="<?= $trip->id ?>" 
                                                            name="subtrips[<?= $trip->id ?>][]" 
                                                            value="<?= $subtrip->id ?>" />
                                                        <?= $subtrip->picklocation ?> ➔ <?= $subtrip->droplocation ?>
                                                    </li>
                                                <?php endforeach; ?>
                                            </ul>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>

                            <div class="col-12 mt-3">
                                <label for="start_date" class="form-label"><?php echo lang("Localize.start") ?> <?php echo lang("Localize.date") ?> <abbr title="Required field">*</abbr></label>
                                <div class="input-append date datepicker" id="start_date" data-date-format="yyyy-mm-dd">
                                    <input size="16" type="text" name="start_date" class="form-control will-fill-by-plugin" required readonly />
                                    <span class="add-on"><i class="icon-th"></i></span>
                                </div>
                            </div>

                            <div class="col-12 mt-3">
                                <label for="end_date" class="form-label"><?php echo lang("Localize.end") ?> <?php echo lang("Localize.date") ?> <abbr title="Required field">*</abbr></label>
                                <div class="input-append date datepicker" id="end_date" data-date-format="yyyy-mm-dd">
                                    <input size="16" type="text" name="end_date" class="form-control will-fill-by-plugin" required readonly />
                                    <span class="add-on"><i class="icon-th"></i></span>
                                </div>
                            </div>
                            <div class="col-12 mt-3" >
                                <label for="subtrip_id">Discount Type </label>
                                <select class="form-select" name="discount_type" id="discount_type" required onchange="getDiscountType()">
                                   <option>Select</option>
                                   <option value='1'>Amount</option>
                                   <option value='2'>Percent</option>
                                </select>
                            </div>
                            <div class="col-12 mt-3">
                                <label for="discount" class=""><?php echo lang("Localize.discount") ?>    <span id='partype'></span>  <abbr title="Required field">*</abbr></label>
                                <input type="number" id="discount" name="discount" value="<?php echo esc(old('discount')) ?>" class="form-control" placeholder="<?php echo lang("Localize.discount") . " " . lang("Localize.amount") ?>" min="0" required />
                            </div>

                            <div class="col-12 mt-3">
                                <label for="condition" class="form-label"><?php echo lang("Localize.terms_conditions") ?> <abbr title="Required field">*</abbr></label>
                                <textarea class="form-control" name="condition" id="condition" rows="3" required><?php echo old('condition') ?></textarea>
                            </div>

                            <div class="text-danger">
                                <?php if (isset($validation)) : ?>
                                    <?= $validation->listErrors(); ?>
                                <?php endif ?>
                            </div>

                            <div class="col-12 mt-3">
                                <button type="submit" class="btn btn-success"><?php echo lang("Localize.submit") ?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

<?php echo $this->section('js') ?>
    <script src="<?php echo base_url('public/js/jquery.sumoselect.min.js'); ?>"></script>
    <script src="<?php echo base_url('public/js/dynamicinput.js'); ?>"></script>
    <script src="<?php echo base_url('public/plugins/select2/select2.min.js'); ?>"></script>
<?php echo $this->endSection() ?>
<script>
    function getDiscountType() {
        var discountType = document.getElementById('discount_type').value;
        if(discountType == 1){
            $("#partype").html(" Amount");
            $('#discount').attr('placeholder', "Discount Amount");
        }else{
            $("#partype").html(" Percent");
            $('#discount').attr('placeholder', "Discount Percent");
        }
    }

    $(document).ready(function () {
        // Auto-select all sub-trips when main trip is selected
        $(document).on('change', '.main-trip', function () {
            const tripId = $(this).data('trip-id');
            $(`.sub-trip[data-parent-id="${tripId}"]`).prop('checked', $(this).prop('checked'));
        });

        // Check main trip if any sub-trip is selected
        $(document).on('change', '.sub-trip', function () {
            const tripId = $(this).data('parent-id');
            // If at least one sub-trip is checked, check the main trip
            const anySubChecked = $(`.sub-trip[data-parent-id="${tripId}"]:checked`).length > 0;
            $(`.main-trip[data-trip-id="${tripId}"]`).prop('checked', anySubChecked);
        });
    });

</script>
<?php echo $this->endSection() ?>