<?php

$routes->group('modules/backend/terms', ["filter" => "cors", "namespace" => "\Modules\Term\Controllers"], function ($routes) {
    $routes->get('new', 'term::new', ['as' => 'new-term']);
    $routes->post('', 'term::create', ['as' => 'create-term']);
    $routes->get('', 'term::index', ['as' => 'index-term']);
    $routes->get('(:segment)/edit', 'term::edit/$1', ['as' => 'edit-term']);
    
    $routes->put('(:segment)/(:segment)', 'term::update/$1/$2', ['as' => 'update-term']);

    $routes->get('(:segment)/edit/company', 'term::edit_company_term/$1', ['as' => 'edit-company-term']);
    $routes->put('(:segment)/(:segment)/company', 'term::update_company_term/$1/$2', ['as' => 'update-company-term']);
    $routes->get('(:segment)/clear/company', 'term::clear_company_term/$1', ['as' => 'clear-company-term']);
    
    $routes->delete('(:segment)', 'term::delete/$1', ['as' => 'delete-term']);

    $routes->get('trash', 'term::index/1', ['as' => 'trash-index-term']);
    $routes->get('restore/(:segment)', 'term::restore/$1', ['as' => 'restore-term']);

});
