<?php $this->extend('template/admin/main') ?>

<?php $this->section('content') ?>

    <?php echo $this->include('common/message') ?>
    
    <div class="card mb-4">
        <div class="card-body">

            <form action="<?php echo base_url(route_to('create-refund')) ?>" id="refundfrom" method="post" class="row g-3" accept-charset="utf-8" enctype="multipart/form-data">
                <?php echo $this->include('common/security') ?>

                <input type="hidden" name="track_table_id" id="track_table_id" value="<?php echo  $track_table->id; ?>">
                <input type="hidden" name="type" id="type" value="<?php echo $type; ?>">
                <input type="hidden" name="baseurl" id="baseurl" value="<?php echo base_url(); ?>">
                <input type="hidden" name="seatnumbers" id="seatnumbers" value="<?php echo isset($track_table->seatnumber) ? $track_table->seatnumber : ''; ?>">
                <input type="hidden" name="subtripId" id="subtripId" value="<?php echo isset($track_table->subtrip_id) ? $track_table->subtrip_id : ''; ?>">
                <input type="hidden" name="journeydate" id="journeydate" value="<?php echo isset($track_table->journeydata) ? $track_table->journeydata : ''; ?>">


                <div class="row justify-content-center">
                    <div class="col-8">
                        <div class="row">
                            <div class="col-12 mt-3">
                                <label for="booking_id"><?php echo lang("Localize.booking") ?> <?php echo lang("Localize.id") ?></label>
                                <input type="text" name="booking_id" id="booking_id" class="form-control" value="<?php echo $track_table->booking_id; ?>" readonly>
                            </div>

                            <div class="col-12 mt-3">
                                <label for="refund_fee"><?php echo lang("Localize.refund") ?> <?php echo lang("Localize.fee") ?> </label>
                                <input type="text" name="refund_fee" id="refund_fee" class="form-control" value="<?php echo old('refund_fee') ?>" placeholder="<?php echo lang("Localize.refund") ?> <?php echo lang("Localize.fee") ?>">
                            </div>

                            <div class="col-12 mt-3" id="payment_method">
                                <label for="pay_method"><?php echo lang("Localize.payment") ?> <?php echo lang("Localize.type") ?></label>
                                <select class="form-select" name="pay_method" id="pay_method" required>

                                    <?php foreach ($paymethod as $paymethodvalue) : ?>
                                        <option value="<?php echo $paymethodvalue->id ?>"><?php echo $paymethodvalue->name ?></option>
                                    <?php endforeach ?>

                                </select>
                            </div>

                            <div class="col-12 mt-3" id="detailpay">
                                <label for="detail"><?php echo lang("Localize.payment") ?> <?php echo lang("Localize.details") ?></label>
                                <input type="text" name="detail" class="form-control" value="<?php echo old('detail') ?>" placeholder="<?php echo lang("Localize.payment") ?> <?php echo lang("Localize.details") ?>" aria-label="Payment Detail">
                            </div>

                            <div class="col-12 mt-3">
                                <button type="submit" class="btn btn-success"><?php echo lang("Localize.submit") ?></button>
                            </div>
                        </div>

                        <div class="text-danger">
                            <?php if (isset($validation)) : ?>
                                <?= $validation->listErrors(); ?>
                            <?php endif ?>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
<script>
document.addEventListener("DOMContentLoaded", function () {
    const refundForm = document.getElementById("refundfrom");
    const baseUrl = document.getElementById("baseurl").value;
    const seatNumbers = document.getElementById("seatnumbers").value;
    const subtripId = document.getElementById("subtripId").value;
    const journeyDate = document.getElementById("journeydate").value;

    if (seatNumbers && subtripId && journeyDate) {
        let isSubmitting = false;

        refundForm.addEventListener("submit", function (e) {
            // If already submitting, allow normal form submission
            if (isSubmitting) {
                return true;
            }

            e.preventDefault(); // Prevent form submission initially

            // Split seat numbers by comma to handle multiple seats (e.g., "6,9" becomes ["6", "9"])
            const seatArray = seatNumbers.split(',').map(function(seat) {
                return seat.trim();
            }).filter(function(seat) {
                return seat !== '';
            });

            if (seatArray.length === 0) {
                alert("No valid seat numbers found.");
                return;
            }

            // Function to unhold a single seat
            function unholdSeat(seatNumber) {
                return new Promise(function(resolve, reject) {
                    const seatsCheckApiEndpoint = `${baseUrl}/modules/api/v1/tickets/deleteHoldSeat/` + seatNumber;
                    
                    $.ajax({
                        type: 'POST',
                        url: seatsCheckApiEndpoint,
                        dataType: 'json',
                        data: {
                            subtrip_id: subtripId,
                            seat_names: seatNumber,
                            journey_date: journeyDate
                        },
                        success: function (response) {
                            if (response.status === "success") {
                                resolve({ seat: seatNumber, success: true });
                            } else {
                                resolve({ seat: seatNumber, success: false, message: response.message || "Failed to unhold seat" });
                            }
                        },
                        error: function (xhr, status, error) {
                            console.error("Error unholding seat " + seatNumber + ":", error);
                            reject({ seat: seatNumber, error: error });
                        }
                    });
                });
            }

            // Unhold all seats sequentially
            let unholdPromises = [];
            seatArray.forEach(function(seatNumber) {
                unholdPromises.push(unholdSeat(seatNumber));
            });

            // Wait for all seats to be unheld
            Promise.all(unholdPromises)
                .then(function(results) {
                    // Check if all seats were unheld successfully
                    const failedSeats = results.filter(function(result) {
                        return !result.success;
                    });

                    if (failedSeats.length > 0) {
                        const failedSeatNumbers = failedSeats.map(function(r) { return r.seat; }).join(', ');
                        alert("Failed to unhold some seats: " + failedSeatNumbers + ". Please try again.");
                    } else {
                        // All seats unheld successfully, now submit the form
                        isSubmitting = true;
                        refundForm.submit();
                    }
                })
                .catch(function(error) {
                    console.error("Error unholding seats:", error);
                    alert("An error occurred while unholding seats. Please try again.");
                });
        });
    }
});
</script>
<?php $this->endSection() ?>