 <?php echo $this->extend('template/admin/main') ?>

 <?php echo $this->section('css') ?>
    <link rel="stylesheet" href="<?php echo base_url('public/css/customestyle.css'); ?>" type="text/css">
 <?php echo $this->endSection() ?>

 <?php echo $this->section('content') ?>

    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">
            <input type="hidden" id="csrf_token" name="<?php echo csrf_token(); ?>" value="<?php echo csrf_hash(); ?>">

            <div class="table-responsive">
                <table class="table display table-bordered table-striped table-hover basic test"
                       id="ticketbookinglist">
                    <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col"><?php echo lang("Localize.booking") ?> <?php echo lang("Localize.id") ?></th>
                            <th scope="col"><?php echo lang("Localize.company") ?></th>
                            <th scope="col"><?php echo lang("Localize.pick_up") ?> </th>
                            <th scope="col"><?php echo lang("Localize.drop") ?> </th>
                            <th scope="col"><?php echo lang("Localize.seat") ?> <?php echo lang("Localize.number") ?> </th>
                            <th scope="col"><?php echo lang("Localize.pick_up") ?> <?php echo lang("Localize.stand") ?> </th>
                            <th scope="col"><?php echo lang("Localize.drop") ?> <?php echo lang("Localize.stand") ?></th>
                            <th scope="col"><?php echo lang("Localize.passanger") ?> <?php echo lang("Localize.name") ?></th>
                            <th scope="col"><?php echo lang("Localize.payment") ?> <?php echo lang("Localize.status") ?></th>
                            <th scope="col"><?php echo lang("Localize.journey") ?> <?php echo lang("Localize.date") ?> </th>
                            <th scope="col"><?php echo lang("Localize.trip") ?> <?php echo lang("Localize.id") ?> </th>
                            <th scope="col"><?php echo "bookedBy"; ?> </th>
                            <th scope="col"><?php echo lang("Localize.action") ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        
                    </tbody>
                </table>
            </div>

        </div>
    </div>
    <?php echo $this->include('common/datatable_default_lang_change') ?>
 <?php echo $this->endSection() ?>


 <?php echo $this->section('js') ?>
<script>
    $(document).ready(function() {
        // Destroy existing DataTable instance if it exists
        if ($.fn.DataTable.isDataTable('#ticketbookinglist')) {
            $('#ticketbookinglist').DataTable().destroy();
        }

        // Get companyname for export titles
        var companyname = $('#logotext').text().trim() || '<?php echo lang("Localize.company"); ?>';

        // Initialize DataTables with server-side processing
        $('#ticketbookinglist').DataTable({
            processing: true,
            serverSide: true,
            order: [[0, 'desc']], // This will be handled by server-side (tickets.id DESC)
            lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            pageLength: 50,
            language: {
                lengthMenu: lengthMenu,
                zeroRecords: zeroRecords,
                info: info,
                infoEmpty: infoEmpty,
                infoFiltered: infoFiltered,
                search: search,
                paginate: {
                    first: first,
                    previous: previous,
                    next: next,
                    last: last
                }
            },
            ajax: {
                url: "<?= base_url(route_to('server-list-ticket')); ?>",
                type: "POST",
                data: function(d) {
                    // Add CSRF token to the request data
                    var csrfToken = $('#csrf_token').val() || $('input[name="<?php echo csrf_token(); ?>"]').val();
                    if (csrfToken) {
                        d.<?php echo csrf_token(); ?> = csrfToken;
                    }
                    return d;
                },
                beforeSend: function(xhr) {
                    // Set CSRF token in header
                    var csrfToken = $('#csrf_token').val() || $('input[name="<?php echo csrf_token(); ?>"]').val();
                    if (csrfToken) {
                        xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken);
                        xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
                    }
                },
                dataSrc: 'data',
                error: function(xhr, error, code) {
                    console.error("DataTables AJAX Error:", error, code);
                    console.error("Response:", xhr.responseText);
                    if (xhr.status === 403) {
                        alert("CSRF token validation failed. Please refresh the page and try again.");
                    }
                }
            },
            buttons: [
                {
                    extend: 'copy',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5,6,7,8,9,10,11,12]}
                },
                {
                    extend: 'csv',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5,6,7,8,9,10,11,12]}
                },
                {
                    extend: 'excel',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5,6,7,8,9,10,11,12]}
                },
                {
                    extend: 'pdf',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5,6,7,8,9,10,11,12]}
                },
                {
                    extend: 'print',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5,6,7,8,9,10,11,12]}
                }
            ],
            columns: [
                { data: "index", orderable: false },
                { data: "booking_id" },
                { data: "company_name" },
                { data: "pick_location" },
                { data: "drop_location" },
                { data: "seatnumber" },
                { data: "pick_stand", orderable: false, searchable: false },
                { data: "drop_stand", orderable: false, searchable: false },
                { data: "passengerName" },
                { data: "payment_status", orderable: false },
                { data: "journeydata" },
                { data: "trip_id" },
                { data: "booked_by", orderable: false },
                { data: "action", orderable: false, searchable: false }
            ],
            responsive: true,
            dom: 'Bfrtip',
            initComplete: function () {
                var api = this.api();
                console.log("Ticket DataTables initialized. Columns:", api.columns().count());
            },
            drawCallback: function(settings) {
                console.log("Ticket DataTables draw callback fired");
            }
        });

    });
</script>
 <?php echo $this->endSection() ?>