<?php



namespace Modules\Trip\Controllers\Api;







use App\Controllers\BaseController;

use Modules\Trip\Models\TripModel;

use Modules\Trip\Models\StuffassignModel;

use Modules\Trip\Models\SubtripModel;

use Modules\Trip\Models\PickdropModel;

use Modules\Location\Models\LocationModel;

use Modules\Employee\Models\EmployeeModel;

use Modules\Fleet\Models\FleetModel;

use Modules\Fleet\Models\VehicleModel;

use Modules\Schedule\Models\ScheduleModel;

use CodeIgniter\API\ResponseTrait;

use CodeIgniter\Database\RawSql;

use Modules\Rating\Models\RatingModel;

use Modules\Cancellation\Models\CancellationModel;



use Modules\Ticket\Models\TicketModel;

use Modules\Offer\Models\OfferModel;

use Modules\Page\Models\PrivacyModel;
use Modules\Page\Models\TermsModel;
use Modules\Trip\Models\RoundtripdiscoundModel;




class Trip extends BaseController

{

    use ResponseTrait;



    protected $Viewpath;

    protected $tripModel;

    protected $subtripModel;

    protected $stuffassignModel;

    protected $locationModel;

    protected $employeeModel;

    protected $fleetTypeModel;

    protected $scheduleeModel;

    protected $vehicleModel;

    protected $pickdropModel;

    protected $db;

    protected $ratingModel;

    protected $ticketModel;

    protected $cancellationModel;

    protected $picdropModel;

    protected $offerModel;

    protected $privacyModel;

    protected $termsModel;
    
    protected $roundtripdiscoundModel;



    public function __construct()

    {

        $this->Viewpath = "Modules\Trip\Views";

        $this->tripModel = new TripModel();

        $this->subtripModel = new SubtripModel();

        $this->stuffassignModel = new StuffassignModel();

        $this->locationModel = new LocationModel();

        $this->employeeModel = new EmployeeModel();

        $this->fleetTypeModel = new FleetModel();

        $this->vehicleModel = new VehicleModel();

        $this->scheduleeModel = new ScheduleModel();

        $this->pickdropModel = new PickdropModel();

        $this->picdropModel = new PickdropModel();

        $this->db = \Config\Database::connect();



        $this->ratingModel = new RatingModel();

        $this->ticketModel = new TicketModel();

        $this->offerModel = new OfferModel();

        $this->privacyModel = new PrivacyModel();

        $this->cancellationModel = new CancellationModel();

        $this->termsModel = new TermsModel();
        
        $this->roundtripdiscoundModel = new RoundtripdiscoundModel();   

    }



    public function test()

    {

        echo "helo";

    }



    public function getAllTrip()

    {

        $fleet_id         = $this->request->getVar('fleet_id');

        $pick_location_id = $this->request->getVar('pick_location_id');

        $drop_location_id = $this->request->getVar('drop_location_id');

        $journey_date     = $this->request->getVar('journeydate');

        $offer = $this->request->getVar('offer')??"";

        $discountAmount = 0;
        $discountPercent = 0;
        $offerSeatClasses = [];



        if($offer != ""){
            
            $offers = $this->offerModel->where('code', $offer)
                                        // ->where('start_date <=', date('Y-m-d'))
                                        // ->where('end_date >=', date('Y-m-d'))
                                        ->first();
            if(isset($offers) && !empty($offers)){
                $offerSeatClasses = !empty($offers->seat_class) ? json_decode($offers->seat_class, true) : [];
            
                if (is_array($offerSeatClasses)) {
                    $offerSeatClasses = array_map('strval', $offerSeatClasses);
                } else {
                    $offerSeatClasses = [];
                }
                if ($offers->discount_type == 1) {
                    $discountAmount = (float) $offers->discount;
                } elseif ($offers->discount_type == 2) {
                    $discountPercent = (float) $offers->discount;
                }
            }

        }




        $journeyDate = date('Y-m-d', strtotime($journey_date));

        $journeyDayOfWeek = date('N', strtotime($journey_date));

        $maxBookDay = date('Y-m-d', strtotime('+1 month'));



        if (empty($pick_location_id)) {

            $data = [

                'message' => "Please pick a location",

                'status' => "failed",

                'response' => 204,

            ];

            return $this->response->setJSON($data);

        }



        if (empty($drop_location_id)) {

            $data = [

                'message' => "Please pick a droping point",

                'status' => "failed",

                'response' => 204,

            ];

            return $this->response->setJSON($data);

        }



        if (empty($journey_date)) {

            $data = [

                'message' => "Please select your journey date",

                'status' => "failed",

                'response' => 204,

            ];

            return $this->response->setJSON($data);

        }



        if (strtotime(date('Y-m-d')) > strtotime($journey_date)) {

            $data = [

                'message' => "No Past Data allow",

                'status' => "failed",

                'response' => 204,

            ];



            return $this->response->setJSON($data);

        }



        if (strtotime($journey_date) > strtotime($maxBookDay)) {

            $data = [

                'message' => "No advance booking for this day",

                'status' => "failed",

                'response' => 204,

            ];

            return $this->response->setJSON($data);

        }



        // bind search query

        $main_privacy_policy = $this->termsModel->first();

        $this->subtripModel

            ->select('trips.id as tripid, trips.*, fleets.*, schedules.*, vehicles.*, subtrips.id as subtripId, subtrips.*, companies.name as companyName,companies.id as companyId, companies.logo as company_logo, company_terms.description as privacy_policy, trip_category.name as trip_category, trip_bus_types.name as trip_bus_types, GROUP_CONCAT(fleetimages.img_path) as bus_images')



            ->join('trips', 'trips.id = subtrips.trip_id')

            ->join('fleets', 'fleets.id = trips.fleet_id',"left")

            ->join('fleetimages', 'fleets.id = fleetimages.fleet_id',"left")

            ->join('schedules', 'schedules.id = trips.schedule_id',"left")

            ->join('vehicles', 'vehicles.id = trips.vehicle_id',"left")

            ->join('companies', 'trips.company_id = companies.id', 'left')

            ->join('company_terms', 'company_terms.company_id = companies.id', 'left')

            ->join('trip_category', 'trip_category.id = trips.trip_category_id', 'left')

            ->join('trip_bus_types', 'trip_bus_types.id = trips.trip_bus_type_id', 'left')

            ->join('vehicalimages', 'vehicalimages.vehicle_id = vehicles.id',"left")



            ->groupStart()

                ->groupStart()

                    ->where('subtrips.pick_location_id', $pick_location_id)

                    ->where('subtrips.drop_location_id', $drop_location_id)

                ->groupEnd()



                ->orGroupStart()

                    ->whereIn('subtrips.trip_id', function ($subQuery) use ($pick_location_id, $drop_location_id) {

                        $subQuery

                            ->select('sm.trip_id')

                            ->from('subtrips sm')

                            ->where('sm.pick_location_id', $pick_location_id)

                            ->where('sm.drop_location_id', $drop_location_id)

                            ->where('sm.type', 'subtrip');

                    })

                    ->where('subtrips.type', 'main')

                ->groupEnd()

            ->groupEnd()



            ->where('subtrips.status', 1)

            ->where('trips.status', 1)

            ->groupBy('subtrips.id')

            ->orderBy('subtrips.id', 'DESC');



        $this->db->transStart();

        $classDataRaw = $this->db->table('seat_class')

        ->get()

        ->getResult();

        $this->db->transComplete();

        $classData = [];

        foreach ($classDataRaw as $class) {

            $classData[$class->id] = $class;

        }
        $economy = new \stdClass();
        $economy->id = 999;
        $economy->name = "Economy class";
        
        $classData[999] = $economy;


        $fleet_id && $this->subtripModel->where('trips.fleet_id', $fleet_id);

        $allSubTrips =  $this->subtripModel->findAll();

        $data = array('trips' => [], 'in_holiday' => [], 'to_open' => [], 'inactive' => [], 'you_may_like' => []);



        foreach ($allSubTrips as $subTrip) {

            // build rating for trip

            $totalRating = $this->ratingModel

                ->select('COUNT(*) AS t_rat, SUM(rating) AS s_rat, AVG(rating) AS avg_rat')

                ->where('subtrip_id', $subTrip->subtripId)

                ->where('status', 1)

                ->first();

            // $stoppages = $this->locationModel

            //                     ->select('id, name')

            //                     ->whereIn('id', array_filter(explode(',', $subTrip->stoppage)))
            //                     ->whereNotIn('id', [$drop_location_id, $pick_location_id])
            //                     ->findAll();
                                
            $stoppages = $this->locationModel
                            ->select('id, name')
                            ->whereIn('id', array_filter(explode(',', $subTrip->stoppage)))
                            ->whereNotIn('id', [$drop_location_id, $pick_location_id])
                            ->findAll();


            $subTrip->stoppage_stand = array_column($stoppages, 'name', 'id');
            
            $roundtripDiscount = $this->roundtripdiscoundModel
                ->where('status', 1)
                ->where('company_id', $subTrip->companyId)
                ->first();
            
            // Add roundTripDiscount key to trip data
            $subTrip->roundTripDiscount = !empty($roundtripDiscount) ? (float) $roundtripDiscount->discountrate : 0;

            $cancelation_policy = $this->cancellationModel

                                ->select('hours, charges')

                                ->where('company_id', $subTrip->companyId)

                                ->findAll();
            $subtripSeatclass = json_decode($subTrip->subtrip_seatclass, true);

            $subtripSeatclass[] = [
                "seatClass" => "999",
                "seatNo" => [],
                "fare" => $subTrip->adult_fair
            ];
            
            // Encode back if needed
            $subTrip->subtrip_seatclass = json_encode($subtripSeatclass);

            $subtripSeatClassArray = json_decode($subTrip->subtrip_seatclass, true);

            $seatClassDetails = [];



            if (!empty($subTrip->subtrip_seatclass) && is_string($subTrip->subtrip_seatclass)) {

                $subtripSeatClassArray = json_decode($subTrip->subtrip_seatclass, true);


                if (json_last_error() === JSON_ERROR_NONE && is_array($subtripSeatClassArray)) {

                    foreach ($subtripSeatClassArray as $item) {
                        
                        $currentSeatClassId = isset($item['seatClass']) ? (string) $item['seatClass'] : '';
                        
                        $shouldApplyDiscount = false;
                        if($offer != ""){
                            
                            if (empty($offerSeatClasses) || in_array($currentSeatClassId, $offerSeatClasses)) {
                                $shouldApplyDiscount = true;
                            }
                        }

                        if($offer != "" && $shouldApplyDiscount){

                            if($discountAmount !=  0){
                                    $seatClassDetails[] = [

                                    'seatClass' => $item['seatClass'] ?$classData[$item['seatClass']]->name :'',

                                    'seatClassId' => $item['seatClass'] ?? '',

                                    'fare'      => $item['fare'] ?? '',

                                    'discountAmount' => $discountAmount,

                                    'FinalFare' => $discountAmount ? max(0, $item['fare'] - $discountAmount) : $item['fare'],


                                ];

                            }else if ($discountPercent != 0) {

                                // $discountAmount = ($item['fare'] ?? 0) * ($discountPercent / 100);

                                // // Calculate final fare ensuring it doesn't go below 0
                                // $finalFare = max(0, ($item['fare'] ?? 0) - $discountAmount);

                                $seatClassDetails[] = [
                                    'seatClass'      => $item['seatClass'] ? $classData[$item['seatClass']]->name : '',
                                    'seatClassId'    => $item['seatClass'] ?? '',
                                    'fare'           => $item['fare'] ?? 0,
                                    'discountAmount' => round($item['fare'] && $discountPercent ? ($item['fare'] * $discountPercent) / 100 : 0, 2),
                                    'FinalFare'      => round(max(0, ($item['fare'] ?? 0) - ($item['fare'] && $discountPercent ? ($item['fare'] * $discountPercent) / 100 : 0)), 2),

                                ];
                            }else{
                                $seatClassDetails[] = [

                                'seatClass' => $item['seatClass'] ?$classData[$item['seatClass']]->name :'',

                                'seatClassId' => $item['seatClass'] ?? '',

                                'fare'      => $item['fare'] ?? '',

                                'discountAmount' => 0,

                                'FinalFare'      => $item['fare'] ?? '',

                                ];

                            }
                            

                        }else{

                            $seatClassDetails[] = [

                                'seatClass' => $item['seatClass'] ?$classData[$item['seatClass']]->name :'',

                                'seatClassId' => $item['seatClass'] ?? '',

                                'fare'      => $item['fare'] ?? '',

                                'discountAmount' => 0,

                                'FinalFare'      => $item['fare'] ?? '',

                            ];

                        }

                    }

                }

            }





            $subTrip->seatclass_price = $seatClassDetails;



            

            $facilityIds = array_filter(explode(',', $subTrip->facility ?? ''));



            $facilitys = [];



            if (!empty($facilityIds)) {

                $this->db->transStart();

                $facilitys = $this->db->table('facilitys')

                    ->whereIn('id', $facilityIds)

                    ->get()

                    ->getResult();

                $this->db->transComplete();

            }



            

            $subTrip->facility = implode(",", array_column($facilitys, 'name', 'id'));



            $subTrip->cancelation_policy = array_map(function ($row) {

                                                return [

                                                    'charges' => $row->charges,

                                                    'hours'   => $row->hours,

                                                ];

                                            }, $cancelation_policy);

            // $subTrip->cancelation_policy = array_column($cancelation_policy, 'hours', 'charges');





            $totalRating = $this->ratingModel

                ->select('COUNT(*) AS t_rat, SUM(rating) AS s_rat, AVG(rating) AS avg_rat')

                ->where('subtrip_id', $subTrip->subtripId)

                ->where('status', 1)

                ->first();



            $subTrip->rating = number_format($totalRating->avg_rat, 1);



            // build booked seats

            $bookedTickets = $this->ticketModel

                ->select(new RawSql('SUM(LENGTH(seatnumber) - LENGTH(REPLACE(seatnumber, ",", "")) + 1) s_length'))

                ->where('journeydata', $journey_date)

                ->where('cancel_status', 0);



            if ($subTrip->type == 'subtrip') {

                $mainTripId = $subTrip->trip_id;

                $subtripStoppagePointsArr = array_filter(explode(',', $subTrip->stoppage));

                $mainTraipMainSubtripId = $this->subtripModel->where('trip_id', $mainTripId)->where('type', 'main')->first();

                $this->ticketModel

                    ->groupStart()

                        ->whereIn('tickets.subtrip_id', [$subTrip->id ?? "", $mainTraipMainSubtripId->id ?? ""])



                        ->orGroupStart()

                            ->where('trip_id', $subTrip->trip_id)

                            ->whereIn('pick_location_id', array_filter($subtripStoppagePointsArr, fn ($stp_id) => $stp_id != $subTrip->drop_location_id))

                        ->groupEnd()



                        ->orGroupStart()

                            ->where('trip_id', $subTrip->trip_id)

                            ->whereIn('drop_location_id', array_filter($subtripStoppagePointsArr, fn ($stp_id) => $stp_id != $subTrip->pick_location_id))

                        ->groupEnd()

                    ->groupEnd();

            } else {

                $this->ticketModel->where('trip_id', $subTrip->trip_id);

            }



            $bookedTickets = $this->ticketModel->first();



            $totalBoking = (int) $bookedTickets->s_length;

            $subTrip->totalbooking = $totalBoking;

            // $subTrip->available_seat = (int) $subTrip->total_seat + (int) $subTrip->last_seat - $totalBoking;

            $subTrip->available_seat = (int) $subTrip->total_seat - $totalBoking;



            $pickup_time = null;

            $drop_time = null;

            $pickup_list = [];

            $drop_list   = [];



            $pickdrop = $this->pickdropModel->select('pickdrops.id as pickdropid,pickdrops.*,stands.*')

                ->join('stands', 'stands.id = pickdrops.stand_id')

                ->where('trip_id', $subTrip->id)
                
                ->orderBy('pickdrops.id','ASC')

                ->findAll();

            if(empty($pickdrop)){

                $pickdrop = $this->pickdropModel->select('pickdrops.id as pickdropid,pickdrops.*,stands.*')

                    ->join('stands', 'stands.id = pickdrops.stand_id')

                    ->where('trip_id', $subTrip->trip_id)
                    
                    ->orderBy('pickdrops.id','ASC')

                    ->findAll();

            }

            // print_r($pickdrop);

            foreach ($pickdrop as $item) {

                if ($item->type == 1) {

                    // Smallest pickup time

                    $pickup_list[] = [

                        'id' => $item->id,

                        'time' => $item->time,

                        'place' => $item->name,

                        'pickid' => $item->pickdropid,

                    ];

                    if (is_null($pickup_time) || strtotime($item->time) < strtotime($pickup_time)) {

                        $pickup_time = $item->time;

                    }

                } elseif ($item->type == 0) {

                    // Largest drop time

                    $drop_list[] = [

                        'id' => $item->id,

                        'time' => $item->time,

                        'place' => $item->name,

                        'dropid' => $item->pickdropid,

                    ];

                    if (is_null($drop_time) || strtotime($item->time) > strtotime($drop_time)) {

                        $drop_time = $item->time;

                    }

                }

            }

            $journeyDateTime = new \DateTime("$journeyDate $drop_time");

            $nowPlusTwoHours = new \DateTime();

            $nowPlusTwoHours->modify('+2 hours');

            if ($nowPlusTwoHours > $journeyDateTime) {

                $data['in_holiday'][] = $subTrip;

                continue;

            }





            if ($subTrip->status == 0) {

                // subtrip is inactive

                $data['inactive'][] = $subTrip;

                continue;

            }

            $subTripStartTime = $subTrip->start_time; // e.g. "14:30:00"

            $DelayedjourneyDateTime = new \DateTime($journeyDate . " " . $subTripStartTime);

            $now = new \DateTime(); // or set a specific value for testing

            $futureNow = (clone $now)->add(new \DateInterval("PT2H")); 

            if ($DelayedjourneyDateTime < $futureNow) {

                $data['inactive'][] = $subTrip;

                continue;

            }



            if (strtotime($journeyDate) < strtotime($subTrip->startdate)) {

                // subtrip yet not begin

                $data['to_open'][] = $subTrip;

                continue;

            }



            $cleanedoffdates = preg_replace('/\s+/', '', $subTrip->offdates);

            if (in_array($journeyDate,explode(",", $cleanedoffdates))) {

                // subtrip is off today

                $data['in_holiday'][] = $subTrip;

                continue;

            }

            if ($this->isDateInRange($journeyDate, $subTrip->startdateinrange, $subTrip->enddateinrange)) {

                // subtrip is not in range

                $data['in_holiday'][] = $subTrip;

                continue;

            }

            $offdateranges = json_decode($subTrip->offdateranges, true);

            $isInAnyRange = false;

            if (is_array($offdateranges) && !empty($offdateranges)) {

                foreach ($offdateranges as $range) {

                    $start = $range['start'] ?? null;

                    $end = $range['end'] ?? null;



                    if ($start && $end && $this->isDateInRange($journeyDate, $start, $end)) {

                        $isInAnyRange = true;

                        break;

                    }

                }

            }



            if ($isInAnyRange) {

                $data['in_holiday'][] = $subTrip;

                continue;

            }

            if (!$this->isDateInRange($journeyDate, $subTrip->repetedstartdate, $subTrip->repetedenddate)) {

                if($journeyDate != date('Y-m-d',strtotime($subTrip->startdate))){

                    //start date and not between start and edn date

                    $data['in_holiday'][] = $subTrip;

                    continue;    

                }

                

            }



            if (@in_array($journeyDayOfWeek, explode(',', $subTrip->weekend))) {

                // subtrip is on holiday

                $data['in_holiday'][] = $subTrip;

                continue;

            }



            if (($subTrip->pick_location_id != $pick_location_id) || ($subTrip->drop_location_id != $drop_location_id)) {

                // subtrip is related to selected locations

                $data['you_may_like'][] = $subTrip;

                continue;

            }

            $subTrip->privacy_policy = !empty($subTrip->privacy_policy) ? strip_tags($subTrip->privacy_policy) : "";

            $subTrip->pickup_points = $pickup_list;

            $subTrip->drop_points   = $drop_list;



            $subTrip->company_logo = !empty($subTrip->company_logo) ? "https://data.busvalley.com/busvalley_new/public/".$subTrip->company_logo : "";

            $subTrip->privacy_policy = !empty($subTrip->privacy_policy) ? strip_tags($subTrip->privacy_policy) : "";

            if (!empty($subTrip->bus_images)) {

                $pics = explode(',', $subTrip->bus_images);

                $subTrip->bus_images = array_map(function($pic) {

                    return "https://data.busvalley.com/busvalley_new/public/" . trim($pic);

                }, $pics);

            } else {

                $subTrip->bus_images = [];

            }
            
            $subTrip->main_privacy_policy = $main_privacy_policy ?? "";
            $data['trips'][] = $subTrip;

        }



        if (!count($data['trips']) && !count($data['you_may_like'])) {

            if (count($data['in_holiday'])) {

                return $this->response->setJSON([

                    'message' => "Holiday for all trips! No trip found.",

                    'status' => "failed",

                    'response' => 204,

                ]);

            }



            if (count($data['to_open'])) {

                return $this->response->setJSON([

                    'message' => "Trips yet not started! No trip found.",

                    'status' => "failed",

                    'response' => 204,

                ]);

            }



            return $this->response->setJSON([

                'message' => "No trip found for this route!",

                'status' => "failed",

                'response' => 204,

            ]);

        }


        return $this->response->setJSON([

            'status' => "success",

            'response' => 200,

            'data' => $data['trips'],

            'suggestions' => $data['you_may_like']

        ]);

    }



    public function showsubtrip()

    {

        $url = base_url();

        $allFronSubTrip =  $this->subtripModel->select('trips.id as tripid,trips.*,schedules.*,subtrips.id as subtripId,subtrips.*')

            ->join('trips', 'trips.id = subtrips.trip_id')

            ->join('schedules', 'schedules.id = trips.schedule_id')

            ->where('subtrips.status', 1)

            ->where('subtrips.show', 1)

            ->findAll();



        if ($allFronSubTrip) {

            foreach ($allFronSubTrip as $key => $value) {

                $value->imglocation = $url . '/public/' . $value->imglocation;

            }



            $data = [

                'status' => "success",

                'response' => 200,

                'data' => $allFronSubTrip,

            ];



            return $this->response->setJSON($data);

        } else {

            $data = [

                'message' => "No trip found for this location",

                'status' => "failed",

                'response' => 204,

            ];



            return $this->response->setJSON($data);

        }

    }



    public function boarding($id)

    {

        $boarding =  $this->pickdropModel->where('type', 1)->where('trip_id', $id)->findAll();



        if ($boarding) {



            $data = [

                'status' => "success",

                'response' => 200,

                'data' => $boarding,

            ];



            return $this->response->setJSON($data);

        } else {

            $data = [

                'message' => "No Boarding Pint Found",

                'status' => "failed",

                'response' => 204,

            ];



            return $this->response->setJSON($data);

        }

    }



    public function dropping($id)

    {

        $boarding =  $this->pickdropModel->where('type', 0)->where('trip_id', $id)->findAll();



        if ($boarding) {



            $data = [

                'status' => "success",

                'response' => 200,

                'data' => $boarding,

            ];



            return $this->response->setJSON($data);

        } else {

            $data = [

                'message' => "No Dropping Pint Found",

                'status' => "failed",

                'response' => 204,

            ];



            return $this->response->setJSON($data);

        }

    }

    public function getClassName($id){

        $this->db->transStart();

        $classData = $this->db->table('seat_class')

        ->get()

        ->getResult();

        $this->db->transComplete();



        $data = [

            'status' => "success",

            'response' => 200,

            'data' => $classData,

        ];

        return $this->response->setJSON($data);

    }

    public function isDateInRange($dateToCheck, $startDate, $endDate) {

        // Convert dates to DateTime objects

        $date       = new \DateTime($dateToCheck);

        $start      = new \DateTime($startDate);

        $end        = new \DateTime($endDate);



        // Check if the date is in the range

        return ($date >= $start && $date <= $end);

    }

}

