<?php

namespace Modules\Ticket\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use Modules\Employee\Models\EmployeeModel;
use Modules\Fleet\Models\FleetModel;
use Modules\Fleet\Models\VehicleModel;
use Modules\Location\Models\LocationModel;
use Modules\Location\Models\StandModel;
use Modules\Paymethod\Models\PaymethodModel;
use Modules\Schedule\Models\ScheduleModel;
use Modules\Tax\Models\TaxModel;
use Modules\Ticket\Models\JourneylistModel;
use Modules\Ticket\Models\PartialpaidModel;
use Modules\Ticket\Models\TicketModel;
use Modules\Ticket\Models\PretripModel;
use Modules\Ticket\Models\MaxtimeModel;
use Modules\Trip\Models\FacilityModel;
use Modules\Trip\Models\PickdropModel;
use Modules\Trip\Models\StuffassignModel;
use Modules\Trip\Models\SubtripModel;
use Modules\Trip\Models\TripModel;
use Modules\User\Models\UserDetailModel;
use Modules\User\Models\UserModel;
use Modules\Role\Models\RoleModel;
use Modules\Agent\Models\AgentModel;
use Modules\Agent\Models\Agentcommission;
use Modules\Website\Models\WebsettingModel;
use Modules\Coupon\Models\CoupondiscountModel;
use Modules\Coupon\Models\CouponModel;
use Modules\Trip\Models\RoundtripdiscoundModel;
use Modules\Company\Models\CompanyModel;
use Modules\Ticket\Models\TemporaryBook;
use PhpParser\Node\Expr\Cast\Double;
use Modules\HoldSeat\Models\HoldSeatModel;
use Modules\Account\Models\PayagentModel;
use Modules\Ticket\Models\TemporaryBook as TemporaryBookModel;


use App\Libraries\Rolepermission;

use App\Libraries\Ticketmail;
use CodeIgniter\Database\RawSql;
use Exception;

class Ticket extends BaseController
{
    use ResponseTrait;

    protected $Viewpath;
    protected $ticketModel;
    protected $pretripModel;
    protected $tripModel;
    protected $subtripModel;
    protected $stuffassignModel;
    protected $locationModel;
    protected $employeeModel;
    protected $fleetTypeModel;
    protected $scheduleeModel;
    protected $vehicleModel;
    protected $standModel;
    protected $picdropModel;
    protected $facilitypModel;
    protected $taxModel;
    protected $db;
    protected $paymethodModel;
    protected $userModel;
    protected $userDetailModel;
    protected $journeylistModel;
    protected $partialpaidModel;
    protected $maxtimeModel;
    protected $roleModel;
    protected $agentModel;
    protected $agentCommissionModel;

    protected $websettingModel;
    protected $couponModel;
    protected $coupondiscountModel;

    protected $roundtripdiscoundModel;
    protected $CompanyModel;

    protected $TemporaryBook;
    protected $holdSeatModel;
    protected $agentPayment;
    protected $temporaryBookModel;

    public function __construct()
    {

        $this->Viewpath = "Modules\Ticket\Views";
        $this->ticketModel = new TicketModel();
        $this->pretripModel = new PretripModel();
        $this->tripModel = new TripModel();
        $this->subtripModel = new SubtripModel();
        $this->stuffassignModel = new StuffassignModel();
        $this->locationModel = new LocationModel();
        $this->employeeModel = new EmployeeModel();
        $this->fleetTypeModel = new FleetModel();
        $this->vehicleModel = new VehicleModel();
        $this->scheduleeModel = new ScheduleModel();
        $this->standModel = new StandModel();
        $this->picdropModel = new PickdropModel();
        $this->facilitypModel = new FacilityModel();
        $this->taxModel = new TaxModel();
        $this->db = \Config\Database::connect();
        $this->paymethodModel = new PaymethodModel();

        $this->userModel = new UserModel();
        $this->userDetailModel = new UserDetailModel();

        $this->journeylistModel = new JourneylistModel();
        $this->partialpaidModel = new PartialpaidModel();

        $this->maxtimeModel = new MaxtimeModel();
        $this->roleModel = new RoleModel();

        $this->agentModel = new AgentModel();
        $this->agentCommissionModel = new Agentcommission();

        $this->websettingModel = new WebsettingModel();

        $this->coupondiscountModel = new CoupondiscountModel();
        $this->couponModel = new CouponModel();

        $this->roundtripdiscoundModel = new RoundtripdiscoundModel();
        $this->CompanyModel = new CompanyModel();
        $this->TemporaryBook = new TemporaryBook();
        $this->holdSeatModel = new HoldSeatModel();
        $this->agentPayment = new PayagentModel();
        $this->temporaryBookModel = new TemporaryBookModel;
    }

    function new()
    {

        $this->session->remove('pick_location_id');
        $this->session->remove('drop_location_id');
        $this->session->remove('filterjourneydate');
        $this->session->remove('filterreturndate');
        $this->session->remove('fleet_id');

        $this->session->remove('subtripId');
        $this->session->remove('seatnumbers');
        $this->session->remove('totalseat');
        $this->session->remove('journeydate');
        $this->session->remove('aseat');
        $this->session->remove('spseat');
        $this->session->remove('vpseat');
        $this->session->remove('cseat');
        $this->session->remove('totalprice');
        $this->session->remove('tax');
        $this->session->remove('grandtotal');
        $this->session->remove('pickstand');
        $this->session->remove('dropstand');
        $this->session->remove('isrountrip');
        $this->session->remove('discountPercent');
        $this->session->remove('roundtrip_discount');

        $data['pick_location_id'] = null;
        $data['drop_location_id'] = null;
        $data['filterjourneydate'] = null;
        $data['filterreturndate'] = null;
        $data['fleet_id'] = null;

        $data['filterpath'] = $this->Viewpath;
        $data['location'] = $this->locationModel->findAll();
        $data['fleet_type'] = $this->fleetTypeModel->findAll();

        $data['module'] =    lang("Localize.ticket_booking");
        $data['title']  =    lang("Localize.book_ticket");

        $heading = lang("Localize.search") . ' ' . lang("Localize.ticket");
        $data['pageheading'] = $heading;

        $data['company_id'] = 0;
        $data['companies'] = $this->CompanyModel->findAll();

        echo view($this->Viewpath . '\ticket/new', $data);
    }

    public function findtrip()
    {
        $t = $this->request->getVar();
        $websetting = $this->websettingModel->first();

        // Get request vars
        $pick_location_id  = $this->request->getVar('pick_location_id') ?: session('pick_location_id');
        $drop_location_id  = $this->request->getVar('drop_location_id') ?: session('drop_location_id');
        $filterjourneydate = $this->request->getVar('filterjourneydate') ?: session('filterjourneydate');
        $filterreturndate  = $this->request->getVar('filterreturndate') ?: session('filterreturndate');
        $fleet_id          = $this->request->getVar('fleet_id') ?: session('fleet_id');
        
        $company_id = session()->get('company_id') ?? 0;
        if(($this->request->getVar('company_id') || $this->request->getVar('company_id') == 0) && session()->get('role_id') == "1"){
            $company_id = $this->request->getVar('company_id') ?? 0;
        } else {
            if(session('search_company_id')){
                $company_id = session('search_company_id');
            }
        }
        // 
        $journeyDate = date('Y-m-d', strtotime($filterjourneydate));
        $journeyDayOfWeek = date('N', strtotime($filterjourneydate));

        $this->session->remove('pick_location_id');
        $this->session->remove('drop_location_id');
        $this->session->remove('filterjourneydate');
        $this->session->remove('filterreturndate');
        $this->session->remove('fleet_id');

        $this->session->remove('subtripId');
        $this->session->remove('seatnumbers');
        $this->session->remove('totalseat');
        $this->session->remove('journeydate');
        $this->session->remove('aseat');
        $this->session->remove('spseat');
        $this->session->remove('vpseat');
        $this->session->remove('cseat');
        $this->session->remove('totalprice');
        $this->session->remove('tax');
        $this->session->remove('grandtotal');
        $this->session->remove('pickstand');
        $this->session->remove('dropstand');
        $this->session->remove('isrountrip');
        $this->session->remove('discountPercent');
        $this->session->remove('roundtrip_discount');
        $this->session->remove('search_company_id');

        $tripData['pick_location_id'] =  $pick_location_id;
        $tripData['drop_location_id'] = $drop_location_id;
        $tripData['filterjourneydate'] =  $filterjourneydate;
        $tripData['filterreturndate'] = $filterreturndate;
        $tripData['fleet_id'] = $fleet_id;
        $tripData['search_company_id'] = $company_id;

        $this->session->set($tripData);

        $monthcomparedate =  date('Y-m-d', strtotime('+1 month'));

        // if ($filterjourneydate > $monthcomparedate) {
        //     return redirect()->route('new-ticket')->with("fail", "No advance booking for this day");
        // }

        $data = array('trips' => [], 'in_holiday' => [], 'to_open' => [], 'inactive' => [], 'you_may_like' => []);
        $data['pick_location_id'] = $pick_location_id;
        $data['drop_location_id'] = $drop_location_id;
        $data['filterjourneydate'] = $filterjourneydate;
        $data['filterreturndate'] = $filterreturndate;
        $data['fleet_id'] = $fleet_id;
        $data['company_id'] = $company_id;

        $data['filterpath'] = $this->Viewpath;
        $data['location'] = $this->locationModel->findAll();
        $data['fleet_type'] = $this->fleetTypeModel->findAll();
        $data['companies'] = $this->CompanyModel->findAll();

        if (strpos($company_id, ',')) { 
            $company_ids = explode(',', $company_id);
        } else {
            $company_ids = [$company_id];
        }

        $allSubTrips = $this->getAllTrip($pick_location_id, $drop_location_id, $fleet_id, $company_ids);

        foreach ($allSubTrips as $subTrip) {
            if ($subTrip->status == 0) {
                // subtrip is inactive
                $data['inactive'][] = $subTrip;
                continue;
            }

            if (strtotime($journeyDate) < strtotime($subTrip->startdate)) {
                // subtrip yet not begin
                $data['to_open'][] = $subTrip;
                continue;
            }
            // if ($journeyDate ==  $subTrip->offdates) {
            $cleanedoffdates = preg_replace('/\s+/', '', $subTrip->offdates);
            if (in_array($journeyDate,explode(",", $cleanedoffdates))) {
                // subtrip is off today
                $data['in_holiday'][] = $subTrip;
                continue;
            }

            if ($this->isDateInRange($journeyDate, $subTrip->startdateinrange, $subTrip->enddateinrange)) {
                // subtrip is not in range
                $data['in_holiday'][] = $subTrip;
                continue;
            }

            $offdateranges = json_decode($subTrip->offdateranges, true);
            $isInAnyRange = false;
            if (is_array($offdateranges) && !empty($offdateranges)) {
                foreach ($offdateranges as $range) {
                    $start = $range['start'] ?? null;
                    $end = $range['end'] ?? null;

                    if ($start && $end && $this->isDateInRange($journeyDate, $start, $end)) {
                        $isInAnyRange = true;
                        break;
                    }
                }
            }

            if ($isInAnyRange) {
                $data['in_holiday'][] = $subTrip;
                continue;
            }


            if (!$this->isDateInRange($journeyDate, $subTrip->repetedstartdate, $subTrip->repetedenddate)) {
                if($journeyDate != date('Y-m-d',strtotime($subTrip->startdate))){
                    //start date and not between start and edn date
                    $data['in_holiday'][] = $subTrip;
                    continue;    
                }
                
            }

            $today = new \DateTime(date('Y-m-d'));

            $journeyDateObj = new \DateTime(date('Y-m-d', strtotime($journeyDate)));
            $interval = $today->diff($journeyDateObj);
            if ($subTrip->maxdayforbooking > 0 && ($subTrip->maxdayforbooking < $interval->days)) {
                //not allowed to book tickets
                $data['in_holiday'][] = $subTrip;
                continue;
            }

            if ($this->isDateInRange($journeyDate, $subTrip->repetedstartdate, $subTrip->repetedenddate)) {
                if($journeyDate != date('Y-m-d',strtotime($subTrip->startdate))){
                    if($subTrip->repeted_after > 0 && $interval->days > 0){
                        if($interval->days%$subTrip->repeted_after > 0){
                            //start date and not between start and edn date
                            $data['in_holiday'][] = $subTrip;
                            continue;
                        }
                    }
                    
                }
                
            }

            if (@in_array($journeyDayOfWeek, explode(',', $subTrip->weekend))) {
                // subtrip is on holiday
                $data['in_holiday'][] = $subTrip;
                continue;
            }

            if (($subTrip->pick_location_id != $pick_location_id) || ($subTrip->drop_location_id != $drop_location_id)) {
                // subtrip is related to selected locations
                $data['you_may_like'][] = $subTrip;
                continue;
            }


            $subtripInfo = $this->subtripModel->find($subTrip->id);
            $this->ticketModel
            ->where('journeydata', $filterjourneydate)
            ->where('cancel_status', 0)
            ->where('refund', 0);

            if ($subtripInfo->type == 'subtrip') {
                $mainTripId = $subtripInfo->trip_id;
                $subtripStoppagePointsArr = array_filter(explode(',', $subtripInfo->stoppage));
                $mainTripMainSubtripId = $this->subtripModel->where('trip_id', $mainTripId)->where('type', 'main')->first();

                $subtripStopage = $this->subtripModel->where('trip_id', $mainTripId)->where('pick_location_id', $subtripInfo->pick_location_id)->where('drop_location_id', $subtripInfo->drop_location_id)->first();
                $results = $this->getDynamicPickupDropCombinations($subtripInfo->pick_location_id, $subtripInfo->drop_location_id, $subtripStopage->stoppage, $filterjourneydate, $mainTripId);
                $bookseat = array_column($results, 'seatnumber');

            } else {
                $this->ticketModel->where('tickets.trip_id', $subtripInfo->trip_id);
                $bookseat = array_column($this->ticketModel->findAll(), 'seatnumber');
            }
            $separatedSeats = [];
            foreach ($bookseat as $seats) {
                // Use explode to separate the comma-separated seat numbers
                $separatedSeats = array_merge($separatedSeats, explode(',', $seats));
            }
            $subTrip->bookseatCount = is_array($separatedSeats)?count($separatedSeats):0;
            $pickdrop = $this->picdropModel->select('pickdrops.id as pickdropid,pickdrops.*,stands.*, stands.name as stand_name')
                ->join('stands', 'stands.id = pickdrops.stand_id')
                ->where('trip_id', $subtripInfo->id)
                ->findAll();
            if(empty($pickdrop)){
                $pickdrop = $this->picdropModel->select('pickdrops.id as pickdropid,pickdrops.*,stands.*, stands.name as stand_name')
                    ->join('stands', 'stands.id = pickdrops.stand_id')
                    ->where('trip_id', $subtripInfo->trip_id)
                    ->findAll();
            }
            // print_r($pickdrop);
            $pickup_time = null;
            $drop_time = null;

            // foreach ($pickdrop as $item) {
            //     if ($item->type == 1) {
            //         $pickup_time = $item->time;
            //     } elseif ($item->type == 0) {
            //         $drop_time = $item->time;
            //     }
            // }
            $pickup_time = null;
            $drop_time = null;

            foreach ($pickdrop as $item) {
                if ($item->type == 1) {
                    // Smallest pickup time
                    if (is_null($pickup_time) || strtotime($item->time) < strtotime($pickup_time)) {
                        $pickup_time = $item->time;
                    }
                } elseif ($item->type == 0) {
                    // Largest drop time
                    if (is_null($drop_time) || strtotime($item->time) > strtotime($drop_time)) {
                        $drop_time = $item->time;
                    }
                }
            }


            $subTrip->pickup_time = $pickup_time;
            $subTrip->drop_time = $drop_time;
            $data['trips'][] = $subTrip;
            // print_r($data);
            // exit;
        }

        $data['taxtype'] = $websetting->tax_type;
        $data['module'] = lang("Localize.ticket_booking");
        $data['title'] = lang("Localize.book_ticket");
        $data['pageheading'] = lang("Localize.book") . ' ' . lang("Localize.ticket");
        $data['triptype'] = lang("Localize.single") . ' ' . lang("Localize.trip");
        //echo "<pre>";print_r($data);exit;
        return view($this->Viewpath . '\ticket\index', $data);
    }

    public function getAllTrip($pickLocationId, $dropLocationId, $fleetId = null, $company_id)
    {
        // bind search query
        $this->subtripModel
            ->select('trips.id as tripid, trips.*, fleets.*, schedules.*, vehicles.*, subtrips.id as subtripId, subtrips.*,companies.name as company, trip_bus_types.name AS trip_bus_type, trip_category.name AS trip_category_name')

            ->join('trips', 'trips.id = subtrips.trip_id')
            ->join('fleets', 'fleets.id = trips.fleet_id')
            ->join('schedules', 'schedules.id = trips.schedule_id')
            ->join('vehicles', 'vehicles.id = trips.vehicle_id',"left")
            ->join('companies', 'companies.id = trips.company_id',"left")
            ->join('trip_bus_types', 'trip_bus_types.id = trips.trip_bus_type_id',"left")
            ->join('trip_category', 'trip_category.id = trips.trip_category_id',"left")

            ->groupStart()
                ->groupStart()
                    ->where('subtrips.pick_location_id', $pickLocationId)
                    ->where('subtrips.drop_location_id', $dropLocationId)
                ->groupEnd()

                ->orGroupStart()
                    ->whereIn('subtrips.trip_id', function ($subQuery) use ($pickLocationId, $dropLocationId) {
                        $subQuery
                            ->select('sm.trip_id')
                            ->from('subtrips sm')
                            ->where('sm.pick_location_id', $pickLocationId)
                            ->where('sm.drop_location_id', $dropLocationId)
                            ->where('sm.type', 'subtrip');
                    })
                    ->where('subtrips.type', 'main')
                ->groupEnd()
            ->groupEnd()
            ->where('subtrips.status', 1)
            ->where('trips.status', 1);

            if(is_array($company_id) && session()->get('role_id') != "1"){
                $this->subtripModel->whereIn('trips.company_id', $company_id);
            } else {
                $nonEmptyCompanyId = array_filter($company_id);
                if(!empty($nonEmptyCompanyId)){
                    $this->subtripModel->whereIn('trips.company_id', $company_id);
                }
                
            }

            $this->subtripModel->orderBy('subtrips.id', 'DESC');

        $fleetId && $this->subtripModel->where('trips.fleet_id', $fleetId);
        // $query = $this->subtripModel->builder()->getCompiledSelect();dd($query);
        return $this->subtripModel->findAll();
    }

    public function getSingleTrip($subTripId, $journeydate)
    {
        $maxtime = $this->maxtimeModel->first();
        $maxtime =  60 * (int)$maxtime->maxtime;
        $subtripInfo = $this->subtripModel->find($subTripId);

        // Release non paid expired seats
        $getData = $this->ticketModel
            ->where('trip_id', $subtripInfo->trip_id)
            ->where('journeydata', $journeydate)
            ->where('payment_status', "unpaid")
            ->where('cancel_status', 0)
            ->where('refund', 0)
            ->findAll();

        foreach ($getData as $key => $delvalue) {
            $cratetime = strtotime($delvalue->created_at);
            $timenow = strtotime("now");

            if (($timenow - $cratetime) > $maxtime) {
                $this->ticketModel->where('id', $delvalue->id)->set(['cancel_status' => 1])->update();
                $bookingId = $this->ticketModel->find($delvalue->id);
                $this->journeylistModel->where('booking_id', $bookingId->booking_id)->delete();
            }
        }

        // Build total booked seats
        $this->ticketModel
            ->where('journeydata', $journeydate)
            ->where('cancel_status', 0)
            ->where('refund', 0);

        if ($subtripInfo->type == 'subtrip') {
            $mainTripId = $subtripInfo->trip_id;
            $subtripStoppagePointsArr = array_filter(explode(',', $subtripInfo->stoppage));
            $mainTripMainSubtripId = $this->subtripModel->where('trip_id', $mainTripId)->where('type', 'main')->first();
            $subtripStopage = $this->subtripModel->where('trip_id', $mainTripId)->where('pick_location_id', $subtripInfo->pick_location_id)->where('drop_location_id', $subtripInfo->drop_location_id)->first();
            
            $results = $this->getDynamicPickupDropCombinations($subtripInfo->pick_location_id, $subtripInfo->drop_location_id, $subtripStopage->stoppage, $journeydate, $mainTripId);
            
            $bookseat = array_column($results, 'seatnumber');
            $holdseat =[];
            $blockseat =[];

            // $builder = $this->TemporaryBook->builder();
            // $builder->where('subtrip_id', $subtripInfo->id)
            //         ->where('journey_date', $journeydate)
            //         ->where('expires_at >', date('Y-m-d H:i:s'));
            // $query = $builder->get();
            // $TempBookedSeat = $query->getResultArray();
            
            $TempBookedSeat = $this->getDynamicPickupDropCombinationsTemp($subtripInfo->pick_location_id, $subtripInfo->drop_location_id, $subtripStopage->stoppage, $journeydate, $subtripInfo->id);
            $currentTime = date("Y-m-d H:i:s");
            $egyptNow = new \DateTime("now", new \DateTimeZone("Africa/Cairo"));
            $currentTime = $egyptNow->format("Y-m-d H:i:s");

            $builder = $this->holdSeatModel->builder();
            $builder
            // ->where('subtrip_id', $subtripInfo->id)
                    ->where("FIND_IN_SET('{$subtripInfo->id}', subtrip_id)", null, false)
                    ->where('status', 1)
                    ->where("'$journeydate' BETWEEN journeydata AND journeydataend", null, false)
                    ->where("'$currentTime' BETWEEN startdate AND enddate", null, false);
            $query = $builder->get();
            $holdSeat = $query->getResultArray();
            // if($subtripInfo->id == 339){
            //     print_r($holdSeat);
            //     exit;
            // }

            if(!empty($TempBookedSeat)){
                foreach($TempBookedSeat as $TempBookedSeat){
                    $holdseat[] = $TempBookedSeat['seat_names'];
                }
                
            }
            if(!empty($holdSeat)){
                foreach ($holdSeat as $seatRow) {
                    $seats = explode(',', $seatRow['seat_number']); // split by comma
                    foreach ($seats as $seat) {
                        $blockseat[] = trim($seat); // trim to clean whitespace
                    }
                }
                
            }

        } else {
            $currentTime = date("Y-m-d H:i:s");
            $egyptNow = new \DateTime("now", new \DateTimeZone("Africa/Cairo"));
            $currentTime = $egyptNow->format("Y-m-d H:i:s");

            $holdseat =[];
            $blockseat = [];
            $builder = $this->holdSeatModel->builder();
            $builder
            ->where('trip_id', $subtripInfo->trip_id)
                    ->where("FIND_IN_SET('{$subtripInfo->id}', subtrip_id)", null, false)
                    ->where("'$journeydate' BETWEEN journeydata AND journeydataend", null, false)
                    ->where('status', 1)
                    ->where("'$currentTime' BETWEEN startdate AND enddate", null, false);
                    // ->where("DATE('$journeydate') BETWEEN DATE(startdate) AND DATE(enddate)", null, false);


            $query = $builder->get();
            $holdSeat = $query->getResultArray();

            // if($subtripInfo->id == 339){
                // print_r($holdSeat);
                // exit;
                foreach ($holdSeat as $key => $row) {
                    // if current time NOT between start and end, remove it
                    if ($currentTime < $row['startdate'] || $currentTime > $row['enddate']) {
                        unset($holdSeat[$key]);
                    }
                }
            //     echo $currentTime;
            //     print_r($holdSeat);
            //     exit;
            // }
            $mainTripId = $subtripInfo->trip_id;
            $subtripStopage = $this->subtripModel->where('trip_id', $mainTripId)->where('pick_location_id', $subtripInfo->pick_location_id)->where('drop_location_id', $subtripInfo->drop_location_id)->first();

            $TempBookedSeat = $this->getDynamicPickupDropCombinationsTemp($subtripInfo->pick_location_id, $subtripInfo->drop_location_id, $subtripStopage->stoppage, $journeydate, $subtripInfo->id);


            if(!empty($holdSeat)){
                foreach ($holdSeat as $seatRow) {
                    $seats = explode(',', $seatRow['seat_number']); // split by comma
                    foreach ($seats as $seat) {
                        $blockseat[] = trim($seat); // trim to clean whitespace
                    }
                }
                
            }
            if(!empty($TempBookedSeat)){
                foreach ($TempBookedSeat as $seatRow) {
                    $seats = explode(',', $seatRow['seat_names']); // split by comma
                    foreach ($seats as $seat) {
                        $holdseat[] = trim($seat); // trim to clean whitespace
                    }
                }
                
            }
            $this->ticketModel->where('tickets.trip_id', $subtripInfo->trip_id);
            $bookseat = array_column($this->ticketModel->findAll(), 'seatnumber');
        }

        // Build locations and taxes
        $pickdrop = $this->picdropModel->select('pickdrops.id as pickdropid,pickdrops.*,stands.*, stands.name as stand_name')
            ->join('stands', 'stands.id = pickdrops.stand_id')
            ->where('trip_id', $subtripInfo->id)
            ->findAll();
        if(empty($pickdrop)){
            $pickdrop = $this->picdropModel->select('pickdrops.id as pickdropid,pickdrops.*,stands.*, stands.name as stand_name')
                ->join('stands', 'stands.id = pickdrops.stand_id')
                ->where('trip_id', $subtripInfo->trip_id)
                ->findAll();
        }

        $tax = $this->taxModel->where('status', 1)->findAll();

        // Build subtrip info
        $subtrips = $this->subtripModel->select('trips.id as tripid,trips.*,fleets.*,schedules.*,vehicles.*,subtrips.id as subtripId,subtrips.*, fleets.id as fleet_id')
            ->join('trips', 'trips.id = subtrips.trip_id')
            ->join('fleets', 'fleets.id = trips.fleet_id')
            ->join('schedules', 'schedules.id = trips.schedule_id')
            ->join('vehicles', 'vehicles.id = trips.vehicle_id',"left")
            ->where('subtrips.status', 1)
            ->where('subtrips.id', $subTripId)
            ->findAll();
            if(isset($subtrips[0]->subtrip_seatclass) && !empty($subtrips[0]->subtrip_seatclass)){
                $seatClasses = $subtrips[0]->subtrip_seatclass ? json_decode($subtrips[0]->subtrip_seatclass, true) : "";        
            }else{
                $seatClasses = $subtrips[0]->seatclass ? json_decode($subtrips[0]->seatclass, true) : "";        
            }
        $adultFair = $subtrips[0]->adult_fair ?? "";


        return $this->response->setJSON([
            'status' => "success",
            'response' => 200,
            'subtrips' => json_encode($subtrips),
            'pickdrop' => json_encode($pickdrop),
            'tax' => json_encode($tax),
            'bookseat' => json_encode(implode(',', $bookseat)),
            'holdseat' => json_encode(implode(',', $holdseat)),
            'blockseat' => json_encode(implode(',', $blockseat)),
            'seatClass' => json_encode($seatClasses),
            'adultfare' => $adultFair,
        ]);
    }

    public function getSeatLayout()
    {
        $subTripId = $this->request->getVar('id');
        $fleetId = $this->request->getVar('fleet_id');
        $bookedSeats = $this->request->getVar('booked');
        $holdSeats = $this->request->getVar('hold');
        $blockSeats = $this->request->getVar('block');
        $fleetInfo = $this->fleetTypeModel->find($fleetId);
        $fleetTotalSeat = $fleetInfo->total_seat;
        // print_r($fleetInfo);die;
        // build seat layout vars
        $seatLayout     = $fleetInfo->layout;
        $seatLayoutArr  = array_filter(explode('-', $seatLayout));
        $totalSeatInRow = array_sum($seatLayoutArr);
        $tSeatRowWithB  = $totalSeatInRow + count($seatLayoutArr) - 3;
        // print_r($tSeatRowWithB);die;
        $seatNumbers    = array_filter(explode(',', $fleetInfo->seat_number));
        // remove last seat
        // if fleet has last seat
        $lastSeat = '';
        // $fleetInfo->last_seat && $lastSeat = array_pop($seatNumbers);
        $seatinfo['forth_seat'] = $fleetInfo->forth_seat;
        $seatinfo['lastSheet'] = $fleetInfo->last_seat;
        $seatinfo['wc'] = $fleetInfo->wc;



        // build seat group/row
        $seatRowGroup = array_chunk($seatNumbers, $totalSeatInRow);
        $seatRows = array_map(function ($singleRow) use ($seatLayoutArr, $tSeatRowWithB, $bookedSeats, $holdSeats, $blockSeats) {
        // print_r($tSeatRowWithB);die;
            $newSingleRow = array();
            $currentTotalIndex = 0;

            foreach ($singleRow as $seatRowIndex => $singleSeat) {
                $seatRowIndex++;
                $newSingleRow[] = array(
                    'seatName' => $singleSeat, 
                    'isBooked' => in_array($singleSeat, $bookedSeats) ?? 0,
                    'isHold' => in_array($singleSeat, (array) $holdSeats) ?? 0,
                    'isBlock' => in_array($singleSeat, (array) $blockSeats) ?? 0
                );

                if (($seatRowIndex != count($singleRow)) && (current($seatLayoutArr) + $currentTotalIndex == $seatRowIndex)) {
                    $newSingleRow[] = '';
                    $currentTotalIndex += current($seatLayoutArr);
                    array_shift($seatLayoutArr);
                }
            }

            return array_pad($newSingleRow, $tSeatRowWithB, '');
        }, $seatRowGroup);

// print_r(count($seatRows));
// exit;
if(count($seatRows[count($seatRows)-1]) != count($seatRows[1])){
    $seatRows[count($seatRows)-2] = array_merge($seatRows[count($seatRows)-2],$seatRows[count($seatRows)-1]);
    unset($seatRows[count($seatRows)-1]);
}
// print_r($seatRows[count($seatRows)-2]);
// exit;
        // $lastRow = end($seatRows);
        // if ($previousRowIndex >= 0) {
        //     $previousRow = &$seatRows[$previousRowIndex];
        //     $outstandingSeats = array_splice($previousRow, $totalSeatInRow);
        //     $lastRow = array_merge($lastRow, $outstandingSeats);
        //     $seatRows[count($seatRows) - 1] = $lastRow;
        // }

        // print_r($seatRows);die;
        if ($lastSeat !== '') {
            // last seat exists
            // build last seat info
            $lastSeatInfo =  array(
                'seatName' => $lastSeat,
                'isBooked' => in_array($lastSeat, $bookedSeats) 
            );
            
            if (($lastBlankSpace = array_search('', end($seatRows))) !== false) {
                // an blank space exists in last row
                // last seat place into the last blank space
                $seatRows[count($seatRows) - 1][$lastBlankSpace] = $lastSeatInfo;
            } else {
                // create new row and last seat place into it
                $seatRows[][] = $lastSeatInfo;
            }
        }
        
        // print_r($seatRows);die;

        try {
            //if()
            $filePath = sprintf("%s\\ticket\\seatlayouts\\%s", $this->Viewpath, $seatLayout);
            return view($filePath, compact('subTripId', 'seatRows', 'totalSeatInRow'));
        } catch (\Throwable $e) {
            // print_r($filePath);die;
            if($seatLayout =='4-1'){
                // print_r($seatRows);
                // exit;
                $filePath = sprintf("%s\\ticket\\seatlayouts\\layoutfinal2", $this->Viewpath);
                return view($filePath, compact('subTripId', 'seatRows', 'totalSeatInRow','fleetTotalSeat','seatinfo'));
            }else if($seatLayout =='1-1'){
                $filePath = sprintf("%s\\ticket\\seatlayouts\\layoutfinal1-1", $this->Viewpath);
                return view($filePath, compact('subTripId', 'seatRows', 'totalSeatInRow','fleetTotalSeat','seatinfo'));
            }else if($seatLayout =='1-2' || $seatLayout =='2-1'){
                $filePath = sprintf("%s\\ticket\\seatlayouts\\layoutfinal1-2", $this->Viewpath);
                return view($filePath, compact('subTripId', 'seatRows', 'totalSeatInRow','fleetTotalSeat','seatinfo'));
            }else{
                $filePath = sprintf("%s\\ticket\\seatlayouts\\default3", $this->Viewpath);
            }
            return view($filePath, compact('subTripId', 'seatRows', 'totalSeatInRow', 'fleetTotalSeat','seatinfo'));
        }
    }

    public function booking()
    {
        if (empty($this->request->getVar())) {
            $failMsg = session()->getFlashdata('fail') ?: 'Session expired!';
            return redirect()->route('new-ticket')->with("fail", $failMsg);
        }

        $data['returndate'] = $this->request->getVar('returndate');

        $data['seatnumbers'] = $this->request->getVar('seatnumbers');
        $array = explode(",", $data['seatnumbers']);
        $daynamic = count($array);
        
        if (!empty($data['returndate'])) {

            $grandtotal = $this->request->getVar('grandtotal');
            $discount = $this->roundtripdiscoundModel->where('status', 1)->first();
            $discountMoney = 0;
            $discountPercent = 0;
            if (!empty($discount)) {
                $discountPercent = $discount->discountrate;
                $caltulateDiscont = (float) ($discountPercent / 100) * $grandtotal;
                $discountMoney = (float)  $grandtotal - (float)$caltulateDiscont;
            } else {
                $discountMoney = $grandtotal;
                $discountPercent = 0;
                $caltulateDiscont = 0;
            }

            $singleTripData['subtripId'] =  $this->request->getVar('subtripId');
            $singleTripData['seatnumbers'] = $this->request->getVar('seatnumbers');
            $singleTripData['totalseat'] =  $daynamic;
            $singleTripData['journeydate'] = $this->request->getVar('journeydate');
            $singleTripData['aseat'] = $this->request->getVar('aseat');
            $singleTripData['spseat'] = $this->request->getVar('spseat');
            $singleTripData['vpseat'] = $this->request->getVar('vpseat')??"";
            $singleTripData['cseat'] = $this->request->getVar('cseat');
            $singleTripData['totalprice'] = $this->request->getVar('totalprice');
            $singleTripData['tax'] = $this->request->getVar('tax');
            $singleTripData['grandtotal'] = $discountMoney;
            $singleTripData['pickstand'] = $this->request->getVar('pickstand');
            $singleTripData['dropstand'] = $this->request->getVar('dropstand');
            $singleTripData['discountPercent'] = $discountPercent;
            $singleTripData['roundtrip_discount'] = $caltulateDiscont;

            $this->session->set($singleTripData);

            return redirect()->route('roundfindtrip-ticket');
        } else {
            $data['filterpath'] = $this->Viewpath;
            $builder = $this->db->table('country');
            $query = $builder->get();
            $data['country'] = $query->getResult();

            $data['subtripId'] = $this->request->getVar('subtripId');
            $data['seatnumbers'] = $this->request->getVar('seatnumbers');

            $array = explode(",", $data['seatnumbers']);

            $daynamic = count($array);
            $data['dynamicfield'] = $daynamic - 1;

            $data['totalseat'] = $daynamic;

            $data['journeydate'] = $this->request->getVar('journeydate');


            $data['aseat'] = $this->request->getVar('aseat');
            $data['spseat'] = $this->request->getVar('spseat');
            $data['vpseat'] = $this->request->getVar('vpseat')??"";
            $data['cseat'] = $this->request->getVar('cseat');

            $data['totalprice'] = $this->request->getVar('totalprice');
            $data['tax'] = $this->request->getVar('tax');



            if ($this->session->has('discountPercent')) {
                $percentDiscount = $this->session->get('discountPercent');
                $getGrandtotal = $this->request->getVar('grandtotal');
                $caltulateDiscont = (float) ($percentDiscount / 100) * $getGrandtotal;
                $discountMoney = (float)  $getGrandtotal - (float)$caltulateDiscont;
                $data['grandtotal'] = $discountMoney;
                $data['roundtrip_discount'] = $caltulateDiscont;
            } else {

                $data['grandtotal'] = $this->request->getVar('grandtotal');
                $data['roundtrip_discount'] = 0;
            }



            $data['pickstand'] = $this->request->getVar('pickstand');
            $data['dropstand'] = $this->request->getVar('dropstand');


            $data['paymethod'] = $this->paymethodModel->where('status', 1)->findAll();

            $data['module'] =    lang("Localize.ticket_booking");
            $data['title']  =    lang("Localize.ticket_list");

            $heading = lang("Localize.book") . ' ' . lang("Localize.ticket");
            $data['pageheading'] = $heading;

            $data['discount'] = $this->session->get('discount');
            $data['coupon'] = $this->session->get('coupon');
            $data['rountripStatus'] = 0;
            $data['isrountrip'] = 0;
            $maxtime = $this->maxtimeModel->where('book_from', "admin")->first();
            $expirytime = $maxtime->maxtime ?? 5;
            // $expirytime = 1;
            $expires_at = date('Y-m-d H:i:s', strtotime("+{$expirytime} minutes"));
            $data['expirytime_minutes'] = $expirytime;
            $data['expires_at'] = $expires_at;


            
            // $tempbooking = ['subtrip_id'   => $this->request->getVar('subtripId'),
            //                 'ticket_token' => 'backendd'.$this->request->getVar('subtripId'),
            //                 'seat_names'   => $this->request->getVar('seatnumbers'),
            //                 'journey_date' => $this->request->getVar('journeydate'),
            //                 'created_at'   => date('Y-m-d H:i:s'),
            //                 'expires_at'   => date('Y-m-d H:i:s', strtotime('+5 minutes'))];

            // $this->TemporaryBook->insert($tempbooking);

            echo view($this->Viewpath . '\ticket\booking', $data);
        }
    }

    public function create()
    {
        

        $rand = substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'), 1, 8);
        $rand = "TB" . $rand;
        $maitripid = null;
        $subtripid = null;
        $piclocation = null;
        $droplocation = null;
        $vehicles_id = null;
        $backUserId = $this->session->get('user_id');
        $subTripId = $this->request->getVar('subtripId');
        $payment_detail_rocord = $this->request->getVar('paydetail');

        $subtrips = $this->subtripModel->select('trips.id as tripid,trips.*,fleets.*,schedules.*,vehicles.*,subtrips.id as subtripId,subtrips.*,trips.company_id as companyId')
            ->join('trips', 'trips.id = subtrips.trip_id')
            ->join('fleets', 'fleets.id = trips.fleet_id')
            ->join('schedules', 'schedules.id = trips.schedule_id')
            ->join('vehicles', 'vehicles.id = trips.vehicle_id',"left")
            ->where('subtrips.status', 1)
            ->where('subtrips.id', $subTripId)
            ->findAll();
        $companyId = $subtrips[0]->companyId??0;
        foreach ($subtrips as $key => $value) {
            $maitripid = $value->tripid;
            $subtripid = $value->id;
            $piclocation = $value->pick_location_id;
            $droplocation = $value->drop_location_id;
            $vehicles_id = $value->vehicle_id;
        }

        // get user info
        $login_email = $this->request->getVar('login_email');
        $login_mobile = $this->request->getVar('login_mobile');
        
        $first_name = $this->request->getVar('first_name');
                $fullName = $this->nameFilter($first_name);
                $first_name = $fullName['first_name'];
              //  print_r($fullName);die;
        if($login_mobile == ""){
            $demoemail = $first_name."123@gmail.com";
            $login_email = $demoemail;
        }
        
        $userid = $this->userCheck($login_email, $login_mobile);

        $loginUserId = $this->session->get('user_id');
        $bookUserId = $this->session->get('role_id');

        // Get role info
        $roelinfo = $this->roleModel->find($bookUserId);
        $bookUserType = $roelinfo->name;

        $ticketbooking = array(
            "booking_id" => $rand,
            "trip_id" => $maitripid,
            "subtrip_id" => $subtripid,
            "passanger_id" => $userid,
            "pick_location_id" => $piclocation,
            "drop_location_id" => $droplocation,
            "pick_stand_id" => $this->request->getVar('pickstand'),
            "drop_stand_id" => $this->request->getVar('dropstand'),
            "price" => $this->request->getVar('totalprice'),
            "discount" => $this->request->getVar('discount'),
            "totaltax" => $this->request->getVar('tax'),
            "paidamount" => $this->request->getVar('grandtotal'),
            "adult" => $this->request->getVar('aseat'),
            "chield" => $this->request->getVar('cseat'),
            "special" => $this->request->getVar('spseat'),
            "vip" => $this->request->getVar('vpseat')??"",
            "refund" => 0,
            "bookby_user_id" =>  $loginUserId,
            "bookby_user_type" => $bookUserType,
            "journeydata" => $this->request->getVar('journeydate'),
            "pay_type_id" => $this->request->getVar('pay_method'),
            "payment_status" => $this->request->getVar('payment_status'),
            "payment_detail" => $this->request->getVar('paydetail'),
            "note" => $this->request->getVar('address')??"",
            "vehicle_id" => $vehicles_id,
            "cancel_status" => 0,
            "offerer" => $this->request->getVar('offerer'),
            "seatnumber" => $this->request->getVar('seatnumbers'),
            "totalseat" => $this->request->getVar('totalseat'),
            "roundtrip_discount" => 0,
        );
        $checkbooking = $this->isAlreadybooked($maitripid, $subtripid, $userid, $piclocation, $droplocation, $this->request->getVar('totalseat'), $this->request->getVar('seatnumbers'),$this->request->getVar('journeydate'));
        if($checkbooking){
            return redirect()->route('allbookinglist-ticket')->with("fail", "Allready booked.");
        }

        $validTicketbooking = array(
            "booking_id" => $rand,
            "trip_id" => $maitripid,
            "subtrip_id" => $subtripid,
            "passanger_id" => $userid,

            "pick_location_id" => $piclocation,
            "drop_location_id" => $droplocation,
            "pick_stand_id" => $this->request->getVar('pickstand'),
            "drop_stand_id" => $this->request->getVar('dropstand'),

            "price" => $this->request->getVar('totalprice'),
            "paidamount" => $this->request->getVar('grandtotal'),
            "seatnumber" => $this->request->getVar('seatnumbers'),
            "totalseat" => $this->request->getVar('totalseat'),
            "bookby_user_id" => 1,
            "journeydata" => $this->request->getVar('journeydate'),
            "pay_type_id" => $this->request->getVar('pay_method'),
            "payment_status" => $this->request->getVar('payment_status'),
            "vehicle_id" => $vehicles_id,
        );

        if ($this->validation->run($validTicketbooking, 'ticket')) {
            $this->db->transStart();
            $paymentStatus = $this->request->getVar('payment_status');

            if ($paymentStatus == "unpaid") {
                $paidamount = 0;
            }

            if ($paymentStatus == "paid") {
                $paidamount = $this->request->getVar('grandtotal');
            }

            if ($paymentStatus == "partial") {
                $paidamount = $this->request->getVar('partialpay');
            }
            $userRole = $this->session->get('role_id');

            if(($userRole == 2)){

                $agetnDetail =  $this->agentModel->where('user_id', $this->session->get('user_id'))->first();

                $walletAmount = $this->agentPayment->select('SUM(payagents.amount) as total_amount')
                ->join('agents', 'agents.id = payagents.agent_id', 'left')
                ->join('companies', 'companies.id = payagents.company_id', 'left')
                ->where('payagents.agent_id', $agetnDetail->id)
                ->where('companies.id ',$companyId)
                ->where('payagents.status',1)
                ->groupBy('companies.name')
                ->first();
                if (!is_object($walletAmount)){
                    $errmsg = lang("Localize.insufficient_balance");
                    $seatNumbers = $this->request->getVar('seatnumbers');
                    $this->deleteHoldSeat($seatNumbers,$subtripid);
                    return redirect()->route('allbookinglist-ticket')->with("fail", $errmsg);
                }
                
                if($paidamount > $walletAmount->total_amount){
                    $errmsg = lang("Localize.insufficient_balance");
                    $seatNumbers = $this->request->getVar('seatnumbers');
                    $this->deleteHoldSeat($seatNumbers,$subtripid);
                    
                    // $datasss = $this->TemporaryBook
                    //                 ->where('seat_names', $seatNumbers)
                    //                 ->where('subtrip_id', $subtripid)
                    //                 ->delete();
                    return redirect()->route('allbookinglist-ticket')->with("fail", $errmsg);
                }

            }
            

            $partialPaid = array(
                "booking_id" => $rand,
                "trip_id" => $maitripid,
                "subtrip_id" => $subtripid,
                "passanger_id" => $userid,
                "paidamount" => $paidamount,
                "pay_type_id" => $this->request->getVar('pay_method'),
            );
            $paidpartial = array(
                "booking_id" => $rand,
                "trip_id" => $maitripid,
                "subtrip_id" => $subtripid,
                "passanger_id" => $userid,
                "paidamount" => $paidamount,
                "pay_type_id" => $this->request->getVar('pay_method'),
                "payment_detail" => $this->request->getVar('paydetail'),
            );

            $this->ticketModel->insert($ticketbooking);


            if ($this->validation->run($partialPaid, 'partialpay')) {

                $this->partialpaidModel->insert($paidpartial);

                $pick_stand_id = $this->request->getVar('pickstand');
                $drop_stand_id = $this->request->getVar('dropstand');

                $journeylist = $this->journeylist($rand, $userid, $maitripid, $subtripid, $piclocation, $droplocation, $pick_stand_id, $drop_stand_id, $ticketbooking['journeydata']);

                

                if (($userRole == 2) && ($paymentStatus != "unpaid")) {
                    $totalprice =  $paidamount;
                    $type = "income";
                    $message = "For Ticket Booking";

                    $agentIncome = agentIncomeCommission($backUserId, $totalprice, $rand, $subtripid, $userid, $message, $companyId);

                    $agentTotalIncome =   agentTotal($backUserId, $totalprice, $rand, $type, $payment_detail_rocord);

                    // if( $this->request->getVar('pay_method')== 1){
                        $agetnDetail =  $this->agentModel->where('user_id', $this->session->get('user_id'))->first();
                        $agentIncome = agentExpenseTicketCharge($agetnDetail->id, $totalprice, $rand, $subtripid, $userid, $message, $companyId);
                    // }
                }
            }

            if ($paymentStatus != "unpaid") {
                $paymethod_id = $this->request->getVar('pay_method');
                $payDetail = $this->request->getVar('paydetail');
                $type = "income";
                $detail = "Ticket Booking (" . $rand . ") ";
                accoutTranjection($type, $detail, $paidamount, $backUserId, $rand, "booking");
                paymethodTeanjection($rand, $paymethod_id, $paidamount, $payDetail, $maitripid, $subtripid, $backUserId);

                $couponcode = $this->request->getVar('offerer');

                if (!empty($couponcode)) {
                    $validDetail = $this->couponModel->where('code', $couponcode)->findAll();


                    $coupondetail = array(
                        "code" => $couponcode,
                        "coupon_id" => $validDetail[0]->id,
                        "booking_id" => $rand,
                        "subtrip_id" => $subtripid,
                        "amount" => $validDetail[0]->discount,

                    );

                    $this->coupondiscountModel->insert($coupondetail);
                }
            }

            $this->db->transComplete();
            $ticketmailLibrary = new Ticketmail();
            $emaildata = $ticketmailLibrary->getticketEmailData($rand);
            $status = sendTicket($login_email, $emaildata);

          //  if ($status == true) {
                return redirect()->route('allbookinglist-ticket')->with("success", "Ticket created successfully");
            //}
        }

        return redirect()->route('new-ticket')->with("fail", $this->validation->listErrors());
    }

    public function userCheck($login_email, $login_mobile)
    {
        
        $userid = null;
        if($login_email != ""){
            $evalue = $this->userModel->where('login_email', $login_email)->findAll();
        }else{
            $evalue = "";
        }
        if($login_mobile != ""){
            $mvalue = $this->userModel->where('login_mobile', $login_mobile)->findAll();
        }else{
            $mvalue = "";
        }
        // $evalue = $this->userModel->where('login_email', $login_email)->findAll();
        // $mvalue = $this->userModel->where('login_mobile', $login_mobile)->findAll();

        if (!empty($evalue) || !empty($mvalue)) {
            if ($evalue) {
                foreach ($evalue as $key => $mobilevalue) {
                    $userid = $mobilevalue->id;
                }
            }
            if ($mvalue) {
                foreach ($mvalue as $key => $emailvalue) {
                    $userid = $emailvalue->id;
                }
            }

            return $userid;
        } else {
            $status = 1;
            $role_id = 3;
            $slug = bin2hex(random_bytes(5));
            $password = $confirm = "123456";
            if($login_email == ""){
                $login_email = null;
            }else{
                $login_email = $login_email;
            }


            $userData = array(
                "login_email" => $login_email,
                "login_mobile" => $login_mobile,
                "password" => $password,
                "confirm" => $confirm,
                "slug" => $slug,
                "role_id" => $role_id,
                "status" => $status,
            );

            if ($this->validation->run($userData, 'user')) {
                $this->db->transStart();

                $userData['password'] = password_hash($password, PASSWORD_DEFAULT);
                $userid = $this->userModel->insert($userData);
                $first_name = $this->request->getVar('first_name');
                $fullName = $this->nameFilter($first_name);
                $first_name = $fullName['first_name'];
                $last_name = $fullName['last_name'];
                $validdata = array(
                    "user_id" => $userid,
                    "first_name" => $first_name,
                    "last_name" => $this->request->getVar('last_name'),
                    "id_type" => $this->request->getVar('id_type') ?: null,
                    "id_number" => $this->request->getVar('id_number') ?: null,
                    "country_id" => $this->request->getVar('country_id')?: null,
                );

                if ($this->validation->run($validdata, 'userDetail')) {
                    $data = array(
                        "user_id" => $userid,
                        "first_name" => $first_name,
                        "last_name" => $last_name,
                        "id_type" => $this->request->getVar('id_type') ?: null,
                        "country_id" => $this->request->getVar('country_id')?: null,
                        "id_number" => $this->request->getVar('id_number') ?: null,
                        "address" => $this->request->getVar('address')?: null,
                        "city" => $this->request->getVar('city')?: null,
                        "zip_code" => $this->request->getVar('zip_code')?: null
                    );

                    $this->userDetailModel->insert($data);

                    $this->db->transComplete();
                }
            }

            return $userid;
        }
    }
    
     function nameFilterold($full_name){
        // Split the full name by spaces
        $name_parts = explode(" ", $full_name);
        
        // Initialize variables for first name, middle name(s), and last name
        $first_name = ""; // Initialize first name as an empty string
        $middle_name = ""; // Initialize middle name as an empty string
        $last_name = ""; // Initialize last name as an empty string
        
        // Extract the last name (always the last part)
        $last_name = array_pop($name_parts);
    
        // If there are remaining parts, set the first name and middle name(s)
        if (!empty($name_parts)) {
            // First name is the first part
            $first_name = array_shift($name_parts);
            // If there are remaining parts, they are middle name(s)
            if (!empty($name_parts)) {
                // Concatenate the remaining parts as middle name(s)
                $middle_name = implode(" ", $name_parts);
            }
        }
        
        // Prepare the data array
        $data['first_name'] = $first_name;
        $data['last_name'] = $last_name;
        
        return $data;
    }
    function nameFilter($full_name) {
        // Trim and split the name at the first space
        $full_name = trim($full_name);
        $spacePos = strpos($full_name, ' ');

        if ($spacePos === false) {
            // No space found — whole name is the first name
            $first_name = $full_name;
            $last_name = '';
        } else {
            $first_name = substr($full_name, 0, $spacePos);
            $last_name = substr($full_name, $spacePos + 1);
        }

        return [
            'first_name' => $first_name,
            'last_name' => $last_name
        ];
    }


    public function journeylist($rand, $userid, $maitripid, $subtripid, $piclocation, $droplocation, $pick_stand_id, $drop_stand_id, $journeydate = "")
    {
        if($journeydate == ""){
            $journeydate = date("Y-m-d", strtotime($this->request->getVar('journeydate')));    
        }
        $joruneylistid = null;

        $mainpassanger = array(
            "booking_id" => $rand,
            "trip_id" => $maitripid,
            "subtrip_id" => $subtripid,
            "pick_location_id" => $piclocation,
            "drop_location_id" => $droplocation,
            "pick_stand_id" => $pick_stand_id,
            "drop_stand_id" => $drop_stand_id,
            "first_name" => $this->request->getVar('first_name'),
            "last_name" => $this->request->getVar('last_name'),
            "phone" => $this->request->getVar('login_mobile'),
            "journeydate" => $journeydate,
            "id_number" => $this->request->getVar('id_number'),
        );

        if ($this->validation->run($mainpassanger, 'journeylist')) {
            $joruneylistid = $this->journeylistModel->insert($mainpassanger);
        }

        $newPassangerFName = $this->request->getVar('first_name_new');
        $newPassangerLName = $this->request->getVar('last_name_new');
        $newPassangerMobile = $this->request->getVar('login_mobile_new');
        $newPassangerNidNumber = $this->request->getVar('id_number_new');

        if (!empty($newPassangerFName)) {
            foreach ($newPassangerFName as $nkey => $newpassanger) {
                $newpassangerlist[$nkey] = array(

                    "booking_id" => $rand,
                    "trip_id" => $maitripid,
                    "subtrip_id" => $subtripid,
                    "pick_location_id" => $piclocation,
                    "drop_location_id" => $droplocation,
                    "pick_stand_id" => $pick_stand_id,
                    "drop_stand_id" => $drop_stand_id,
                    "first_name" => $newPassangerFName[$nkey],
                    "last_name" => $newPassangerLName[$nkey],
                    "phone" => $newPassangerMobile[$nkey],
                    "journeydate" => $journeydate,
                    "id_number" => $newPassangerNidNumber[$nkey],

                );
            }



            $this->journeylistModel->insertBatch($newpassangerlist);
        }


        return   $joruneylistid;
    }

    public function allbookinglist()
    {
        $rolepermissionLibrary = new Rolepermission();
        $refund_action = "refund_list";
        $cancel_action = "cancel_list";

        $data['refund_create'] = $rolepermissionLibrary->create($refund_action);
        $data['cancel_create'] = $rolepermissionLibrary->create($cancel_action);

        $pickdrops =  $this->picdropModel
            ->select('stands.id as standId,stands.*,pickdrops.*, stands.name as stand_name')
            ->join('stands', 'stands.id = pickdrops.stand_id')
            ->withDeleted()
            ->findAll();

        // print_r($pickdrops);
        // dd("asdasd");

        $data['ticket'] = $this->filterBooking();
        $data['location'] =  $this->locationModel->withDeleted()->findAll();
        $data['pickdropstand'] =  $pickdrops;
        $data['paymethod'] = $this->paymethodModel->where('status', 1)->findAll();

        $data['module'] =    lang("Localize.ticket_booking");
        $data['title']  =    lang("Localize.ticket_list");
        $data['pageheading'] = lang("Localize.ticket_list");

        return view($this->Viewpath . '\ticket\bookinglist', $data);
    }

    public function filterBooking()
    {
        $userRole = $this->session->get('role_id');
        $userId = $this->session->get('user_id');
        // print_r($this->session->get());
        // exit;
        if (!in_array($userRole,[1,2,7])) {
            //not agent company and super admin
            // user role is agent or employee
            // list only user booking lists
            $rolepermissionLibrary = new Rolepermission();
            if (!$rolepermissionLibrary->create('all_tickets')) {
                $this->ticketModel->where('bookby_user_id', $userId);
            }else{
                $this->ticketModel->where('trips.company_id', session()->get('company_id'));
            }
        }else{
            if(in_array($userRole,[7])){
              $this->ticketModel->where('trips.company_id', session()->get('company_id'));
            }
            if(in_array($userRole,[2])){
              $this->ticketModel->whereIn('trips.company_id', explode(",", session()->get('company_id')))->where('bookby_user_id', $userId);
            }
        }

        $this->ticketModel->where('cancel_status', 0);
        $this->ticketModel->where('refund', 0);
        $this->ticketModel->where('tickets.journeydata >=', '2025-08-21 00:00:00');
        $this->ticketModel->select('tickets.*,CONCAT(user_details.first_name," ",user_details.last_name) as passengerName, CONCAT(COALESCE(booker.first_name, booker_agents.first_name,booker_agents_emp.first_name), " ", COALESCE(booker.last_name, booker_agents.last_name, booker_agents_emp.last_name)) AS booked_by, companies.name as company_name');
        $this->ticketModel->join("user_details","user_details.user_id = tickets.passanger_id");
        $this->ticketModel->join("user_details AS booker","booker.user_id = tickets.bookby_user_id","left");
        $this->ticketModel->join("agents AS booker_agents","booker_agents.user_id = tickets.bookby_user_id","left");
        $this->ticketModel->join("users","users.id = tickets.bookby_user_id","left");
        $this->ticketModel->join("employees AS booker_agents_emp","booker_agents_emp.email = users.login_email","left");
        $this->ticketModel->join("trips","trips.id = tickets.trip_id","left");
        $this->ticketModel->join("companies","trips.company_id = companies.id","left");
        $this->ticketModel->orderBy('id', 'DESC');
        $filterTicket = $this->ticketModel->withDeleted()->findAll();

        return $filterTicket;
    }

    public function agentCommission($totalprice)
    {
        $userId = $this->session->get('user_id');
        $agetnDetail =  $this->agentModel->where('user_id', $userId)->first();
        (float)$commission = (float)(($totalprice) * ($agetnDetail->commission / 100));
        return $commission;
    }


    public function roundfindtrip()
    {
        $websetting = $this->websettingModel->first();

        $pick_location_id = $this->session->get('drop_location_id');
        $drop_location_id = $this->session->get('pick_location_id');
        $filterjourneydate = $this->session->get('filterreturndate');

        // build journey date
        $journeyDate = date('Y-m-d', strtotime($filterjourneydate));
        $journeyDayOfWeek = date('N', strtotime($filterjourneydate));

        $fleet_id = $this->session->get('fleet_id');

        $monthcomparedate =  date('Y-m-d', strtotime('+1 month'));

        if ($filterjourneydate > $monthcomparedate) {
            return redirect()->route('new-ticket')->with("fail", "No advance booking for this day");
        }
        $company_id = session()->get('company_id') ?? 0;
        if(($this->request->getVar('company_id') || $this->request->getVar('company_id') == 0) && session()->get('role_id') == "1"){
            $company_id = $this->request->getVar('company_id') ?? 0;
        } else {
            if(session('search_company_id')){
                $company_id = session('search_company_id');
            }
        }

        $data = array('trips' => [], 'in_holiday' => [], 'to_open' => [], 'inactive' => [], 'you_may_like' => []);
        $data['pick_location_id'] = $pick_location_id;
        $data['drop_location_id'] = $drop_location_id;
        $data['filterjourneydate'] = $filterjourneydate;
        $data['filterreturndate'] = "";
        $data['fleet_id'] = $fleet_id;
        $data['company_id'] = $company_id;

        $data['filterpath'] = $this->Viewpath;
        $data['location'] = $this->locationModel->findAll();
        $data['fleet_type'] = $this->fleetTypeModel->findAll();
        $data['companies'] = $this->CompanyModel->findAll();


        if (strpos($company_id, ',')) { 
            $company_ids = explode(',', $company_id);
        } else {
            $company_ids = [$company_id];
        }

        $allSubTrips = $this->getAllTrip($pick_location_id, $drop_location_id, $fleet_id, $company_ids);

        foreach ($allSubTrips as $subTrip) {
            if ($subTrip->status == 0) {
                // subtrip is inactive
                $data['inactive'][] = $subTrip;
                continue;
            }

            if (strtotime($journeyDate) < strtotime($subTrip->startdate)) {
                // subtrip yet not begin
                $data['to_open'][] = $subTrip;
                continue;
            }

            if (@in_array($journeyDayOfWeek, explode(',', $subTrip->weekend))) {
                // subtrip is on holiday
                $data['in_holiday'][] = $subTrip;
                continue;
            }

            if (($subTrip->pick_location_id != $pick_location_id) || ($subTrip->drop_location_id != $drop_location_id)) {
                // subtrip is related to selected locations
                $data['you_may_like'][] = $subTrip;
                continue;
            }
            
            $subtripInfo = $this->subtripModel->find($subTrip->id);
            $this->ticketModel
            ->where('journeydata', $filterjourneydate)
            ->where('cancel_status', 0)
            ->where('refund', 0);

            if ($subtripInfo->type == 'subtrip') {
                $mainTripId = $subtripInfo->trip_id;
                $subtripStoppagePointsArr = array_filter(explode(',', $subtripInfo->stoppage));
                $mainTripMainSubtripId = $this->subtripModel->where('trip_id', $mainTripId)->where('type', 'main')->first();

                $subtripStopage = $this->subtripModel->where('trip_id', $mainTripId)->where('pick_location_id', $subtripInfo->pick_location_id)->where('drop_location_id', $subtripInfo->drop_location_id)->first();
                $results = $this->getDynamicPickupDropCombinations($subtripInfo->pick_location_id, $subtripInfo->drop_location_id, $subtripStopage->stoppage, $filterjourneydate, $mainTripId);
                $bookseat = array_column($results, 'seatnumber');

            } else {
                $this->ticketModel->where('tickets.trip_id', $subtripInfo->trip_id);
                $bookseat = array_column($this->ticketModel->findAll(), 'seatnumber');
            }

            $separatedSeats = [];
            foreach ($bookseat as $seats) {
                // Use explode to separate the comma-separated seat numbers
                $separatedSeats = array_merge($separatedSeats, explode(',', $seats));
            }
            $subTrip->bookseatCount = is_array($separatedSeats)?count($separatedSeats):0;
            $pickdrop = $this->picdropModel->select('pickdrops.id as pickdropid,pickdrops.*,stands.*, stands.name as stand_name')
                ->join('stands', 'stands.id = pickdrops.stand_id')
                ->where('trip_id', $subtripInfo->id)
                ->findAll();
            if(empty($pickdrop)){
                $pickdrop = $this->picdropModel->select('pickdrops.id as pickdropid,pickdrops.*,stands.*, stands.name as stand_name')
                    ->join('stands', 'stands.id = pickdrops.stand_id')
                    ->where('trip_id', $subtripInfo->trip_id)
                    ->findAll();
            }
            // print_r($pickdrop);
            $pickup_time = null;
            $drop_time = null;

            // foreach ($pickdrop as $item) {
            //     if ($item->type == 1) {
            //         $pickup_time = $item->time;
            //     } elseif ($item->type == 0) {
            //         $drop_time = $item->time;
            //     }
            // }
            $pickup_time = null;
            $drop_time = null;

            foreach ($pickdrop as $item) {
                if ($item->type == 1) {
                    // Smallest pickup time
                    if (is_null($pickup_time) || strtotime($item->time) < strtotime($pickup_time)) {
                        $pickup_time = $item->time;
                    }
                } elseif ($item->type == 0) {
                    // Largest drop time
                    if (is_null($drop_time) || strtotime($item->time) > strtotime($drop_time)) {
                        $drop_time = $item->time;
                    }
                }
            }


            $subTrip->pickup_time = $pickup_time;
            $subTrip->drop_time = $drop_time;

            $data['trips'][] = $subTrip;
        }

        $data['taxtype'] = $websetting->tax_type;
        $data['rountripStatus'] = 1;

        $data['module'] =    lang("Localize.ticket_booking");
        $data['title']  =    lang("Localize.book_ticket");

        $heading = lang("Localize.book") . ' ' . lang("Localize.ticket");
        $data['pageheading'] = $heading;
        $data['triptype'] = lang("Localize.round") . ' ' . lang("Localize.trip");
        $data['isrountrip'] = 1;
        $data['totalseat'] = $this->session->get('totalseat');

        $isroundtrip['isrountrip'] = 1;

        $this->session->set($isroundtrip);

        return view($this->Viewpath . '\ticket\index', $data);
    }


    public function roundcreate()
    {

        $ticketmailLibrary = new Ticketmail();

        //single Trip Ticket Booking
        $rand = substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'), 1, 8);
        $rand = "TB" . $rand;
        $maitripid = null;
        $subtripid = null;
        $piclocation = null;
        $droplocation = null;
        $vehicles_id = null;
        $backUserId = $this->session->get('user_id');
        $subTripId = $this->session->get('subtripId');
        $payment_detail_rocord = $this->request->getVar('paydetail');

        $discount = $this->request->getVar('discount');

        if ((!empty($discount)) && $discount > 0) {
            $getDiscount = (float) $discount / 2;
        } else {
            $getDiscount = 0;
        }

        $subtrips = $this->subtripModel->select('trips.id as tripid,trips.*,fleets.*,schedules.*,vehicles.*,subtrips.id as subtripId,subtrips.*')
            ->join('trips', 'trips.id = subtrips.trip_id')
            ->join('fleets', 'fleets.id = trips.fleet_id')
            ->join('schedules', 'schedules.id = trips.schedule_id')
            ->join('vehicles', 'vehicles.id = trips.vehicle_id', "left")
            ->where('subtrips.status', 1)
            ->where('subtrips.id', $subTripId)
            ->findAll();


        foreach ($subtrips as $key => $value) {
            $maitripid = $value->tripid;
            $subtripid = $value->id;
            $piclocation = $value->pick_location_id;
            $droplocation = $value->drop_location_id;
            $vehicles_id = $value->vehicle_id;
        }


        $login_email = $this->request->getVar('login_email');
        $login_mobile = $this->request->getVar('login_mobile');

        $userid = $this->userCheck($login_email, $login_mobile);

        $loginUserId = $this->session->get('user_id');

        $bookUserId = $this->session->get('role_id');

        $roelinfo = $this->roleModel->find($bookUserId);

        $bookUserType = $roelinfo->name;

        $pay_method_id = $this->request->getVar('pay_method');

        $payment_status = $this->request->getVar('payment_status');
        $payment_detail = $this->request->getVar('paydetail');

        $ticketbooking = array(
            "booking_id" => $rand,
            "trip_id" => $maitripid,
            "subtrip_id" => $subtripid,
            "passanger_id" => $userid,
            "pick_location_id" => $piclocation,
            "drop_location_id" => $droplocation,
            "pick_stand_id" => $this->session->get('pickstand'),
            "drop_stand_id" => $this->session->get('dropstand'),
            "price" => $this->session->get('totalprice'),
            "discount" =>  $getDiscount,
            "roundtrip_discount" =>  $this->session->get('roundtrip_discount'),
            "totaltax" => $this->session->get('tax'),
            "paidamount" => $this->session->get('grandtotal'),
            "adult" => $this->session->get('aseat'),
            "chield" => $this->session->get('cseat'),
            "special" => $this->session->get('spseat'),
            "vip" => $this->session->get('vpseat')??"",
            "refund" => 0,
            "bookby_user_id" =>  $loginUserId,
            "bookby_user_type" => $bookUserType,
            "journeydata" => $this->session->get('journeydate'),
            "pay_type_id" =>  $pay_method_id,
            // "payment_status" => $payment_status,
            "payment_detail" => $payment_detail,
            "vehicle_id" => $vehicles_id,
            "cancel_status" => 0,

            "offerer" => $this->session->get('offerer'),
            // "offerer" => 0,
            "seatnumber" => $this->session->get('seatnumbers'),
            "totalseat" => $this->session->get('totalseat'),

        );

        $validTicketbooking = array(

            "booking_id" => $rand,
            "trip_id" => $maitripid,
            "subtrip_id" => $subtripid,
            "passanger_id" => $userid,

            "pick_location_id" => $piclocation,
            "drop_location_id" => $droplocation,
            "pick_stand_id" => $this->session->get('pickstand'),
            "drop_stand_id" => $this->session->get('dropstand'),

            "price" => $this->request->getVar('totalprice'),
            "paidamount" => $this->request->getVar('grandtotal'),
            "seatnumber" => $this->request->getVar('seatnumbers'),
            "totalseat" => $this->session->get('totalprice'),
            "bookby_user_id" => 1,
            "journeydata" => $this->session->get('journeydate'),
            "pay_type_id" => $pay_method_id,
            "payment_status" => $payment_status,
            "vehicle_id" => $vehicles_id,

        );


        if ($this->validation->run($validTicketbooking, 'ticket')) {
            $this->db->transStart();

            $paymentStatus = $this->request->getVar('payment_status');

            if ($paymentStatus == "unpaid") {
                $singleTripPaymentStatus = "unpaid";
                $roundTripPaymentStatus = "unpaid";
                $paidamount = $this->session->get('grandtotal');
                $roundtripPaid = $this->request->getVar('grandtotal');
                $roundPaidamount = (float) $roundtripPaid - (float)$paidamount;
                $transectionSingeltrip = 0;
                $transectionDoubletrip = 0;
            }
            if ($paymentStatus == "paid") {
                $paidamount = $this->session->get('grandtotal');
                $roundtripPaid = $this->request->getVar('grandtotal');
                $roundPaidamount = (float) $roundtripPaid - (float)$paidamount;
                $singleTripPaymentStatus = "paid";
                $roundTripPaymentStatus = "paid";
                $transectionSingeltrip = $paidamount;
                $transectionDoubletrip =   $roundPaidamount;
            }
            if ($paymentStatus == "partial") {
                $partialamount = $this->request->getVar('partialpay');
                $singelTripamount = $this->session->get('grandtotal');
                if ($partialamount < $singelTripamount) {
                    $paidamount = $this->session->get('grandtotal');
                    $roundtripPaid = $this->request->getVar('grandtotal');
                    $roundPaidamount = (float) $roundtripPaid - (float)$paidamount;
                    $singleTripPaymentStatus = "partial";
                    $roundTripPaymentStatus = "unpaid";
                    $transectionSingeltrip = $partialamount;
                    $transectionDoubletrip = 0;
                }

                if ($partialamount == $singelTripamount) {

                    $paidamount = $this->session->get('grandtotal');
                    $roundtripPaid = $this->request->getVar('grandtotal');
                    $roundPaidamount = (float) $roundtripPaid - (float)$paidamount;
                    $singleTripPaymentStatus = "paid";
                    $roundTripPaymentStatus = "unpaid";
                    $transectionSingeltrip = $partialamount;
                    $transectionDoubletrip = 0;
                }

                if ($partialamount > $singelTripamount) {

                    $paidamount = $this->session->get('grandtotal');
                    $roundtripPaid = $this->request->getVar('grandtotal');
                    $roundPaidamount = (float) $roundtripPaid - (float)$paidamount;

                    $extraMoney = (float) $partialamount - (float) $paidamount;
                    $singleTripPaymentStatus = "paid";
                    $roundTripPaymentStatus = "partial";

                    $transectionSingeltrip = $paidamount;
                    $transectionDoubletrip = $extraMoney;
                }
            }



            $ticketbooking['payment_status'] = $singleTripPaymentStatus;
            $this->ticketModel->insert($ticketbooking);

            $partialPaid = array(
                "booking_id" => $rand,
                "trip_id" => $maitripid,
                "subtrip_id" => $subtripid,
                "passanger_id" => $userid,
                "paidamount" => $transectionSingeltrip,
                "pay_type_id" => $this->request->getVar('pay_method'),
            );
            $paidpartial = array(
                "booking_id" => $rand,
                "trip_id" => $maitripid,
                "subtrip_id" => $subtripid,
                "passanger_id" => $userid,
                "paidamount" => $transectionSingeltrip,
                "pay_type_id" => $this->request->getVar('pay_method'),
                "payment_detail" => $payment_detail,
            );

            if ($this->validation->run($partialPaid, 'partialpay')) {
                $this->partialpaidModel->insert($paidpartial);
                $pick_stand_id = $this->session->get('pickstand');
                $drop_stand_id = $this->session->get('dropstand');

                $journeylist = $this->journeylist($rand, $userid, $maitripid, $subtripid, $piclocation, $droplocation, $pick_stand_id, $drop_stand_id, $ticketbooking['journeydata']);
                $userRole = $this->session->get('role_id');

                if (($userRole == 2) && ($singleTripPaymentStatus != "unpaid")) {
                    $totalprice =  $transectionSingeltrip;
                    $type = "income";
                    $message = "For Ticket Booking";
                    $agentIncome = agentIncomeCommission($backUserId, $totalprice, $rand, $subtripid, $userid, $message);
                    $agentTotalIncome = agentTotal($backUserId, $totalprice, $rand, $type, $payment_detail_rocord);
                }
            }


            if ($singleTripPaymentStatus != "unpaid") {
                $paymethod_id = $this->request->getVar('pay_method');
                $payDetail = $this->request->getVar('paydetail');
                $type = "income";
                $detail = "Ticket Booking (" . $rand . ") ";
                accoutTranjection($type, $detail, $transectionSingeltrip, $backUserId, $rand, "booking");
                paymethodTeanjection($rand, $paymethod_id, $transectionSingeltrip, $payDetail, $maitripid, $subtripid, $backUserId);
            }


            $roundrand = substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'), 1, 8);
            $roundrand = "TB" . $roundrand;
            $maitripid = null;
            $subtripid = null;
            $piclocation = null;
            $droplocation = null;
            $vehicles_id = null;
            $backUserId = $this->session->get('user_id');
            $subTripId = $this->request->getVar('subtripId');
            $payment_detail_rocord = $this->request->getVar('paydetail');

            $subtrips = $this->subtripModel->select('trips.id as tripid,trips.*,fleets.*,schedules.*,vehicles.*,subtrips.id as subtripId,subtrips.*')
                ->join('trips', 'trips.id = subtrips.trip_id')
                ->join('fleets', 'fleets.id = trips.fleet_id')
                ->join('schedules', 'schedules.id = trips.schedule_id')
                ->join('vehicles', 'vehicles.id = trips.vehicle_id',"left")
                ->where('subtrips.status', 1)
                ->where('subtrips.id', $subTripId)
                ->findAll();

            foreach ($subtrips as $key => $value) {
                $maitripid = $value->tripid;
                $subtripid = $value->id;
                $piclocation = $value->pick_location_id;
                $droplocation = $value->drop_location_id;
                $vehicles_id = $value->vehicle_id;
            }


            $roundticketbooking = array(
                "booking_id" => $roundrand,
                "trip_id" => $maitripid,
                "subtrip_id" => $subtripid,
                "passanger_id" => $userid,
                "pick_location_id" => $piclocation,
                "drop_location_id" => $droplocation,
                "pick_stand_id" => $this->request->getVar('pickstand'),
                "drop_stand_id" => $this->request->getVar('dropstand'),
                "price" => $this->request->getVar('totalprice'),
                "discount" =>  $getDiscount,
                "roundtrip_discount" =>  $this->request->getVar('roundtrip_discount'),
                "totaltax" => $this->request->getVar('tax'),
                "paidamount" =>  $roundPaidamount,
                "adult" => $this->request->getVar('aseat'),
                "chield" => $this->request->getVar('cseat'),
                "special" => $this->request->getVar('spseat'),
                "vip" => $this->request->getVar('vpseat')??"",
                "refund" => 0,
                "bookby_user_id" =>  $loginUserId,
                "bookby_user_type" => $bookUserType,
                "journeydata" => $this->request->getVar('journeydate'),
                "pay_type_id" => $this->request->getVar('pay_method'),
                // "payment_status" => $this->request->getVar('payment_status'),
                "payment_detail" => $this->request->getVar('paydetail'),
                "vehicle_id" => $vehicles_id,
                "cancel_status" => 0,

                "offerer" => $this->request->getVar('offerer'),
                // "offerer" => 0,
                "seatnumber" => $this->request->getVar('seatnumbers'),
                "totalseat" => $this->request->getVar('totalseat'),

            );

            $roundvalidTicketbooking = array(
                "booking_id" => $roundrand,
                "trip_id" => $maitripid,
                "subtrip_id" => $subtripid,
                "passanger_id" => $userid,

                "pick_location_id" => $piclocation,
                "drop_location_id" => $droplocation,
                "pick_stand_id" => $this->request->getVar('pickstand'),
                "drop_stand_id" => $this->request->getVar('dropstand'),

                "price" => $this->request->getVar('totalprice'),
                "paidamount" =>  $roundPaidamount,
                "seatnumber" => $this->request->getVar('seatnumbers'),
                "totalseat" => $this->request->getVar('totalseat'),
                "bookby_user_id" => 1,
                "journeydata" => $this->request->getVar('journeydate'),
                "pay_type_id" => $this->request->getVar('pay_method'),
                "payment_status" => $this->request->getVar('payment_status'),
                "vehicle_id" => $vehicles_id,

            );

            if ($this->validation->run($roundvalidTicketbooking, 'ticket')) {
                $partialPaid = array(
                    "booking_id" => $roundrand,
                    "trip_id" => $maitripid,
                    "subtrip_id" => $subtripid,
                    "passanger_id" => $userid,
                    "paidamount" => $transectionDoubletrip,
                    "pay_type_id" => $this->request->getVar('pay_method'),
                );

                $paidpartial = array(
                    "booking_id" => $roundrand,
                    "trip_id" => $maitripid,
                    "subtrip_id" => $subtripid,
                    "passanger_id" => $userid,
                    "paidamount" => $transectionDoubletrip,
                    "pay_type_id" => $this->request->getVar('pay_method'),
                    "payment_detail" => $this->request->getVar('paydetail'),
                );


                $roundticketbooking['payment_status'] = $roundTripPaymentStatus;
                $this->ticketModel->insert($roundticketbooking);


                if ($this->validation->run($partialPaid, 'partialpay')) {

                    $this->partialpaidModel->insert($paidpartial);

                    $pick_stand_id = $this->request->getVar('pickstand');
                    $drop_stand_id = $this->request->getVar('dropstand');

                    $journeylist = $this->journeylist($roundrand, $userid, $maitripid, $subtripid, $piclocation, $droplocation, $pick_stand_id, $drop_stand_id);

                    $userRole = $this->session->get('role_id');



                    if (($userRole == 2) && ($roundTripPaymentStatus != "unpaid")) {
                        $totalprice =  $transectionDoubletrip;
                        $type = "income";
                        $message = "For Ticket Booking";

                        $agentIncome = agentIncomeCommission($backUserId, $totalprice, $roundrand, $subtripid, $userid, $message);

                        $agentTotalIncome =   agentTotal($backUserId, $totalprice, $roundrand, $type, $payment_detail_rocord);
                    }
                }
            }

            if ($roundTripPaymentStatus != "unpaid") {
                $paymethod_id = $this->request->getVar('pay_method');
                $payDetail = $this->request->getVar('paydetail');
                $type = "income";
                $detail = "Ticket Booking (" . $roundrand . ") ";
                accoutTranjection($type, $detail, $transectionDoubletrip, $backUserId, $roundrand, "booking");
                paymethodTeanjection($rand, $paymethod_id, $transectionDoubletrip, $payDetail, $maitripid, $subtripid, $backUserId);
            }

            $couponcode = $this->request->getVar('offerer');
            if (!empty($couponcode)) {
                $validDetail = $this->couponModel->where('code', $couponcode)->findAll();


                $coupondetail = array(
                    "code" => $couponcode,
                    "coupon_id" => $validDetail[0]->id,
                    "booking_id" => $rand,
                    "subtrip_id" => $subtripid,
                    "amount" => $validDetail[0]->discount,

                );

                $coupondetailround = array(
                    "code" => $couponcode,
                    "coupon_id" => $validDetail[0]->id,
                    "booking_id" => $roundPaidamount,
                    "subtrip_id" => $subtripid,
                    "amount" => $validDetail[0]->discount,

                );

                $this->coupondiscountModel->insert($coupondetail);
                $this->coupondiscountModel->insert($coupondetailround);
            }


            $emaildata = $ticketmailLibrary->getticketEmailData($rand);
            $roundemaildata = $ticketmailLibrary->getticketEmailData($roundrand);
            $this->db->transComplete();
            $status = sendTicket($login_email, $emaildata);
            $rouondstatus = sendTicket($login_email, $roundemaildata);
            $status = true;
            $rouondstatus = true;

            if (($status == true) && ($rouondstatus == true)) {
                $this->session->remove('subtripId');
                $this->session->remove('seatnumbers');
                $this->session->remove('totalseat');
                $this->session->remove('journeydate');
                $this->session->remove('aseat');
                $this->session->remove('spseat');
                $this->session->remove('vpseat');
                $this->session->remove('cseat');
                $this->session->remove('totalprice');
                $this->session->remove('tax');
                $this->session->remove('grandtotal');
                $this->session->remove('pickstand');
                $this->session->remove('dropstand');
                $this->session->remove('isrountrip');
                $this->session->remove('discountPercent');
                $this->session->remove('roundtrip_discount');
                return redirect()->route('allbookinglist-ticket')->with("success", "Ticket Booking");
            }
        }

        return redirect()->route('new-ticket')->with("fail", $this->validation->getError());
    }
    
    public function pretrip()
    {
        $data['fleet_type'] = $this->fleetTypeModel->findAll();
        $data['vehicle'] = $this->vehicleModel->findAll();
        
        $company_id = session()->get('company_id') ?? 0;
        if(($this->request->getVar('company_id') || $this->request->getVar('company_id') == 0) && session()->get('role_id') == "1"){
            $data['companies'] = $this->CompanyModel->findAll();
        }else{
            $company_ids = explode(',', $company_id);
            $data['companies'] = $this->CompanyModel->whereIn('id', $company_ids)->findAll();
        }
            
        $data['trip'] = $this->tripModel->select('trips.id as tripid, trips.*, schedules.*, vehicles.*, pic_location.name as pic_location_name, drop_location.name as drop_location_name')
                ->join('schedules', 'schedules.id = trips.schedule_id','left')
                ->join('vehicles', 'vehicles.id = trips.vehicle_id','left')
                ->join('locations as pic_location', 'pic_location.id = trips.pick_location_id', 'left')
                ->join('locations as drop_location', 'drop_location.id = trips.drop_location_id', 'left')
                ->findAll();
            
        $data['driver'] = $this->employeeModel->where('employeetype_id', 1)->findAll();
        $data['assistant'] = $this->employeeModel->where('employeetype_id', 2)->findAll();
        
        // print_r($data['trip'][0]);die;
        // reg_no
        
        return view($this->Viewpath . '\ticket\pretrip', $data);
    }
    
    public function pre_trip_booking()
    {
        $loginUserId = $this->session->get('user_id');
        $data1['trip_id'] = $this->request->getVar('tripid');
        $data1['Driver_id'] = $this->request->getVar('Driver_id');
        $data1['Assistant_id'] = $this->request->getVar('Assistant_id');
        $data1['bus_id'] = $this->request->getVar('bus_id');
        $data1['Number_of_Seats'] = $this->request->getVar('Number_of_Seats');
        $data1['gas_later'] = $this->request->getVar('Gas_later');
        $data1['bus_meter'] = $this->request->getVar('Bus_meter');
        $data1['notes'] = $this->request->getVar('notes');
        $data1['created_by'] = $loginUserId;
        $data1['create_at'] = $this->request->getVar('pretripDate');
        $data1['pretrip_id'] = 1;

        $tripId = $this->request->getVar('tripid');
        $trip = $this->tripModel->find($tripId);
        
        if ($trip) {
            $companyTripIds = $this->tripModel
                ->select('id')
                ->where('company_id', $trip->company_id)
                ->findColumn('id');

            $maxPretripId = $this->pretripModel
                ->selectMax('pretrip_id')
                ->whereIn('trip_id', $companyTripIds)
                ->first();
            $data1['pretrip_id'] = ($maxPretripId->pretrip_id ?? 0) + 1;
        }
        $today = date('Y-m-d');
        $existing = $this->pretripModel
            ->where('trip_id', $data1['trip_id'])
            ->where("DATE(create_at)", $this->request->getVar('pretripDate'))
            ->first();

        if ($existing) {
            return redirect()->route('pre_trip_list')->with("fail", "pretrip is already created.");
        }
        
        $this->pretripModel->insert($data1);

        $data2['trip_id']       = $this->request->getVar('tripid');
        $data2['employee_id']   = $this->request->getVar('Driver_id');
        $data2['employee_type']   = 1;//static for driver
        $data2['created_at']   = $this->request->getVar('pretripDate');
        $this->stuffassignModel->insert($data2);

        $data3['trip_id']       = $this->request->getVar('tripid');
        $data3['employee_id']   = $this->request->getVar('Assistant_id');
        $data3['employee_type']   = 2;//static for Assistant
        $data3['created_at']   = $this->request->getVar('pretripDate');
        $this->stuffassignModel->insert($data3);
        
        // $data['fleet_type'] = $this->fleetTypeModel->findAll();
        // $data['vehicle'] = $this->vehicleModel->findAll();
            
            
        // $data['trip'] = $this->tripModel->select('trips.id as tripid, trips.*, schedules.*, vehicles.*, pic_location.name as pic_location_name, drop_location.name as drop_location_name')
        //         ->join('schedules', 'schedules.id = trips.schedule_id')
        //         ->join('vehicles', 'vehicles.id = trips.vehicle_id')
        //         ->join('locations as pic_location', 'pic_location.id = trips.pick_location_id', 'left')
        //         ->join('locations as drop_location', 'drop_location.id = trips.drop_location_id', 'left')
        //         ->findAll();
            
        // $data['driver'] = $this->employeeModel->where('employeetype_id', 1)->findAll();
        // $data['assistant'] = $this->employeeModel->where('employeetype_id', 2)->findAll();
        
        // print_r($data['trip'][0]);die;
        // reg_no
        
        return redirect()->route('pre_trip_list')->with("success", "pretrip created");
        
        // return view($this->Viewpath . '\ticket\pretrip', $data);
    }
    
    public function pre_trip_list()
    {
        $roleId     = session()->get("role_id");
        $companyId  = session()->get("company_id");
        $user_id    = session()->get("user_id");
        if($roleId == 1){
            $data['pretrip'] = $this->pretripModel->select('pretrip.id as pretripId, pretrip.*, trips.*, CONCAT(driver.first_name," ",driver.last_name) as driverName, CONCAT(assistance.first_name," ",assistance.last_name) as assistanceName, vehicles.*, schedules.*, pic_location.name as pic_location_name, drop_location.name as drop_location_name, companies.name as company, pretrip.create_at as pretrip_create,  CONCAT(COALESCE(booker.first_name, booker_agents.first_name, booker_agents_emp.first_name), " ", COALESCE(booker.last_name, booker_agents.last_name, booker_agents_emp.last_name)) AS createdBy, schedules.start_time as schedule_time, pretrip.updated_at as updatedAt')
                ->join('trips', 'pretrip.trip_id = trips.id')
                ->join('companies', 'companies.id = trips.company_id','left')
                ->join('employees AS driver', 'pretrip.Driver_id = driver.id')
                ->join('employees AS assistance', 'pretrip.Assistant_id = assistance.id',"left")
                ->join('vehicles', 'pretrip.bus_id = vehicles.id')
                ->join('schedules', 'trips.schedule_id = schedules.id')
                ->join('locations as pic_location', 'pic_location.id = trips.pick_location_id', 'left')
                ->join('locations as drop_location', 'drop_location.id = trips.drop_location_id', 'left')
                ->join('user_details as booker', 'pretrip.created_by = booker.user_id', "left")
                ->join('agents as booker_agents', 'pretrip.created_by = booker_agents.user_id', "left")
                ->join("users","users.id = pretrip.created_by","left")
                ->join("employees AS booker_agents_emp","booker_agents_emp.email = users.login_email","left")
                // ->where('DATE(pretrip.create_at)',date('Y-m-d'))
                ->findAll();
        }else if($roleId == 7){
            $data['pretrip'] = $this->pretripModel->select('pretrip.id as pretripId, pretrip.*, trips.*, driver.first_name as driverName, assistance.first_name as assistanceName, vehicles.*, schedules.*, pic_location.name as pic_location_name, drop_location.name as drop_location_name,companies.name as company, pretrip.create_at as pretrip_create,  CONCAT(COALESCE(booker.first_name, booker_agents.first_name, booker_agents_emp.first_name), " ", COALESCE(booker.last_name, booker_agents.last_name, booker_agents_emp.last_name)) AS createdBy, schedules.start_time as schedule_time, pretrip.updated_at as updatedAt')
                ->join('trips', 'pretrip.trip_id = trips.id')
                ->join('companies', 'companies.id = trips.company_id','left')
                ->join('employees AS driver', 'pretrip.Driver_id = driver.id')
                ->join('employees AS assistance', 'pretrip.Assistant_id = assistance.id',"left")
                ->join('vehicles', 'pretrip.bus_id = vehicles.id')
                ->join('schedules', 'trips.schedule_id = schedules.id')
                ->join('locations as pic_location', 'pic_location.id = trips.pick_location_id', 'left')
                ->join('locations as drop_location', 'drop_location.id = trips.drop_location_id', 'left')
                ->join('user_details as booker', 'pretrip.created_by = booker.user_id', "left")
                ->join('agents as booker_agents', 'pretrip.created_by = booker_agents.user_id', "left")
                ->join("users","users.id = pretrip.created_by","left")
                ->join("employees AS booker_agents_emp","booker_agents_emp.email = users.login_email","left")
                // ->where('DATE(pretrip.create_at)',date('Y-m-d'))
                ->where('trips.company_id',$companyId)
                ->findAll();
        }else{
            $data['pretrip'] = $this->pretripModel->select('pretrip.id as pretripId, pretrip.*, trips.*, driver.first_name as driverName, assistance.first_name as assistanceName, vehicles.*, schedules.*, pic_location.name as pic_location_name, drop_location.name as drop_location_name, companies.name as company, pretrip.create_at as pretrip_create,  CONCAT(COALESCE(booker.first_name, booker_agents.first_name, booker_agents_emp.first_name), " ", COALESCE(booker.last_name, booker_agents.last_name, booker_agents_emp.last_name)) AS createdBy, schedules.start_time as schedule_time, pretrip.updated_at as updatedAt')
                ->join('trips', 'pretrip.trip_id = trips.id')
                ->join('companies', 'companies.id = trips.company_id','left')
                ->join('employees AS driver', 'pretrip.Driver_id = driver.id')
                ->join('employees AS assistance', 'pretrip.Assistant_id = assistance.id',"left")
                ->join('vehicles', 'pretrip.bus_id = vehicles.id')
                ->join('schedules', 'trips.schedule_id = schedules.id')
                ->join('locations as pic_location', 'pic_location.id = trips.pick_location_id', 'left')
                ->join('locations as drop_location', 'drop_location.id = trips.drop_location_id', 'left')
                ->join('user_details as booker', 'pretrip.created_by = booker.user_id', "left")
                ->join('agents as booker_agents', 'pretrip.created_by = booker_agents.user_id', "left")
                ->join("users","users.id = pretrip.created_by","left")
                ->join("employees AS booker_agents_emp","booker_agents_emp.email = users.login_email","left")
                // ->where('DATE(pretrip.create_at)',date('Y-m-d'))
                ->where('trips.company_id',$companyId)
                ->where('pretrip.created_by',$user_id)
                ->findAll();
        }
        

                
        // print_r($data['pretrip'][0]);die;
        
        
        return view($this->Viewpath . '\ticket\pretriplist', $data);    
    }
    
    public function edit_pretrip($id)
    {
        
        $data['fleet_type'] = $this->fleetTypeModel->findAll();
        $data['vehicle'] = $this->vehicleModel->findAll();
            
            
        $data['trip'] = $this->tripModel->select('trips.id as tripid, trips.*, schedules.*, vehicles.*, pic_location.name as pic_location_name, drop_location.name as drop_location_name')
                ->join('schedules', 'schedules.id = trips.schedule_id')
                ->join('vehicles', 'vehicles.id = trips.vehicle_id')
                ->join('locations as pic_location', 'pic_location.id = trips.pick_location_id', 'left')
                ->join('locations as drop_location', 'drop_location.id = trips.drop_location_id', 'left')
                ->findAll();
            
        $data['driver'] = $this->employeeModel->where('employeetype_id', 1)->findAll();
        $data['assistant'] = $this->employeeModel->where('employeetype_id', 2)->findAll();
        
        
        $data['pretrip'] = $this->pretripModel->select('pretrip.id as pretripId, pretrip.*, trips.*, driver.first_name as driverName, assistance.first_name as assistanceName, vehicles.*, schedules.*, pic_location.name as pic_location_name, drop_location.name as drop_location_name')
                ->join('trips', 'pretrip.trip_id = trips.id')
                ->join('employees AS driver', 'pretrip.Driver_id = driver.id')
                ->join('employees AS assistance', 'pretrip.Assistant_id = assistance.id')
                ->join('vehicles', 'pretrip.bus_id = vehicles.id')
                ->join('schedules', 'trips.schedule_id = schedules.id')
                ->join('locations as pic_location', 'pic_location.id = trips.pick_location_id', 'left')
                ->join('locations as drop_location', 'drop_location.id = trips.drop_location_id', 'left')
                ->where('pretrip.id', $id) // Example WHERE condition
                ->find();
                
            // print_r($data['pretrip']);die;
            
        return view($this->Viewpath . '\ticket\pretrip_edit', $data);
    }
    
    public function edit_pre_trip_booking()
    {
        $id = $this->request->getVar('pretripId');
        
        $data['trip_id'] = $this->request->getVar('tripid');
        $data['Driver_id'] = $this->request->getVar('Driver_id');
        $data['Assistant_id'] = $this->request->getVar('Assistant_id');
        $data['bus_id'] = $this->request->getVar('bus_id');
        $data['Number_of_Seats'] = $this->request->getVar('Number_of_Seats');
        
        $this->pretripModel->update($id, $data);
        
        return redirect()->route('pre_trip_list')->with("success", "pretrip updated");
    }
    
    public function delete_pretrip($id)
    {
        if ($this->pretripModel->delete($id)) {
            return redirect()->route('pre_trip_list')->with("success", "pretrip deleted");
        } else {
            return redirect()->route('pre_trip_list')->with("fail", "not delete");
        }
    }
    public function getDynamicPickupDropCombinations($pickup, $drop, $tripSeries, $date, $tripId)
    {
        // Convert trip series to an array of stops
        $stops = explode(',', $tripSeries);
        $this->db = \Config\Database::connect(); // Load CI4 Database
        
        // Start building the query
        $builder = $this->db->table('tickets');
        $builder->select("tickets.*, subtrips.*");
        $builder->join('subtrips', 'tickets.subtrip_id = subtrips.id', 'LEFT');
        $builder->join('trips', 'tickets.trip_id = trips.id', 'LEFT');
        $builder->where('journeydata', $date);
        $builder->where('cancel_status', 0);
        $builder->where('trips.status', 1);
        $builder->where('refund', 0);
        $builder->where('refund', 0);
        $builder->where('tickets.trip_id', $tripId);
        
        // Build the dynamic WHERE conditions
        $whereClause = '';
        foreach ($stops as $stop) {
            if (!empty($whereClause)) {
                $whereClause .= ' OR ';
            }
            $whereClause .= "FIND_IN_SET('$stop', TRIM(BOTH ',' FROM REPLACE(REPLACE(subtrips.stoppage, subtrips.pick_location_id, ''), subtrips.drop_location_id, '')))";
        }

        foreach ($stops as $start) {
            foreach ($stops as $end) {
                // if (array_search($start, $stops) < array_search($end, $stops)) {
                    $whereClause .= " OR (subtrips.pick_location_id = '$start' AND subtrips.drop_location_id = '$end') OR (subtrips.pick_location_id = '$end' AND subtrips.drop_location_id = '$start')";
                // }
            }
        }

        $builder->where("($whereClause)");

        // $sql = $builder->getCompiledSelect();
        // echo "<pre>";
        // print_r($sql); // Die and Debug: This will print the raw SQL query and stop execution
        // dd($sql);
        // Execute the query
        $query = $builder->get();    
        return $query->getResultArray();
    }

    public function getDynamicPickupDropCombinationsTemp($pickup, $drop, $tripSeries, $date, $subtripId)
    {
        // Convert trip series to an array of stops
        $stops = explode(',', $tripSeries);
        $this->db = \Config\Database::connect(); // Load CI4 Database
        
        // Start building the query
        $builder = $this->db->table('temporarybooks');
        $builder->select("temporarybooks.*, subtrips.*");
        $builder->join('subtrips', 'temporarybooks.subtrip_id = subtrips.id', 'LEFT');
        $builder->join('trips', 'subtrips.trip_id = trips.id', 'LEFT');
        $builder->where('journey_date', $date);
        $builder->where('expires_at >', date('Y-m-d H:i:s'));
        $builder->where('trips.status', 1);
        $builder->where('temporarybooks.subtrip_id', $subtripId);
        
        // Build the dynamic WHERE conditions
        $whereClause = '';
        foreach ($stops as $stop) {
            if (!empty($whereClause)) {
                $whereClause .= ' OR ';
            }
            $whereClause .= "FIND_IN_SET('$stop', TRIM(BOTH ',' FROM REPLACE(REPLACE(subtrips.stoppage, subtrips.pick_location_id, ''), subtrips.drop_location_id, '')))";
        }

        foreach ($stops as $start) {
            foreach ($stops as $end) {
                // if (array_search($start, $stops) < array_search($end, $stops)) {
                    $whereClause .= " OR (subtrips.pick_location_id = '$start' AND subtrips.drop_location_id = '$end') OR (subtrips.pick_location_id = '$end' AND subtrips.drop_location_id = '$start')";
                // }
            }
        }

        $builder->where("($whereClause)");

        // $sql = $builder->getCompiledSelect();
        // echo "<pre>";
        // print_r($sql); // Die and Debug: This will print the raw SQL query and stop execution
        // dd($sql);
        // Execute the query
        $query = $builder->get();    
        return $query->getResultArray();
    }

    public function isDateInRange($dateToCheck, $startDate, $endDate) {
        // Convert dates to DateTime objects
        $date       = new \DateTime($dateToCheck);
        $start      = new \DateTime($startDate);
        $end        = new \DateTime($endDate);

        // Check if the date is in the range
        return ($date >= $start && $date <= $end);
    }

    public function print_pretrip($id)
    {
        $data['pretrip'] = $this->pretripModel->select('pretrip.id as pretripId, pretrip.*, trips.*, CONCAT(driver.first_name," ",driver.last_name) as driverName, driver.phone as driverphone, CONCAT(assistance.first_name," ",assistance.last_name) as assistanceName, assistance.phone as assistancephone, vehicles.*, schedules.*, pic_location.name as pic_location_name, drop_location.name as drop_location_name, pretrip.gas_later as gas_later, pretrip.bus_meter as bus_meter, pretrip.notes as notes, CONCAT(COALESCE(booker.first_name, booker_agents.first_name, booker_agents_emp.first_name), " ", COALESCE(booker.last_name, booker_agents.last_name, booker_agents_emp.last_name)) AS createdBy, companies.name as company_name, pretrip.create_at as pretrip_created_at, pretrip.updated_at as pretrip_updated_at, booker_agents.id as booker_id, booker_agents.id as booker_agent_id, booker_agents_emp.id as booker_agents_emp_id,users.role_id as booker_agents_emp_role, roles.name AS role_name
            ')
                ->join('trips', 'pretrip.trip_id = trips.id')
                ->join('employees AS driver', 'pretrip.Driver_id = driver.id')
                ->join('employees AS assistance', 'pretrip.Assistant_id = assistance.id',"left")
                ->join('vehicles', 'pretrip.bus_id = vehicles.id')
                ->join('schedules', 'trips.schedule_id = schedules.id')
                ->join('user_details as booker', 'pretrip.created_by = booker.user_id', "left")
                ->join('agents as booker_agents', 'pretrip.created_by = booker_agents.user_id', "left")
                ->join('locations as pic_location', 'pic_location.id = trips.pick_location_id', 'left')
                ->join('locations as drop_location', 'drop_location.id = trips.drop_location_id', 'left')
                ->join('companies', "trips.company_id = companies.id","left")
                ->join("users","users.id = pretrip.created_by","left")
                ->join('roles', 'users.role_id = roles.id',"left")
                ->join("employees AS booker_agents_emp","booker_agents_emp.email = users.login_email","left")
                // ->where('DATE(pretrip.create_at)',date('Y-m-d'))
                ->where('pretrip.id',$id)
                ->findAll();
        $dropLocationIdsCsv = $data['pretrip'][0]->stoppage?? '';
        if ($dropLocationIdsCsv) {
            $dropIdsArray = explode(',', $dropLocationIdsCsv);
            $stoppageNames = $this->db->table('locations')
                ->select('GROUP_CONCAT(name ORDER BY FIELD(id, ' . $dropLocationIdsCsv . ') SEPARATOR ", ") AS stoppage')
                ->whereIn('id', $dropIdsArray)
                ->get()
                ->getRow();
            $data['pretrip'][0]->dropLocations = $stoppageNames->stoppage ?? '';
        } else {
            // $data['pretrip'][0]?->dropLocations = '';
            if (isset($data['pretrip'][0])) {
                $data['pretrip'][0]->dropLocations = '';
            }
            
        }

        // $boarding = $this->picdropModel->select('pickdrops.id as pickdropid,pickdrops.*,stands.*')
        //     ->join('stands', 'stands.id = pickdrops.stand_id')
        //     ->where('trip_id', $data['pretrip'][0]->trip_id)
        //     ->where('pickdrops.type', 1)
        //     ->first();
        // $dropping = $this->picdropModel->select('pickdrops.id as pickdropid,pickdrops.*,stands.*')
        //     ->join('stands', 'stands.id = pickdrops.stand_id')
        //     ->where('trip_id', $data['pretrip'][0]->trip_id)
        //     ->where('pickdrops.type', 0)
        //     ->first();
        // $data['pretrip'][0]->boarding = $boarding->name ??"";
        // $data['pretrip'][0]->dropping = $dropping->name ??"";

        // Earliest pickup (boarding)
        $boardingList = $this->picdropModel->select('pickdrops.id as pickdropid, pickdrops.*, stands.*, stands.name as stand_name')
            ->join('stands', 'stands.id = pickdrops.stand_id')
            ->where('trip_id', $data['pretrip'][0]->trip_id)
            ->where('pickdrops.type', 1)
            ->findAll();

        $boarding = null;
        foreach ($boardingList as $item) {
            if (is_null($boarding) || strtotime($item->time) < strtotime($boarding->time)) {
                $boarding = $item;
            }
        }

        // Latest drop (dropping)
        $droppingList = $this->picdropModel->select('pickdrops.id as pickdropid, pickdrops.*, stands.*, stands.name as stand_name')
            ->join('stands', 'stands.id = pickdrops.stand_id')
            ->where('trip_id', $data['pretrip'][0]->trip_id)
            ->where('pickdrops.type', 0)
            ->findAll();

        $dropping = null;
        foreach ($droppingList as $item) {
            if (is_null($dropping) || strtotime($item->time) > strtotime($dropping->time)) {
                $dropping = $item;
            }
        }

        $data['pretrip'][0]->boarding = $boarding->name ?? "";
        $data['pretrip'][0]->dropping = $dropping->name ?? "";





        // $data['module'] =    lang("Localize.ticket_booking");
        // $data['title']  =    lang("Localize.journey_list");
        return view($this->Viewpath . '\ticket\pretripprint', $data);
    }
    public function getTripsByCompany($companyId)
    {
        $trips = $this->tripModel->select('trips.id as tripid, trips.*, schedules.*, vehicles.*, pic_location.name as pic_location_name, drop_location.name as drop_location_name')
                ->join('schedules', 'schedules.id = trips.schedule_id','left')
                ->join('vehicles', 'vehicles.id = trips.vehicle_id','left')
                ->join('locations as pic_location', 'pic_location.id = trips.pick_location_id', 'left')
                ->join('locations as drop_location', 'drop_location.id = trips.drop_location_id', 'left')
                ->where('trips.company_id', $companyId)
                ->findAll();
        echo json_encode($trips);
        exit;
    }
    public function getTripsVehicle($tripID, $companyId){
        $tripDetails = $this->tripModel
                            ->select('trips.fleet_id as fleetID')
                            ->where('trips.id', $tripID)
                            ->first();

    if ($tripDetails) {
        $fleetID = $tripDetails->fleetID;
        $VehicleDetails = $this->vehicleModel
            ->select('vehicles.*')
            ->where('fleet_id', $fleetID)
            ->where('company_id', $companyId)
            ->findAll();
        } else {
            $VehicleDetails = [];
        }
        echo json_encode($VehicleDetails);
        exit;
    }

    public function getVehicleDetails($vehicleId){
        $VehicleDetails = $this->vehicleModel
            ->select('vehicles.*, fleets.*')
            ->join('fleets', 'fleets.id = vehicles.fleet_id')
            ->where('vehicles.id', $vehicleId)
            ->first();
        echo json_encode($VehicleDetails);
        exit;
    }

    public function getDriverDetails($companyId){
        $Driver = $this->employeeModel->where('employeetype_id', 1)->where('company_id', $companyId)->findAll();
        echo json_encode($Driver);
        exit;
    }

    public function getAssistantDetails($companyId){
        $assistant = $this->employeeModel->where('employeetype_id', 2)->where('company_id', $companyId)->findAll();
        echo json_encode($assistant);
        exit;
    }
    // public function deleteHoldSeat(int $seatNumber,int $subtripId)
    // {
    //     $subtrip_id = $subtripId;

    //     if($this->temporaryBookModel->where('seat_names', $seatNumber)->where('subtrip_id',$subtrip_id)->delete()){
    //         return $this->response->setJSON([
    //             'status' => 'success',
    //             'response' => 200,
    //             'message' => true
    //         ]);    
    //     }else{
    //         return $this->response->setJSON([
    //             'status' => 'failed',
    //             'response' => 204,
    //             'message' => "Seat not unHolded"
    //         ]);            
    //     }
        
    // }
    public function deleteHoldSeat(string $seatNumber, int $subtripId)
    {
        $seatNumbers = explode(',', $seatNumber); // Convert to array

        // Build the query
        $builder = $this->temporaryBookModel->where('subtrip_id', $subtripId);

        // If multiple seat numbers, use whereIn
        if (count($seatNumbers) > 1) {
            $builder->whereIn('seat_names', $seatNumbers);
        } else {
            $builder->where('seat_names', $seatNumbers[0]);
        }

        // Execute delete
        if ($builder->delete()) {
            return $this->response->setJSON([
                'status' => 'success',
                'response' => 200,
                'message' => true
            ]);
        } else {
            return $this->response->setJSON([
                'status' => 'failed',
                'response' => 204,
                'message' => 'Seat not unHolded'
            ]);
        }
    }
    function isAlreadybooked($tripid, $subtripid, $userid, $piclocation, $droplocation, $totalseat, $seatNumbers, $journeydate)
    {
        return $this->ticketModel
            ->where('cancel_status', 0)
            ->where('trip_id', $tripid)
            ->where('subtrip_id', $subtripid)
            ->where('passanger_id', $userid)
            ->where('pick_location_id', $piclocation)
            ->where('drop_location_id', $droplocation)
            ->where('totalseat', $totalseat)
            ->where('seatnumber', $seatNumbers)
            ->where('journeydata',$journeydate)
            ->first();
    }


}
