<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]>      <html class="no-js"> <!--<![endif]-->
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title></title>
        <meta name="description" content="">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
        
    </head>
    <body>
    <?php
        $sessiondata = \Config\Services::session(); // Needed for Point 5
        $uri = service('uri');
        $menuname = $uri->getSegment(3);
  
        ?>

    <div class="container-fluid">
        <div class="row">
            <div class="col-12 ">
                <h6 class="text-center"><?php echo $sessiondata->get('logotext') ?></h6>
                <h6 class="text-center"><?php echo lang("Localize.company"). " : " ?> <?php echo $pretrip[0]->company_name??""; ?></h6>
                <h6 class="text-center"><?php echo lang("Localize.id") . ":" ?> <?php echo $pretrip[0]->pretrip_id??""; ?></h6>

                <table class="table display table-bordered  basic" id="">
                      <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col"><?php echo lang("Localize.trip") ?> </th>
                            <th scope="col"><?php echo lang("Localize.pick_up") ?> </th>
                            <th scope="col"><?php echo lang("Localize.drop") ?> </th>
                            <th scope="col"><?php echo lang("Localize.time") ?></th>
                            <!-- <th scope="col"><?php echo lang("Localize.driver") ?></th> -->
                            <!-- <th scope="col"><?php echo lang("assistace") ?> </th> -->
                            <th scope="col"><?php echo lang("Localize.bus") ?> <?php echo lang("Localize.number") ?> </th>
                            <th scope="col"><?php echo lang("Localize.seat") ?></th>
                            <th scope="col"><?php echo lang("Localize.gaslater") ?></th>
                            <th scope="col"><?php echo lang("Localize.busmeter") ?></th>
                            <th scope="col"><?php echo lang("Localize.note") ?></th>
                        </tr>
                      </thead>
                    <tbody>
                        <?php foreach ($pretrip as $kye =>  $value) : ?>   
                          
                            <tr>
                                <th scope="row"><?php echo $kye+1 ;?></th>
                                <td><?php echo $value->trip_id; ?></td>
                                <td><?php echo $value->pic_location_name; ?></td>
                                <td><?php echo $value->drop_location_name; ?></td>
                                <td><?php echo $value->start_time;  ?></td>
                                <!-- <td><?php echo $value->driverName ?></td> -->
                                <!-- <td><?php echo $value->assistanceName ?></td> -->
                                <td><?php echo $value->reg_no ?></td>
                                <td><?php echo $value->Number_of_Seats; ?></td>
                                <td><?php echo $value->gas_later; ?></td>
                                <td><?php echo $value->bus_meter; ?></td>
                                <td><?php echo $value->notes; ?></td>
                            </tr> 

                        <?php endforeach ?>
                   
                   
                    </tbody>
                </table>
                <div class="row">
                    <div class="text-left col-md-6">
                        <h6>
                            <?php echo lang("Localize.create_by"); ?> : 
                            <?php echo isset($pretrip[0]->createdBy) && $pretrip[0]->createdBy !== '' ? $pretrip[0]->createdBy : "-"; ?>
                            
                        </h6>

                        <h6><?php echo lang("Localize.driver") ?> <?php echo lang("Localize.name") ?> : <?php echo $pretrip[0]->driverName ." (". $pretrip[0]->driverphone .")"; ?></h6>
                        <h6>
                            <?php echo lang("Localize.assiatant") . " " . lang("Localize.name"); ?> : 
                            <?php 
                                if (isset($pretrip[0]->assistanceName) && isset($pretrip[0]->assistancephone)) {
                                    echo $pretrip[0]->assistanceName . " (" . $pretrip[0]->assistancephone . ")";
                                } else {
                                    echo "-";
                                }
                            ?>
                        </h6>

                        <h6 style="margin-top:50px;"><?php echo lang("Localize.driver"). " ".lang("Localize.signature");?></h6>
                        <h6><?php echo lang("Localize.assiatant")." ".lang("Localize.signature");?></h6>
                        <h6><?php echo "By ".lang("Localize.signature");?></h6>
                        <h6><?php echo "Opration"; ?></h6>
                    </div>
                    <div class="text-right col-md-6">
                        <h6><?php echo "Bus End Mater"; ?></h6>
                        <h6><?php echo "Bus Number"; ?></h6>
                    </div>
                    <div>
                        <!-- <h6><?php echo "All Points";?></h6> -->
                        <?php $allLocations = isset($pretrip[0]->dropLocations) ? explode(',', $pretrip[0]->dropLocations) : [];?>
                        <table style="width:100%; border-collapse: collapse; border: 1px solid #000;margin-top:20px">
                            <tr>
                                <th colspan="<?= count($allLocations) ?>" style="border: 1px solid #000; padding: 6px; text-align: left;">All Points</th>
                            </tr>
                            <tr>
                                <?php foreach ($allLocations as $point): ?>
                                    <td style="border: 1px solid #000; padding: 6px; text-align: center;"><?= htmlspecialchars(trim($point)) ?></td>
                                <?php endforeach; ?>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>  
        
    </body>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
    
    <script type="text/javascript">

        $(document).ready(function () {
            window.print();
        });

   </script>
</html>