<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('css') ?>
    <link href="<?php echo base_url('plugins/select2/select2.min.css'); ?>" rel="stylesheet" />
    <link rel="stylesheet" href="<?php echo base_url('public/css/customestyle.css'); ?>" type="text/css">
<?php echo $this->endSection() ?>

<?php echo $this->section('content') ?>
    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">

            <form action="<?php echo base_url(route_to('update-Subtrip', $subtrip->id)) ?>" id="employee" method="post" accept-charset="utf-8" enctype="multipart/form-data">
                <?php echo $this->include('common/securityupdate') ?>

                <input type="hidden" name="id" value="<?= esc($subtrip->id) ?>">
                <input type="hidden" id="imagepath" name="imagepath" value="<?php echo esc($subtrip->imglocation) ?>">
                <input type="hidden" id="trip_id" name="trip_id" value="<?php echo esc($subtrip->trip_id) ?>">
                <input type="hidden" name="baseurl" id="baseurl" value="<?php echo base_url() ?>">

                <div class="row justify-content-center">
                    <div class="col-12">
                        <div class="row form-group mb-2">
                            <div class="col-6">
                                <label for="pick_location_id" class="form-label"><?php echo lang("Localize.pick_up") ?> <abbr title="Required field">*</abbr></label>

                                <select class="form-select select2" name="pick_location_id" id="pick_location_id" required>
                                    <option value="">None</option>

                                    <?php
                                    foreach ($location as $locationvalue) :
                                        $checkSelected = ($locationvalue->id == $subtrip->pick_location_id) ? 'selected' : '';
                                        $checkDisabled = ($locationvalue->id == $subtrip->drop_location_id) ? 'disabled' : '';
                                    ?>
                                        <option value="<?php echo $locationvalue->id ?>" <?php echo $checkSelected . " " . $checkDisabled ?>>
                                            <?php echo $locationvalue->name ?>
                                        </option>
                                    <?php endforeach ?>

                                </select>
                            </div>

                            <div class="col-6">
                                <label for="drop_location_id" class="form-label"><?php echo lang("Localize.drop") ?> <abbr title="Required field">*</abbr></label>
                                <select class="form-select select2" name="drop_location_id" id="drop_location_id" required>
                                    <option value="">None</option>

                                    <?php
                                    foreach ($location as $locationvalue) :
                                        $checkSelected = ($locationvalue->id == $subtrip->drop_location_id) ? 'selected' : '';
                                        $checkDisabled = ($locationvalue->id == $subtrip->pick_location_id) ? 'disabled' : '';
                                    ?>
                                        <option value="<?php echo $locationvalue->id ?>" <?php echo $checkSelected . " " . $checkDisabled ?>>
                                            <?php echo $locationvalue->name ?>
                                        </option>
                                    <?php endforeach ?>

                                </select>
                            </div>
                        </div>

                        <div class="row form-group mb-2">
                            <div class="col-6">
                                <label for="stoppage" class="form-label"><?php echo lang("Localize.stoppage") ?> <?php echo lang("Localize.point") ?> <abbr title="Required field">*</abbr></label>
                                <select name="stoppage[]" id="stoppage" class="form-control" multiple>
                                    <?php
                                    foreach ($location as $dropkye => $dlocationvalue) :
                                        $checkSelected = in_array($dlocationvalue->id, $stoppage) ? 'selected' : '';
                                        $checkDisabled = in_array($dlocationvalue->id, [$subtrip->pick_location_id, $subtrip->drop_location_id]) ? 'disabled' : '';
                                    ?>

                                        <option value="<?php echo $dlocationvalue->id ?>" <?php echo $checkSelected . " " . $checkDisabled ?>>
                                            <?php echo $dlocationvalue->name ?>
                                        </option>

                                    <?php endforeach ?>

                                </select>
                            </div>

                            <!-- <div class="col-6">
                                <label for="child_fair" class="form-label"><?php echo lang("Localize.children") ?> <?php echo lang("Localize.fair") ?></label>
                                <input type="number" id="child_fair" name="child_fair" class="form-control" value="<?= old('child_fair') ?? $subtrip->child_fair ?>" min="0">
                            </div> -->
                            <div class="col-6">
                                <label for="adult_fair" class="form-label"><?php echo lang("Localize.adult") ?> <?php echo lang("Localize.fair") ?> <abbr title="Required field">*</abbr></label>
                                <input type="number" id="adult_fair" name="adult_fair" class="form-control" value="<?= old('adult_fair') ?? $subtrip->adult_fair ?>" placeholder="<?php echo lang("Localize.adult") ?> <?php echo lang("Localize.fair") ?>" min="0" required>
                            </div>
                        </div>

                        <div class="row form-group mb-2">
                            <!-- <div class="col-6">
                                <label for="special_fair" class="form-label"><?php echo lang("Localize.special") ?> <?php echo lang("Localize.fair") ?></label>
                                <input type="number" id="special_fair" name="special_fair" class="form-control" value="<?= old('special_fair') ?? $subtrip->special_fair ?>" placeholder="<?php echo lang("Localize.special") ?>  <?php echo lang("Localize.fair") ?>" min="0">
                            </div> -->
                        </div>
                        
                        <!--edit page-->
                        <!--boarding point end-->
                        <?php echo $this->include($viewpath . '/subtrip/editarrival') ?>
                        <!--boarding point end-->
                    
                    <!--droping point start-->
                <?php echo $this->include($viewpath . '/subtrip/editdeparture') ?>
                 <!--droping point end-->

                <?php if(!empty($seatsFairArr)){ ?>
                <div class="bg-light p-3 my-2">
                    <strong class="mb-1">
                        <?php echo lang("Localize.class").", " . lang("Localize.seat").", ".lang("Localize.fair"); ?>
                    </strong>
                    <?php for ($j = 0; $j < count($seatsFairArr); $j++){ ?>
                    <div class="row mb-2">
                    
                        <div class="col-4 ">
                            <label class="form-label"><?php echo lang("Localize.class"); ?>  <abbr title="Required field">*</abbr></label>
                            <input type="hidden" readonly id="seatClass<?php echo $j; ?>" name="seatClass[]" class="form-control" value="<?php echo $seatsFairArr[$j]['seatClass']; ?>" required />
                            <input type="text" readonly id="seatClassName<?php echo $j; ?>" name="seatClassName[]" class="form-control" value="<?php echo $seatsFairArr[$j]['seatClassName']; ?>" required />
                        </div>

                        <div class="col-4 ">
                            <label class="form-label"><?php echo lang("Localize.seat") ?> <abbr title="Required field">*</abbr></label>
                            <input type="text" readonly id="seatNo<?php echo $j; ?>" name="seatNo[<?php echo $j; ?>][]" class="form-control" value="<?php if(is_array($seatsFairArr[$j]['seatNo']) && !empty($seatsFairArr[$j]['seatNo'])){ echo implode(", ", $seatsFairArr[$j]['seatNo']); } ?>" required />
                        </div>

                        <div class="col-4 ">
                            <label class="form-label"><?php echo lang("Localize.fair") ?> <abbr title="Required field">*</abbr></label>
                            <input type="text" id="fares<?php echo $j; ?>" name="fares[]" class="form-control" value="<?php echo $seatsFairArr[$j]['fare']; ?>" required />
                        </div>
                    </div>
                    <?php } ?>

                </div>
                <?php } ?>
                        
                        <!--distance-->
                        <div class="col-6 mt-2">
                            <label for="adult_fair" class="form-label"><?php echo lang("Localize.distance") ?> <abbr title="Required field">*</abbr></label>
                            <input type="number" id="distance" name="distance" class="form-control" value="<?= old('distance')?? $subtrip->distance ?>" placeholder="<?php echo lang("Localize.distance") ?>" min="1" required />
                        </div>
                        
                        <!--edit page end-->

                        <div class="row form-group my-4">

                            <?php if ($subtrip->show == 1) : ?>
                                <div class="col-12">
                                    <label for="show" class="form-label"><?php echo lang("Localize.show_in_home_page") ?></label>
                                    <div class="form-check mt-1">
                                        <input class="form-check-input" type="checkbox" value="1" id="show" name="show" checked>
                                        <label class="form-check-label" for="show">
                                            <?php echo lang("Localize.show_in_home_page") ?>
                                        </label>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div id="picsection">
                                        <label for="picsection" class="form-label"><?php echo lang("Localize.trip") ?> <?php echo lang("Localize.image") ?></label>
                                        <div id="editsubtripimage"></div>
                                    </div>
                                </div>
                            <?php else : ?>
                                <div class="col-12">
                                    <label for="show" class="form-label"><?php echo lang("Localize.show_in_home_page") ?></label>
                                    <div class="form-check mt-1">
                                        <input class="form-check-input" type="checkbox" value="1" id="show" name="show">
                                        <label class="form-check-label" for="show">
                                            <?php echo lang("Localize.show_in_home_page") ?>
                                        </label>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div id="picsection">
                                        <label for="picsection" class="form-label"><?php echo lang("Localize.trip") ?> <?php echo lang("Localize.image") ?></label>
                                        <div id="editsubtripimage"></div>
                                    </div>
                                </div>
                            <?php endif ?>
                        </div>

                        <div class="row form-group mt-2">
                            <div class="col-12">
                                <label for="status" class="form-labe mt-3">
                                    <?php echo lang("Localize.trip") ?> <?php echo lang("Localize.status") ?>
                                    <abbr title="Required field">*</abbr>
                                </label>

                                <div class="status-radio">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="status" id="active" value="1" <?php if ($subtrip->status == 1) : ?>checked<?php endif ?>>
                                        <label class="form-check-label" for="active"><?php echo lang("Localize.active") ?></label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="status" value="0" id="disable" <?php if ($subtrip->status == 0) : ?>checked<?php endif ?>>
                                        <label class="form-check-label" for="disable"><?php echo lang("Localize.disable") ?></label>
                                    </div>
                                </div>
                            </div>

                            <div class="text-danger my-2">
                                <?php if (isset($validation)) : ?>
                                    <?= $validation->listErrors(); ?>
                                <?php endif ?>
                            </div>

                            <div class="col-12 text-center">
                                <button type="submit" class="btn btn-success"><?php echo lang("Localize.submit") ?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php echo $this->endSection() ?>

<?php echo $this->section('js') ?>
    <script src="<?php echo base_url('plugins/select2/select2.min.js'); ?>"></script>
    <script src="<?php echo base_url('public/js/dynamicinput.js'); ?>"></script>
<?php echo $this->endSection() ?>