<?php

namespace App\Libraries\DeleteData\SoftwareSettings;

use App\Libraries\DeleteData\DeleteData;
use Modules\Company\Models\CompanyModel;

class Company extends DeleteData
{
    public function __construct()
    {
        $this->title = 'companies';
        $this->model = new CompanyModel;
        $this->model->select('*');
    }

    public function deleteCallback(string $table, array $deleteData = [])
    {
        $db = \Config\Database::connect();

        if ($table == 'companies') {
            foreach ($deleteData as $company) {
                $db->table('users')
                    ->where('id', $company->user_id)
                    ->set('deleted_at', date('Y-m-d H:i:s'))
                    ->update();
            }
        }
    }
}
