<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>
    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">
            <form action="<?php echo base_url(route_to('update-company-cancellation', $logged_user_id, $logged_company_id)) ?>" id="employee" method="post" class="row g-3" accept-charset="utf-8" enctype="multipart/form-data">
                <?php echo $this->include('common/securityupdate') ?>
                <input type="hidden" id="baseurl" name="baseurl" value="<?php echo base_url(); ?>">
                <input type="hidden" name="user_id" id="user_id" class="form-control" value="<?php echo $logged_user_id; ?>">
                
                <div class="row">
                    
                    <div class="col-12">
                        <?php if($list_available > 0){ ?>
                            
                            <div id="addedExtraHoursDiv">
                                <?php foreach ($cancellationlist as $index => $list) { ?>
                                    
                                    <div class="row <?php if($index > 0){ echo ''; } ?>">
                                        <div class="col-4 mt-3">
                                            <label class="form-label"><?php echo lang("Localize.hours") ?><abbr title="Required field">*</abbr></label>
                                            <input type="text" name="hours[]" class="form-control" value="<?php echo $list->hours; ?>">
                                            <?php if (isset($validation) && $validation->hasError('hours')): ?>
                                                <div class="text-danger"><?= $validation->getError('hours') ?></div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-4 mt-3">
                                            <label class="form-label"><?php echo lang("Localize.charges") ?> (%)<abbr title="Required field">*</abbr></label>
                                            <input type="text" name="charges[]" class="form-control" value="<?php echo $list->charges; ?>">
                                            <?php if (isset($validation) && $validation->hasError('charges')): ?>
                                                <div class="text-danger"><?= $validation->getError('charges') ?></div>
                                            <?php endif; ?>
                                        </div>
                                        <?php if($index == 0){ ?>
                                            <div class="col-4 mt-3">
                                                <label style="display:block;" class="form-label">&nbsp;</label>
                                                <a class="btn btn-primary mb-3" href="#" id="addMoreBtn"><i class="fas fa-plus"></i> Add More</a>
                                            </div>
                                        <?php } else { ?>
                                            <div class="col-4 mt-3">
                                                <label style="display:block;" class="form-label">&nbsp;</label>
                                                <button type="button" class="btn btn-danger deleteBtn"><?php echo lang("Localize.c_delete") ?></button>
                                            </div>
                                        <?php } ?>
                                    </div>
                                <?php } ?>
                            </div>
                        <?php } else { ?>
                            <div class="row">
                                <div class="col-4 mt-3">
                                    <label class="form-label"><?php echo lang("Localize.hours") ?><abbr title="Required field">*</abbr></label>
                                    <input type="text" name="hours[]" class="form-control">
                                    <?php if (isset($validation) && $validation->hasError('hours')): ?>
                                        <div class="text-danger"><?= $validation->getError('hours') ?></div>
                                    <?php endif; ?>
                                </div>
                                <div class="col-4 mt-3">
                                    <label class="form-label"><?php echo lang("Localize.charges") ?> (%)<abbr title="Required field">*</abbr></label>
                                    <input type="text" name="charges[]" class="form-control">
                                    <?php if (isset($validation) && $validation->hasError('charges')): ?>
                                        <div class="text-danger"><?= $validation->getError('charges') ?></div>
                                    <?php endif; ?>
                                </div>
                                <div class="col-4 mt-3">
                                    <label style="display:block;" class="form-label">&nbsp;</label>
                                    <a class="btn btn-primary mb-3" href="#" id="addMoreBtn"><i class="fas fa-plus"></i> Add More</a>
                                </div>
                            </div>
                            <div id="addedExtraHoursDiv">
                            </div>
                        <?php } ?>
                        <div class="row extraFieldsTemplate" style="display:none;">
                            <div class="col-4 mt-3">
                                <label for="hours" class="form-label"><?php echo lang("Localize.hours") ?><abbr title="Required field">*</abbr></label>
                                <input type="text" name="hours[]" class="form-control">
                            </div>
                            <div class="col-4 mt-3">
                                <label for="charges" class="form-label"><?php echo lang("Localize.charges") ?> (%)<abbr title="Required field">*</abbr></label>
                                <input type="text" name="charges[]" class="form-control">
                            </div>
                            <div class="col-4 mt-3">
                                <label style="display:block;" class="form-label">&nbsp;</label>
                                <button type="button" class="btn btn-danger deleteBtn"><?php echo lang("Localize.c_delete") ?></button>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 mt-3">
                                <button type="submit" class="btn btn-success"><?php echo lang("Localize.update") ?></button>
                                <a href="<?php echo base_url(route_to('clear-company-cancellation', $logged_company_id)) ?>" class="btn btn-danger"><?php echo lang("Localize.clear_all_policy") ?></a>
                            </div>
                        </div>
                    </div>

                </div>

            </form>
        </div>
    </div>
    <script>
        document.getElementById('addMoreBtn').addEventListener('click', function (e) {
            e.preventDefault();

            // Clone the template
            var newFields = document.querySelector('.extraFieldsTemplate').cloneNode(true);
            
            var inputs = newFields.querySelectorAll('input');
            inputs.forEach(function(input) {
                input.value = ''; // Clear the input value
            });

            newFields.style.display = 'flex'; // Show the cloned fields

            // Append to the container
            document.getElementById('addedExtraHoursDiv').appendChild(newFields);

            // Add event listener for delete button
            newFields.querySelector('.deleteBtn').addEventListener('click', function () {
                newFields.remove(); // Remove the current set of fields
            });
        });
        document.getElementById('addedExtraHoursDiv').addEventListener('click', function (e) {
            if (e.target && e.target.classList.contains('deleteBtn')) {
                // Remove the row containing the clicked delete button
                e.target.closest('.row').remove();
            }
        });
    </script>
<?php echo $this->endSection() ?>