<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>
    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">

            <?php if ($add_data == true) : ?>
                <div class="text-end">
                    
                    <?php if (true && false) : ?>
                        <?php if (!isset($trash_view)) : ?>
                            <a class="btn btn-warning me-1" href="<?php echo base_url(route_to('trash-index-employee')) ?>">
                                <i class="fas fa-trash-restore"></i>
                                <?php echo lang("Localize.view_deleted") ?>
                            </a>
                        <?php else : ?>
                            <a class="btn btn-info me-1" href="<?php echo base_url(route_to('index-employee')) ?>">
                                <i class="fas fa-list"></i>
                                <?php echo lang("Localize.view_all") ?>
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>

                    <a class="btn btn-success" href="<?php echo base_url(route_to('new-employee')) ?>">
                        <i class="fas fa-user-tie"></i><sup><i class="fas fa-plus small"></i></sup>
                        <?php echo lang("Localize.add_employee") ?>
                    </a>
                </div>
            <?php endif ?>

            <input type="hidden" id="csrf_token" name="<?php echo csrf_token(); ?>" value="<?php echo csrf_hash(); ?>">
            <div class="table-responsive">
                <table class="table display table-bordered table-striped table-hover basic" id="employeelist">
                    <thead>
                        <tr>
                            <th scope="col">#</th>
                            <?php if($logged_role_id == 1){ ?>
                            <th scope="col"><?php echo lang("Localize.company") ?></th>
                            <?php } ?>
                            <th scope="col"><?php echo lang("Localize.name") ?></th>
                            <th scope="col"><?php echo lang("Localize.email") ?></th>
                            <th scope="col"><?php echo lang("Localize.mobile") ?></th>
                            <th scope="col"><?php echo lang("Localize.type") ?></th>
                            <th scope="col"><?php echo lang("Localize.action") ?></th>
                        </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php echo $this->include('common/datatable_default_lang_change') ?>
    <?php echo $this->include('common/confirmation-modal') ?>
<?php echo $this->endSection() ?>

<?php echo $this->section('js') ?>
<script>
    $(document).ready(function() {
        // Destroy existing DataTable instance if it exists
        if ($.fn.DataTable.isDataTable('#employeelist')) {
            $('#employeelist').DataTable().destroy();
        }

        // Get companyname for export titles
        var companyname = $('#logotext').text().trim() || '<?php echo lang("Localize.company"); ?>';

        // Build columns array based on role
        var columns = [
            { data: "index", orderable: false }
        ];

        <?php if($logged_role_id == 1){ ?>
        columns.push({ data: "company_name" });
        <?php } ?>

        columns.push(
            { data: "name" },
            { data: "email" },
            { data: "phone" },
            { data: "type" },
            { data: "action", orderable: false, searchable: false }
        );

        // Initialize DataTables with server-side processing
        $('#employeelist').DataTable({
            processing: true,
            serverSide: true,
            order: [[0, 'desc']],
            lengthMenu: [[10, 15, 20, 25, 30, 40, 50, -1], [10, 15, 20, 25, 30, 40, 50, "All"]],
            pageLength: 10,
            language: {
                lengthMenu: lengthMenu,
                zeroRecords: zeroRecords,
                info: info,
                infoEmpty: infoEmpty,
                infoFiltered: infoFiltered,
                search: search,
                paginate: {
                    first: first,
                    previous: previous,
                    next: next,
                    last: last
                }
            },
            ajax: {
                url: "<?= base_url(route_to('server-list-employee')); ?>",
                type: "POST",
                data: function(d) {
                    // Add CSRF token to the request data
                    var csrfToken = $('#csrf_token').val() || $('input[name="<?php echo csrf_token(); ?>"]').val();
                    if (csrfToken) {
                        d.<?php echo csrf_token(); ?> = csrfToken;
                    }
                    return d;
                },
                beforeSend: function(xhr) {
                    // Set CSRF token in header
                    var csrfToken = $('#csrf_token').val() || $('input[name="<?php echo csrf_token(); ?>"]').val();
                    if (csrfToken) {
                        xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken);
                        xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
                    }
                },
                dataSrc: 'data',
                error: function(xhr, error, code) {
                    console.error("DataTables AJAX Error:", error, code);
                    console.error("Response:", xhr.responseText);
                    if (xhr.status === 403) {
                        alert("CSRF token validation failed. Please refresh the page and try again.");
                    }
                }
            },
            buttons: [
                {
                    extend: 'copy',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: <?php echo $logged_role_id == 1 ? '[0,1,2,3,4,5]' : '[0,1,2,3,4]'; ?>}
                },
                {
                    extend: 'csv',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: <?php echo $logged_role_id == 1 ? '[0,1,2,3,4,5]' : '[0,1,2,3,4]'; ?>}
                },
                {
                    extend: 'excel',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: <?php echo $logged_role_id == 1 ? '[0,1,2,3,4,5]' : '[0,1,2,3,4]'; ?>}
                },
                {
                    extend: 'pdf',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: <?php echo $logged_role_id == 1 ? '[0,1,2,3,4,5]' : '[0,1,2,3,4]'; ?>}
                },
                {
                    extend: 'print',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: <?php echo $logged_role_id == 1 ? '[0,1,2,3,4,5]' : '[0,1,2,3,4]'; ?>}
                }
            ],
            columns: columns,
            responsive: true,
            dom: 'lBfrtip',
            initComplete: function () {
                var api = this.api();
                console.log("Employee DataTables initialized. Columns:", api.columns().count());
            },
            drawCallback: function(settings) {
                console.log("Employee DataTables draw callback fired");
            }
        });

    });
</script>
<?php echo $this->endSection() ?>