<?php echo $this->extend('template/admin/main') ?>



<?php echo $this->section('content') ?>



    <?php echo $this->include('common/message') ?>



    <div class="card">

        <div class="card-header">

            <div class="row align-items-center">

                <div class="col">

                    <h5 class="card-title mb-0">Create New Notification</h5>

                </div>

                <div class="col-auto">

                    <a href="<?php echo base_url(route_to('index-notification')) ?>" class="btn btn-secondary">

                        <i class="fas fa-arrow-left"></i> Back to List

                    </a>

                </div>

            </div>

        </div>

        <div class="card-body">

            <form action="<?php echo base_url(route_to('create-notification')) ?>" method="post" class="row g-3" accept-charset="utf-8">

                <?php echo $this->include('common/security') ?>



                <div class="col-12">

                    <label for="subject" class="form-label">Subject <span class="text-danger">*</span></label>

                    <input type="text" class="form-control" id="subject" name="subject" 

                           value="<?php echo old('subject') ?>" required>

                    <?php if (isset($validation) && $validation->hasError('subject')) : ?>

                        <div class="text-danger"><?php echo $validation->getError('subject') ?></div>

                    <?php endif ?>

                </div>



                <div class="col-12">

                    <label for="message" class="form-label">Message <span class="text-danger">*</span></label>

                    <textarea class="form-control" id="message" name="message" rows="5" required><?php echo old('message') ?></textarea>

                    <div class="form-text">Write the notification message that will be sent to users.</div>

                    <?php if (isset($validation) && $validation->hasError('message')) : ?>

                        <div class="text-danger"><?php echo $validation->getError('message') ?></div>

                    <?php endif ?>

                </div>



                <div class="col-md-6">

                    <label for="target_group" class="form-label">Target Group <span class="text-danger">*</span></label>

                    <select class="form-select" id="target_group" name="target_group" required onchange="toggleTripSelection()">

                        <option value="">Select Target Group</option>

                        <option value="all_users" <?php echo old('target_group') == 'all_users' ? 'selected' : '' ?>>All Users</option>

                        <option value="specific_trip" <?php echo old('target_group') == 'specific_trip' ? 'selected' : '' ?>>Passengers of Specific Trip</option>

                    </select>

                    <?php if (isset($validation) && $validation->hasError('target_group')) : ?>

                        <div class="text-danger"><?php echo $validation->getError('target_group') ?></div>

                    <?php endif ?>

                </div>



                <div class="col-md-6" id="trip_selection" style="display: none;">

                    <label for="trip_id" class="form-label">Select Trip</label>

                    <select class="form-select" id="trip_id" name="trip_id">

                        <option value="">Select Trip</option>

                        <?php foreach ($trips as $trip) : ?>

                            <option value="<?php echo $trip->id ?>" <?php echo old('trip_id') == $trip->id ? 'selected' : '' ?>>

                                <?= $trip->picklocation ?> ➔ <?= $trip->droplocation ?><?php echo "( ". $trip->id. " )" ?>

                            </option>
                            

                        <?php endforeach ?>

                    </select>

                    <div class="form-text">Select the trip whose passengers will receive this notification.</div>

                </div>



                <div class="col-md-6">

                    <label for="notification_date" class="form-label">Notification Date & Time <span class="text-danger">*</span></label>

                    <input type="datetime-local" class="form-control" id="notification_date" name="notification_date" 

                           value="<?php echo old('notification_date') ?>" required>

                    <div class="form-text">When should this notification be sent?</div>

                    <?php if (isset($validation) && $validation->hasError('notification_date')) : ?>

                        <div class="text-danger"><?php echo $validation->getError('notification_date') ?></div>

                    <?php endif ?>

                </div>



                <div class="col-md-6">

                    <label for="repeat_option" class="form-label">Repeat Option</label>

                    <select class="form-select" id="repeat_option" name="repeat_option">

                        <option value="none" <?php echo old('repeat_option') == 'none' ? 'selected' : '' ?>>No Repeat</option>

                        <option value="daily" <?php echo old('repeat_option') == 'daily' ? 'selected' : '' ?>>Daily</option>

                        <option value="weekly" <?php echo old('repeat_option') == 'weekly' ? 'selected' : '' ?>>Weekly</option>

                        <option value="monthly" <?php echo old('repeat_option') == 'monthly' ? 'selected' : '' ?>>Monthly</option>

                    </select>

                    <div class="form-text">Should this notification repeat automatically?</div>

                </div>





                <div class="col-12">

                    <div class="form-check">

                        <input class="form-check-input" type="checkbox" id="send_immediately" name="send_immediately" value="1">

                        <label class="form-check-label" for="send_immediately">

                            Send Immediately

                        </label>

                        <div class="form-text">Check this to send the notification right now, ignoring the scheduled date.</div>

                    </div>

                </div>



                <div class="col-12">

                    <hr>

                    <div class="d-flex justify-content-between">

                        <a href="<?php echo base_url(route_to('index-notification')) ?>" class="btn btn-secondary">Cancel</a>

                        <button type="submit" class="btn btn-success">

                            <i class="fas fa-save"></i> Create Notification

                        </button>

                    </div>

                </div>

            </form>

        </div>

    </div>



<script>

function toggleTripSelection() {

    var targetGroup = document.getElementById('target_group').value;

    var tripSelection = document.getElementById('trip_selection');

    var tripSelect = document.getElementById('trip_id');

    

    if (targetGroup === 'specific_trip') {

        tripSelection.style.display = 'block';

        tripSelect.required = true;

    } else {

        tripSelection.style.display = 'none';

        tripSelect.required = false;

        tripSelect.value = '';

    }

}



// Initialize on page load

document.addEventListener('DOMContentLoaded', function() {

    toggleTripSelection();

    

    // Set minimum date to current date/time

    var now = new Date();

    now.setMinutes(now.getMinutes() - now.getTimezoneOffset());

    document.getElementById('notification_date').min = now.toISOString().slice(0, 16);

});



// Handle send immediately checkbox

document.getElementById('send_immediately').addEventListener('change', function() {

    var notificationDate = document.getElementById('notification_date');

    var repeatOption = document.getElementById('repeat_option');

    

    if (this.checked) {

        notificationDate.disabled = true;

        repeatOption.disabled = true;

        repeatOption.value = 'none';

    } else {

        notificationDate.disabled = false;

        repeatOption.disabled = false;

    }

});

</script>



<?php echo $this->endSection() ?>

