<?php echo $this->extend('template/admin/main') ?>
<?php echo $this->section('content') ?>
<?php echo $this->include('common/message') ?>

<style>
    .trip-group {
        display: flex;
        align-items: center;
        font-weight: bold;
        padding: 8px;
        background-color: #f8f9fa;
        border-radius: 5px;
        margin-bottom: 5px;
    }

    .subtrip-container {
        margin-left: 20px;
        padding-left: 10px;
        border-left: 2px solid #ccc;
        max-height: 150px; /* Set a max height for scrolling */
        overflow-y: auto;
    }

    #tripContainer {
        max-height: 300px; /* Set a height for scrolling */
        overflow-y: auto;
        padding: 10px;
        border: 1px solid #ddd;
        border-radius: 5px;
        background-color: #fff;
    }

    /* Style checkboxes */
    input[type="checkbox"] {
        margin-right: 8px;
        transform: scale(1.2);
        cursor: pointer;
    }

</style>

<div class="card mb-4">
    <div class="card-body">
        <div class="sp3 mb-5">
            <form action="<?php echo base_url(route_to('datatickesell-report')) ?>" id="ticketSoldReport" method="post">
                <?php echo $this->include('common/security') ?>
                <input type="hidden" name="baseurl" id="baseurl" value="<?php echo base_url() ?>" />
    
                <div class="row mb-2">
                    
                       
                    <?php if ($role_id == 1) : ?>
                        <div class="col-4" style="display:none;">
                            <label for="r_company_id" class="form-label"><?php echo lang("Localize.company") ?></label>
                            <select id="r_company_id" name="company_id" class="form-select">
                                <option value="all"><?php echo ucfirst(lang("Localize.all")) ?></option>
                                <?php foreach ($companies as $company) : ?>
                                    <?php $select = ""; if(isset($s_company_id)){ if($s_company_id == $company->id){ $select = "selected"; }} ?>
                                    <option <?php echo $select; ?> value="<?php echo $company->id; ?>">
                                        <?php echo $company->name; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    <?php else : ?>
                        
                        <input type="hidden" id="r_company_id" name="company_id" value="<?php echo session()->get('company_id'); ?>">
                    <?php endif; ?>

                    <?php if ($role_id == 1) : ?>
                        <div class="col-4">
                            <label for="report_company_id" class="form-label"><?php echo lang("Localize.company") ?></label>
                            <select id="report_company_id" name="company_id" class="form-select">
                                <option value="all"><?php echo ucfirst(lang("Localize.all")) ?></option>
                                <?php foreach ($companies as $company) : ?>
                                    <?php $select = ""; if(isset($s_company_id)){ if($s_company_id == $company->id){ $select = "selected"; }} ?>
                                    <option <?php echo $select; ?> value="<?php echo $company->id; ?>">
                                        <?php echo $company->name; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    <?php else : ?>
                        
                        <input type="hidden" id="report_company_id" name="company_id" value="<?php echo session()->get('company_id'); ?>">
                    <?php endif; ?>
                    
                    <div class="col-4">
                        <input type="hidden" name="selectedMainTrips" id="selectedMainTrips" value="<?= htmlspecialchars(json_encode($selectedMainTrips), ENT_QUOTES, 'UTF-8') ?>" />
                        <input type="hidden" name="selectedSubTrips" id="selectedSubTrips" value="<?= htmlspecialchars(json_encode($selectedSubTrips), ENT_QUOTES, 'UTF-8') ?>" />
                        <label for="report_trip" class="form-label"><?php echo lang("Localize.trip") ?></label>
                        <div id="tripContainer"></div>
                    </div>


                    <div class="col-4" style="display:none;">
                        <label for="r_trip_id" class="form-label"><?php echo lang("Localize.main") ?> <?php echo lang("Localize.trip") ?></label>
                        <select id="r_trip_id" name="trip_id" class="form-select" required>

                        <option <?php $tripallselect = ""; if(isset($s_trip_id)){ if($s_trip_id == "all"){ $tripallselect = "selected"; }} echo $tripallselect; $tripallselect = ""?> value="all">All</option>
                            <?php if (!empty($trip_list) && is_array($trip_list)) : foreach ($trip_list as $l_trip) : ?>
                                <?php $select = ""; if(isset($s_trip_id)){ if($s_trip_id == $l_trip->tripid){ $select = "selected"; }} ?>
                                <option <?php echo $select; ?> value="<?php echo $l_trip->tripid; ?>">
                                    <?php echo $l_trip->pickup_location_name ." - ". $l_trip->drop_location_name . " (".$l_trip->start_time." - " .$l_trip->end_time. ")"; ?>
                                </option>
                            <?php endforeach;  endif; ?>
                        </select>
                    </div>
    
                    <div class="col-4" style="display:none;">
                        <label for="r_subtrip_id" class="form-label"><?php echo lang("Localize.sub") ?> <?php echo lang("Localize.trip") ?></label>
                        <select id="r_subtrip_id" name="subtrip_id" class="form-select" required>
                            <option <?php $subtripallselect = ""; if(isset($s_subtrip_id)){ if($s_subtrip_id == "all"){ $subtripallselect = "selected"; }} echo $subtripallselect; $subtripallselect = ""?> value="all">All</option>
                            <?php foreach ($subtrip_list as $l_subtrip) : ?>
                                <?php $select = ""; if(isset($s_subtrip_id)){ if($s_subtrip_id == $l_subtrip->subtripsid){ $select = "selected"; }} ?>
                                <option <?php echo $select; ?> value="<?php echo $l_subtrip->subtripsid; ?>">
                                    <?php echo $l_subtrip->pickup_location_name ." - ". $l_subtrip->drop_location_name; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
    
                    
                </div>
    
                <div class="row mb-2">
                    <div class="col-4">
                        <label for="type" class="form-label"><?php echo lang("Localize.ticket") ?> <?php echo lang("Localize.type") ?></label>
                        <select id="type" name="type" class="form-select" required>
                            <option <?php if($ticketType == "normal"){ echo "selected"; } ?> value="normal"><?php echo lang("Localize.sold") ?> <?php echo lang("Localize.ticket") ?> </option>
                            <option <?php if($ticketType == "refund"){ echo "selected"; } ?> value="refund"><?php echo lang("Localize.refund") ?> <?php echo lang("Localize.ticket") ?> </option>
                            <option <?php if($ticketType == "cancel"){ echo "selected"; } ?> value="cancel"><?php echo lang("Localize.cancel") ?> <?php echo lang("Localize.ticket") ?> </option>
                        </select>
                    </div>
                    <div class="col-4">
                        
                        <label for="start_date" class="form-label"><?php echo lang("Localize.from") ?></label>
                        <div class="input-append date datepicker" id="start_date"  data-date-format="yyyy-mm-dd">
                            <input size="16" type="text" name="start_date" class="form-control" value="<?php if(isset($s_startdate) && $s_startdate != ""){ echo date("Y-m-d", strtotime($s_startdate)); } else { echo date('Y-m-01'); }?>"  required readonly>
                            <span class="add-on"><i class="icon-th"></i></span>
                        </div>
                    </div>
                    <div class="col-4">
                        <?php //echo $this->include('common/filter/daterangeto') ?>
                        <label for="end_date" class="form-label"><?php echo lang("Localize.to") ?></label>
                        <div class="input-append date datepicker" id="end_date" data-date-format="yyyy-mm-dd">
                            <input size="16" type="text" name="end_date" class="form-control" value="<?php if(isset($s_enddate) && $s_enddate != ""){ echo date("Y-m-d", strtotime($s_enddate)); } else { echo date('Y-m-d'); }?>"  required readonly>
                            <span class="add-on"><i class="icon-th"></i></span>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-success"><?php echo lang("Localize.submit") ?></button>
            </form>
        </div>

        <div class="table-responsive">
            <table class="table display table-bordered table-striped table-hover basic" id="ticketsoldreport">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        
                        <?php if(session()->get('role_id') == 1){ ?>
                            <th scope="col"><?php echo lang("Localize.company") ?></th>
                        <?php } ?>
                        <th scope="col"><?php echo lang("Localize.booking") ?> <?php echo lang("Localize.id") ?> </th>
                        <th scope="col"><?php echo lang("Localize.booking") ?> <?php echo lang("Localize.date") ?></th>
                        <?php if($ticketType == "refund"){ ?>
                            <th scope="col"><?php echo lang("Localize.refund") ?> <?php echo lang("Localize.date") ?></th>
                        <?php } else if($ticketType == "cancel") {?>
                            <th scope="col"><?php echo lang("Localize.cancel") ?> <?php echo lang("Localize.date") ?></th>
                        <?php } ?>
                        <th scope="col"><?php echo lang("Localize.journey") ?> <?php echo lang("Localize.date") ?></th>
                        <th scope="col"><?php echo lang("Localize.main") ?> <?php echo lang("Localize.trip") ?> </th>
                        <th scope="col"><?php echo lang("Localize.sub") ?> <?php echo lang("Localize.trip") ?> </th>
                        <th scope="col"><?php echo lang("Localize.total") ?> <?php echo lang("Localize.seat") ?></th>
                        <th scope="col"><?php echo lang("Localize.seat") ?> <?php echo lang("Localize.number") ?></th>
                        
                        <!-- <th scope="col"><?php echo lang("Localize.coupon") ?></th> -->
                        <th scope="col"><?php echo "Type of ticket";//lang("Localize.coupon") ?></th>
                        
                        <th scope="col"><?php echo lang("Localize.price") ?></th>

                        <th scope="col"><?php echo lang("Localize.discount")." ".lang("Localize.type"); ?></th>

                        <th scope="col"><?php echo lang("Localize.discount")." ".lang("Localize.amount") ?></th>
                        <th scope="col"><?php echo lang("Localize.tax") ?></th>
                        <th scope="col"><?php echo "Net ".lang("Localize.price") ?></th>

                        <?php if($ticketType == "refund" || $ticketType == "cancel"){ ?>
                                <th scope="col"><?php echo "Fees Amount"; //lang("Localize.price") ?></th>
                                <?php if($ticketType == "refund"){?>
                                    <th scope="col"><?php echo "Refund Details" //lang("Localize.price") ?></th>
                                <?php } ?>
                        <?php } ?>
                        
                        
                        <th scope="col"><?php echo lang("Localize.booked_by") ?></th>
                        <th scope="col"><?php echo lang("Localize.booked_user_name") ?></th>
                    </tr>
                </thead>
                <tbody>

                    <?php foreach ($ticket as $kye =>  $value) : ?>
                        <tr>
                            <th scope="row"><?php echo $kye + 1; ?></th>
                            <?php if(session()->get('role_id') == 1){ ?>
                                <td><?php echo $value->company_name; ?></td>
                            <?php } ?>
                            <td><?php echo $value->booking_id; ?></td>
                            <td><?php echo $value->date; ?></td>
                            <?php if($ticketType == "refund"){ ?>
                                <td><?php echo $value->refund_date; ?></td>
                            <?php } else if($ticketType == "cancel") {?>
                                <td><?php echo $value->cancel_date; ?></td>
                            <?php } ?>
                            <td><?php echo date('Y-m-d', strtotime($value->journeydata)); ?></td>
                            <td>
                            <?php echo $value->tripid; ?> - <?php echo $value->pickup_location_name; ?> - <?php echo $value->drop_location_name; ?>
                                (<?php echo $value->start_time; ?> - <?php echo $value->end_time; ?>)
                            </td>
                            <td><?php echo $value->sub_pickup_location_name; ?> - <?php echo $value->sub_drop_location_name; ?></td>
                            <td class="text-end"><?php echo $value->totalseat; ?></td>
                            <td><?php echo $value->seatnumber; ?></td>

                            <!-- <td class="text-end"><?php echo $value->offerer; ?></td> -->
                            <td class="text-end">
                                <?php
                                    if($value->bookby_user_type == "passanger"){
                                        echo "Online";
                                    } else {
                                        echo "Offline";
                                    }
                                ?>
                            </td>

                            <td class="text-end"><?php echo $value->price; ?></td>
                            <td class="text-end">
                                <?php 
                                    $discount_type = "";
                                    if($value->roundtrip_discount > 0){
                                        $discount_type = "Round Trip";
                                    } else if($value->offerer != ""){
                                        $discount_type = "Coupon - ". $value->offerer;
                                    } else if($value->offerer == "" && $value->roundtrip_discount == 0 && $value->discount > 0){
                                        $discount_type = "Direct Discount";
                                    }
                                    echo $discount_type;
                                ?>
                            </td>


                            <td class="text-end"><?php echo $value->discount; ?></td>
                            <td class="text-end"><?php echo $value->totaltax; ?></td>
                            <td class="text-end"><?php echo $value->paidamount; ?></td>
                            <?php if($ticketType == "refund" || $ticketType == "cancel"){ ?>
                                <td class="text-end"><?php echo $value->refund_cancel_fee; ?></td>
                                <?php if($ticketType == "refund"){?>
                                    <th scope="col"><?php echo $value->refund_details; //lang("Localize.price") ?></th>
                                <?php } ?>
                            <?php } ?>
                            
                            
                            <td class="text-end"><?php echo $value->bookby_user_type; ?></td>
                            <td class="text-end">
                                <?php 
                                if($value->bookby_user_type == "Agent"){ 
                                    echo $value->agent_fname . " " . $value->agent_lname;
                                } else { 
                                    echo $value->booked_by_f_name . " " . $value->booked_by_l_name;
                                } ?></td>
                        </tr>
                    <?php endforeach ?>

                </tbody>
                <tfoot>
                    <tr>
                        <th scope="row" colspan="7" class="text-end"><?php echo lang("Localize.total") ?></th>
                        <td class="text-end"> <?php echo array_sum(array_column($ticket, 'totalseat'));; ?></td>
                        <td></td>
                        <td></td>
                        <td class="text-end"><?php echo $currency_symbol; ?> <?php echo array_sum(array_column($ticket, 'price'));; ?></td>
                        <td></td>
                        <td class="text-end"><?php echo $currency_symbol; ?> <?php echo array_sum(array_column($ticket, 'discount'));; ?></td>
                        <td class="text-end"><?php echo $currency_symbol; ?> <?php echo array_sum(array_column($ticket, 'totaltax'));; ?></td>
                        <td class="text-end"><?php echo $currency_symbol; ?> <?php echo array_sum(array_column($ticket, 'paidamount'));; ?></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
<?php echo $this->section('js') ?>
    <script src="<?php echo base_url('public/js/jquery.sumoselect.min.js'); ?>"></script>
    <script src="<?php echo base_url('public/js/dynamicinput.js'); ?>"></script>
    <script src="<?php echo base_url('public/plugins/select2/select2.min.js'); ?>"></script>
<?php echo $this->endSection() ?>

<?php echo $this->include('common/datatable_default_lang_change') ?>
<?php echo $this->endSection() ?>