<?php

/**
 * @var \App\Libraries\Rolepermission $rolepermissionLibrary
 * @var string $menuname Current menuname
 */

$offer_management = "offer_management";
$offer_result = $rolepermissionLibrary->menu($offer_management);

$session = session();
$role_id = $session->get('role_id');
$logged_user_id = $session->get('user_id');
$logged_company_id = 0;
if($role_id == "7"){
    $logged_company_id = $session->get('company_id');
}

?>

<?php if ($offer_result == true) : ?>
    <!-- Offer Management menu -->
    <li class="<?php echo ($menuname == "offers") ? "mm-active" : ""  ?>">
        <a class="has-arrow material-ripple" href="#">
            <i class="fas fa-gift"></i>
            <?php echo lang("Localize.offer_management"); ?>
        </a>

        <ul class="nav-second-level">

            <?php
            $add_offer = "add_offer";
            $add_offer_result = $rolepermissionLibrary->read($add_offer);
            ?>

            <li>
                <a href="<?php echo base_url(route_to('new-offer')) ?>">
                    
                    <?php echo lang("Localize.create").lang("Localize.offer");?>
                </a>
            </li>

            <li>
                <a href="<?php echo base_url(route_to('index-offer')) ?>">
                    <?php echo lang("Localize.all").lang("Localize.offer");?>
                </a>
            </li>

        </ul>

    </li>
    <!-- Offer Management menu -->
<?php endif ?>
