<?php

namespace Modules\Trip\Controllers;

use App\Controllers\BaseController;
use Modules\Trip\Models\RoundtripdiscoundModel;
use App\Libraries\Rolepermission;
use Modules\Company\Models\CompanyModel;

class Roundtripdiscount extends BaseController
{
    protected $Viewpath;
	protected $roundtripdiscountModel;
	protected $companyModel;
	
	protected $db;
	
	public function __construct()
    {

        $this->Viewpath = "Modules\Trip\Views";
		$this->roundtripdiscountModel = new RoundtripdiscoundModel();
		$this->db      = \Config\Database::connect();
		$this->companyModel = new CompanyModel();
		
      
    }
    public function index()
    {

		if(session()->get('role_id') == "1"){
        	$data['discountround'] = $this->roundtripdiscountModel
										->select('roundtripdiscounds.*, companies.name as company_name')
										->join('companies', 'roundtripdiscounds.company_id = companies.id', 'left')
										->orderBy('id', 'DESC')->findAll();
		}else if(session()->get('company_id') > 0){
			$data['discountround'] = $this->roundtripdiscountModel
			->select('roundtripdiscounds.*, companies.name as company_name')
			->join('companies', 'roundtripdiscounds.company_id = companies.id', 'left')
			->where('roundtripdiscounds.company_id', session()->get('company_id'))
			->orderBy('id', 'DESC')->findAll();
		}else{
			$data['discountround'] = $this->roundtripdiscountModel
			->select('roundtripdiscounds.*, companies.name as company_name')
			->join('companies', 'roundtripdiscounds.company_id = companies.id', 'left')
			->orderBy('id', 'DESC')->findAll();
		}

        if (empty($data['discountround'])) {
            return redirect()->route('new-roundtripdiscount');
        }

        $data['module'] =    lang("Localize.trip") ; 
		$data['title']  =    lang("Localize.discount_round_trip") ;

		$data['pageheading'] = lang("Localize.discount_round_trip");

		

		$rolepermissionLibrary = new Rolepermission();
        $add_data = "discount_round_trip";
        $list_data = "discount_round_trip";

        $data['add_data'] = $rolepermissionLibrary->create($add_data); 
        $data['edit_data'] = $rolepermissionLibrary->edit($list_data); 
        $data['delete_data'] = $rolepermissionLibrary->delete($list_data);
		$data['companies'] = $this->companyModel->findAll();

		echo view($this->Viewpath.'\discountround/index',$data);
    }

    public function new()
	{
		

		$data['module'] =    lang("Localize.trip") ; 
		$data['title']  =    lang("Localize.discount_round_trip") ;

		$data['pageheading'] = lang("Localize.discount_round_trip");
		$data['companies'] = $this->companyModel->findAll();
		
		echo view($this->Viewpath.'\discountround/new',$data);
	}

    public function create()
	{
		$companyId = $this->request->getVar('company_id')??session()->get('company_id');

		$data= array(
			"name"=> $this->request->getVar('name'),
			"discountrate"=> $this->request->getVar('discountrate'),
			"onlinediscountrate"=> $this->request->getVar('onlinediscountrate'),
			"status"=> $this->request->getVar('status'),
			"company_id" => $companyId,
		);
	
		
		if($this->validation->run($data, 'discountround'))
		{
			
			$this->roundtripdiscountModel->insert($data);
           
			return redirect()->route('index-roundtripdiscount')->with("success","Data Save");
		}
		
		
		else
		{
			$data['module'] =    lang("Localize.trip") ; 
            $data['title']  =    lang("Localize.discount_round_trip") ;

            $data['pageheading'] = lang("Localize.discount_round_trip");

			$data['validation'] = $this->validation;
			echo view($this->Viewpath.'\discountround/new',$data);

		}
		
	}


    public function edit($id)
	{
		$data['module'] =    lang("Localize.trip") ; 
        $data['title']  =    lang("Localize.discount_round_trip") ;

		$heading = lang("Localize.edit").' '.lang("Localize.discount_round_trip");
		$data['pageheading'] = $heading;

		$data['discountround'] = $this->roundtripdiscountModel->find($id);
		$data['company_id'] = $data['discountround']->company_id;
        $data['companies'] = $this->companyModel->findAll();
		echo view($this->Viewpath.'\discountround/edit',$data);
	}


    public function update($id)
	{
		$companyId = $this->request->getVar('company_id')??session()->get('company_id');
		$validdata= array(
			"name"=> $this->request->getVar('name'),
			"discountrate"=> $this->request->getVar('discountrate'),
			"status"=> $this->request->getVar('status'),
		);
		$data= array(
			"id"=> $id,
			"name"=> $this->request->getVar('name'),
			"discountrate"=> $this->request->getVar('discountrate'),
			"onlinediscountrate"=> $this->request->getVar('onlinediscountrate'),
			"status"=> $this->request->getVar('status'),
			"company_id" => $companyId,
		);

		if($this->validation->run($validdata, 'discountround'))
		{
			$this->roundtripdiscountModel->save($data);
			return redirect()->route('index-roundtripdiscount')->with("success","Data Update");
		}
		
		
		else
		{
			$data['module'] =    lang("Localize.trip") ; 
            $data['title']  =    lang("Localize.discount_round_trip") ;

            $heading = lang("Localize.edit").' '.lang("Localize.discount_round_trip");
            $data['pageheading'] = $heading;

			$data['validation'] = $this->validation;
			$data['discountround'] = $this->roundtripdiscountModel->find($id);
			$data['company_id'] = $data['discountround']->company_id;
        	$data['companies'] = $this->companyModel->findAll();
			echo view($this->Viewpath.'\tax/edit',$data);

		}
	}

    public function delete($id)
	{

		$this->roundtripdiscountModel->delete($id);
		return redirect()->route('index-roundtripdiscount')->with("fail","Data Deleted");
	
	}
}
