<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>

    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <h5 class="card-title mb-0">Notification Management</h5>
                </div>
                <div class="col-md-6 text-end">
                    <?php if ($add_data == true) : ?>
                        <a class="btn btn-success" href="<?php echo base_url(route_to('new-notification')) ?>">
                            <i class="fas fa-plus"></i> Create New Notification
                        </a>
                    <?php endif ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-lg-3 col-sm-6">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h5 class="mb-0"><?php echo $stats['total'] ?></h5>
                            <small class="text-muted">Total Notifications</small>
                        </div>
                        <div class="text-primary">
                            <i class="fas fa-bell fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-sm-6">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h5 class="mb-0"><?php echo $stats['sent'] ?></h5>
                            <small class="text-muted">Sent</small>
                        </div>
                        <div class="text-success">
                            <i class="fas fa-check-circle fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-sm-6">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h5 class="mb-0"><?php echo $stats['scheduled'] ?></h5>
                            <small class="text-muted">Scheduled</small>
                        </div>
                        <div class="text-warning">
                            <i class="fas fa-clock fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-sm-6">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h5 class="mb-0"><?php echo $stats['cancelled'] ?></h5>
                            <small class="text-muted">Cancelled</small>
                        </div>
                        <div class="text-danger">
                            <i class="fas fa-times-circle fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Navigation Tabs -->
    <div class="card">
        <div class="card-header">
            <ul class="nav nav-pills card-header-pills">
                <li class="nav-item">
                    <a class="nav-link active" href="<?php echo base_url(route_to('index-notification')) ?>">All</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo base_url(route_to('scheduled-notifications')) ?>">Scheduled</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo base_url(route_to('sent-notifications')) ?>">Sent</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo base_url(route_to('cancelled-notifications')) ?>">Cancelled</a>
                </li>
            </ul>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table display table-bordered table-striped table-hover basic" id="notificationTable">
                    <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Subject</th>
                            <th scope="col">Target Group</th>
                            <th scope="col">Trip</th>
                            <th scope="col">Scheduled Date</th>
                            <th scope="col">Status</th>
                            <th scope="col">Created By</th>
                            <th scope="col">Created Date</th>
                            <th scope="col">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($notifications as $key => $notification) : ?>
                            <tr>
                                <th scope="row"><?php echo $key + 1; ?></th>
                                <td>
                                    <strong><?php echo esc($notification->subject) ?></strong>
                                    <?php if ($notification->is_push_notification) : ?>
                                        <span class="badge bg-info ms-1">Push</span>
                                    <?php endif ?>
                                </td>
                                <td>
                                    <?php if ($notification->target_group == 'all_users') : ?>
                                        <span class="badge bg-primary">All Users</span>
                                    <?php else : ?>
                                        <span class="badge bg-secondary">Specific Trip</span>
                                    <?php endif ?>
                                </td>
                                <td>
                                    <?php echo $notification->trip_name ? esc($notification->trip_name) : '-' ?>
                                </td>
                                <td><?php echo date('Y-m-d H:i', strtotime($notification->notification_date)) ?></td>
                                <td>
                                    <?php
                                    $statusClass = [
                                        'draft' => 'bg-secondary',
                                        'scheduled' => 'bg-warning',
                                        'sent' => 'bg-success',
                                        'cancelled' => 'bg-danger'
                                    ];
                                    ?>
                                    <span class="badge <?php echo $statusClass[$notification->status] ?? 'bg-secondary' ?>">
                                        <?php echo ucfirst($notification->status) ?>
                                    </span>
                                </td>
                                <td><?php echo esc($notification->created_by_name) ?></td>
                                <td><?php echo date('Y-m-d H:i', strtotime($notification->created_at)) ?></td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="<?php echo base_url(route_to('show-notification', $notification->id)) ?>" 
                                           class="btn btn-sm btn-info" title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        
                                        <?php if (in_array($notification->status, ['draft', 'scheduled']) && $edit_data) : ?>
                                            <a href="<?php echo base_url(route_to('edit-notification', $notification->id)) ?>" 
                                               class="btn btn-sm btn-warning" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                        <?php endif ?>
                                        
                                        <?php if (in_array($notification->status, ['draft', 'scheduled'])) : ?>
                                            <button type="button" class="btn btn-sm btn-success" 
                                                    onclick="sendNow(<?php echo $notification->id ?>)" title="Send Now">
                                                <i class="fas fa-paper-plane"></i>
                                            </button>
                                            
                                            <button type="button" class="btn btn-sm btn-danger" 
                                                    onclick="cancelNotification(<?php echo $notification->id ?>)" title="Cancel">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        <?php endif ?>
                                        
                                        <?php if ($notification->status !== 'sent' && $delete_data) : ?>
                                            <button type="button" class="btn btn-sm btn-danger" 
                                                    onclick="deleteNotification(<?php echo $notification->id ?>)" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        <?php endif ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

<script>
function sendNow(id) {
    if (confirm('Are you sure you want to send this notification now?')) {
        var form = document.createElement('form');
        form.method = 'POST';
        form.action = '<?php echo base_url('modules/backend/notifications/send/') ?>' + id;
        
        var csrf = document.createElement('input');
        csrf.type = 'hidden';
        csrf.name = '<?= csrf_token() ?>';
        csrf.value = '<?= csrf_hash() ?>';
        form.appendChild(csrf);
        
        document.body.appendChild(form);
        form.submit();
    }
}

function cancelNotification(id) {
    if (confirm('Are you sure you want to cancel this notification?')) {
        var form = document.createElement('form');
        form.method = 'POST';
        form.action = '<?php echo base_url('modules/backend/notifications/cancel/') ?>' + id;
        
        var csrf = document.createElement('input');
        csrf.type = 'hidden';
        csrf.name = '<?= csrf_token() ?>';
        csrf.value = '<?= csrf_hash() ?>';
        form.appendChild(csrf);
        
        document.body.appendChild(form);
        form.submit();
    }
}

function deleteNotification(id) {
    if (confirm('Are you sure you want to delete this notification? This action cannot be undone.')) {
        var form = document.createElement('form');
        form.method = 'POST';
        form.action = '<?php echo base_url(route_to('delete-notification', '')) ?>' + id;
        
        var method = document.createElement('input');
        method.type = 'hidden';
        method.name = '_method';
        method.value = 'DELETE';
        form.appendChild(method);
        
        var csrf = document.createElement('input');
        csrf.type = 'hidden';
        csrf.name = '<?= csrf_token() ?>';
        csrf.value = '<?= csrf_hash() ?>';
        form.appendChild(csrf);
        
        document.body.appendChild(form);
        form.submit();
    }
}
</script>

<?php echo $this->endSection() ?>
