<?php

namespace Modules\Ticket\Controllers\Api;

use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use Modules\Ticket\Config\TicketValidation;
use Modules\Ticket\Exceptions\TicketExceptions;
use Modules\Ticket\Models\TemporaryBook as TemporaryBookModel;
use Modules\Ticket\Models\MaxtimeModel as  MaxtimeModel;
use CodeIgniter\Database\RawSql;
use CodeIgniter\I18n\Time;
use Modules\Ticket\Models\TicketModel;
use Modules\Trip\Models\SubtripModel;

class TemporaryBook extends BaseController
{
    use ResponseTrait;

    /**
     * Temporary book model
     *
     * @var TemporaryBookModel
     */
    protected $temporaryBookModel;
    protected $maxtimeModel;
    protected $ticketModel;
    protected $subtripModel;

    public function __construct()
    {
        // Init temporary book validator
        $this->ticketModel = new TicketModel();
        $ticketValidation = new TicketValidation;
        $this->validation = \Config\Services::validation($ticketValidation);
        $this->validation->setRuleGroup('temporarybooks');

        // Init temporary book model
        $this->temporaryBookModel = new TemporaryBookModel;
        $this->subtripModel = new SubtripModel();
        $this->maxtimeModel = new MaxtimeModel();
    }

    public function checkSeats($book_from="")
    {
        $updateBookId = null;
        $subtrip_id = $this->request->getVar('subtrip_id');
        $client_token = $this->request->getVar('ticket_token');
        $seat_names = $this->request->getVar('seat_names');
        if (is_array($seat_names)) {
            $seat_nameArr = array_map('trim', $seat_names);
        } else{
            $seat_nameArr = array_map('trim', array_filter(explode(',', $seat_names)));
        }
        
        $journey_date = $this->request->getVar('journey_date');

        // clean expired rows
        $this->cleanDatabase();

        // check subtrip exists
        // seat search regex string
        $seatSearchRegex = '\\b(' . implode('|', $seat_nameArr) . ')\\b';
        $curDate = date('Y-m-d H:i:s');
        $check = $this->temporaryBookModel->query(
            "SELECT * FROM `temporarybooks`
              WHERE subtrip_id = ?
              AND DATE(journey_date) = DATE(?)
              AND seat_names REGEXP ?
              AND expires_at > ?",
            [$subtrip_id, $journey_date, $seatSearchRegex, $curDate]
        )->getResult();

        try {
            if (!empty($check) && is_array($check)) {
                // build booked seats 
                $bookByOtherSeats = array();

                foreach ($check as $singleCheck) {
                    // build book info
                    $seatBookId = $singleCheck->id;
                    $seatBookToken = $singleCheck->ticket_token;

                    if ($client_token != $seatBookToken) {
                        // this seats booked by other passanger
                        $bookByOtherSeats = array_merge($bookByOtherSeats, explode(',', $singleCheck->seat_names));
                        continue;
                    }

                    // this seats booked by me
                    $updateBookId = $seatBookId;
                    $this->store($updateBookId,$book_from);
                }

                if (count($bookByOtherSeats)) {
                    $seatMatches = array_intersect($bookByOtherSeats, $seat_nameArr);
                    throw new TicketExceptions(sprintf('Seat %s already processed!', implode(', ', $seatMatches)));
                }
            }else{
                if(is_array($seat_nameArr)){
                    foreach($seat_nameArr as $seat_nameArr){
                        $this->store($seat_nameArr,$book_from);
                    }
                }
            }

            
        } catch (TicketExceptions $th) {
            return $this->response->setJSON([
                'status' => 'failed',
                'response' => 204,
                'message' => $th->getErrors()
            ]);
        }

        return $this->response->setJSON([
            'status' => 'success',
            'response' => 200,
            'message' => true
        ]);
    }

    protected function store(int $seatBookId = null, $book_from = null)
    {
        if($book_from == "admin"){
            $maxtime = $this->maxtimeModel->where('book_from', $book_from)->first();
            $expirytime = $maxtime->maxtime ?? 5;

            $temporaryBookData = array(
                'subtrip_id' => $this->request->getVar('subtrip_id'),
                'ticket_token' => $this->request->getVar('ticket_token'),
                'seat_names' => $this->request->getVar('seat_names'),
                'journey_date' => $this->request->getVar('journey_date'),
                'expires_at' => date('Y-m-d H:i:s', strtotime('+' . $expirytime . ' Minutes'))
            );
        }else {
            $temporaryBookData = array(
                'subtrip_id' => $this->request->getVar('subtrip_id'),
                'ticket_token' => $this->request->getVar('ticket_token'),
                'seat_names' => $this->request->getVar('seat_names'),
                'journey_date' => $this->request->getVar('journey_date'),
                'expires_at' => date('Y-m-d H:i:s', strtotime('+5 Minutes'))
            );
        }

        $seatBookId !== null && $temporaryBookData = array_merge(['id' => $seatBookId], $temporaryBookData);

        if ($this->validation->run($temporaryBookData, 'temporarybooks')) {
            return $this->temporaryBookModel->replace($temporaryBookData);
        }

        throw new TicketExceptions(null, 0, null, array_values($this->validation->getErrors()));
    }

    protected function cleanDatabase()
    {
        $this->temporaryBookModel->where('expires_at < NOW()')->delete();
    }

    protected function delete(int $seatBookId)
    {
        return $this->temporaryBookModel->where('id', $seatBookId)->delete();
    }
    public function deleteHoldSeat(int $seatNumber)
    {
        $subtrip_id = $this->request->getVar('subtrip_id');

        if($this->temporaryBookModel->where('seat_names', $seatNumber)->where('subtrip_id',$subtrip_id)->delete()){
            return $this->response->setJSON([
                'status' => 'success',
                'response' => 200,
                'message' => true
            ]);    
        }else{
            return $this->response->setJSON([
                'status' => 'failed',
                'response' => 204,
                'message' => "Seat not unHolded"
            ]);            
        }
        
    }
    public function bookingcheck()
    {
        $updateBookId = null;
        $subtrip_id = $this->request->getVar('subtrip_id');
        $seat_names = $this->request->getVar('seat_names');
        $pickstand = $this->request->getVar('pickstand');
        $dropstand = $this->request->getVar('dropstand');
        $journeydate = $this->request->getVar('journeydate');
        if (is_array($seat_names)) {
            $seat_nameArr = array_map('trim', $seat_names);
        } else{
            $seat_nameArr = array_map('trim', array_filter(explode(',', $seat_names)));
        }
        
        $journey_date = $this->request->getVar('journey_date');
        $subtripInformation = $this->subtripModel->find($subtrip_id);
        $mainTripId = $subtripInformation->trip_id;
        $subtripStopage = $this->subtripModel->where('trip_id', $mainTripId)->where('pick_location_id', $subtripInformation->pick_location_id)->where('drop_location_id', $subtripInformation->drop_location_id)->first();
        
        $TempBookedSeat = $this->getDynamicPickupDropCombinationsTemp($subtripInformation->pick_location_id, $subtripInformation->drop_location_id, $subtripStopage->stoppage, $journeydate, $subtripInformation->id);
        $holdseats = [];
        if(!empty($TempBookedSeat)){
            foreach($TempBookedSeat as $TempBookedSeat){
                $holdseats[] = $TempBookedSeat['seat_names'];
            }
            
        }
        // if($subtripInformation->id == 344){
        //     print_r($holdseats);
        //     exit;
        // }
        $results = $this->getDynamicPickupDropCombinations($subtripInformation->pick_location_id, $subtripInformation->drop_location_id, $subtripStopage->stoppage, $journeydate, $mainTripId);
        $bookedSeats = array_column($results, 'seatnumber');

        $allBookedSeats = [];
        foreach ($holdseats as $holdseat) {
            $tempSeats = array_filter(explode(',', $holdseat));
            foreach ($tempSeats as $tempSeat) {
                $allBookedSeats[] = trim($tempSeat);
            }
        }
        foreach ($bookedSeats as $seatString) {
            $seats = array_filter(explode(',', $seatString));
            foreach ($seats as $seat) {
                $allBookedSeats[] = trim($seat);
            }
        }
        $finalBookedSeats = array_unique($allBookedSeats);
        $requested_seats = array_map('trim', array_filter(explode(',', $seat_names)));
        $any_seat_matches = false;

        foreach ($requested_seats as $seat) {
            if (in_array($seat, $finalBookedSeats)) {
                $any_seat_matches = true;
                break;
            }
        }
        // if($subtripInformation->id == 344){
        //     var_dump($any_seat_matches);
        //     exit;
        // }

        if ($any_seat_matches) {
            $response = [
                'status' => 'error',
                'message' => 'Seat is already booked please check again.'
            ];
        } else {
            $response = [
                'status' => 'success',
                'message' => 'Seat is already booked please check again.'
            ];
        }

        return $this->response->setJSON($response);

    }
    public function getDynamicPickupDropCombinations($pickup, $drop, $tripSeries, $date, $tripId)
    {
        // Convert trip series to an array of stops
        $stops = explode(',', $tripSeries);
        $this->db = \Config\Database::connect(); // Load CI4 Database
        
        // Start building the query
        $builder = $this->db->table('tickets');
        $builder->select("tickets.*, subtrips.*");
        $builder->join('subtrips', 'tickets.subtrip_id = subtrips.id', 'LEFT');
        $builder->join('trips', 'tickets.trip_id = trips.id', 'LEFT');
        $builder->where('journeydata', $date);
        $builder->where('cancel_status', 0);
        $builder->where('trips.status', 1);
        $builder->where('refund', 0);
        $builder->where('refund', 0);
        $builder->where('tickets.trip_id', $tripId);
        
        // Build the dynamic WHERE conditions
        $whereClause = '';
        foreach ($stops as $stop) {
            if (!empty($whereClause)) {
                $whereClause .= ' OR ';
            }
            $whereClause .= "FIND_IN_SET('$stop', TRIM(BOTH ',' FROM REPLACE(REPLACE(subtrips.stoppage, subtrips.pick_location_id, ''), subtrips.drop_location_id, '')))";
        }

        foreach ($stops as $start) {
            foreach ($stops as $end) {
                // if (array_search($start, $stops) < array_search($end, $stops)) {
                    $whereClause .= " OR (subtrips.pick_location_id = '$start' AND subtrips.drop_location_id = '$end') OR (subtrips.pick_location_id = '$end' AND subtrips.drop_location_id = '$start')";
                // }
            }
        }

        $builder->where("($whereClause)");

        // $sql = $builder->getCompiledSelect();
        // echo "<pre>";
        // print_r($sql); // Die and Debug: This will print the raw SQL query and stop execution
        // dd($sql);
        // Execute the query
        $query = $builder->get();    
        return $query->getResultArray();
    }
    public function getDynamicPickupDropCombinationsTemp($pickup, $drop, $tripSeries, $date, $subtripId)
    {
        // Convert trip series to an array of stops
        $stops = explode(',', $tripSeries);
        $this->db = \Config\Database::connect(); // Load CI4 Database
        // $currentTime = date("Y-m-d H:i:s");
        // $egyptNow = new \DateTime("now", new \DateTimeZone("Africa/Cairo"));
        // $currentTime = $egyptNow->format("Y-m-d H:i:s");
        $currentTime = (new \DateTime("now", new \DateTimeZone("+02:00")))
                  ->format("Y-m-d H:i:s");
        
        // Start building the query
        $builder = $this->db->table('temporarybooks');
        $builder->select("temporarybooks.*, subtrips.*");
        $builder->join('subtrips', 'temporarybooks.subtrip_id = subtrips.id', 'LEFT');
        $builder->join('trips', 'subtrips.trip_id = trips.id', 'LEFT');
        $builder->where('journey_date', $date);
        $builder->where('expires_at >', $currentTime);
        $builder->where('trips.status', 1);
        $builder->where('temporarybooks.subtrip_id', $subtripId);
        
        // Build the dynamic WHERE conditions
        $whereClause = '';
        foreach ($stops as $stop) {
            if (!empty($whereClause)) {
                $whereClause .= ' OR ';
            }
            $whereClause .= "FIND_IN_SET('$stop', TRIM(BOTH ',' FROM REPLACE(REPLACE(subtrips.stoppage, subtrips.pick_location_id, ''), subtrips.drop_location_id, '')))";
        }

        foreach ($stops as $start) {
            foreach ($stops as $end) {
                // if (array_search($start, $stops) < array_search($end, $stops)) {
                    $whereClause .= " OR (subtrips.pick_location_id = '$start' AND subtrips.drop_location_id = '$end') OR (subtrips.pick_location_id = '$end' AND subtrips.drop_location_id = '$start')";
                // }
            }
        }

        $builder->where("($whereClause)");

        // $sql = $builder->getCompiledSelect();
        // echo "<pre>";
        // print_r($sql); // Die and Debug: This will print the raw SQL query and stop execution
        // dd($sql);
        // Execute the query
        $query = $builder->get();    
        return $query->getResultArray();
    }

}
