<?php
$sessiondata = \Config\Services::session(); // Needed for Point 5

if ($sessiondata->has('grandtotal')) {
    $singleTripTotal  = $sessiondata->grandtotal;
    $rouondTripTotal = (float) $singleTripTotal + (float) $grandtotal;
}

$isrountripPost  = $sessiondata->has('isrountrip') ? $sessiondata->isrountrip : 0;
?>

<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>
<div class="card mb-4">
    <div class="card-header"><h4>Edit pretrip</h4></div>
    <div class="card-body">
        <form action="<?php echo base_url(route_to('edit_pre_trip_booking')) ?>" method="post" id="createbooking" accept-charset="utf-8" enctype="multipart/form-data">
            <?php echo $this->include('common/security') ?>

            <input type="hidden" name="baseurl" id="baseurl" value="<?php echo base_url(); ?>">
            
            <div class="booking-payments mb-4">
                <h5 class="card-title"><?php echo lang('Pre_trip') . " " . lang('Localize.details')  ?></h5>    

                <div class="row">
                    <div class="col-4 form-group">
                        <label for="trip"><?php echo lang("Trip Location") ?> <abbr class="required" title="Required field">*</abbr></label>
                        <select class="form-select" name="tripid" id="tripid"  required>
                            <option>select trip</option>
                            <?php foreach($trip as $trip)
                            { ?>
                                <option <?= ($trip->tripid == $pretrip[0]->trip_id) ? 'selected' : '' ?>  value="<?php echo $trip->tripid ?>"><?php echo $trip->start_time, "-", $trip->end_time, " - ", $trip->pic_location_name," - ",$trip->drop_location_name ?></option>
                            <?php } ?>
                            <option>city</option>
                        </select>
                    </div>
                    

                    <div class="col-4 form-group" >
                        <label for="Driver_Name"><?php echo lang("Driver Name") ?> <abbr class="required" title="Required field">*</abbr></label>
                        <select class="form-select" name="Driver_id" id="Driver_id" required>
                            <option>select driver</option>
                            <?php foreach($driver as $driver)
                            { ?>
                                <option <?= ($driver->id == $pretrip[0]->Driver_id) ? 'selected' : '' ?> value="<?php echo $driver->id ?>"><?php echo $driver->first_name, " ", $driver->last_name ?></option>
                            <?php } ?>
                        </select>
                    </div>
                    
                    <div class="col-4 form-group">
                        <label for="Assistant_Name"><?php echo lang("Assistant Name") ?> <abbr class="required" title="Required field">*</abbr></label>
                        <select class="form-select" name="Assistant_id" id="Assistant_id" required>
                            <option>select driver</option>
                            <?php foreach($assistant as $assistant)
                            { ?>
                                <option <?= ($assistant->id == $pretrip[0]->Assistant_id) ? 'selected' : '' ?> value="<?php echo $assistant->id ?>"><?php echo $assistant->first_name, " ",$assistant->last_name ?></option>
                            <?php } ?>
                        </select>
                    </div>
                    
                    <div class="col-4 form-group" >
                        <label for="Bus_Number"><?php echo lang("Bus Number") ?> <abbr class="required" title="Required field">*</abbr></label>
                        <select class="form-select" name="bus_id" id="bus_id" required>
                            <?php foreach($vehicle as $vehicle)
                            { ?>
                                <option <?= ($vehicle->id == $pretrip[0]->bus_id) ? 'selected' : '' ?> value="<?php echo $vehicle->id ?>"><?php echo $vehicle->reg_no ?></option>
                            <?php } ?>
                        </select>
                    </div>
                    
                    <div class="col-4 form-group" >
                        <label for="Number_of_Seats"><?php echo lang("Number of Seats") ?> <abbr class="required" title="Required field">*</abbr></label>
                        <input value="<?= $pretrip[0]->Number_of_Seats ?>" class="form-control" type="text" name="Number_of_Seats" id="Number_of_Seats" />
                        <input type="hidden" value="<?= $pretrip[0]->pretripId ?>" name="pretripId" /> 
                    </div>

                </div>
            </div>

            <!--<div class="text-danger">-->
            <!--    <?php if (isset($validation)) : ?>-->
            <!--        <?= $validation->listErrors(); ?>-->
            <!--    <?php endif ?>-->
            <!--</div>-->

            <div class="row">
                <div class="col-12 text-center">
                    <button type="submit" class="btn btn-success" id="submit-booking"><?php echo lang("Localize.submit") ?></button>
                </div>
            </div>
        </form>
    </div>
</div>

<?php echo $this->endSection() ?>

<?php echo $this->section('js') ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script src="<?php echo base_url('js/booking.js'); ?>"></script>
<script src="<?php echo base_url('public/js/ajax.js'); ?>"></script>

<script>
function fetchTripData(){
    var tripId = $('#tripLocation').val();
    
    
}
</script>
<?php echo $this->endSection() ?>