<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>
<?php echo $this->include('common/message') ?>

<div class="card mb-4">
    <div class="card-body">
        <div class="sp3 mb-5">
            <div class="card">
                <div class="card-body">
                    <form action="<?php echo base_url(route_to('commissiondata-report')) ?>" id="agentCommissionform" method="post">
                        <?php echo $this->include('common/security') ?>

                        <div class="row mb-3">
                            <?php if ($role_id == 1) : ?>
                                <div class="col-3">
                                    <label for="company_id_for_agent" class="form-label"><?php echo lang("Localize.company") ?></label>
                                    <select id="company_id_for_agent" name="company_id_for_agent" class="form-select">
                                        <option <?php if(isset($s_company_id)){ if($s_company_id == "all"){ echo "selected"; } } ?> value="all"><?php echo strtoupper(lang("Localize.all")) ?></option>
                                        <?php foreach ($companies as $company) : ?>
                                            <?php $select = ""; 
                                                if(isset($s_company_id)){
                                                    if($s_company_id == $company->id){
                                                        $select = "selected";
                                                    }
                                                } 
                                            ?>
                                            <option <?php echo $select; ?> value="<?php echo $company->id; ?>">
                                                <?php echo $company->name; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            <?php else : ?>
                    
                                <input type="hidden" id="company_id" name="company_id" value="<?php echo session()->get('company_id'); ?>">
                            <?php endif; ?>
                            
                            <div class="col-3">
                                <label for="agent_id" class="form-label"><?php echo lang("Localize.agent") ?></label>
                                <select id="agent_id" name="agent_id" class="form-select" required>
                                    <option <?php if(isset($s_agent_id)){ if($s_agent_id == "all"){ echo "selected"; } } ?> value="all"><?php echo strtoupper(lang("Localize.all")) ?></option>
                                    <?php foreach ($agentList as $agent) : ?>
                                        <?php $select = ""; 
                                            if(isset($s_agent_id)){
                                                if($s_agent_id == $agent->id){
                                                    $select = "selected";
                                                }
                                            } 
                                        ?>
                                        <option <?php echo $select; ?> value="<?php echo $agent->id; ?>">
                                            <?php echo $agent->first_name . " " .$agent->last_name; ?>
                                        </option>
                                    <?php endforeach; ?>

                                </select>
                            </div>
                            <div class="col-3">
                                <label for="start_date" class="form-label"><?php echo lang("Localize.from") ?></label>
                                <div class="input-append date datepicker" id="start_date"  data-date-format="yyyy-mm-dd">
                                    <input size="16" type="text" name="start_date" class="form-control" value="<?php if(isset($s_startdate) && $s_startdate != ""){ echo date("Y-m-d", strtotime($s_startdate)); } else { echo date('Y-m-01'); }?>"  required readonly>
                                    <span class="add-on"><i class="icon-th"></i></span>
                                </div>
                            </div>
                            <div class="col-3">
                                <label for="end_date" class="form-label"><?php echo lang("Localize.to") ?></label>
                                <div class="input-append date datepicker" id="end_date" data-date-format="yyyy-mm-dd">
                                    <input size="16" type="text" name="end_date" class="form-control" value="<?php if(isset($s_enddate) && $s_enddate != ""){ echo date("Y-m-d", strtotime($s_enddate)); } else { echo date('Y-m-d'); }?>"  required readonly>
                                    <span class="add-on"><i class="icon-th"></i></span>
                                </div>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-success"><?php echo lang("Localize.submit") ?></button>
                    </form>
                </div>
            </div>
        </div>

        <div class="table-responsive mt-3">
            <table class="table display table-bordered basic" id="commissionlist">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <?php if ($role_id == 1) : ?>
                            <th scope="col"><?php echo lang("Localize.company") ?> <?php echo lang("Localize.name") ?></th>
                        <?php endif; ?>
                        <th scope="col"><?php echo lang("Localize.agent") ?> <?php echo lang("Localize.name") ?></th>
                        <th scope="col"><?php echo lang("Localize.booking") ?> <?php echo lang("Localize.id") ?></th>
                        <th scope="col"><?php echo lang("Localize.ticket") ?> <?php echo lang("Localize.status") ?></th>
                        <th scope="col"><?php echo lang("Localize.fee") ?></th>
                        <th scope="col"><?php echo lang("Localize.trip") ?></th>
                        <th scope="col"><?php echo lang("Localize.total") ?> <?php echo lang("Localize.amount") ?></th>
                        <th scope="col"><?php echo lang("Localize.agent") ?> <?php echo lang("Localize.commission") ?></th>
                        <th scope="col"><?php echo lang("Localize.commission") ?> <?php echo lang("Localize.rate") ?></th>
                        <th scope="col"><?php echo lang("Localize.details") ?></th>
                        <th scope="col"><?php echo lang("Localize.date") ?></th>
                    </tr>
                </thead>
                <tbody>

                    <?php foreach ($commission as $kye => $commissionvalue) : ?>
                        <tr>
                            <th scope="row"><?php echo $kye + 1; ?></th>
                            <?php if ($role_id == 1) : ?>
                                <td><?php echo $commissionvalue->company_name ?? '-'; ?></td>
                            <?php endif; ?>
                            <td><?php echo $commissionvalue->first_name . " " . $commissionvalue->last_name; ?></td>
                            <td><?php echo $commissionvalue->booking_id; ?></td>
                            <td><?php echo $commissionvalue->is_cancel ?"Canceled":($commissionvalue->is_refund ? "refund":"Complete"); ?></td>
                            <td><?php echo $commissionvalue->refund_fee ?? $commissionvalue->cancel_fee ?? 0; ?></td>
                            <td><?php echo $commissionvalue->subtrip_id; ?></td>
                            <td class="text-end"><?php echo $commissionvalue->grandtotal; ?></td>
                            <td class="text-end"><?php echo $commissionvalue->commissionamount; ?></td>
                            <td><?php echo $commissionvalue->rate; ?>%</td>
                            <td><?php echo $commissionvalue->detail; ?></td>
                            <td><?php echo $commissionvalue->date; ?></td>
                        </tr>
                    <?php endforeach ?>

                </tbody>
                <tfoot>
                    <tr>
                        <th scope="row" class="text-end" colspan="4"><?php echo lang("Localize.total") ?></th>
                        <th class="text-end"><?php echo $currency_symbol; ?> <?php echo array_sum(array_column($commission, 'grandtotal')); ?></th>
                        <th class="text-end"><?php echo $currency_symbol; ?> <?php echo array_sum(array_column($commission, 'commissionamount')); ?></th>
                        <th colspan="3"></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
<?php echo $this->include('common/datatable_default_lang_change') ?>
<?php echo $this->endSection() ?>