<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>
    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">

            <form action="<?php echo base_url(route_to('create-role')) ?>" id="roleform" method="post" class="row g-3" accept-charset="utf-8" enctype="multipart/form-data">
                <?php echo $this->include('common/security') ?>

                <div class="row justify-content-md-center">
                    <div class="col col-4">
                        <div class="row">
                            <?php if($logged_role == "1"){ ?>
                                <div class="col-12 mb-2">
                                    <label class="form-group mt-3" for="">
                                        <?php echo lang("Localize.role") ?> <?php echo lang("Localize.type") ?>
                                    </label>

                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="role_type" id="role_type1" value="global" checked>
                                        <label class="form-check-label" for="role_type1">
                                            <?php echo lang("Localize.global") ?>
                                        </label>
                                    </div>

                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="role_type" id="role_type2" value="custome">
                                        <label class="form-check-label" for="role_type2">
                                            <?php echo lang("Localize.custome") ?>
                                        </label>
                                    </div>
                                </div>

                                <div class="col-12 mb-2" id="company_div" style="display:none;">
                                    <?php echo $this->include('common/filter/company') ?>
                                </div>
                            <?php } else if($logged_role == "7"){ ?>
                                <input type="hidden" name="company_id" id="company_id" value="<?php echo $logged_company_id; ?>" >
                                <input type="hidden" name="role_type" id="role_type" value="custome" >
                            <?php } ?>

                            <div class="col-12 mb-2">
                                <label for="name" class=""><?php echo lang("Localize.role") ?> <?php echo lang("Localize.name") ?> <abbr title="Required field">*</abbr></label>
                                <input type="text" id="name" name="name" value="<?php echo esc(old('name'))  ?>" class="form-control" placeholder="<?php echo lang("Localize.role") ?> <?php echo lang("Localize.name") ?>" required />
                            </div>
                            <div class="col-12 mb-2">
                            <label class="form-group mt-3" for="">
                                <?php echo lang("Localize.status") ?>
                            </label>

                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="status" id="status" value="1" checked>
                                <label class="form-check-label" for="exampleRadios1">
                                    <?php echo lang("Localize.active") ?>
                                </label>
                            </div>

                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="status" id="status" value="0">
                                <label class="form-check-label" for="exampleRadios2">
                                    <?php echo lang("Localize.disable") ?>
                                </label>
                            </div>
                            </div>

                            <div class="col-12 text-center">
                                <button type="submit" class="btn btn-success"><?php echo lang("Localize.submit") ?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php echo $this->endSection() ?>
<?php echo $this->section('js') ?>
    
    <script type="text/javascript">
        $(document).ready(function () {
            
            $('input[name="role_type"]').change(function () {
                // Get the value of the selected radio button
                var selectedValue = $(this).val();
                if(selectedValue == "custome"){
                    
                    $('#company_id').val(""); 
                   // $('#company_id').attr('required', true);
                    $('label[for="company_id"]').html(function (_, currentHtml) {
                        return currentHtml + ' <abbr title="Required field">*</abbr>';
                    });
                    $("#company_div").show();

                } else {
                    
                    $('#company_id').val("");
                    $('#company_id').attr('required', false);
                    $("#company_div").hide();
                    $('label[for="company_id"] abbr').remove();
                }

            });
        });
    </script>
<?php echo $this->endSection() ?>
