<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('css') ?>
    <link href="<?php echo base_url('public/plugins/select2/select2.min.css'); ?>" rel="stylesheet" />
<?php echo $this->endSection() ?>

<?php echo $this->section('content') ?>
    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">

            <form action="<?php echo base_url(route_to('create-trip')) ?>" id="locationform" method="post" class="row g-3" accept-charset="utf-8" enctype="multipart/form-data">
                <?php echo $this->include('common/security') ?>

                <input type="hidden" id="baseurl" name="basurl" value="<?php echo base_url(); ?>">

                <div class="bg-light p-3 my-2">
                    <strong class="mb-1"><?php echo lang("Localize.trip") ?> <?php echo lang("Localize.section") ?></strong>

                    <div class="row">
                        <?php if(session()->get('role_id') == "1"){ ?>
                            <div class="col-3 mt-2">
                                <?php echo $this->include('common/filter/companyrequire') ?>
                            </div>
                        <?php } ?>
                        <div class="col-3 mt-2">
                            <label for="pick_location_id" class="form-label"><?php echo lang("Localize.pick_up") ?> <abbr title="Required field">*</abbr></label>
                            <select class="form-select select2" name="pick_location_id" id="pick_location_id" required>
                                <option value=""><?php echo lang("Localize.none") ?></option>
                                
                                <?php foreach ($location as $locationvalue) : ?>
                                    <option value="<?php echo $locationvalue->id ?>"><?php echo $locationvalue->name ?></option>
                                <?php endforeach ?>
                                
                            </select>
                        </div>
                        <div class="col-3 mt-2">
                            <label for="drop_location_id" class="form-label"><?php echo lang("Localize.drop") ?> <abbr title="Required field">*</abbr></label>
                            <select class="form-select select2" name="drop_location_id" id="drop_location_id" required>
                                <option value=""><?php echo lang("Localize.none") ?></option>
                                
                                <?php foreach ($location as $locationvalue) : ?>
                                    <option value="<?php echo $locationvalue->id ?>"><?php echo $locationvalue->name ?></option>
                                <?php endforeach ?>

                            </select>
                        </div>
                        <div class="col-3 mt-2">
                            <label for="stoppage" class="form-label"><?php echo lang("Localize.stoppage") ?> <?php echo lang("Localize.point") ?> <abbr title="Required field">*</abbr></label>
                            <select name="stoppage[]" id="stoppage" class="form-control" multiple>
                               
                                <option value="" disabled selected><?php echo lang("Localize.none") ?></option>
                                <?php foreach ($location as $locationvalue) : ?>
                                    <option value="<?php echo $locationvalue->id ?>"><?php echo $locationvalue->name ?></option>
                                <?php endforeach ?>

                            </select>
                        </div>
                        
                        <div class="col-3 mt-2">
                            <label for="schedule_id" class="form-label"><?php echo lang("Localize.schedule") ?> <?php echo lang("Localize.time") ?> <abbr title="Required field">*</abbr></label>
                            <select name="schedule_id" id="schedule_id" class="form-select select2" data-minimum-results-for-search="-1" required>
                                <option value=""><?php echo lang("Localize.none") ?></option>
                                
                                <?php foreach ($schedule as $schedulevalue) : ?>
                                    <option value="<?php echo $schedulevalue->id ?>"><?php echo $schedulevalue->start_time ?>  <?php //echo $schedulevalue->end_time ?></option>
                                <?php endforeach ?>

                            </select>
                        </div>
                        <div class="col-3 mt-2">
                            <label for="fleettype" class="form-label"><?php echo lang("Localize.fleet") ?> <?php echo lang("Localize.type") ?> <abbr title="Required field">*</abbr></label>
                            <select name="fleet_id" id="fleet_id" class="form-select select2" data-minimum-results-for-search="-1" required>
                                <option value=""><?php echo lang("Localize.none") ?></option>
                                
                                <?php foreach ($fleet_types as $fleet_type) : ?>
                                    <option value="<?php echo $fleet_type->id ?>"><?php echo $fleet_type->type ?></option>
                                <?php endforeach ?>

                            </select>
                        </div>
                        <div class="col-3 mt-2">
                            <label for="trip_category_id" class="form-label"><?php echo lang("Localize.category") ?> <?php echo lang("Localize.type") ?> <abbr title="Required field">*</abbr></label>    
                            <select name="trip_category_id" id="trip_category_id" class="form-select select2" data-minimum-results-for-search="-1" required>
                                <option value=""><?php echo lang("Localize.none") ?></option>
                                
                                <?php foreach ($TripCategories as $TripCategory) : ?>
                                    <option value="<?php echo $TripCategory->id ?>"><?php echo $TripCategory->name ?></option>
                                <?php endforeach ?>

                            </select>
                        </div>
                        <div class="col-3 mt-2">
                            <label for="trip_bus_type_id" class="form-label"><?php echo lang("Localize.bus") ?> <?php echo lang("Localize.type") ?> <abbr title="Required field">*</abbr></label>
                            <select name="trip_bus_type_id" id="trip_bus_type_id" class="form-select select2" data-minimum-results-for-search="-1" required>
                                <option value=""><?php echo lang("Localize.none") ?></option>
                                
                                <?php foreach ($TripBusTypes as $TripBusType) : ?>
                                    <option value="<?php echo $TripBusType->id ?>"><?php echo $TripBusType->name ?></option>
                                <?php endforeach ?>

                            </select>
                        </div>
                        <div class="col-3 mt-2">
                            <label for="trip_type" class="form-label"><?php echo lang("Localize.trip") ?> <?php echo lang("Localize.type") ?> <abbr title="Required field">*</abbr></label>
                            <select name="trip_type" id="trip_type" class="form-select select2" data-minimum-results-for-search="-1" required>
                                <option value=""><?php echo lang("Localize.none") ?></option>
                                <option value="Main"><?php echo lang("Localize.main") ?></option>
                                <option value="Add On"><?php echo lang("Localize.add_on") ?></option>

                            </select>
                        </div>
                        <!-- <div class="col-3 ">
                            <label for="company_name" class="form-label"><?php //echo lang("Localize.company") ?> <?php //echo lang("Localize.name") ?>  <abbr title="Required field">*</abbr></label>
                            <input type="text" id="company_name" name="company_name" class="form-control" value="<?php //echo old('company_name') ?>" placeholder="<?php //echo lang("Localize.company") ?> <?php //echo lang("Localize.name") ?>" required />
                        </div> -->
                    </div>
                </div>

                <div class="bg-light p-3 my-2">
                    <strong class="mb-1"><?php echo lang("Localize.boarding") ?> <?php echo lang("Localize.point") ?></strong>

                    <div class="row" id="boarding">
                        <div class="col-3 ">
                            <label for="picktime" class="form-label"><?php echo lang("Localize.select") ?> <?php echo lang("Localize.time") ?>  <abbr title="Required field">*</abbr></label>
                            <input type="text" id="picktime" name="picktime[]" class="form-control" value="<?php echo old('time') ?>" placeholder="<?php echo lang("Localize.select") ?> <?php echo lang("Localize.time") ?>" required />
                        </div>

                        <div class="col-3 ">
                            <label class="form-label"><?php echo lang("Localize.bus") ?> <?php echo lang("Localize.stand") ?> <abbr title="Required field">*</abbr></label>
                            <select name="picstand[]" id="b_stand_1" class="form-select select2" required>
                                <option value=""><?php echo lang("Localize.none") ?></option>

                                <?php foreach ($stand as $standvalue) : ?>
                                    <option value="<?php echo $standvalue->id ?>"><?php echo $standvalue->name ?></option>
                                <?php endforeach ?>
                            </select>
                        </div>

                        <div class="col-3 ">
                            <label for="detail" class="form-label"><?php echo lang("Localize.details") ?> </label>
                            <input type="text" id="detail" name="detail[]" class="form-control" value="" placeholder="<?php echo lang("Localize.details") ?>">
                        </div>

                        <input type="hidden" name="type[]" value="1">
                        <div class="col-3 mt-4">
                            <a id="boardingadd" class="btn btn-success mt-1 text-white" onclick="addfieldboard()">+</a>
                        </div>
                    </div>

                    <div id="boardinadd"></div>
                </div>

                <div class="bg-light p-3 my-2">
                    <strong class="mb-1"><?php echo lang("Localize.dropping") ?> <?php echo lang("Localize.point") ?></strong>

                    <div class="row" id="droping">
                        <div class="col-3 ">
                            <label for="droptime" class="form-label"><?php echo lang("Localize.select") ?> <?php echo lang("Localize.time") ?>  <abbr title="Required field">*</abbr></label>
                            <input type="text" id="droptime" name="droptime[]" class="form-control" value="" placeholder="<?php echo lang("Localize.select") ?> <?php echo lang("Localize.time") ?>" required />
                        </div>

                        <div class="col-3 ">
                            <label class="form-label"><?php echo lang("Localize.bus") ?> <?php echo lang("Localize.stand") ?> <abbr title="Required field">*</abbr></label>
                            <select name="dropstand[]" id="d_stand_1" class="form-select select2" required>
                                <option value=""><?php echo lang("Localize.none") ?></option>
                                <?php foreach ($stand as $standvalue) : ?>
                                    <option value="<?php echo $standvalue->id ?>"><?php echo $standvalue->name ?></option>
                                <?php endforeach ?>
                            </select>
                        </div>

                        <div class="col-3 ">
                            <label for="dropdetail" class="form-label"><?php echo lang("Localize.details") ?></label>
                            <input type="text" id="detail" name="dropdetail[]" class="form-control" value="" placeholder="<?php echo lang("Localize.details") ?>">
                        </div>

                        <input type="hidden" name="droptype[]" value="0">

                        <div class="col-3 mt-4">
                            <a id="boardingadd" class="btn btn-success mt-1 text-white" onclick="addfielddrop()">+</a>
                        </div>
                    </div>

                    <div id="droppingadd"></div>
                </div>

                <div class="bg-light p-3 my-2">
                    <strong class="mb-1"><?php echo lang("Localize.class") . ', ' . lang("Localize.seat") . ', ' . lang("Localize.fair") ?></strong>

                    <div class="row">
                        <!-- <div class="col-3">
                            <label for="child_seat" class="form-label"><?php echo lang("Localize.children") ?> <?php echo lang("Localize.seat") ?> </label>
                            <input type="number" id="child_seat" name="child_seat" class="form-control" value="<?= old('child_seat') ?>" placeholder="<?php echo lang("Localize.children") ?> <?php echo lang("Localize.seat") ?>" min="0">
                        </div>

                        <div class="col-3">
                            <label for="child_fair" class="form-label"><?php echo lang("Localize.children") ?> <?php echo lang("Localize.fair") ?></label>
                            <input type="number" id="child_fair" name="child_fair" class="form-control" value="<?= old('child_fair') ?>" placeholder="<?php echo lang("Localize.children") ?> <?php echo lang("Localize.fair") ?>" min="0">
                        </div>

                        <div class="col-3">
                            <label for="special_seat" class="form-label"><?php echo lang("Localize.special") ?> <?php echo lang("Localize.seat") ?></label>
                            <input type="number" id="special_seat" name="special_seat" class="form-control" value="<?= old('special_seat') ?>" placeholder="<?php echo lang("Localize.special") ?> <?php echo lang("Localize.seat") ?>" min="0">
                        </div>

                        <div class="col-3">
                            <label for="special_fair" class="form-label"><?php echo lang("Localize.special") ?> <?php echo lang("Localize.fair") ?> </label>
                            <input type="number" id="special_fair" name="special_fair" class="form-control" value="<?= old('special_fair') ?>" placeholder="<?php echo lang("Localize.special") ?> <?php echo lang("Localize.fair") ?>" min="0">
                        </div>

                        <div class="col-3">
                            <label for="vip_seat" class="form-label"><?php echo lang("Localize.vip") ?> <?php echo lang("Localize.seat") ?></label>
                            <input type="number" id="vip_seat" name="vip_seat" class="form-control" value="<?= old('vip_seat') ?>" placeholder="<?php echo lang("Localize.vip") ?> <?php echo lang("Localize.seat") ?>" min="0">
                        </div>

                        <div class="col-3">
                            <label for="vip_fair" class="form-label"><?php echo lang("Localize.vip") ?> <?php echo lang("Localize.fair") ?> </label>
                            <input type="number" id="vip_fair" name="vip_fair" class="form-control" value="<?= old('vip_fair') ?>" placeholder="<?php echo lang("Localize.vip") ?> <?php echo lang("Localize.fair") ?>" min="0">
                        </div> -->

                        <div class="col-3 mt-2">
                            <label for="adult_fair" class="form-label"><?php echo lang("Localize.adult") ?> <?php echo lang("Localize.fair") ?> <abbr title="Required field">*</abbr></label>
                            <input type="number" id="adult_fair" name="adult_fair" class="form-control" value="<?= old('adult_fair') ?>" placeholder="<?php echo lang("Localize.adult") ?> <?php echo lang("Localize.fair") ?>" min="1" required />
                        </div>

                        <div class="col-3 mt-2">
                            <label for="adult_fair" class="form-label"><?php echo lang("Localize.distance") ?> <abbr title="Required field">*</abbr></label>
                            <input type="number" id="distance" name="distance" class="form-control" value="<?= old('distance') ?>" placeholder="<?php echo lang("Localize.distance") ?>" min="1" required />
                        </div>

                        <div class="col-3 mt-2">
                            <label for="journey_hour" class="form-label"><?php echo lang("Localize.approximate") ?> <?php echo lang("Localize.time") ?> <abbr title="Required field">*</abbr></label>
                            <input type="number" id="journey_hour" name="journey_hour" class="form-control" value="<?= old('journey_hour') ?>" placeholder="<?php echo lang("Localize.approximate") ?> <?php echo lang("Localize.time") ?>" min="1" step=1 required />
                        </div>


                        <div class="col-3 mt-2">
                            <label for="startdate" class="form-label"><?php echo lang("Localize.trip") ?> <?php echo lang("Localize.start") ?> <?php echo lang("Localize.date") ?>  <abbr title="Required field">*</abbr></label>
                            <div class="input-group date datepicker" id="startdate">
                                <input type="text" class="form-control" name="startdate" readonly required />
                                <div class="input-group-addon"></div>
                            </div>
                        </div>


                        <div class="col-3 mt-2">
                            <label for="facility" class="form-label"><?php echo lang("Localize.facility") ?> </label>
                            <select multiple="multiple" name="facility[]" class="testselect3">
                                <option value="" disabled selected><?php echo lang("Localize.none") ?></option>

                                <?php foreach ($facility as $facilityvalue) : ?>
                                    <option value="<?php echo $facilityvalue->id ?>"><?php echo $facilityvalue->name ?></option>
                                <?php endforeach ?>

                            </select>
                        </div>
                        
                        <div class="row mt-3" id="extraRow0">
                            <div class="col-3">
                                <label class="form-label"><?php echo lang("Localize.class"); ?></label>
                                <select class="form-select select2 seatClass" name="seatClass[]" id="seatClass0" required>
                                    <?php foreach ($class as $classvalue) : ?>
                                        <option value="<?php echo $classvalue->id; ?>"><?php echo $classvalue->name; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-3">
                                <label for="seatNo0" class="form-label"><?php echo lang("Localize.seat"); ?></label>
                                <select name="seatNo[0][]" id="seatNo0" class="form-control seatNo" multiple>
                                    <?php 
                                    $seats = [];
                                    for ($i = 1; $i <= 50; $i++) {
                                        $seats[] = $i;
                                    }
                                    foreach ($seats as $seatvalue) : ?>
                                        <option value="<?php echo $seatvalue; ?>"><?php echo $seatvalue; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-3">
                                <label for="fares0" class="form-label"><?php echo lang("Localize.fair"); ?></label>
                                <input type="number" name="fares[]" id="fares0" class="form-control">
                            </div>
                            <div class="col-3">
                                <label style="display:block;" class="form-label">&nbsp;</label>
                                <button type="button" class="btn btn-success" id="addMoreClass">Add More</button>
                            </div>
                        </div>
                        <div id="addedExtraseatDiv">
                        </div>
                        


                    </div>
                </div>
                
                <div class="bg-light p-3 my-2">
                    <strong class="mb-1"><?php echo lang("Date Settings") ?></strong>

                    <div class="row">
                        
                        <!--//bus opration date type-->
                        <div class="col-6 mt-2">
                            <label for="oprationDatetype" class="form-label"><?php echo lang("Bus Opration Date Type") ?> </label>
                        </div>
                        <div class="col-6 mt-2">
                            <select name="oprationDatetype" class="testselect3" onchange="toggleRepetedFields()">
                                <option value="repeted"><?php echo "Repeted" ?> </option>
                                <option value="nonRepeted"><?php echo "Non-Repeted" ?> </option>
                            </select>
                        </div>

                        <!--repeted start date-->
                        <div class="col-6 mt-2">
                            <label for="repetedstartdate" class="form-label"><?php echo lang("Repeted") ?> <?php echo lang("Localize.start") ?> <?php echo lang("Localize.date") ?>  <abbr title="Required field">*</abbr></label>
                        </div>
                        <div class="col-6 mt-2">
                            <div class="input-group date datepicker">
                                <input type="text" class="form-control" id="repetedstartdate" name="repetedstartdate" readonly required />
                                <div class="input-group-addon"></div>
                            </div>
                        </div>

                        <!--repeted end date-->
                        <div class="col-6 mt-2">
                            <label for="repetedenddate" class="form-label"><?php echo lang("Repeted") ?> <?php echo lang("Localize.end") ?> <?php echo lang("Localize.date") ?>  <abbr title="Required field">*</abbr></label>
                        </div>
                        <div class="col-6 mt-2">
                            <div class="input-group date datepicker">
                                <input type="text" class="form-control" id="repetedenddate" name="repetedenddate" readonly required />
                                <div class="input-group-addon"></div>
                            </div>
                        </div>

                        <!--repeted after-->
                        <div class="col-6 mt-2">
                            <label for="repeted_after" class="form-label"><?php echo lang("Repeted After") ?> </label>
                        </div>
                        <div class="col-6 mt-3">
                            <input type="number" id="repeted_after" name="repeted_after" class="form-control" value="<?= old('repeted_after') ?>" min="0">
                        </div>

                        
                        
                        <!--maximum day for booking-->
                        <div class="col-6 mt-2">
                            <label for="maxdayforbooking" class="form-label"><?php echo lang("Maximum Day For Booking") ?> </label>
                            
                        </div>
                        <div class="col-6 mt-2">
                            
                            <input type="number" id="maxdayforbooking" name="maxdayforbooking" class="form-control" value="<?= old('maxdayforbooking') ?>" min="0">
                        </div>
                        
                        <div class="col-4 mt-2">
                            <label for="weekend" class="form-label"><?php echo lang("Days Off") ?> </label>
                            
                        </div>
                        <div class="col-8 mt-2 text-end">
                            
                            <div class="d-flex flex-wrap">
                                <?php foreach ($weekday as $key => $weekdayvalue) : ?>
                                <div class="form-check me-3">
                                <input class="form-check-input" type="checkbox" style="border-color:green;" name="weekend[]" value="<?php echo $key ?>" id="weekend_<?php echo $key ?>">
                                <label class="form-check-label" for="weekend_<?php echo $key ?>">
                                <?php echo $weekdayvalue ?>
                                </label>
                                </div>
                                <?php endforeach ?>
                            </div>
                        </div>
                        
                        <!--off dates-->
                        <div class="col-4 mt-2">
                            <label for="offdates" class="form-label"><?php echo lang("Off Dates") ?> </label>
                        </div>
                        <div class="col-8 mt-2 text-end" id="dateoffinput">
                            <div class="row mb-2">
                                <div class="col-6 date datepicker">
                                    <input type="text" class="form-control offdatefield" name="addDateoff[]" placeholder="Select date" readonly required />
                                    <div class="input-group-addon"></div>
                                </div>
                                <div class="col-2">
                                    <a class="btn btn-success mt-1 text-white" onclick="addfielddateoff()">+</a>
                                </div>
                            </div>
                            <input type="hidden" name="offdates" id="offdates"/>
                        </div>
                        
                        <div class="col-4 mt-2">
                            <label for="offdatesInrange" class="form-label"><?php echo lang("Off Dates In Range") ?> </label>
                            
                        </div>
                        
                        <div class="col-8 mt-2 text-end">
    <div id="offDateRangesList" class="mb-2"></div> <!-- Show all ranges here -->
    <span id="startdateinrange1"></span><span id="enddateinrange1"></span>
    <input type="hidden" name="startdateinrange2" id="startdateinrange2" />
    <input type="hidden" name="enddateinrange2" id="enddateinrange2" />
    <input type="hidden" name="offdateranges" id="offdateranges" /> <!-- Store all ranges -->
    <button onclick="offdateinrange()" type='button' style="background-color: #4CAF50;color: white;padding: 10px 20px;margin-bottom: 10px;border: none;cursor: pointer;">Add New Off Date Range</button>
</div>
                        
                    </div>
                </div>

               
                    <div class="row">
                            <!-- <input type='hidden' name="fleet_id" value='0'/> -->
                            <input type='hidden' name="vehicle_id" value='0'/>
                            <input type='hidden' name="driver[]" value='0'/>
                            <input type='hidden' name="assistant[]" value='0'/>
                            <input type='hidden' name="company_name" value='0'/>

                    </div>

                <label for="status" class="form-label"><?php echo lang("Localize.trip") ?> <?php echo lang("Localize.status") ?> </label>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="status" id="active" value="1" checked>
                    <label class="form-check-label" for="active">
                        <?php echo lang("Localize.active") ?>
                    </label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="status" value="0" id="disable">
                    <label class="form-check-label" for="disable">
                        <?php echo lang("Localize.disable") ?>
                    </label>
                </div>

                <div class="text-danger">
                    <?php if (isset($validation)) : ?>
                        <?= $validation->listErrors(); ?>
                    <?php endif ?>
                </div>

                <br>
                <input type="hidden" id="baseurl" name="baseurl" value="<?php echo esc(base_url()) ?>">

                <br>
                <div class="col-12">
                    <button type="submit" class="btn btn-success"><?php echo lang("Localize.submit") ?></button>
                </div>

            </form>
        </div>
    </div>
    
    
    <!--model for wallet-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Add New Off Date</h5>
        <button type="button" class="close"  onclick='modelClose()' data-dismiss="exampleModal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
        </button>
      </div>
        <form>
            <?php echo $this->include('common/security') ?>
            <div class="modal-body">
                <div class="row">
                    
                    <div class="col-md-6">
                       <label for="">Add Date Off</label>
                        
                        <div class="input-group date datepicker" id="repetedenddate">
                            <input type="text" class="form-control" name="addDateoff" onchange="valuepassdayoff()" id="addDateoff" readonly required />
                            <div class="input-group-addon"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" onclick='modelClose()' class="btn btn-secondary" data-dismiss="exampleModal">Close</button>
                <button type="button" onclick="modelClose()" class="btn btn-primary" data-dismiss="exampleModal">submit</submit>
            </div>
        </form>
    </div>
  </div>
</div>  


<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<div class="modal fade" id="offdateinrange" tabindex="-1" role="dialog" aria-labelledby="offdateinrangeLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="offdateinrangeLabel">Add Day Off in Range Date</h5>
        <button type="button" class="close"  onclick='bmodelClosePopup()' data-dismiss="offdateinrange" aria-label="Close">
        <span aria-hidden="true">&times;</span>
        </button>
      </div>
        <form>
            <?php echo $this->include('common/security') ?>
            <div class="modal-body">
                <div class="row">
                    
                    <div class="col-md-6">
                       <label for="">Start</label>
                        
                        <div class="input-group date datepicker" >
                            <input type="text" class="form-control" name="daysInRangeStart" onchange="valuepassdayoffinRange()" id="daysInRangeStart" required />
                            <div class="input-group-addon"></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                       <label for="">End</label>
                        
                        <div class="input-group date datepicker" >
                            <input type="text" class="form-control" name="daysInRangeEnd" onchange="valuepassdayoffinRange()" id="daysInRangeEnd" required />
                            <div class="input-group-addon"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" onclick='bmodelClosePopup()' class="btn btn-secondary" data-dismiss="offdateinrange">Close</button>
                <button type="button" onclick="bmodelClose()" class="btn btn-primary" data-dismiss="offdateinrange">submit</submit>
            </div>
        </form>
    </div>
  </div>
</div>

<script>
    function toggleRepetedFields() {
        var oprationDatetype = document.querySelector('select[name="oprationDatetype"]').value;
        var repetedstartdate = document.getElementById('repetedstartdate');
        var repetedenddate = document.getElementById('repetedenddate');
        var repeted_after = document.getElementById('repeted_after');
        
        if (oprationDatetype === 'nonRepeted') {
            repetedstartdate.disabled = true;
            repetedenddate.disabled = true;
            repeted_after.disabled = true;
            repetedstartdate.required = false;
            repetedenddate.required = false;
        } else {
            repetedstartdate.disabled = false;
            repetedenddate.disabled = false;
            repeted_after.disabled = false;
            repetedstartdate.required = true;
            repetedenddate.required = true;
        }
    }

    // Call the function initially to set the correct state based on the initial value
    document.addEventListener('DOMContentLoaded', toggleRepetedFields);
</script>
</script>

<script>
    
    function valuepassdayoff(){
        
       let addDateoff = $('#addDateoff').val();
        $('#adddayoffid').html(addDateoff);
        $('#offdates').val(addDateoff);
    }
    
    function valuepassdayoffinRange(){
        let daysInRangeStart = $('#daysInRangeStart').val();
        let daysInRangeEnd = $('#daysInRangeEnd').val();
        $('#startdateinrange1').html("start "+daysInRangeStart);
        $('#startdateinrange2').val(daysInRangeStart);
        $('#enddateinrange1').html(", end "+daysInRangeEnd);    
        $('#enddateinrange2').val(daysInRangeEnd);
    }

    // Store all off date ranges
    var offDateRanges = [];

    // Add a new off date range to the list
    // function bmodelClose(){
    //     let start = $('#daysInRangeStart').val();
    //     let end = $('#daysInRangeEnd').val();
    //     if(start && end){
    //         offDateRanges.push({start: start, end: end});
    //         updateOffDateRangesList();
    //     }
    //     $("#offdateinrange").modal("hide");
    //     // Clear modal fields for next use
    //     $('#daysInRangeStart').val('');
    //     $('#daysInRangeEnd').val('');
    // }

    function bmodelClose(){
        let start = $('#daysInRangeStart').val();
        let end = $('#daysInRangeEnd').val();
        if(start && end){
            let startDate = new Date(start);
            let endDate = new Date(end);
            // Validation: end date must be after start date
            if (new Date(end) <= new Date(start)) {
                alert('End date must be greater than start date.');
                return;
            }
            let isDuplicate = offDateRanges.some(function(range) {
                return range.start === start && range.end === end;
            });

            if (isDuplicate) {
                alert('This date range already exists.');
                return;
            }
            let isOverlapping = offDateRanges.some(function(range) {
            let existingStart = new Date(range.start);
            let existingEnd = new Date(range.end);

            return (
                (startDate <= existingEnd && endDate >= existingStart) // overlap logic
                );
            });

            if (isOverlapping) {
                alert('The selected date range overlaps with an existing range.');
                return;
            }

            offDateRanges.push({start: start, end: end});
            updateOffDateRangesList();
        }
        $("#offdateinrange").modal("hide");
        // Clear modal fields for next use
        $('#daysInRangeStart').val('');
        $('#daysInRangeEnd').val('');
    }
    function bmodelClosePopup(){
        $("#offdateinrange").modal("hide");
        // Clear modal fields for next use
        $('#daysInRangeStart').val('');
        $('#daysInRangeEnd').val('');   
    }

    // Remove a range by index
    function removeOffDateRange(idx){
        offDateRanges.splice(idx, 1);
        updateOffDateRangesList();
    }

    // Update the UI and hidden input
    function updateOffDateRangesList(){
        let html = '';
        offDateRanges.forEach(function(r, idx){
            html += `<div>
                <span>${r.start} to ${r.end}</span>
                <button type="button" class="btn btn-sm btn-danger ms-2" onclick="removeOffDateRange(${idx})">&times;</button>
            </div>`;
        });
        $('#offDateRangesList').html(html);
        // Store as JSON string in hidden input
        $('#offdateranges').val(JSON.stringify(offDateRanges));
    }

    // On form submit, ensure hidden input is updated
    $('#locationform').on('submit', function() {
        updateOffDateRangesList();
    });
    function offdateinrange() {
        $("#offdateinrange").modal("show");
    }
</script>

    <!--model end-->
<?php echo $this->endSection() ?>



<?php echo $this->section('js') ?>
    <script src="<?php echo base_url('public/js/ajax.js'); ?>"></script>
    <script src="<?php echo base_url('public/js/dynamicinput.js'); ?>"></script>
    <script src="<?php echo base_url('public/plugins/select2/select2.min.js'); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script>
    <script>
        $(document).ready(function () {
        
            var maxSeats = 50; // Default max seats
            // Initialize Select2 for the first row
            //$('.select2').select2();

            // Counter to generate unique IDs for new rows
            let counter = 1;

            // Add More functionality
            $('#addMoreClass').on('click', function (e) {
                
                e.preventDefault();

                // Generate a new row
                const newRow = `
                <div class="row mt-3" id="extraRow${counter}">
                    <div class="col-3">
                        <label class="form-label"><?php echo lang("Localize.class"); ?></label>
                        <select class="form-select select2 seatClass" name="seatClass[]" id="seatClass${counter}" required>
                            <?php foreach ($class as $classvalue) : ?>
                                <option value="<?php echo $classvalue->id; ?>"><?php echo $classvalue->name; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-3">
                        <label for="seatNo${counter}" class="form-label"><?php echo lang("Localize.seat"); ?></label>
                        <select name="seatNo[${counter}][]" id="seatNo${counter}" class="form-control seatNo" multiple>
                            <?php 
                            $seats = [];
                            for ($i = 1; $i < 50; $i++) {
                                $seats[] = $i;
                            }
                            foreach ($seats as $seatvalue) : ?>
                                <option value="<?php echo $seatvalue; ?>"><?php echo $seatvalue; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-3">
                        <label for="fares${counter}" class="form-label"><?php echo lang("Localize.fair"); ?></label>
                        <input type="number" name="fares[]" id="fares${counter}" class="form-control">
                    </div>
                    <div class="col-3">
                        <label style="display:block;" class="form-label">&nbsp;</label>
                        <button type="button" class="btn btn-danger deleteBtn" data-row-id="extraRow${counter}">Delete</button>
                    </div>
                </div>
                `;

                // Append the new row to the div
                $('#addedExtraseatDiv').append(newRow);
                const seatSelect = $(`#seatNo${counter}`); // Target the new seat select element
                seatSelect.empty();
                for (let i = 1; i <= maxSeats; i++) {
                    seatSelect.append(`<option value="${i}">${i}</option>`);
                }

                // Reinitialize Select2 for the new row
                $(`#seatClass${counter}`).select2();
                
                $(`#seatNo${counter}`).SumoSelect({ 
                    okCancelInMulti: true ,
                    triggerChangeCombined: true,
                    forceCustomRendering: true  
                });

                updateSeatClassUniqueness();
                updateSeatNoUniqueness();

                // Increment the counter
                counter++;
            });

            // Delete functionality
            $(document).on('click', '.deleteBtn', function () {
                const rowId = $(this).data('row-id');
                $(`#${rowId}`).remove(); // Remove the row
                updateSeatClassUniqueness();
                updateSeatNoUniqueness();
            });

            $('#fleet_id').on('change', function () {
                const fleetId = $(this).val(); // Get the selected fleet_id value

                const fleetData = <?php echo json_encode($fleet_types); ?>;

                const selectedFleet = fleetData.find(fleet => fleet.id == fleetId);

                if (selectedFleet) {
                    maxSeats = selectedFleet.total_seat;
                }
                /* const seatSelect = $('#seatNo0');

                // Destroy the existing SumoSelect
                seatSelect[0].sumo.unload(); 

                // Clear and append new options
                seatSelect.empty();
                seatSelect.append('<option value="" disabled selected>None</option>');
                for (let i = 1; i <= maxSeats; i++) {
                    seatSelect.append(`<option value="${i}">${i}</option>`);
                }

                // Reinitialize SumoSelect
                seatSelect.SumoSelect({ placeholder: 'Select Seats', csvDispCount: 3 }); */

                $(".seatNo").each(function (index) {
                    var $select = $(this);

                    // Destroy existing SumoSelect instance if initialized
                    if ($select.hasClass("SumoUnder")) {
                        $select[0].sumo.unload(); // Properly remove SumoSelect
                    }

                    $select.empty(); // Clear existing options
                    //$select.append('<option value="" disabled selected>None</option>'); // Default option

                    for (var i = 1; i <= maxSeats; i++) {
                        $select.append('<option value="' + i + '">' + i + '</option>');
                    }

                    // Reinitialize SumoSelect
                    $select.SumoSelect({
                        okCancelInMulti: true ,
                        triggerChangeCombined: true,
                        forceCustomRendering: true  
                    });
                });

            });

            // Function to Update seatClass Uniqueness
            function updateSeatClassUniqueness() {
                const selectedClasses = new Set();

                // Collect all selected seatClass values
                $('.seatClass').each(function() {
                    const selectedValue = $(this).val();
                    if (selectedValue) {
                        selectedClasses.add(selectedValue);
                    }
                });

                // Loop through all seatClass dropdowns to disable selected options
                $('.seatClass').each(function() {
                    $(this).find('option').each(function() {
                        if (selectedClasses.has($(this).val()) && !$(this).is(':selected')) {
                            $(this).prop('disabled', true);
                        } else {
                            $(this).prop('disabled', false);
                        }
                    });
                    $(this).select2(); // Reinitialize Select2 to update options
                });
            }

            // Function to Update seatNo Uniqueness
            function updateSeatNoUniqueness() {
                const selectedSeats = new Set();

                // Collect all selected seat numbers
                $('.seatNo').each(function() {
                    const selected = $(this).val();
                    if (selected) {
                        selected.forEach(seat => selectedSeats.add(seat));
                    }
                });

                // Loop through all seatNo dropdowns to disable selected options
                $('.seatNo').each(function() {
                    const currentSelect = $(this);
                    const currentSelected = currentSelect.val() || [];

                    currentSelect.find('option').each(function() {
                        const optionValue = $(this).val();
                        if (optionValue && selectedSeats.has(optionValue) && !currentSelected.includes(optionValue)) {
                            $(this).prop('disabled', true);
                        } else {
                            $(this).prop('disabled', false);
                        }
                    });

                    // Destroy existing SumoSelect instance if initialized
                    if (currentSelect.hasClass('SumoUnder')) {
                        currentSelect[0].sumo.unload(); // Properly remove SumoSelect
                    }

                    // Reinitialize SumoSelect
                   /*  currentSelect.SumoSelect({ 
                        placeholder: 'Select Seats', 
                        csvDispCount: 3,
                        okCancelInMulti: true
                    }); */

                    currentSelect.SumoSelect({ okCancelInMulti: true ,
                        triggerChangeCombined: true,
                        forceCustomRendering: true  
                    });
                });
            }

            // Initial call for the first row
            updateSeatClassUniqueness();
            updateSeatNoUniqueness();

            // Event Listener for seatClass change
            $(document).on('change', '.seatClass', function() {
                updateSeatClassUniqueness();
            });

            $(document).on('click', '.SumoSelect .btnOk', function() {
                updateSeatNoUniqueness();
            });
        });

        

    </script>

    <script>
        // Initialize datepicker for existing fields
        // $(function() {
        //     $('.datepicker input').datepicker({
        //         format: 'yyyy-mm-dd',
        //         autoclose: true,
        //         todayHighlight: true
        //     });
        // });
        $(function() {
            $('.offdatefield').datepicker({
                format: 'yyyy-mm-dd',
                autoclose: true,
                todayHighlight: true,
                startDate: 'today'
            });

            // Initialize all other datepickers (except .offdatefield) without startDate restriction
            $('.datepicker input:not(.offdatefield)').datepicker({
                format: 'yyyy-mm-dd',
                autoclose: true,
                todayHighlight: true,
                startDate: 'today'
            });

            // --- Add this for the off date range modal ---
            // When start date changes, set min selectable date for end date
            $('#daysInRangeStart').datepicker({
                format: 'yyyy-mm-dd',
                autoclose: true,
                todayHighlight: true,
                startDate: 'today'
            }).on('changeDate', function(e) {
                var start = $(this).val();
                $('#daysInRangeEnd').datepicker('setStartDate', start);
                // Optional: clear end date if it's before new start
                if ($('#daysInRangeEnd').val() && $('#daysInRangeEnd').val() <= start) {
                    $('#daysInRangeEnd').val('');
                }
            });

            $('#daysInRangeEnd').datepicker({
                format: 'yyyy-mm-dd',
                autoclose: true,
                todayHighlight: true,
                startDate: 'today'
            });
        });


        // Add new date field
        function addfielddateoff() {
            var html = `
            <div class="row mb-2">
                <div class="col-6 date datepicker">
                    <input type="text" class="form-control offdatefield" name="addDateoff[]" placeholder="Select date" readonly required />
                    <div class="input-group-addon"></div>
                </div>
                <div class="col-2">
                    <a class="btn btn-danger mt-1 text-white" onclick="removethisdateoff(this)">&times;</a>
                </div>
            </div>`;
            $('#dateoffinput').append(html);
            // Re-initialize datepicker for new fields
            $('#dateoffinput .datepicker input').datepicker({
                format: 'yyyy-mm-dd',
                autoclose: true,
                todayHighlight: true,
                startDate: 'today'
            });
        }

        // Remove a date field
        function removethisdateoff(btn) {
            $(btn).closest('.row').remove();
            updateOffDates();
        }

        // Collect all off dates into hidden input before submit
        function updateOffDates() {
            var dates = [];
            $('.offdatefield').each(function() {
                if ($(this).val()) dates.push($(this).val());
            });
            $('#offdates').val(dates.join(','));
        }

        // Update hidden input on change
        $(document).on('change', '.offdatefield', updateOffDates);

        // Also update on form submit
        $('#locationform').on('submit', function() {
            updateOffDates();
        });
    </script>
<?php echo $this->endSection() ?>