<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>

    <?php echo $this->include('common/message') ?>

    <div class="card">
        <div class="card-header">
            <div class="row align-items-center">
                <div class="col">
                    <h5 class="card-title mb-0">Scheduled Notifications</h5>
                </div>
                <div class="col-auto">
                    <a href="<?php echo base_url(route_to('new-notification')) ?>" class="btn btn-success">
                        <i class="fas fa-plus"></i> Create New
                    </a>
                </div>
            </div>
        </div>
        <div class="card-header">
            <!-- Navigation Tabs -->
            <ul class="nav nav-pills card-header-pills">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo base_url(route_to('index-notification')) ?>">All</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link active" href="<?php echo base_url(route_to('scheduled-notifications')) ?>">Scheduled</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo base_url(route_to('sent-notifications')) ?>">Sent</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo base_url(route_to('cancelled-notifications')) ?>">Cancelled</a>
                </li>
            </ul>
        </div>
        <div class="card-body">
            <?php if (empty($notifications)) : ?>
                <div class="text-center py-5">
                    <i class="fas fa-clock fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">No Scheduled Notifications</h5>
                    <p class="text-muted">There are no notifications scheduled for delivery.</p>
                    <a href="<?php echo base_url(route_to('new-notification')) ?>" class="btn btn-success">
                        <i class="fas fa-plus"></i> Create Your First Notification
                    </a>
                </div>
            <?php else : ?>
                <div class="table-responsive">
                    <table class="table display table-bordered table-striped table-hover basic" id="scheduledTable">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Subject</th>
                                <th scope="col">Target Group</th>
                                <th scope="col">Scheduled Date</th>
                                <th scope="col">Repeat</th>
                                <th scope="col">Push</th>
                                <th scope="col">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($notifications as $key => $notification) : ?>
                                <tr class="<?php echo strtotime($notification->notification_date) <= time() ? 'table-warning' : '' ?>">
                                    <th scope="row"><?php echo $key + 1; ?></th>
                                    <td>
                                        <strong><?php echo esc($notification->subject) ?></strong>
                                        <?php if (strtotime($notification->notification_date) <= time()) : ?>
                                            <br><small class="text-warning"><i class="fas fa-exclamation-triangle"></i> Due for sending</small>
                                        <?php endif ?>
                                    </td>
                                    <td>
                                        <?php if ($notification->target_group == 'all_users') : ?>
                                            <span class="badge bg-primary">All Users</span>
                                        <?php else : ?>
                                            <span class="badge bg-secondary">Specific Trip</span>
                                        <?php endif ?>
                                    </td>
                                    <td>
                                        <?php
                                        $scheduledDate = strtotime($notification->notification_date);
                                        $now = time();
                                        $diff = $scheduledDate - $now;
                                        ?>
                                        <div><?php echo date('Y-m-d H:i', $scheduledDate) ?></div>
                                        <?php if ($diff > 0) : ?>
                                            <small class="text-muted">
                                                <?php
                                                if ($diff < 3600) {
                                                    echo 'In ' . ceil($diff / 60) . ' minutes';
                                                } elseif ($diff < 86400) {
                                                    echo 'In ' . ceil($diff / 3600) . ' hours';
                                                } else {
                                                    echo 'In ' . ceil($diff / 86400) . ' days';
                                                }
                                                ?>
                                            </small>
                                        <?php else : ?>
                                            <small class="text-danger">Overdue</small>
                                        <?php endif ?>
                                    </td>
                                    <td>
                                        <?php if ($notification->repeat_option !== 'none') : ?>
                                            <span class="badge bg-info"><?php echo ucfirst($notification->repeat_option) ?></span>
                                        <?php else : ?>
                                            <span class="text-muted">-</span>
                                        <?php endif ?>
                                    </td>
                                    <td>
                                        <?php if ($notification->is_push_notification) : ?>
                                            <i class="fas fa-mobile-alt text-info" title="Push notification enabled"></i>
                                        <?php else : ?>
                                            <span class="text-muted">-</span>
                                        <?php endif ?>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo base_url(route_to('show-notification', $notification->id)) ?>" 
                                               class="btn btn-sm btn-info" title="View Details">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo base_url(route_to('edit-notification', $notification->id)) ?>" 
                                               class="btn btn-sm btn-warning" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button type="button" class="btn btn-sm btn-success" 
                                                    onclick="sendNow(<?php echo $notification->id ?>)" title="Send Now">
                                                <i class="fas fa-paper-plane"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-danger" 
                                                    onclick="cancelNotification(<?php echo $notification->id ?>)" title="Cancel">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach ?>
                        </tbody>
                    </table>
                </div>
            <?php endif ?>
        </div>
    </div>

<script>
function sendNow(id) {
    if (confirm('Are you sure you want to send this notification now?')) {
        var form = document.createElement('form');
        form.method = 'POST';
        form.action = '<?php echo base_url('modules/backend/notifications/send/') ?>' + id;
        
        var csrf = document.createElement('input');
        csrf.type = 'hidden';
        csrf.name = '<?= csrf_token() ?>';
        csrf.value = '<?= csrf_hash() ?>';
        form.appendChild(csrf);
        
        document.body.appendChild(form);
        form.submit();
    }
}

function cancelNotification(id) {
    if (confirm('Are you sure you want to cancel this notification?')) {
        var form = document.createElement('form');
        form.method = 'POST';
        form.action = '<?php echo base_url('modules/backend/notifications/cancel/') ?>' + id;
        
        var csrf = document.createElement('input');
        csrf.type = 'hidden';
        csrf.name = '<?= csrf_token() ?>';
        csrf.value = '<?= csrf_hash() ?>';
        form.appendChild(csrf);
        
        document.body.appendChild(form);
        form.submit();
    }
}

// Auto-refresh page every 5 minutes to update overdue notifications
setTimeout(function() {
    location.reload();
}, 300000);
</script>

<?php echo $this->endSection() ?>
