<?php

namespace App\Libraries\DeleteData\SoftwareSettings;

use App\Libraries\DeleteData\DeleteData;
use Modules\Cancellation\Models\CancellationModel;

class Cancellation extends DeleteData
{
    public function __construct()
    {
        $this->title = 'cancellation_policies';
        $this->model = new CancellationModel;
        $this->model->select('*');
    }
    
    public function deleteByCompanyId(int $companyId): bool
    {
        return $this->model->where('company_id', $companyId)->delete();
    }
}
