<?php

namespace App\Libraries\DeleteData\SoftwareSettings;

use App\Libraries\DeleteData\DeleteData;
use Modules\Offer\Models\OfferModel;
use Modules\Offer\Models\OfferDetailsModel;

class Offer extends DeleteData
{
    public function __construct()
    {
        $this->title = 'offers';
        $this->model = new OfferModel;
        $this->model->select('offers.id, offers.offer_title AS name');

        $this->relatives[] = [new OfferDetails, 'offer_id'];
    }
}

class OfferDetails extends DeleteData
{
    public function __construct()
    {
        $this->title = 'offer_details';
        $this->model = new OfferDetailsModel;
        $this->model->select('offer_details.id, CONCAT("Offer Detail #", offer_details.id) AS name');
    }
}
