<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

$routes->group('modules/backend/offers',["filter" => "cors","namespace" => "\Modules\Offer\Controllers"], function($routes)
{
    $routes->get('new', 'Offer::new',['as' => 'new-offer']);
    $routes->post('', 'Offer::create',['as' => 'create-offer']);
    $routes->get('', 'Offer::index',['as' => 'index-offer']);
    $routes->get('(:segment)/edit', 'Offer::edit/$1',['as' => 'edit-offer']);
    $routes->put('(:segment)', 'Offer::update/$1',['as' => 'update-offer']);
    $routes->delete('(:segment)', 'Offer::delete/$1',['as' => 'delete-offer']);
    $routes->get('getTripsByCompany', 'Offer::getTripsByCompany');
    $routes->post('server-list', 'Offer::serverList', ['as' => 'server-offer-list']);
    // $routes->post('getSeatClassesBySubtrips', 'Offer::getSeatClassesBySubtrips', ['as' => 'get-seat-classes-by-subtrips']);
    $routes->get('getSeatClassesBySubtrips', 'Offer::getSeatClassesBySubtrips', ['as' => 'get-seat-classes-by-subtrips']);
});

$routes->group('modules/api/v1/offers',["filter" => "cors","namespace" => "\Modules\Offer\Controllers\Api"], function($routes)
{
  $routes->get('validation/(:segment)/(:segment)/(:segment)', 'Offer::offerValidation/$1/$2/$3');
  $routes->get('', 'Offer::getAllOffers');
  $routes->get('(:segment)', 'Offer::getOfferById/$1');
});
