<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>
    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">

            <?php if ($add_data == true) : ?>
                <div class="text-end">
                    <a class="btn btn-success" href="<?php echo base_url(route_to('new-offer')) ?>">
                        <i class="fas fa-gift"></i><sup><i class="fas fa-plus small"></i></sup>
                        <?php echo lang("Localize.add_offer") ?>
                    </a>
                </div>
            <?php endif ?>

            <div class="table-responsive">
                <table class="table display table-bordered table-striped table-hover basic" id="offerlist">
                    <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Offer Title</th>
                            <th scope="col"><?php echo lang("Localize.code") ?></th>
                            <th><?php echo lang('Localize.company'); ?></th>
                            <th scope="col">Discount</th>
                            <th scope="col">Min Passengers</th>
                            <th scope="col"><?php echo lang("Localize.start") ?> <?php echo lang("Localize.date") ?></th>
                            <th scope="col"><?php echo lang("Localize.end") ?> <?php echo lang("Localize.date") ?></th>
                            <th scope="col"><?php echo lang("Localize.action") ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($offer as $kye =>  $value) : ?>
                            <tr>
                                <th scope="row"><?php echo $kye + 1; ?></th>
                                <td>
                                    <strong><?php echo esc($value->offer_title ?? 'N/A'); ?></strong>
                                    <?php if (!empty($value->offer_image)): ?>
                                        <br>
                                        <!--<small class="text-muted">📷 Has Image</small>-->
                                        <img src="<?= base_url('public/uploads/offers/' . $value->offer_image); ?>" style="width:50px; height:50px; object-fit:cover;" />
                                    <?php endif; ?>
                                </td>
                                <td><?php echo $value->code; ?></td>
                                <td>
                                    <?php echo !empty($value->company_names) 
                                        ? esc($value->company_names) 
                                        : ''; ?>
                                </td>
                                <td>
                                    <?php 
                                    if($value->discount_type == 1) {
                                        echo '₹' . $value->discount;
                                    } else {
                                        echo $value->discount . '%';
                                    }
                                    ?>
                                </td>
                                <td><?php echo $value->min_passengers ?? 1; ?></td>
                                <td><?php echo $value->start_date; ?></td>
                                <td><?php echo $value->end_date; ?></td>
                                <td>
                                    <form action="<?php echo base_url(route_to('ss-delete-confirmation', 'offer', $value->id)) ?>" method="get" class="deletionForm">
                                        <?php echo $this->include('common/delete') ?>

                                        <?php if ($edit_data == true) : ?>
                                            <a href="<?= base_url(route_to('edit-offer', $value->id)) ?>" class="btn btn-sm btn-info text-white" title="<?php echo lang("Localize.edit") ?>"><i class="fas fa-edit"></i></a>
                                        <?php endif ?>

                                        <?php if ($delete_data == true) : ?>
                                            <button type="button" data-modal-confirm="true" class="btn btn-sm btn-danger" title="<?php echo lang("Localize.delete") ?>"><i class="far fa-trash-alt"></i></button>
                                        <?php endif ?>

                                    </form>
                                </td>
                            </tr>
                        <?php endforeach ?>

                    </tbody>
                </table>
            </div>

        </div>
    </div>
    <?php echo $this->include('common/datatable_default_lang_change') ?>
    <?php echo $this->include('common/confirmation-modal') ?>
<?php echo $this->endSection() ?>
