<?php

namespace Modules\Ticket\Controllers;

use App\Controllers\BaseController;

use Modules\Ticket\Models\PartialpaidModel;
use Modules\Ticket\Models\TicketModel;
use Modules\Paymethod\Models\PaymethodModel;
use Modules\Ticket\Models\RefundModel;
use Modules\Agent\Models\AgentModel;
use Modules\Agent\Models\Agentcommission;
use Modules\Agent\Models\AgenttotalModel;
use Modules\Ticket\Models\JourneylistModel;
use Modules\Paymethod\Models\GeideaWave as ModelsGeideaWave;

class Refund extends BaseController
{
	protected $Viewpath;
	protected $partialpayModel;
	protected $ticketpayModel;
	protected $paymethodModel;
	protected $db;
	protected $agentModel;
    protected $agentCommissionModel;
    protected $refundModel;

    protected $agetTotalModel;
	
	protected $journeylistModel;
	
	protected $geideaWaveModel;

	
	public function __construct()
    {

        $this->Viewpath = "Modules\Ticket\Views";
		$this->partialpayModel = new PartialpaidModel();
		$this->ticketpayModel = new TicketModel();
		$this->paymethodModel = new PaymethodModel();

		$this->agentModel = new AgentModel();
        $this->agentCommissionModel = new Agentcommission();
		$this->db = \Config\Database::connect();

		$this->agetTotalModel = new AgenttotalModel();
		$this->refundModel = new RefundModel();

		$this->journeylistModel = new JourneylistModel();
		$this->geideaWaveModel = new ModelsGeideaWave();
		
    }

	public function new($ticketid,$type)
	{
		if ($type == "ticket" ) {
			$data['track_table'] = $this->ticketpayModel->find($ticketid);
		}
		

		$data['type'] = $type;
		$data['paymethod'] = $this->paymethodModel->findAll();

		$data['module'] =    lang("Localize.ticket_booking") ; 
		$data['title']  =    lang("Localize.refund_list") ;

		$heading = lang("Localize.ticket").' '.lang("Localize.refund");
		$data['pageheading'] = $heading;
		
		// Check if payment was made via Geidea
		$geideaPayment = null;
		
		// Check if there's a Geidea payment record for this ticket
		$geideaPayment = $this->db->table('paystatusgeidea')
			->where('ticket_id', $ticketid)
			->where('status', 'Success')
			->where('order_id IS NOT NULL')
			->where('order_id !=', '')
			->where('refund', 0) // Not already refunded
			->get()
			->getRow();
		
		$data['geidea_payment'] = $geideaPayment;
			

		echo view($this->Viewpath.'\refund/new',$data);
	}

	public function create()
	{
		$tableTargetDetail ="";

		$currentuserid = $this->session->get('user_id');
		$type = $this->request->getVar('type');
		$trackTableId = $this->request->getVar('track_table_id');
		$booking_id = $this->request->getVar('booking_id');
		$paymathodid = $this->request->getVar('pay_method');
		$paydetail = $this->request->getVar('detail');
		$refun_fee = $this->request->getVar('refund_fee');


		$validRefund = array(
			"booking_id" => $booking_id,
			"type" => $type,
			"refund_by" => $currentuserid,
			
		  );
		 
		$refund = array(
			"booking_id" => $booking_id,
			"refund_fee" => $refun_fee,
			"track_table_id" => $trackTableId,
			"type" => $type,
			"detail" => $paydetail,
			"pay_type_id" => $paymathodid,
			"refund_by" => $currentuserid,
		 );





		 if ($this->validation->run($validRefund, 'refund')) {

			$this->db->transStart();
			
			$this->refundModel->insert($refund);

			if ($type == "ticket") {

				$data = [
					'id' => $trackTableId,
					'refund' => 1,
				];
				
				$this->ticketpayModel->save($data);

				$tableTargetDetail = $this->ticketpayModel->where('booking_id',$booking_id)->first();
				
			}
			
			else {
				// $tableTargetDetail = ""
			}
			

			$totalamount = $this->partialpayModel->selectSum('paidamount')->where('booking_id',$booking_id)->findAll();

			$refundAmount = (int)$totalamount[0]->paidamount;
			
		

			$userRole = $this->session->get('role_id');

			if ($userRole == 2) {

				if (!empty($refun_fee)) {
					
					$userid = $tableTargetDetail->passanger_id;
					$subtripid = $tableTargetDetail->subtrip_id;
					$payDetail = $paydetail;
					$incometype = "income";
					$detail = "Refund fee (".$booking_id.") ";
					$amount = $refun_fee;

					agentIncomeCommission($currentuserid,$amount,$booking_id,$subtripid,$userid,$detail);
					
					agentTotal($currentuserid,$amount,$booking_id,$incometype,$payDetail);
				
					}

			   

			  }

			  if (!empty($refun_fee)) {
				
				$intype = "income";
                $detail = "Refund (".$booking_id.") ";
				$amount = $refun_fee;
                accoutTranjection($intype, $detail, $amount, $currentuserid, $booking_id, "booking");

				paymethodTeanjection($booking_id,$paymathodid,$refun_fee,$paydetail,$tableTargetDetail->trip_id,$tableTargetDetail->subtrip_id,$currentuserid);
			
				}

			  	$paymethod_id = $paymathodid;
                $payDetail = $paydetail;
                $extype = "expense";
                $detail = "Refund (".$booking_id.") ";
                accoutTranjection($extype, $detail, $refundAmount, $currentuserid, $booking_id, "booking");


				$agetCommission = $this->agentCommissionModel->where('booking_id',$booking_id)->findAll();

				foreach ($agetCommission as $key => $commissionValue) {

					$data = [
						'id' => $commissionValue->id,
						'commission' => "refund",
					];
					
					$this->agentCommissionModel->save($data);
					
				}
			
				$agetTotal = $this->agetTotalModel->where('booking_id',$booking_id)->where('expense',0)->findAll();

				foreach ($agetTotal as $key => $totalvalue) {
					
					$data = [
						'agent_id' => $totalvalue->agent_id,
						'booking_id' => $totalvalue->booking_id,
						'income' => 0,
						'expense' => $totalvalue->income,
						'detail' => "Refund",
					];

					$this->agetTotalModel->insert($data);
				}

				$this->journeylistModel->where('booking_id', $booking_id)->delete();

			

				$this->db->transComplete();
			
			return redirect()->route('ticketindex-refund')->with("success", "Refund Successful");
	

			
		}

		else
		{
			

			
			if ($type == "ticket" ) {
				$data['track_table'] = $this->ticketpayModel->find($trackTableId);
			}

			$data['type'] = $type;
			$data['paymethod'] = $this->paymethodModel->findAll();
			$data['validation'] = $this->validation;

			$data['module'] =    lang("Localize.ticket_booking") ; 
			$data['title']  =    lang("Localize.refund_list") ;

			echo view($this->Viewpath.'\refund/new',$data);

		}
	}

	public function indexTicket()
	{
		$data['module'] =    lang("Localize.ticket_booking") ; 
		$data['title']  =    lang("Localize.refund_list") ;

		$roleId     = session()->get("role_id");
		$companyId  = session()->get("company_id");
		if($roleId == 1){
			$data['refund'] = $this->refundModel->where('type',"ticket")->orderBy('id', 'DESC')->withDeleted()->findAll();	
		}else{
			$data['refund'] = $this->refundModel    
									->select('refunds.*')
								    ->join('tickets', 'tickets.id = refunds.track_table_id', 'left')
							        ->join('trips', 'trips.id = tickets.trip_id', 'left')
						            ->where('trips.company_id', $companyId)
									->where('type',"ticket")->orderBy('id', 'DESC')->withDeleted()->findAll();	
		}
		

		$heading = lang("Localize.ticket").' '.lang("Localize.refund_list");
		$data['pageheading'] = $heading;

		echo view($this->Viewpath.'\refund/index',$data);
	}
	public function serverListRefund()
	{
		$request = service('request');

		// Role and company ID from session
		$roleId = session()->get('role_id');
		$companyId = session()->get('company_id');

		// DataTables request values
		$draw   = $request->getPost('draw');
		$start  = $request->getPost('start');
		$length = $request->getPost('length');
		$searchValue = $request->getPost('search')['value'] ?? '';

		// Column map
		$columns = [
			0 => null, // index
			1 => 'refunds.booking_id', // booking_id
			2 => 'refunds.refund_fee', // amount
			3 => 'refunds.type', // type
			4 => 'refunds.detail', // payment details
			5 => 'refunds.created_at' // date
		];

		// Order column & direction
		$order = $request->getPost('order');
		$orderColumnIndex = !empty($order) && isset($order[0]['column']) ? $order[0]['column'] : 5;
		$orderDirection   = !empty($order) && isset($order[0]['dir']) ? $order[0]['dir'] : 'desc';

		// ---- TOTAL RECORDS ----
		$countBuilder = $this->db->table('refunds');
		$countBuilder->select('refunds.id')
			->where('refunds.type', 'ticket');

		// Apply role-based filtering for total count
		if ($roleId != 1) {
			$countBuilder->join('tickets', 'tickets.id = refunds.track_table_id', 'left')
				->join('trips', 'trips.id = tickets.trip_id', 'left')
				->where('trips.company_id', $companyId);
		}

		$totalRecords = $countBuilder->countAllResults(false);

		// ---- FILTERED QUERY ----
		$builder = $this->db->table('refunds');
		$builder->select('refunds.id, refunds.booking_id, refunds.refund_fee, refunds.type, refunds.detail, refunds.created_at')
			->where('refunds.type', 'ticket');

		// Apply role-based filtering
		if ($roleId == 1) {
			// Super admin sees all
		} else {
			$builder->join('tickets', 'tickets.id = refunds.track_table_id', 'left')
				->join('trips', 'trips.id = tickets.trip_id', 'left')
				->where('trips.company_id', $companyId);
		}

		// Global search
		if (!empty($searchValue)) {
			$builder->groupStart()
				->like('refunds.booking_id', $searchValue)
				->orLike('refunds.refund_fee', $searchValue)
				->orLike('refunds.type', $searchValue)
				->orLike('refunds.detail', $searchValue)
				->orLike('refunds.created_at', $searchValue)
				->groupEnd();
		}

		// Create a separate builder for filtered count
		$filteredCountBuilder = $this->db->table('refunds');
		$filteredCountBuilder->select('refunds.id')
			->where('refunds.type', 'ticket');

		// Apply role-based filtering for filtered count
		if ($roleId != 1) {
			$filteredCountBuilder->join('tickets', 'tickets.id = refunds.track_table_id', 'left')
				->join('trips', 'trips.id = tickets.trip_id', 'left')
				->where('trips.company_id', $companyId);
		}

		// Apply search filter for filtered count
		if (!empty($searchValue)) {
			$filteredCountBuilder->groupStart()
				->like('refunds.booking_id', $searchValue)
				->orLike('refunds.refund_fee', $searchValue)
				->orLike('refunds.type', $searchValue)
				->orLike('refunds.detail', $searchValue)
				->orLike('refunds.created_at', $searchValue)
				->groupEnd();
		}

		// ---- TOTAL FILTERED ----
		$totalRecordwithFilter = $filteredCountBuilder->countAllResults(false);

		// ---- ORDERING ----
		if (isset($columns[$orderColumnIndex]) && $columns[$orderColumnIndex] !== null) {
			$builder->orderBy($columns[$orderColumnIndex], $orderDirection);
		} else {
			$builder->orderBy('refunds.id', 'desc');
		}

		// ---- PAGINATION ----
		if ($length > 0) {
			$builder->limit($length, $start);
		}

		// ---- FETCH RECORDS ----
		$records = $builder->get()->getResult();

		// ---- FORMAT JSON ----
		$data = [];
		$i = $start + 1;

		foreach ($records as $row) {
			$data[] = [
				"index" => $i++,
				"booking_id" => esc($row->booking_id ?? ''),
				"refund_fee" => esc($row->refund_fee ?? ''),
				"type" => esc($row->type ?? ''),
				"detail" => esc($row->detail ?? ''),
				"created_at" => esc($row->created_at ?? '')
			];
		}

		return $this->response->setJSON([
			"draw" => intval($draw),
			"recordsTotal" => $totalRecords,
			"recordsFiltered" => $totalRecordwithFilter,
			"data" => $data
		]);
	}
/**
	 * Process Geidea online refund
	 */
	public function refundGeidea()
	{
		$bookingId = $this->request->getVar('booking_id');
		$refundAmount = $this->request->getVar('refund_amount');
		$ticketId = $this->request->getVar('ticket_id');

		if (empty($bookingId) || empty($refundAmount) || empty($ticketId)) {
			return $this->response->setJSON([
				'success' => false,
				'message' => 'Missing required parameters'
			])->setStatusCode(400);
		}

		try {
			// Get Geidea payment record
			$geideaPayment = $this->db->table('paystatusgeidea')
				->where('ticket_id', $ticketId)
				->where('status', 'Success')
				->where('order_id IS NOT NULL')
				->where('order_id !=', '')
				->get()
				->getRow();

			if (!$geideaPayment) {
				return $this->response->setJSON([
					'success' => false,
					'message' => 'Geidea payment record not found or already refunded'
				])->setStatusCode(404);
			}

			$orderId = $geideaPayment->order_id;
			
			// Validate orderId is a valid GUID
			if (empty($orderId) || !preg_match('/^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i', $orderId)) {
				return $this->response->setJSON([
					'success' => false,
					'message' => 'Invalid order ID format: ' . $orderId
				])->setStatusCode(400);
			}

			// Check if already refunded
			if ($geideaPayment->refund == 1) {
				return $this->response->setJSON([
					'success' => false,
					'message' => 'This payment has already been refunded'
				])->setStatusCode(400);
			}

			// Validate refund amount
			$refundAmountFloat = (float)$refundAmount;
			$originalAmount = (float)$geideaPayment->amount;
			
			if ($refundAmountFloat <= 0) {
				return $this->response->setJSON([
					'success' => false,
					'message' => 'Refund amount must be greater than zero'
				])->setStatusCode(400);
			}

			if ($refundAmountFloat > $originalAmount) {
				return $this->response->setJSON([
					'success' => false,
					'message' => 'Refund fees cannot exceed original payment amount (' . $originalAmount . ' EGP)'
				])->setStatusCode(400);
			}

			// Get Geidea credentials
			$geideaData = $this->geideaWaveModel->first();
			if (!$geideaData) {
				return $this->response->setJSON([
					'success' => false,
					'message' => 'Geidea credentials not found'
				])->setStatusCode(500);
			}

			if ($geideaData->environment == 0) {
				$publicKey = $geideaData->test_public_key;
				$apiPassword = $geideaData->test_api_pass;
			} else {
				$publicKey = $geideaData->live_public_key;
				$apiPassword = $geideaData->live_api_pass;
			}

			// Verify order status from Geidea before attempting refund
			// According to Geidea docs, refunds are only allowed for "Paid" or "Captured" transactions
			$orderStatus = $this->checkGeideaOrderStatus($orderId, $publicKey, $apiPassword);
			
			if ($orderStatus === false) {
				return $this->response->setJSON([
					'success' => false,
					'message' => 'Unable to verify order status from Geidea. Please check the order ID and try again.'
				])->setStatusCode(400);
			}

			// Check if order is in a refundable state
			$orderDetailedStatus = $orderStatus['detailedStatus'] ?? null;
			$orderStatusValue = $orderStatus['status'] ?? null;
			
			// Log order status for debugging
			$this->writeLogsInFile('geidea_refund_status_check', [
				'order_id' => $orderId,
				'status' => $orderStatusValue,
				'detailedStatus' => $orderDetailedStatus,
				'full_order_status' => $orderStatus
			]);
			
			// Refunds are only allowed for orders with status "Success"
			if ($orderStatusValue !== 'Success') {
				return $this->response->setJSON([
					'success' => false,
					'message' => 'Order is not in a refundable state. Current status: ' . ($orderDetailedStatus ?? $orderStatusValue ?? 'Unknown') . '. Only successful transactions can be refunded.'
				])->setStatusCode(400);
			}

			// Check if order is in a non-refundable detailed status
			$nonRefundableStatuses = ['FullyRefunded', 'Voided', 'Cancelled'];
			if (in_array($orderDetailedStatus, $nonRefundableStatuses)) {
				return $this->response->setJSON([
					'success' => false,
					'message' => 'This order cannot be refunded. Current status: ' . $orderDetailedStatus
				])->setStatusCode(400);
			}

			// Allow refunds for: Paid, Captured, PaidOut, PartiallyRefunded
			// These are all refundable states according to Geidea documentation
			$refundableDetailedStatuses = ['Paid', 'Captured', 'PaidOut', 'PartiallyRefunded'];
			if (!empty($orderDetailedStatus) && !in_array($orderDetailedStatus, $refundableDetailedStatuses)) {
				// If detailedStatus is set but not in refundable list, warn but don't block
				// Some statuses might still be refundable even if not explicitly listed
				$this->writeLogsInFile('geidea_refund_status_warning', [
					'order_id' => $orderId,
					'detailedStatus' => $orderDetailedStatus,
					'message' => 'Proceeding with refund despite unknown detailedStatus'
				]);
			}

			// Check if order is partially refunded and calculate remaining refundable amount
			$totalRefunded = (float)($orderStatus['totalRefundedAmount'] ?? 0);
			$orderAmount = (float)($orderStatus['amount'] ?? $originalAmount);
			$remainingRefundable = $orderAmount - $totalRefunded;

			if ($refundAmountFloat > $remainingRefundable) {
				return $this->response->setJSON([
					'success' => false,
					'message' => 'Refund amount exceeds remaining refundable amount. Already refunded: ' . $totalRefunded . ' EGP, Remaining: ' . $remainingRefunded . ' EGP'
				])->setStatusCode(400);
			}

			// Geidea Refund API endpoint (from official documentation)
			// https://docs.geidea.net/docs/refund-2
			$url = 'https://api.merchant.geidea.net/pgw/api/v2/direct/refund';
			
			// Format refund amount - must be > 0.01 and max 2 decimal places
			$refundAmountFloat = (float)$refundAmount;
			if ($refundAmountFloat < 0.01) {
				return $this->response->setJSON([
					'success' => false,
					'message' => 'Refund amount must be at least 0.01'
				])->setStatusCode(400);
			}
			$refundAmountStr = number_format($refundAmountFloat, 2, '.', '');
			
			// Timestamp format as per Geidea documentation example: "3/18/2024 5:16:48 AM"
			// Using server's local time
			$timestamp = date("n/j/Y g:i:s A");
			
			// Generate signature for refund
			// According to Geidea docs: Concatenate {TimeStamp, MerchantPublicKey, RefundAmount, OrderID}
			$signature = $this->generateGeideaRefundSignature($timestamp, $publicKey, $refundAmountStr, $orderId, $apiPassword);

			// Prepare refund payload - only required fields
			// Required: orderId, refundAmount, signature
			// Optional: callbackUrl, timestamp
			$payload = [
				'orderId' => (string)$orderId, // Ensure it's a string (GUID format)
				'refundAmount' => $refundAmountFloat, // Send as float/number (must be > 0.01)
				'signature' => (string)$signature // Ensure it's a string (Base64 encoded)
			];
			
			// Add optional callbackUrl only if it's a valid HTTPS URL
			$callbackUrl = base_url('modules/api/v1/tickets/refund-callback');
			if (filter_var($callbackUrl, FILTER_VALIDATE_URL) && strpos($callbackUrl, 'https://') === 0) {
				$payload['callbackUrl'] = $callbackUrl;
			}
			
			// Note: timestamp is optional in payload but required in signature calculation
			// We'll include it in the payload as well for consistency
			$payload['timestamp'] = $timestamp;

			// Log refund attempt with detailed information
			$this->writeLogsInFile('geidea_refund', [
				'booking_id' => $bookingId,
				'ticket_id' => $ticketId,
				'order_id' => $orderId,
				'refund_amount' => $refundAmount,
				'refund_amount_str' => $refundAmountStr,
				'timestamp' => $timestamp,
				'public_key' => substr($publicKey, 0, 10) . '...', // Log partial key for security
				'payload' => $payload,
				'payload_json' => json_encode($payload, JSON_PRETTY_PRINT),
				'signature_input' => $timestamp . $publicKey . $refundAmountStr . $orderId
			]);

			// Call Geidea Refund API
			$client = \Config\Services::curlrequest();
			
			try {
				// Manually encode JSON to ensure proper format
				$jsonPayload = json_encode($payload, JSON_UNESCAPED_SLASHES);
				
				// Log the exact JSON being sent
				$this->writeLogsInFile('geidea_refund_json', [
					'json_payload' => $jsonPayload,
					'payload_array' => $payload
				]);
				
				// Set headers explicitly as per Geidea API requirements
				// Try with SSL verification first
				try {
					$response = $client->post($url, [
						'auth' => [$publicKey, $apiPassword],
						'headers' => [
							'Content-Type' => 'application/json',
							'Accept' => 'application/json'
						],
						'body' => $jsonPayload, // Send as raw JSON body
						'http_errors' => false, // Don't throw exceptions on HTTP errors
						'verify' => true, // Verify SSL certificate
						'timeout' => 30, // 30 second timeout
						'allow_redirects' => true
					]);
				} catch (\Exception $sslError) {
					// If SSL verification fails, log and try without verification (for testing)
					// WARNING: Disabling SSL verification is not recommended for production
					$this->writeLogsInFile('geidea_ssl_error', [
						'order_id' => $orderId,
						'error' => $sslError->getMessage(),
						'url' => $url,
						'operation' => 'refund'
					]);
					
					// Retry without SSL verification (only for development/testing)
					$response = $client->post($url, [
						'auth' => [$publicKey, $apiPassword],
						'headers' => [
							'Content-Type' => 'application/json',
							'Accept' => 'application/json'
						],
						'body' => $jsonPayload,
						'http_errors' => false,
						'verify' => false, // Disable SSL verification (testing only)
						'timeout' => 30,
						'allow_redirects' => true
					]);
				}
			} catch (\Exception $e) {
				$this->writeLogsInFile('geidea_refund_error', [
					'error' => $e->getMessage(),
					'url' => $url,
					'payload' => $payload
				]);
				
				return $this->response->setJSON([
					'success' => false,
					'message' => 'Error calling Geidea API: ' . $e->getMessage()
				])->setStatusCode(500);
			}

			$responseBody = json_decode($response->getBody(), true);
			$statusCode = $response->getStatusCode();
			
			// Log response for debugging
			$this->writeLogsInFile('geidea_refund_response', [
				'status_code' => $statusCode,
				'response' => $responseBody,
				'order_id' => $orderId
			]);

			if ($statusCode === 200 && isset($responseBody['responseCode']) && $responseBody['responseCode'] === '000') {
				// Refund successful - update local records
				$this->db->transStart();

				// Update paystatusgeidea to mark as refunded
				$this->db->table('paystatusgeidea')
					->where('id', $geideaPayment->id)
					->update(['refund' => 1]);

				// Create refund record
				$currentuserid = $this->session->get('user_id');
				$refundData = [
					"booking_id" => $bookingId,
					"refund_fee" => $refundAmount,
					"track_table_id" => $ticketId,
					"type" => "ticket",
					"detail" => "Geidea Online Refund - Order ID: " . $orderId,
					"pay_type_id" => null, // Geidea refund
					"refund_by" => $currentuserid,
				];
				$this->refundModel->insert($refundData);

				// Update ticket refund status
				$this->ticketpayModel->update($ticketId, ['refund' => 1]);

				// Process other refund logic (similar to create method)
				$tableTargetDetail = $this->ticketpayModel->where('booking_id', $bookingId)->first();
				
				if ($tableTargetDetail) {
					$totalamount = $this->partialpayModel->selectSum('paidamount')->where('booking_id', $bookingId)->findAll();
					$refundAmountTotal = (int)$totalamount[0]->paidamount ?? $refundAmount;

					// Account transactions
					$extype = "expense";
					$detail = "Refund (Geidea Online) (" . $bookingId . ") ";
					accoutTranjection($extype, $detail, $refundAmountTotal, $currentuserid, $bookingId, "booking");

					// Update agent commissions
					$agetCommission = $this->agentCommissionModel->where('booking_id', $bookingId)->findAll();
					foreach ($agetCommission as $commissionValue) {
						$this->agentCommissionModel->update($commissionValue->id, ['commission' => "refund"]);
					}

					// Update agent totals
					$agetTotal = $this->agetTotalModel->where('booking_id', $bookingId)->where('expense', 0)->findAll();
					foreach ($agetTotal as $totalvalue) {
						$this->agetTotalModel->insert([
							'agent_id' => $totalvalue->agent_id,
							'booking_id' => $totalvalue->booking_id,
							'income' => 0,
							'expense' => $totalvalue->income,
							'detail' => "Refund (Geidea Online)",
						]);
					}

					// Delete journey list
					$this->journeylistModel->where('booking_id', $bookingId)->delete();
				}

				$this->db->transComplete();

				return $this->response->setJSON([
					'success' => true,
					'message' => 'Refund processed successfully via Geidea',
					'data' => $responseBody
				]);
			} else {
				// Refund failed
				$errorMessage = $responseBody['detailedResponseMessage'] ?? $responseBody['responseMessage'] ?? 'Refund failed';
				return $this->response->setJSON([
					'success' => false,
					'message' => 'Geidea refund failed: ' . $errorMessage,
					'data' => $responseBody
				])->setStatusCode($statusCode);
			}

		} catch (\Exception $e) {
			return $this->response->setJSON([
				'success' => false,
				'message' => 'Error processing refund: ' . $e->getMessage()
			])->setStatusCode(500);
		}
	}

	/**
	 * Check Geidea order status before attempting refund
	 * Fetches order details from Geidea API to verify refund eligibility
	 */
	private function checkGeideaOrderStatus($orderId, $publicKey, $apiPassword, $environment = 0)
	{
		try {
			// Geidea API endpoint to fetch order details
			$baseUrl = $environment == 0 
				? 'https://api.merchant.geidea.net' 
				: 'https://api.merchant.geidea.net';
			
			$url = $baseUrl . '/pgw/api/v2/direct/order/' . $orderId;
			
			$client = \Config\Services::curlrequest();
			
			// Try with SSL verification first, if it fails, try without (for testing only)
			try {
				$response = $client->get($url, [
					'auth' => [$publicKey, $apiPassword],
					'headers' => [
						'Accept' => 'application/json',
						'Content-Type' => 'application/json'
					],
					'http_errors' => false,
					'verify' => true, // Verify SSL certificate
					'allow_redirects' => true,
					'timeout' => 30
				]);
			} catch (\Exception $sslError) {
				// If SSL verification fails, log and try without verification (for testing)
				// WARNING: Disabling SSL verification is not recommended for production
				$this->writeLogsInFile('geidea_ssl_error', [
					'order_id' => $orderId,
					'error' => $sslError->getMessage(),
					'url' => $url
				]);
				
				// Retry without SSL verification (only for development/testing)
				$response = $client->get($url, [
					'auth' => [$publicKey, $apiPassword],
					'headers' => [
						'Accept' => 'application/json',
						'Content-Type' => 'application/json'
					],
					'http_errors' => false,
					'verify' => false, // Disable SSL verification (testing only)
					'allow_redirects' => true,
					'timeout' => 30
				]);
			}
			
			$statusCode = $response->getStatusCode();
			$responseBody = json_decode($response->getBody(), true);
			
			// Log the full order status JSON response
			$this->writeLogsInFile('geidea_order_status_json', [
				'order_id' => $orderId,
				'status_code' => $statusCode,
				'full_response' => $responseBody,
				'response_json' => json_encode($responseBody, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES)
			]);
			
			if ($statusCode === 200 && isset($responseBody['order'])) {
				$order = $responseBody['order'];
				
				// Log order details separately for easier reading
				$this->writeLogsInFile('geidea_order_status', [
					'order_id' => $orderId,
					'status' => $order['status'] ?? null,
					'detailedStatus' => $order['detailedStatus'] ?? null,
					'amount' => $order['amount'] ?? null,
					'totalRefundedAmount' => $order['totalRefundedAmount'] ?? 0,
					'order_details' => $order
				]);
				
				// Return order details
				return [
					'status' => $order['status'] ?? null,
					'detailedStatus' => $order['detailedStatus'] ?? null,
					'amount' => $order['amount'] ?? null,
					'totalRefundedAmount' => $order['totalRefundedAmount'] ?? 0,
					'orderId' => $order['orderId'] ?? $orderId
				];
			}
			
			// Log error
			$this->writeLogsInFile('geidea_order_check_error', [
				'order_id' => $orderId,
				'status_code' => $statusCode,
				'response' => $responseBody
			]);
			
			return false;
			
		} catch (\Exception $e) {
			$this->writeLogsInFile('geidea_order_check_exception', [
				'order_id' => $orderId,
				'error' => $e->getMessage()
			]);
			return false;
		}
	}

	/**
	 * Generate Geidea refund signature
	 * According to Geidea documentation:
	 * 1. Concatenate: {TimeStamp, MerchantPublicKey, RefundAmount, OrderID}
	 * 2. Hash (SHA-256) this concatenated string by Merchant_API_Password
	 * 3. Convert Hashed Value to Base64Str
	 * 
	 * Reference: https://docs.geidea.net/docs/refund-2
	 */
	private function generateGeideaRefundSignature($timestamp, $merchantPublicKey, $refundAmount, $orderId, $apiPassword)
	{
		// Concatenate: TimeStamp + MerchantPublicKey + RefundAmount + OrderID
		$data = $timestamp . $merchantPublicKey . $refundAmount . $orderId;
		
		// Hash (SHA-256) with API Password
		$hash = hash_hmac('sha256', $data, $apiPassword, true);
		
		// Convert to Base64
		return base64_encode($hash);
	}

	/**
	 * Write logs to file (similar to Ticket API)
	 */
	private function writeLogsInFile($logFileName, $msgArray)
	{
		$date = date("Y-m-d");
		$logDir = WRITEPATH . 'logs/geidea';
		
		if (!is_dir($logDir)) {
			mkdir($logDir, 0777, true);
		}

		$filePath = $logDir . '/' . $logFileName . '_' . $date . '.log';
		$logEntry = "[" . date('Y-m-d H:i:s') . "] " . print_r($msgArray, true) . "\n";
		file_put_contents($filePath, $logEntry, FILE_APPEND);
	}
}
