<?php

namespace App\Libraries;



use Kreait\Firebase\Factory;

use Kreait\Firebase\Messaging\CloudMessage;

use Kreait\Firebase\Messaging\Notification;



class FirebaseNotification

{

    private $messaging;



    public function __construct()

    {

        $serviceAccount = ROOTPATH . 'writable/firebase/firebase-service-account.json';



        $factory = (new Factory)->withServiceAccount($serviceAccount);

        $this->messaging = $factory->createMessaging();

    }



    public function sendToToken(string $deviceToken, string $title, string $body, array $data = [])

    {

        $message = CloudMessage::withTarget('token', $deviceToken)

            ->withNotification(Notification::create($title, $body))

            ->withData($data); // extra custom payload

        $response = $this->messaging->send($message);

        return $response;

    }

}

