<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>
    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">

            <?php if ($add_data == true) : ?>
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div>
                        <form method="get" class="d-flex">
                            <input type="text" name="search" class="form-control form-control-sm me-2"
                                   placeholder="<?php echo lang('Localize.search'); ?>"
                                   value="<?php echo isset($search) ? esc($search) : ''; ?>">
                            <button type="submit" class="btn btn-sm btn-primary">
                                <?php echo lang('Localize.search'); ?>
                            </button>
                        </form>
                    </div>
                    <div class="text-end">
                        <a class="btn btn-sm btn-secondary me-1"
                           href="<?php echo base_url(route_to('export-passanger') . (!empty($search) ? '?search=' . urlencode($search) : '')); ?>">
                            <?php echo lang('Localize.export'); ?> CSV
                        </a>
                        <a class="btn btn-sm btn-success" href="<?php echo base_url(route_to('new-passanger')) ?>">
                            <?php echo lang("Localize.add_passanger") ?>
                        </a>
                    </div>
                </div>
            <?php endif ?>

            <?php
                $currentPage = isset($pager) ? $pager->getCurrentPage() : 1;
                $perPage = isset($pager) ? $pager->getPerPage() : count($userDetail);
            ?>
            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover basic" id="passangerlist">
                    <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col"><?php echo lang("Localize.name") ?></th>
                            <th scope="col"><?php echo lang("Localize.joined_at") ?></th>
                            <th scope="col"><?php echo lang("Localize.email") ?></th>
                            <?php if (session()->get('role_id') == "1") { ?>
                                <th scope="col"><?php echo lang("Localize.company") ?></th>
                            <?php } ?>
                            <th scope="col"><?php echo lang("Localize.mobile") ?></th>

                            <th scope="col"><?php echo lang("Localize.action") ?></th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php foreach ($userDetail as $kye => $value) : ?>
                            <tr>
                                <th scope="row"><?php echo (($currentPage - 1) * $perPage) + $kye + 1; ?></th>
                                <td><?php echo $value->first_name . ' ' . $value->last_name; ?></td>
                                <td><?php echo $value->created_at; ?></td>
                                <td><?php echo $value->login_email; ?></td>
                                <?php if (session()->get('role_id') == "1") { ?>
                                    <td><?php echo $value->company_names; ?></td>
                                <?php } ?>
                                <td><?php echo $value->login_mobile; ?></td>
                                <td>
                                    <?php if ($value->deleted_at == null) :  ?>

                                        <form action="" class="deletionForm" method="get">
                                            <?php if ($edit_data == true) : ?>
                                                <a href="<?= base_url(route_to('edit-passanger', (int)$value->id)) ?>" class="btn btn-sm btn-info text-white" title="<?php echo lang("Localize.edit") ?>"><i class="fas fa-edit"></i></a>
                                            <?php endif ?>

                                            <?php if ($delete_data == true && 0) : ?>
                                                <button data-modal-confirm="true" class="btn btn-sm btn-danger"><i class="far fa-trash-alt" title="<?php echo lang("Localize.delete") ?>"></i> </button>
                                            <?php endif ?>

                                        </form>
                                    <?php else : ?>
                                        <?php if ($delete_data == true) : ?>
                                            <a href="<?php echo base_url(route_to('restore-passanger', $value->id)) ?>" class="btn btn-sm btn-success text-white" title="<?php echo lang("Localize.restore") ?>">
                                                <i class="fas fa-undo-alt"></i>
                                                <?php echo lang("Localize.restore"); ?>
                                            </a>
                                        <?php endif; ?>

                                    <?php endif; ?>

                                </td>
                            </tr>
                        <?php endforeach ?>

                    </tbody>
                </table>
            </div>

            <?php if (isset($pager)) : ?>
                <div class="d-flex justify-content-end mt-3">
                    <?php echo $pager->links(); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <?php echo $this->include('common/datatable_default_lang_change') ?>
    <?php echo $this->include('common/confirmation-modal') ?>
<?php echo $this->endSection() ?>