<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('css') ?>
    <link rel="stylesheet" href="<?php echo base_url('public/css/customestyle.css'); ?>" type="text/css">
<?php echo $this->endSection() ?>

<?php echo $this->section('content') ?>

    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-3">
                <form method="get" class="d-flex">
                    <input type="text"
                           name="search"
                           class="form-control form-control-sm me-2"
                           placeholder="<?php echo lang('Localize.search'); ?>"
                           value="<?php echo isset($search) ? esc($search) : ''; ?>">
                    <?php if (!empty($perPage)) : ?>
                        <input type="hidden" name="per_page" value="<?php echo (int) $perPage; ?>">
                    <?php endif; ?>
                    <button type="submit" class="btn btn-sm btn-primary">
                        <?php echo lang('Localize.search'); ?>
                    </button>
                </form>
                <div class="text-end">
                    <a class="btn btn-sm btn-secondary me-1"
                       href="<?php echo base_url(route_to('export-trip') . (!empty($search) ? '?search=' . urlencode($search) : '')); ?>">
                        <?php echo lang('Localize.export'); ?> CSV
                    </a>
                    <?php if ($add_data == true) : ?>
                        <a class="btn btn-sm btn-success" href="<?php echo base_url(route_to('new-trip')) ?>">
                            <i class="fas fa-suitcase"></i> <sup><i class="fas fa-plus small"></i></sup>
                            <?php echo lang("Localize.add_trip") ?>
                        </a>
                    <?php endif ?>
                </div>
            </div>

            <?php
                $tripList = is_array($trip) ? $trip : [];
                $currentPage = isset($pager) ? $pager->getCurrentPage() : 1;
                $tripCount = count($tripList);
                $perPageValue = isset($pager) ? $pager->getPerPage() : (!empty($perPage) ? $perPage : max($tripCount, 1));
                $columnCount = session()->get('role_id') == "1" ? 10 : 9;
            ?>
            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover" id="triplist" data-server="true">
                    <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col"><?php echo lang("Localize.pick_up") ?> </th>
                            <th scope="col"><?php echo lang("Localize.drop") ?> </th>
                            <th scope="col"><?php echo lang("Localize.schedule") ?> </th>
                            <th scope="col"><?php echo lang("Localize.distance") ?> </th>
                            <th scope="col"><?php echo lang("Localize.hour") ?> </th>
                            <?php if(session()->get('role_id') == "1"){ ?>
                                <th scope="col"><?php echo lang("Localize.company") ?> </th>
                            <?php } ?>
                            <th scope="col"><?php echo lang("Localize.trip").lang("Localize.id") ?> </th>
                            <th scope="col"><?php echo lang("Localize.status") ?> </th>
                            <th scope="col"><?php echo lang("Localize.action") ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($tripList)) : ?>
                            <?php foreach ($tripList as $kye =>  $value) : ?>
                                <?php if (!is_object($value)) { continue; } ?>
                                <tr>
                                    <th scope="row"><?php echo (($currentPage - 1) * $perPageValue) + $kye + 1; ?></th>
                                    <td><?php echo  $value->pick_location_name ?? ''; ?></td>
                                    <td><?php echo $value->drop_location_name ?? ''; ?></td>
                                    <td><?php echo $value->start_time ?? ''; ?></td>
                                    <td><?php echo ($value->trip_distance ?? '') !== '' ? ($value->trip_distance . 'km') : ''; ?></td>
                                    <td><?php echo $value->trip_journey_hour ?? ''; ?></td>
                                    <?php if(session()->get('role_id') == "1"){ ?>
                                        <td><?php echo $value->company_name ?? ''; ?></td>
                                    <?php } ?>
                                    <td><?php echo $value->tripid; ?></td>
                                    <td>
                                        <?php if ($value->trip_status == "1") : ?>
                                            <span class="badge bg-success"><?php echo lang("Localize.active") ?></span>
                                        <?php else : ?>
                                            <span class="badge bg-secondary"><?php echo lang("Localize.disable") ?></span>
                                        <?php endif ?>
                                    </td>
                                    <td>
                                        <?php if ($edit_data == true) : ?>
                                            <form action="<?php echo base_url(route_to('status-trip', $value->tripid)) ?>" class="d-inline-block" method="post">
                                                <?php echo $this->include('common/securityupdate'); ?>

                                                <button type="submit" class="btn btn-sm btn-secondary text-white" title="<?php echo lang("Localize.status") ?>">
                                                    <i class="<?php echo 'fa fa-user-' . (!$value->trip_status ? 'check' : 'slash') ?>"></i>
                                                </button>
                                            </form>
                                        <?php endif ?>
                                        <form action="<?php echo base_url(route_to('ss-delete-confirmation', 'trip', $value->tripid)) ?>" id="tripDelete" method="get" class="deletionForm">
                                            <?php echo $this->include('common/delete') ?>

                                            <?php if ($edit_data == true) : ?>
                                                <a href="<?= base_url(route_to('edit-trip', $value->tripid)) ?>" class="btn btn-sm btn-info text-white" title="<?php echo lang("Localize.edit") ?>"><i class="fas fa-edit"></i></a>
                                            <?php endif ?>

                                            <a href="<?= base_url(route_to('index-Subtrip', $value->tripid)) ?>" class="btn btn-sm btn-success"><?php echo lang("Localize.sub") ?> <?php echo lang("Localize.trip") ?></a>

                                            <?php if ($delete_data == true) : ?>
                                                <button type="button" data-modal-confirm="true" class="btn btn-sm btn-danger"><i class="far fa-trash-alt"></i></button>
                                            <?php endif ?>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach ?>
                        <?php else : ?>
                            <tr>
                                <td colspan="<?php echo $columnCount; ?>" class="text-center">
                                    <?php echo lang('Localize.no_data_found') ?? 'No trips found.'; ?>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php if (isset($pager)) : ?>
                <div class="d-flex justify-content-end mt-3">
                    <?php echo $pager->links(); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <?php echo $this->include('common/confirmation-modal') ?>
<?php echo $this->endSection() ?>