<?php

namespace Modules\Fleet\Models;

use CodeIgniter\Model;

class VehicleModel extends Model
{
	protected $DBGroup              = 'default';
	protected $table                = 'vehicles';
	protected $primaryKey           = 'id';
	protected $useAutoIncrement     = true;
	protected $insertID             = 0;
	protected $returnType           = 'object';
	protected $useSoftDeletes       = true;
	protected $protectFields        = true;
	protected $allowedFields        = [
		'id',
		'reg_no',
		'fleet_id',
		'engine_no',
		'model_no',
		'bus_plate_no',
		'chasis_no',
		'bus_type',
		'ownership',
		'woner',
		'woner_mobile',
		'company_id',
		'status',
		'assign',
		'deleted_at'
	];

	// Dates
	protected $useTimestamps        = true;
	protected $dateFormat           = 'datetime';
	protected $createdField         = 'created_at';
	protected $updatedField         = 'updated_at';
	protected $deletedField         = 'deleted_at';

	// Validation
	protected $validationRules      = [];
	protected $validationMessages   = [];
	protected $skipValidation       = false;
	protected $cleanValidationRules = true;

	// Callbacks
	protected $allowCallbacks       = true;
	protected $beforeInsert         = [];
	protected $afterInsert          = [];
	protected $beforeUpdate         = [];
	protected $afterUpdate          = [];
	protected $beforeFind           = [];
	protected $afterFind            = [];
	protected $beforeDelete         = [];
	protected $afterDelete          = [];
}
